<?php
/**
 * AjaxTicketsControlle.php
 * Controlador para el manejo de ajax con tickets
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package ayuda
 */


date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxTicketsController {

    public function crearTicket() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'NotificacionesDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $asunto = filter_input(INPUT_POST, 'asunto', FILTER_SANITIZE_STRING);
        $prioridad = filter_input(INPUT_POST, 'prioridad', FILTER_SANITIZE_NUMBER_INT);
        $mensaje = filter_input(INPUT_POST, 'mensaje', FILTER_SANITIZE_STRING);
        $folio = 'TK-' . date("YmdHis");
        $t = new Ticket();
        $t->__set('_folio', $folio);
        $t->__set('_fecha', date("Y-m-d H:i:s"));
        $t->__set('_prioridad', $prioridad);
        $t->__set('_idUsuario', Sesion::obtener('idUsuario'));
        $t->__set('_status', 1);
        $tic = new TicketDao();
        $ticket = $tic->nuevoTicket($t);
        if ($ticket['status']) {
            $idTicket = $ticket['idTicket'];
            $dt = new DetalleTicket();
            if (isset($_FILES['adjunto']['name'])) {
                $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR .
                        'archivos' . DIRECTORY_SEPARATOR;
                if (!is_dir($ruta)){
                    mkdir(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR .
                        'archivos' . DIRECTORY_SEPARATOR);
                    chmod($ruta, 0777);
                }
                if (move_uploaded_file($_FILES['adjunto']['tmp_name'], $ruta . $_FILES['adjunto']['name'])) {
                    $dt->__set('_adjunto', $_FILES['adjunto']['name']);
                } else {
                    $dt->__set('_adjunto', '');
                }
            } else {
                $dt->__set('_adjunto', '');
            }

            $dt->__set('_asunto', $asunto);
            $dt->__set('_descripcion', $mensaje);
            $dt->__set('_fecha', date("Y-m-d H:i:s"));
            $dt->__set('_idUsuario', Sesion::obtener('idUsuario'));
            $dt->__set('_idTicket', $idTicket);
            $det = new DetalleTicketDao();
            $detalle = $det->crearDetalle($dt);
            if ($detalle['status']) {
                //generamos la notificacion
                $n = new Notificaciones();
                $n->__set('_asunto', $asunto);
                $n->__set('_descripcion', $mensaje);
                $n->__set('_fecha', date("Y-m-d"));
                $n->__set('_hora', date("H:i:s"));
                //$n->__set('_url', 'inicio/notificaciones/');
                $n->__set('_url', 'ayuda/ticket/'.$idTicket.'/');
                $n->__set('_status', 1);
                $n->__set('_idUsuario', 122);
                $n->__set('_idSolicita', Sesion::obtener('idUsuario'));
                $not = new NotificacionesDao();
                $not->crearNotificacion($n);                
                $contenido = $mensaje.'<br><br>'.BASEURL.'ayuda/ticket/'.$idTicket.'/';
                $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                $datos = array('contenido' => $contenido);
                $opciones = array(
                        'http' => array(
                            'method' => 'POST',
                            'header' => 'Content-type: application/x-www-form-urlencoded',
                            'content' => http_build_query($datos)
                        )
                    );

                $contexto = stream_context_create($opciones);
                $contenidoEmail = file_get_contents($url, false, $contexto);
                
                $email = 'sistemas@merdizshell.com';
                $subject = 'Nuevo Ticket';
                $attachment = array();
                $attachment['file'][] = $ruta . $_FILES['adjunto']['name'];
                $attachment['name'][] = $_FILES['adjunto']['name'];
                Email::enviarEmail($email, '', $subject, $contenidoEmail, $attachment);
                //generamos el mail de notificación al usuario
                $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                $datos = array('contenido' => 'Tu solicitud ha sido procesada con número de ticket ' . $folio . '. En cuanto tengamos una respuesta para tu solicitud, la recibirás directamente en tu correo electrónico, aunque también puedes revisarla en tus tickets activos.');
                $opciones = array(
                        'http' => array(
                            'method' => 'POST',
                            'header' => 'Content-type: application/x-www-form-urlencoded',
                            'content' => http_build_query($datos)
                        )
                    );

                $contexto = stream_context_create($opciones);
                $contenidoEmail = file_get_contents($url, false, $contexto);
                $u = new UsuarioDao();
                $usuario = $u->obtenerUsuario(Sesion::Obtener('idUsuario'))['usuarios'];
                Email::enviarEmail($usuario->Mail, '', $subject, $contenidoEmail, $attachment);

                $response['status'] = true;
                $response['mensaje'] = 'Ticket generado correctamente. En breve será respondido.';
            } else {
                $response['status'] = false;
                $response['mensaje'] = $detalle['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $ticket['error'];
        }

        echo json_encode($response);
    }

    public function cargarTickesActivos()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = 10;
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }


        $t = new TicketDao();
        $to = $t->totalTicketsActivos(Sesion::obtener('idUsuario'));
        if ($to['status']){
            $total = (int) $to['total'];
            $paginas = ceil($total / $registros);
            $tickets = $t->obtenerTicketsActivos(Sesion::obtener('idUsuario'), $inicio, $registros);
            if ($tickets['status']){
                $response['status'] = true;
                $response['tickets'] = $tickets['tickets'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $tickets;
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $to['error'];
        }

        echo json_encode($response);
    }

    public function cargarTickes()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = 10;
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }


        $t = new TicketDao();
        $to = $t->totalTickets();
        if ($to['status']){
            $total = (int) $to['total'];
            $paginas = ceil($total / $registros);
            $tickets = $t->obtenerTickets($inicio, $registros);
            if ($tickets['status']){
                $response['status'] = true;
                $response['tickets'] = $tickets['tickets'];
                $response['ticketsr'] = $tickets;
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $tickets;
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $to['error'];
        }

        echo json_encode($response);
    }

    public function responderTicket(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idTicket = filter_input(INPUT_POST, 'idTicket', FILTER_SANITIZE_NUMBER_INT);
        $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);

        $tt = new TicketDao();
        $ticket = $tt->obtenerTicket($idTicket)['ticket'];

        $t = new DetalleTicketDao();
        $detalle = $t->obtenerDetalleUnico($idTicket)['detalle'];

        $asunto = $detalle->Asunto;
        $fecha = date("Y-m-d H:i:s");

        $d = new DetalleTicket();
        $d->__set('_asunto', $asunto);
        $d->__set('_descripcion', $descripcion);
        if (isset($_FILES['adjunto']['name'])) {
            $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR .
                    'archivos' . DIRECTORY_SEPARATOR;
            if (!is_dir($ruta)){
                mkdir(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR .
                    'archivos' . DIRECTORY_SEPARATOR);
                chmod($ruta, 0777);
            }
            if (move_uploaded_file($_FILES['adjunto']['tmp_name'], $ruta . $_FILES['adjunto']['name'])) {
                $d->__set('_adjunto', $_FILES['adjunto']['name']);
            } else {
                $d->__set('_adjunto', '');
            }
        } else {
            $d->__set('_adjunto', '');
        }

        $d->__set('_fecha', $fecha);
        $d->__set('_idUsuario', Sesion::obtener('idUsuario'));
        $d->__set('_idTicket', $idTicket);

        $guardar = $t->crearDetalle($d);
        if(Sesion::obtener('idUsuario') == 122)
            $tt->cambiarStatus($idTicket, 4);
        else
            $tt->cambiarStatus($idTicket, 1);

        $contenido = $descripcion.'<br><br>'.BASEURL.'ayuda/ticket/'.$idTicket.'/';
        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => $contenido);
        $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        
        $email = 'sistemas@merdizshell.com';
        $subject = 'Respuesta de Ticket';
        $attachment = array();
        $attachment['file'][] = $ruta . $_FILES['adjunto']['name'];
        $attachment['name'][] = $_FILES['adjunto']['name'];
        Email::enviarEmail($email, '', $subject, $contenidoEmail, $attachment);

        //generamos el mail de notificación al usuario
        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => 'Tienes una respuesta del ticket ' . $ticket->Folio . ' ('.$ticket->Asunto.').');
        $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        $u = new UsuarioDao();
        $attachment = array();
        $attachment['file'][] = $ruta . $_FILES['adjunto']['name'];
        $attachment['name'][] = $_FILES['adjunto']['name'];
        $usuario = $u->obtenerUsuario($ticket->Id_Usuario)['usuarios'];
        Email::enviarEmail($usuario->Mail, '', $subject, $contenidoEmail, $attachment);

        $response['status'] = true;
        $response['mensaje'] = 'Respuesta enviada correctamente';

        echo json_encode($response);
    }

    public function guardaDetalle($asunto, $descripcion, $idTicket){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';

        $dt = new DetalleTicketDao();
        $d = new DetalleTicket();
        $d->__set('_asunto', $asunto);
        $d->__set('_descripcion', $descripcion);
        $d->__set('_adjunto', '');
        $d->__set('_fecha', date("Y-m-d H:i:s"));
        $d->__set('_idUsuario', Sesion::obtener('idUsuario'));
        $d->__set('_idTicket', $idTicket);

        $guardar = $dt->crearDetalle($d);
        return $guardar;
    }

    public function cerrarTicket(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idTicket = filter_input(INPUT_POST, 'idTicket', FILTER_SANITIZE_NUMBER_INT);
        $calificacion = filter_input(INPUT_POST, 'calificacion', FILTER_SANITIZE_STRING);
        $comentarios = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING);
        $t = new TicketDao();
        $ticket = $t->obtenerTicket($idTicket)['ticket'];
        $cerrar = $t->cambiarStatus($idTicket, 6);
        $actualiza = $t->actualizaCierre($calificacion, $comentarios, $idTicket);

        $this->guardaDetalle($ticket->Asunto,'Ticket Cerrado', $idTicket);
        
        $email = 'sistemas@merdizshell.com';
        $subject = 'Ticket Cerrado';
        $attachment = array();                
        //generamos el mail de notificación al usuario
        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => 'El ticket ' . $ticket->Folio . ' ('.$ticket->Asunto.') ha sido cerrado correctamente.'.'<br><br>'.BASEURL.'ayuda/ticket/'.$idTicket.'/');
        $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        $u = new UsuarioDao();
        $attachment = array();
       
        $usuario = $u->obtenerUsuario(Sesion::Obtener('idUsuario'))['usuarios'];
        Email::enviarEmail($usuario->Mail, '', $subject, $contenidoEmail);
        Email::enviarEmail($email, '', $subject, $contenidoEmail);

        $response['status'] = true;
        $response['mensaje'] = 'Ticket cerrado correctamente.';

        echo json_encode($response);
    }

    public function resolverTicket(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idTicket = filter_input(INPUT_POST, 'idTicket', FILTER_SANITIZE_NUMBER_INT);
        $t = new TicketDao();
        $ticket = $t->obtenerTicket($idTicket)['ticket'];
        $resuelto = $t->cambiarStatus($idTicket, 5);

        $this->guardaDetalle($ticket->Asunto,'Ticket Resuelto', $idTicket);
        
        $email = 'sistemas@merdizshell.com';
        $subject = 'Ticket Resuelto';
        $attachment = array();                
        //generamos el mail de notificación al usuario
        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => 'El ticket ' . $ticket->Folio . ' ('.$ticket->Asunto.') ha sido marcado como resuelto, ingresa al ticket para cerrarlo.'.'<br><br>'.BASEURL.'ayuda/ticket/'.$idTicket.'/');
        $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        $u = new UsuarioDao();
        $attachment = array();
        $usuario = $u->obtenerUsuario($ticket->Id_Usuario)['usuarios'];
        Email::enviarEmail($usuario->Mail, '', $subject, $contenidoEmail);
        Email::enviarEmail($email, '', $subject, $contenidoEmail);

        $response['status'] = true;
        $response['mensaje'] = 'Ticket resuelto correctamente.';

        echo json_encode($response);
    }

    public function enviarAutorizacion(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idTicket = filter_input(INPUT_POST, 'idTicket', FILTER_SANITIZE_NUMBER_INT);
        $t = new TicketDao();
        $ticket = $t->obtenerTicket($idTicket)['ticket'];
        $cerrar = $t->cambiarStatus($idTicket, 3);

        $this->guardaDetalle($ticket->Asunto,'Ticket enviado a Autorización', $idTicket);
                
        $email = 'arturomercado.merdiz@gmail.com';
        $subject = 'Autorizar Ticket';
        $attachment = array();                
        //generamos el mail de notificación al usuario
        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => 'El ticket ' . $ticket->Folio . ' require de autorización.');
        $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        $u = new UsuarioDao();
        $attachment = array();
       
        $usuario = $u->obtenerUsuario(Sesion::Obtener('idUsuario'))['usuarios'];                
        Email::enviarEmail($email, '', $subject, $contenidoEmail);

        $response['status'] = true;
        $response['mensaje'] = 'Ticket enviado a autorización correctamente.';

        echo json_encode($response);
    }

    public function autorizar(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idTicket = filter_input(INPUT_POST, 'idTicket', FILTER_SANITIZE_NUMBER_INT);
        $t = new TicketDao();
        $ticket = $t->obtenerTicket($idTicket)['ticket'];
        $cerrar = $t->cambiarStatus($idTicket, 2);

        $this->guardaDetalle($ticket->Asunto,'Ticket Autorizado', $idTicket);

        $email = 'sistemas@merdizshell.com';
        $subject = 'Ticket autorizado';
        $attachment = array();                
        //generamos el mail de notificación al usuario
        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => 'El ticket ' . $ticket->Folio . ' ('.$ticket->Asunto.') ha sido autorizado.'.'<br><br>'.BASEURL.'ayuda/ticket/'.$idTicket.'/');
        $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        $u = new UsuarioDao();
        $attachment = array();
       
        $usuario = $u->obtenerUsuario(Sesion::Obtener('idUsuario'))['usuarios'];                
        Email::enviarEmail($email, '', $subject, $contenidoEmail);

        $response['status'] = true;
        $response['mensaje'] = 'Ticket autorizado correctamente.';

        echo json_encode($response);
    }
    
    public function eliminar(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idTicket = filter_input(INPUT_POST, 'idTicket', FILTER_SANITIZE_NUMBER_INT);
        $t = new TicketDao();
        $ticket = $t->obtenerTicket($idTicket)['ticket'];
        $cerrar = $t->cambiarStatus($idTicket, 6);

        $this->guardaDetalle($ticket->Asunto,'Ticket Rechazado', $idTicket);

        $email = 'sistemas@merdizshell.com';
        $subject = 'Ticket autorizado';
        $attachment = array();
        //generamos el mail de notificación al usuario
        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => 'El ticket ' . $ticket->Folio . ' ('.$ticket->Asunto.') ha sido rechazado.'.'<br><br>'.BASEURL.'ayuda/ticket/'.$idTicket.'/');
        $opciones = array(
            'http' => array(
                'method' => 'POST',
                'header' => 'Content-type: application/x-www-form-urlencoded',
                'content' => http_build_query($datos)
            )
        );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        $u = new UsuarioDao();
        $attachment = array();

        $usuario = $u->obtenerUsuario(Sesion::Obtener('idUsuario'))['usuarios'];
       // Email::enviarEmail($email, '', $subject, $contenidoEmail);

        $response['status'] = true;
        $response['mensaje'] = 'Ticket rechazado correctamente.';

        echo json_encode($response);
    }

}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        } else {
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxTicketsController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}