<?php
/**
 * AyudaController.php
 * Controlador principal para el módulo de ayuda
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package ayuda
 */

ini_set('display_errors', 1);
error_reporting(E_ALL);

class AyudaController extends Controller
{
    public function __construct()
    {
        $this->_modulo = 'ayuda';
    }
    
    public function index()
    {
        $this->_vista = 'tickets';
        $this->existeVista();
        $this->_datos['accion'] = 'tickets';
        $this->cargarVista();
    }
    
    public function tickets()
    {
        $this->_vista = 'tickets';
        $this->existeVista();
        $this->_datos['accion'] = 'tickets';
        $this->cargarVista();
    }
    
    public function nuevoTicket()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';

        $t = new TicketDao();
        $tickets = $t->obtenerTicketsActivosUsuario(Sesion::obtener('idUsuario'));
        if ($tickets['total'] == 0){
            $this->_vista = 'nuevoTicket';
            $this->existeVista();
            $this->_datos['accion'] = 'tickets';
            $this->cargarVista();
        }
        else{
            ErrorController::mostrarError(1, 'Para generar otro ticket debes cerrar los tickets Resueltos.');
        }
    }

    public function ticket(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';

        $id = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
        $t = new TicketDao();
        $ticket = $t->obtenerTicket($id)['ticket'];

        $d = new DetalleTicketDao();
        $detalle = $d->obtenerDetalle($id)['detalle'];
        $arrayDetalle = new ArrayObject($detalle);
        $iteradorDetalle = $arrayDetalle->getIterator();
        $this->_vista = 'ticket';
        $this->existeVista();
        $this->_datos['accion'] = 'tickets';
        $this->_datos['ticket'] = $ticket;
        $this->_datos['detalle'] = $iteradorDetalle;
        $this->cargarVista();
    }

    public function misTicketsActivos()
    {
        $this->_vista = 'misTicketsActivos';
        $this->existeVista();
        $this->_datos['accion'] = 'tickets';
        $this->cargarVista();
    }

    public function misTickets()
    {
        $this->_vista = 'misTickets';
        $this->existeVista();
        $this->_datos['accion'] = 'tickets';
        $this->cargarVista();
    }

    public function todos()
    {
        if (Sesion::obtener('idUsuario') == 122){
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';

            $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
            $registros = 10;
            $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
            $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

            $inicio = ($pagina - 1) * $registros;       
            
            if ($pagina > $superior){
                $inferior = $pagina;
                $superior = $pagina + 9;
            }
            
            if ($inferior > $pagina){
                $inferior = $pagina - 9;
                $superior = $pagina;
            }

            
            $this->_vista = 'todos';
            $this->existeVista();
            $this->_datos['accion'] = 'tickets';
            $this->cargarVista();
        }
        else{
            ErrorController::mostrarError(403);
        }
    }

    public function autorizar(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';

        $t = new TicketDao();
        $tickets = $t->obtenerTicketsAutorizar();        
        $arrayTickets = new ArrayObject($tickets['tickets']);
        $iteradorTickets = $arrayTickets->getIterator();
        $tickets = [];
        while($iteradorTickets->valid()){
            $d = new DetalleTicketDao();
                $detalle = $d->obtenerDetalleUnico($iteradorTickets->current()->Id_Ticket)['detalle'];
                $descripcion = $detalle->Descripcion;
            $tickets[] = array(                
                'Id_Ticket' => $iteradorTickets->current()->Id_Ticket,
                'Folio' => $iteradorTickets->current()->Folio,
                'Fecha' => date("d/m/ H:i:s", strtotime($iteradorTickets->current()->Fecha)),
                'Descripcion' => $descripcion
            );
            $iteradorTickets->next();
        }
        $this->_vista = 'autorizar';
            $this->existeVista();
            $this->_datos['accion'] = 'tickets';
            $this->_datos['tickets'] = $tickets;
            $this->cargarVista();
    }

    public function reporte(){
        $this->_vista = 'reporte';
            $this->existeVista();
            $this->_datos['accion'] = 'tickets';            
            $this->cargarVista();
    }

    public function generaReporte(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'TicketDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleTicketDao.php';

        $fechaInicial = filter_input(INPUT_POST, 'fechaInicial', FILTER_SANITIZE_STRING);
        $fechaFinal = filter_input(INPUT_POST, 'fechaFinal', FILTER_SANITIZE_STRING);
        $fechaInicial = $fechaInicial . ' 00:00:00';
        $fechaFinal = $fechaFinal . ' 23:59:59';    
        $t = new TicketDao();

        $tickets = $t->obtenerReporte($fechaInicial, $fechaFinal);
        $arrayTickets = new ArrayObject($tickets['tickets']);
        $iteradorTickets = $arrayTickets->getIterator();
        $reporte = [];
        while($iteradorTickets->valid()){
            $idTicket = $iteradorTickets->current()->Id_Ticket;
            $d = new DetalleTicketDao();
                $detalle = $d->obtenerDetalleUnico($iteradorTickets->current()->Id_Ticket)['detalle'];
                $descripcion = $detalle->Descripcion;
            $reporte[] = array(                
                'Id_Ticket' => $iteradorTickets->current()->Id_Ticket,
                'Folio' => $iteradorTickets->current()->Folio,
                'Fecha' => date("d/m/ H:i:s", strtotime($iteradorTickets->current()->Fecha)),
                'Descripcion' => $descripcion,
                'Nombre' => $iteradorTickets->current()->Nombre,
                'Apellido_Paterno' => $iteradorTickets->current()->Apellido_Paterno,
                'Apellido_Materno' => $iteradorTickets->current()->Apellido_Materno,
                'Status' => $iteradorTickets->current()->Status,
                'Calificacion' => $iteradorTickets->current()->Calificacion,
                'Comentarios' => $iteradorTickets->current()->Comentarios
            );

            $iteradorTickets->next();
        }

        $this->_vista = 'generaReporte';
            $this->existeVista();
            $this->_datos['accion'] = 'tickets';         
            $this->_datos['tickets'] = $reporte;
            $this->cargarVista();
    }


}