/**
 * Tickets.js
 * Clase y funciones para el módulo de ayuda
 * @copyright (c) 2015 Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package ayuda
 */

var Ticket = (function(){
    function Ticket()
    {
        
    };
    
    Ticket.prototype.nuevoTicket = function(){
        _this = this;
        formulario = new FormData($('#nuevoTicketForm')[0]);
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            processData: false,
            contentType: false,
            data: formulario,
            beforeSend: function(){
                $('#btnNewTicket').prop('disabled', true).html('<i class="fa fa-spinner" aria-hidden="true"></i> Generando Ticket');
            },
            success: function(response){
                if (response.status){
                     $('#mensajeTicket').removeClass().addClass('alert alert-success').html(response.mensaje);
                     setTimeout(function(){
                         window.location = url + 'ayuda/tickets/';
                     }, 2000);
                }
                $('#btnNewTicket').prop('disabled', false).html('Generar Ticket');
            },
            error: function(xhr, responseText, thrownError){
                $('#btnNewTicket').prop('disabled', false).html('Generar Ticket');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                $('#mensajeTicket').removeClass().addClass('alert alert-danger').html(error);
            }            
        });
    };

    Ticket.prototype.cargarTickesActivos = function(pagina, inferior, superior) {
        _this = this;
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cargarTickesActivos',
                inferior: inferior,
                superior: superior, 
                pagina: pagina
            },
            beforeSend: function(){
                $('.refresh-container-table').show();
            },
            success: function(response){
                $('.refresh-container-table').hide();
                if (response.status){
                    _this.renderTickets(response, 'grillaTicketsActivos');
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Ticket.prototype.cargarTickes = function(pagina, inferior, superior) {
        _this = this;
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cargarTickes',
                inferior: inferior,
                superior: superior, 
                pagina: pagina
            },
            beforeSend: function(){
                $('.refresh-container-table').show();
            },
            success: function(response){
                $('.refresh-container-table').hide();
                if (response.status){
                    _this.renderTickets(response, 'grillaSegumientoTickets');
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Ticket.prototype.renderTickets = function(response, tabla) {
        _this = this;
        console.log(response.tickets.length);
        $('#' + tabla + ' tbody').html('');
        if (response.tickets.length > 0){
            $.each(response.tickets, function(item, el){
                clase = '';
                if(el.Status != '6' && el.Status != '4') clase = 'warning';
                var tr = $('<tr class="'+clase+'"></tr>');
                switch(el.Status){
                    case '1':
                        status = 'Activo';
                        break;
                    case '2':
                        status = 'Autorizado';
                        break;
                    case '3':
                        status = 'En autorizacion';
                        break;
                    case '4':
                        status = 'Esperando respuesta';
                        break;
                    case '5':
                        status = 'Resuelto';
                        break;            
                    case '6':
                        status = 'Cerrado';
                        break;                                                               
                }
                tr.append('<td>' + el.Folio + '</td>');
                tr.append('<td>' + date("d/m/Y", strtotime(el.Fecha)) + '</td>');
                tr.append('<td>' + el.Asunto + '</td>');
                tr.append('<td>' + date("d/m/Y", strtotime(el.Actualizacion)) + ' <small>'+el.nombre+'</small>' + '</td>');
                tr.append('<td>' + status + '</td>');
                prio = '';
                if(el.Status != 6 ){
                    prio = '<span class="label label-success">B</span>';
                    if(el.Prioridad == 2) prio = '<span class="label label-warning">M</span>';
                    if(el.Prioridad == 5) prio = '<span class="label label-danger">A</span>';
                }
                tr.append('<td>'+prio+' <a href="' + url + 'ayuda/ticket/' + el.Id_Ticket + '/"><i class="fa fa-eye"></i> Ver Ticket</a></td>');
                $('#' + tabla + ' tbody').append(tr);
            });

            var ul = $('<ul class="pagination" />');
            pagina = parseInt(response.pagina);
            paginas = parseInt(response.paginas);
            if (pagina > 1) {
                $('<li />').html('<a class="pagina" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
            }
            inferior = response.inferior;
            superior = response.superior;
            paginas = parseInt(response.paginas);
            if (paginas < superior) {
                limite = paginas;
            } else {
                limite = superior;
            }
            for (i = inferior; i <= limite; i++) {
                if (pagina == i) {
                    $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
                } else {
                    $('<li />').html('<a class="pagina" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
                }
            }
            if (pagina < paginas) {
                $('<li />').html('<a class="pagina" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
            }
            $('#paginacion').html(ul);                      
        }
        else{
            var tr = $('<tr></tr>');
            tr.append('<td colspan="6">No se encontraron resultados</td>');
            $('#' + tabla + ' tbody').append(tr);
        }
    };

    Ticket.prototype.enviarRespuesta = function(){
        _this = this;
        forma = new FormData($('#responderForm')[0]);
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'POST',
            dataType: 'json',
            cache: false,
            processData: false,
            contentType: false,
            data: forma,
            success: function(response){
                if (response.status){
                    abreAlerta('Respuesta enviada correctamente');
                    $('#responderForm').trigger('reset');                    
                    setTimeout(function(){
                         window.location.reload();
                     }, 2000);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    }

    Ticket.prototype.cerrarTicket = function(id, calificacion, observaciones){
        _this = this;
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cerrarTicket',
                idTicket: id,
                calificacion: calificacion,
                observaciones: observaciones
            },
            beforeSend: function(){
                $('#cerrarTicketModal').modal('hide');
            },
            success: function(response){
                if (response.status){
                    abreAlerta('Ticket cerrado correctamente');
                    setTimeout(function(){
                        window.location = url + 'ayuda/misTicketsActivos/';
                     }, 2000);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    }

    Ticket.prototype.resolverTicket = function (id){
        _this = this;
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'resolverTicket',
                idTicket: id
            },
            beforeSend: function(){

            },
            success: function(response){
                if (response.status){
                    abreAlerta('Ticket marcado como resuelto correctamente.');
                    setTimeout(function(){
                        window.location = url + 'ayuda/todos/';
                     }, 2000);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    }

    Ticket.prototype.enviarAutorizacion = function (id){
        _this = this;
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'enviarAutorizacion',
                idTicket: id
            },
            beforeSend: function(){

            },
            success: function(response){
                if (response.status){
                    abreAlerta('Autorización generada correctamente.');
                    setTimeout(function(){
                        window.location = url + 'ayuda/todos/';
                     }, 2000);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    }

    Ticket.prototype.autorizarTicket = function(id){
        _this = this;
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'autorizar',
                idTicket: id
            },
            beforeSend: function(){

            },
            success: function(response){
                if (response.status){
                    abreAlerta('Autorización generada correctamente.');
                    setTimeout(function(){
                        window.location = url + 'ayuda/autorizar/';
                     }, 2000);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    }

    Ticket.prototype.eliminarTicket = function(id){
        _this = this;
        $.ajax({
            url: url + 'application/ayuda/controllers/AjaxTicketsController.php',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'eliminar',
                idTicket: id
            },
            beforeSend: function(){

            },
            success: function(response){
                if (response.status){
                    abreAlerta('Autorización generada correctamente.');
                    setTimeout(function(){
                        window.location = url + 'ayuda/autorizar/';
                    }, 2000);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    }
    
    return Ticket;
})();

$(document).ready(function(){    
    if ($('#grillaTicketsActivos').length > 0){
        inferior = $('#inferior').val();
        superior = $('#superior').val();
        pagina = $('#pagina').val();
        t = new Ticket();
        t.cargarTickesActivos(pagina, inferior, superior);
    }

    if ($('#grillaSegumientoTickets').length > 0){
        inferior = $('#inferior').val();
        superior = $('#superior').val();
        pagina = $('#pagina').val();
        t = new Ticket();
        t.cargarTickes(pagina, inferior, superior);
    }
});

//eventos
$(document).on('submit', '#nuevoTicketForm', function(e){
    e.preventDefault();
    asunto = $('#asunto').val();
    prioridad = $('input:radio[name=prioridad]:checked').val();
    mensaje = $('#mensaje').val();
    
    
    if (asunto == ''){
        abreAlerta('Por favor ingresa el asunto. -_-');
        return false;
    }
    
    if (prioridad == '' || prioridad == undefined){
        abreAlerta('Por favor selecciona la prioridad del problema. -_-');
        return false;
    }
    
    if (mensaje == ''){
        abreAlerta('Por favor describe con detalle el problema. -_-');
        return false;
    }
    
    t = new Ticket();
    t.nuevoTicket();
});

$(document).on('click', '#btnAdjunto', function(e){
    e.preventDefault();
    $('#adjunto').click();
});

$(document).on('change', '#adjunto', function(e){
    e.preventDefault();
    archivo = this.files[0];
    tipo = archivo.type;
    nombre = archivo.name;
    console.log(tipo);
    if (!(/\.(jpg|png|gif|jpeg)$/i).test(nombre)) {
        abreAlerta('El archivo debe ser una imagen.');
        return false;
    }
    
    $('#fileInfo').html(archivo.name);
});

$(document).on('click', '.pagina', function(){
    pagina = $(this).attr('data-pagina');
    inferior = $('#inferior').val();
    superior = $('#superior').val();
    t = new Ticket();
    if ($('#grillaTicketsActivos').length > 0)
        t.cargarTickesActivos(pagina, inferior, superior);
    if ($('#grillaSegumientoTickets').length > 0)
        t.cargarTickes(pagina, inferior, superior);
});

$(document).on('click', '#btnSend', function(e){
    console.log('entra');
    t = new Ticket();
    t.enviarRespuesta();
});

$(document).on('click', '#cerrarTicket', function(){
    console.log('entra');
    id = $('#idTicket').val();
    $('#cerrarTicketModal').modal('show');
});

$(document).on('click', '#cerrarTicket2', function(){
    $("#cerrarTicket").trigger("click");
});

$(document).on('click', '#activarTicket', function(){
    $("#divRespuesta").removeClass("hide");
    $("#divResuelto").remove();
});

$(document).on('click', '#resolverTicket', function(){
    id = $('#idTicket').val();
    t = new Ticket();
    t.resolverTicket(id);
});

$(document).on('click', '#btnCerrar', function(){
    calificacion = $('input:radio[name=calificacion]:checked').val()
    console.log(calificacion);
    observaciones = $('#comentarios').val();
    id = $('#idTicket').val();
    t = new Ticket();
    t.cerrarTicket(id, calificacion, observaciones);
});

$(document).on('click', '#enviarAutorizacion', function(){
    id = $('#idTicket').val();
    t = new Ticket();
    t.enviarAutorizacion(id);
});


$(document).on('click', '.autorizar', function(){
    id = $(this).attr('data-id');
    t = new Ticket();
    t.autorizarTicket(id);
});

$(document).on('click', '.eliminar', function(){
    id = $(this).attr('data-id');
    t = new Ticket();
    t.eliminarTicket(id);
});