<?php
/**
 * Description of DetalleTicketDao
 *
 * @author sistemas
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'DetalleTicket.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class DetalleTicketDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function crearDetalle(DetalleTicket $d)
    {
        $sql = "INSERT INTO `detalle_ticket` (`Asunto`, `Descripcion`, `Adjunto`, `Fecha`, `Id_Usuario`,`Id_Ticket`) "
                . "VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $d->__get('_asunto'), PDO::PARAM_STR);
        $stmt->bindValue(2, $d->__get('_descripcion'), PDO::PARAM_STR);
        $stmt->bindValue(3, $d->__get('_adjunto'), PDO::PARAM_STR);
        $stmt->bindValue(4, $d->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(5, $d->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(6, $d->__get('_idTicket'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Esto es embarazoso, pero ocurrió un error al generar tu ticket. Ponte en contacto con sistemas';
        }
        
        return $response;
    }

    public function obtenerDetalle($id){
        $sql = "SELECT * FROM detalle_ticket INNER JOIN usuarios ON usuarios.Id_Usuario = detalle_ticket.Id_Usuario WHERE detalle_ticket.Id_Ticket = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['detalle'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener el detalle del ticket';
        }

        return $response;
    }

    public function obtenerDetalleUnico($id){
        $sql = "SELECT * FROM detalle_ticket INNER JOIN usuarios ON usuarios.Id_Usuario = detalle_ticket.Id_Usuario WHERE detalle_ticket.Id_Ticket = ? ORDER BY Id_Detalle_Ticket ASC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['detalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener el detalle del ticket';
        }

        return $response;
    }
}