<?php
/**
 * TicketDao.php
 * Modelo para la persistencia de datos de tickets
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 beta
 * @package ayuda
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ayuda' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Ticket.php';

class TicketDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function nuevoTicket(Ticket $t)
    {
        $sql = "INSERT INTO `tickets` (`Folio`, `Fecha`, `Prioridad`, `Id_Usuario`, `Status`, `Calificacion`, `Comentarios`) "
                . "VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $t->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindValue(2, $t->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(3, $t->__get('_prioridad'), PDO::PARAM_INT);
        $stmt->bindValue(4, $t->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(5, $t->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(6, '', PDO::PARAM_STR);
        $stmt->bindValue(7, '', PDO::PARAM_STR);
        try{
            $stmt->execute();
            $idTicket = $this->_dbh->lastInsertId();
            $response['status'] = true;
            $response['idTicket'] = $idTicket;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Esto es embarazoso, pero ocurrió un error al generar tu ticket. Ponte en contacto con sistemas';
        }
        
        return $response;
    }

    public function totalTicketsActivos($idUsuario)
    {
        $sql = "SELECT Id_Ticket FROM tickets WHERE Id_Usuario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Ocurrió un error al calcular el total de tickets activos. Ponte en contacto con sistemas';
        }

        return $response;
    }

    public function obtenerTicketsActivos($idUsuario, $inicio, $registros)
    {
        $sql = "SELECT *, 
                    (SELECT Asunto FROM detalle_ticket WHERE Id_Ticket = t.Id_Ticket ORDER BY Fecha DESC LIMIT 1) AS Asunto, 
                    (SELECT Fecha FROM detalle_ticket WHERE Id_Ticket = t.Id_Ticket ORDER BY Fecha DESC LIMIT 1) AS Actualizacion, 
                    (SELECT concat(usuarios.Nombre, ' ', usuarios.Apellido_Paterno, ' ', usuarios.Apellido_Materno) FROM usuarios WHERE Id_Usuario = t.Id_Usuario) AS nombre FROM tickets t WHERE Id_Usuario = ? ORDER BY Fecha DESC LIMIT ?,? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['tickets'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Ocurrió un error al obtener los tickets activos. Ponte en contacto con sistemas';
        }

        return $response;
    }

    public function totalTickets()
    {
        $sql = "SELECT Id_Ticket FROM tickets";
        $stmt = $this->_dbh->prepare($sql);       
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Ocurrió un error al calcular el total de tickets activos. Ponte en contacto con sistemas';
        }

        return $response;
    }

    public function obtenerTickets($inicio, $registros)
    {
        $sql = "SELECT *, 
                    (SELECT Asunto FROM detalle_ticket WHERE Id_Ticket = t.Id_Ticket ORDER BY Fecha DESC LIMIT 1) AS Asunto, 
                    (SELECT Fecha FROM detalle_ticket WHERE Id_Ticket = t.Id_Ticket ORDER BY Fecha DESC LIMIT 1) AS Actualizacion, 
                    (SELECT concat(usuarios.Nombre, ' ', usuarios.Apellido_Paterno, ' ', usuarios.Apellido_Materno) 
                        FROM usuarios WHERE Id_Usuario = (SELECT Id_Usuario FROM detalle_ticket WHERE Id_Ticket = t.Id_Ticket ORDER BY Fecha DESC LIMIT 1)) AS nombre 
                    FROM tickets t ORDER BY t.Status, Actualizacion DESC LIMIT ?,? ";
        $stmt = $this->_dbh->prepare($sql);        
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['sql'] = $sql;
            $response['tickets'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Ocurrió un error al obtener los tickets activos. Ponte en contacto con sistemas';
        }

        return $response;
    }

    public function obtenerTicket($id){
        $sql = "SELECT tickets.*, usuarios.Nombre, usuarios.Apellido_Paterno, usuarios.Apellido_Materno, 
                        (SELECT CASE usuarios.Id_Sucursal WHEN 1 THEN 'Pachuca' WHEN 2 THEN 'Puebla' WHEN 5 THEN 'Querétaro' END) AS Sucursal, 
                        (SELECT Asunto FROM detalle_ticket WHERE detalle_ticket.Id_Ticket = tickets.Id_Ticket LIMIT 1) AS Asunto
                    FROM tickets INNER JOIN usuarios ON usuarios.Id_Usuario = tickets.Id_Usuario WHERE tickets.Id_Ticket = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['ticket'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener el ticket';
        }

        return $response;
    }

    public function cambiarStatus($id, $status){
        $sql = "UPDATE tickets SET Status = ? WHERE Id_Ticket = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_INT);
        $stmt->bindValue(2, $id, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al cambiar el status del ticket';
        }
    }

    public function obtenerTicketsActivosUsuario($idUsuario){
        $sql = "SELECT * FROM tickets WHERE Id_Usuario = ? AND Status = 5";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['tickets'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al validar los tickets activos.';
        }

        return $response;
    }

    public function actualizaCierre($calificacion, $comentarios, $id){        
        $sql = "UPDATE tickets SET Calificacion = ?, Comentarios = ? WHERE Id_Ticket = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $calificacion, PDO::PARAM_STR);
        $stmt->bindValue(2, $comentarios, PDO::PARAM_STR);
        $stmt->bindValue(3, $id, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al validar los tickets activos.';
        }

        return $response;
    }

    public function obtenerTicketsAutorizar(){
        $sql = "SELECT tickets.*, usuarios.Nombre, usuarios.Apellido_Paterno, usuarios.Apellido_Materno FROM tickets INNER JOIN usuarios ON usuarios.Id_Usuario = tickets.Id_Usuario WHERE tickets.Status = 3";
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['tickets'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los ticketes. ' . $e->getMessage();
        }

        return $response;
    }

    public function obtenerReporte($fechaInicial, $fechaFinal)
    {
        $sql = "SELECT tickets.*, usuarios.Nombre, usuarios.Apellido_Paterno, usuarios.Apellido_Materno FROM tickets INNER JOIN usuarios ON usuarios.Id_Usuario = tickets.Id_Usuario WHERE tickets.Fecha BETWEEN ? AND ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['tickets'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los ticketes. ' . $e->getMessage();
        }

        return $response;
    }

}