<?php
/**
 * AjaxBalanceController.php
 * Controlador para el manejo de ajax con el módulo de balance
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */
 

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxBalanceController {

    public function nuevoProcedimiento() {        
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CategoriaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProcedimientoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleProcedimiento.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Validador.php';

        //validamos los datos
        if (!Validador::validarDatos($_POST)) {
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, debes ingresar todos los datos.';
        } else {
            //sanitizamos los datos
            $categoria = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_NUMBER_INT);
            $procedimiento = filter_input(INPUT_POST, 'procedimiento', FILTER_SANITIZE_STRING);
            $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);

            //validamos que se adjunte un archivo
            if (!isset($_FILES['documento']['name'])) {
                $response['status'] = false;
                $response['mensaje'] = 'Lo siento, debes adjuntat tu archivo.';
            } else {
                if ($_FILES['documento']['type'] != 'application/pdf') {
                    $response['status'] = false;
                    $response['mensaje'] = 'Lo siento, debes adjuntar tu archivo en formato PDF.';
                } else {
                    $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                            'documentos' . DIRECTORY_SEPARATOR . 'temporales' . DIRECTORY_SEPARATOR;
                    $nombre = $_FILES['documento']['name'];
                    if (!move_uploaded_file($_FILES['documento']['tmp_name'], $ruta . $nombre)) {
                        $response['status'] = false;
                        $response['mensaje'] = 'Lo siento, no pude subir tu documento. ' . TICKETS;
                    } else {
                        chmod($ruta . $nombre, 0777);
                        $c = new Categoria();
                        $c->__set('_idCategoria', $categoria);
                        $cat = new CategoriaDao();
                        $categoriaa = $cat->obtenerCategoria($c);
                        if ($categoriaa['status']) {
                            $datosCategoria = $categoriaa['categoria'];
                            $fo = $datosCategoria->Folio;
                            $p = new Procedimiento();
                            $p->__set('_idCategoria', $categoria);
                            $p->__set('_procedimiento', $procedimiento);
                            $p->__set('_idUsuario', Sesion::obtener('idUsuario'));
                            $fecha = date("Y-m-d");
                            $pr = new ProcedimientoDao();
                            $totalPro = $pr->totalProcedimientosCategoria($p);
                            if ($totalPro['status']) {
                                $total = $totalPro['total'];
                                if ($total == 0) {
                                    $folio = $fo . '-01';
                                } else {
                                    $folio = $fo . $total + 1;
                                }

                                $p->__set('_folio', $folio);
                                $p->__set('_status', 0);

                                $guardar = $pr->guardarProcedimiento($p);
                                if ($guardar['status']) {
                                    $idProcedimiento = $guardar['idProcedimiento'];
                                    $idUsuario = Sesion::obtener('idUsuario');
                                    $ruta2 = 'temporales/';
                                    $deta = $pr->insertarDetalleProcedimiento($fecha, $descripcion, $nombre, $ruta2, $idUsuario, $idProcedimiento);
                                    if ($deta['status']) {
                                        $response['status'] = true;
                                        $response['mensaje'] = 'Documento guardado correctamente';
                                    } else {
                                        $response['status'] = false;
                                        $response['mensaje'] = $deta['error'];
                                    }
                                } else {
                                    $response['status'] = false;
                                    $response['mensaje'] = $guardar['error'];
                                }
                            } else {
                                $response['status'] = false;
                                $response['mensaje'] = $totalPro['error'];
                            }
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $categoriaa['error'];
                        }
                    }
                }
            }
        }

        echo json_encode($response);
    }

    public function cargarProcedimientos() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProcedimientoDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new ProcedimientoDao();
        $t = $p->totalProcedimientos();
        if ($t['status']) {
            $total = $t['total'];
            $procedimientos = $p->obtenerProcedimientos($inicio, $registros);
            if ($procedimientos['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['procedimientos'] = $procedimientos['procedimientos'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $procedimientos['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }
    
    public function cargarFormatos() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FormatoDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new FormatoDao();
        $t = $p->totalFormatosAutorizados();
        if ($t['status']) {
            $total = $t['total'];
            $procedimientos = $p->obtenerFormatos($inicio, $registros);
            if ($procedimientos['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['formatos'] = $procedimientos['formatos'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $procedimientos['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarManualesCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ManualCalidadDao.php';        

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $c = new ManualCalidadDao();
        $t = $c->totalManualesCalidad();
        if ($t['status']) {
            $total = $t['total'];
            $manuales = $c->obtenerManualesCalidad($inicio, $registros);
            if ($manuales['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['calidad'] = $manuales['manuales'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $manuales['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarProcedimientosAutorizar() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProcedimientoDao.php';       

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new ProcedimientoDao();
        $t = $p->totalProcedimientosAutorizar();
        if ($t['status']) {
            $total = $t['total'];
            $procedimientos = $p->obtenerProcedimientosAutorizar($inicio, $registros);
            if ($procedimientos['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['procedimientos'] = $procedimientos['procedimientos'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $procedimientos['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarManualesCalidadAutorizar() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ManualCalidadDao.php';       

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $c = new ManualCalidadDao();
        $t = $c->totalManualesCalidadAutorizar();
        if ($t['status']) {
            $total = $t['total'];
            $manuales = $c->obtenerManualesCalidadAutorizar($inicio, $registros);
            if ($manuales['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['manuales'] = $manuales['manuales'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $manuales['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function autorizarProcedimiento() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProcedimientoDao.php';

        $idProcedimiento = filter_input(INPUT_POST, 'idProcedimiento', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);

        $p = new Procedimiento();
        $p->__set('_idProcedimiento', $idProcedimiento);
        $p->__set('_status', $status);
        $pr = new ProcedimientoDao();
        $cambiarStatus = $pr->cambiarStatus($p);
        if ($cambiarStatus['status']) {
            $response['status'] = true;
            $proce = $pr->obtenerProcedimiento($p);
            if ($proce['status']) {
                $datosProcedimiento = $proce['procedimiento'];
                $documento = $datosProcedimiento->documento;
                $rutaActual = $datosProcedimiento->ruta . $documento;
                $rutaDocumento = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                        DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $documento;
                //movemos el documento
                if (copy(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $rutaActual, $rutaDocumento)) {
                    chmod($rutaDocumento, 0777);
                    //unlink($rutaActual);
                    $de = $pr->obtenerDetalleAutorizar($idProcedimiento);
                    if ($de['status']) {
                        $detalle = $de['datosDetalle'];
                        $idDetalle = $detalle->Id_Procedimiento_Detalle;
                        $usuarioAutoriza = $pr->usuarioAutoriza(16, $idDetalle);
                        if ($usuarioAutoriza['status']) {
                            $procedimientos = $pr->obtenerProcedimientosAutorizar(10, 10);
                            if ($procedimientos['status']) {
                                $response['status'] = true;
                                $response['mensaje'] = 'Procedimiento autorizado correctamente.';
                                $response['procedimientos'] = $procedimientos['procedimientos'];
                            } else {
                                $response['status'] = false;
                                $response['mensaje'] = 'Procedimiento Autorizado correctamete, pero no se cargaron datos para autorizar.';
                            }
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $usuarioAutoriza['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $de['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = 'Ocurrió un error al guardar el documento';
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $proce['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }

    public function rechazarProcedimiento() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProcedimientoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'PHPMailer.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'SMTP.php';

        $idProcedimiento = filter_input(INPUT_POST, 'idProcedimiento', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);
        $razon = filter_input(INPUT_POST, 'razon', FILTER_SANITIZE_STRING);
        $p = new Procedimiento();
        $p->__set('_idProcedimiento', $idProcedimiento);
        $p->__set('_status', $status);
        $pr = new ProcedimientoDao();
        $cambiarStatus = $pr->cambiarStatus($p);
        if ($cambiarStatus['status']) {
            $obtener = $pr->obtenerProcedimiento($p);
            if ($obtener['status']) {
                $datosProcedimiento = $obtener['procedimiento'];
                $u = new UsuarioDao();
                $idUsuario = $datosProcedimiento->Id_Usuario;
                $usu = $u->obtenerUsuario($idUsuario);
                if ($usu['status']) {
                    $datosUsuario = $usu['usuarios'];
                    $emailUsuario = $datosUsuario->Mail;
                    $asunto = 'Manual de Procedimientos Rechazado';
                    $cuerpo = 'El Manual de Procedimientos ' . $datosProcedimiento->Procedimiento . ' ha sido rechazado. Motivo: ' . $razon . '<br>'
                            . 'Por favor vuelve a solicitar su autorización.<br>No respondas a este correo, fue generado automaticamente.';
                    $mail = new PHPMailer();
                    $mail->isSMTP();
                    $mail->SMTPDebug = 0;
                    $mail->Host = "mail.merdizshell.com";
                    $mail->Port = 2626;
                    $mail->SMTPAuth = true;
                    $mail->Username = 'notificaciones@merdizshell.com';
                    $mail->Password = '@NotificacionesMerdiz';
                    $mail->CharSet = "UTF-8";
                    $mail->setFrom("notificaciones@merdizshell.com", "Notificaciones MerdizShell");
                    $mail->addAddress($emailUsuario);
                    $mail->addBCC("notificaciones@merdizshell.com");
                    $mail->Subject = $asunto;
                    $mail->Body = $cuerpo;
                    $mail->msgHTML($cuerpo);
                    if ($mail->send()) {
                        $response['status'] = true;
                        $response['mensaje'] = 'El procedimiento fue rechazado correctamente. Se ha enviado notificación al usuario';
                    } else {
                        $response['status'] = true;
                        $response['mensaje'] = 'El procedimiento fue rechazado correctamente. Pero no se notificó al usuario. ' . $mail->ErrorInfo;
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $usu['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $obtener['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }

    public function autorizarManualCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ManualCalidadDao.php';

        $idManual = filter_input(INPUT_POST, 'idManual', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);

        $c = new ManualCalidad();
        $c->__set('_idManual', $idManual);
        $c->__set('_status', $status);
        $ca = new ManualCalidadDao();
        $cambiarStatus = $ca->cambiarStatus($c);
        if ($cambiarStatus['status']) {
            $response['status'] = true;
            $proce = $ca->obtenerManual($c);
            if ($proce['status']) {
                $datosManual = $proce['manual'];
                $documento = $datosManual->documento;
                $rutaActual = $datosManual->ruta . $documento;
                $rutaDocumento = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                        DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $documento;
                //movemos el documento
                if (copy(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $rutaActual, $rutaDocumento)) {
                    chmod($rutaDocumento, 0777);
                    //unlink($rutaActual);
                    $de = $ca->obtenerDetalleAutorizar($idManual);
                    if ($de['status']) {
                        $detalle = $de['datosDetalle'];
                        $idDetalle = $detalle->Id_Manual;
                        $usuarioAutoriza = $ca->usuarioAutoriza(16, $idDetalle);
                        if ($usuarioAutoriza['status']) {
                            $response['status'] = true;
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $usuarioAutoriza['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $de['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = 'Ocurrió un error al guardar el documento';
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $proce['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }

    public function autorizarPolitica() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'PoliticasDao.php';

        $idPolitica = filter_input(INPUT_POST, 'idPolitica', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);

        $c = new Politicas();
        $c->__set('_idPolitica', $idPolitica);
        $c->__set('_status', $status);
        $ca = new PoliticasDao();
        $cambiarStatus = $ca->cambiarStatus($c);
        if ($cambiarStatus['status']) {
            $proce = $ca->obtenerPolitica($idPolitica);
            if ($proce['status']) {
                $datosManual = $proce['politica'];
                $documento = $datosManual->Documento;
                $rutaActual = $datosManual->Ruta . $documento;
                $rutaDocumento = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                        DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $documento;
                //movemos el documento
                if (copy(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $rutaActual, $rutaDocumento)) {
                    chmod($rutaDocumento, 0777);
                    //unlink($rutaActual);
                    $de = $ca->obtenerDetalleAutorizar($idPolitica);
                    if ($de['status']) {
                        $detalle = $de['datosDetalle'];
                        $idDetalle = $detalle->Id_Politica_Detalle;
                        $usuarioAutoriza = $ca->usuarioAutoriza(16, $idDetalle);
                        if ($usuarioAutoriza['status']) {
                            $response['status'] = true;
                            $response['mensaje'] = 'Documento autorizado correctamente.';
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $usuarioAutoriza['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $de['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = 'Ocurrió un error al guardar el documento';
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $proce['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }

    public function autorizarInstruccion() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'InstruccionDao.php';

        $idInstruccion = filter_input(INPUT_POST, 'idInstruccion', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'estado', FILTER_SANITIZE_NUMBER_INT);

        $i = new Instruccion();
        $i->__set('_idInstruccion', $idInstruccion);
        $i->__set('_status', $status);
        $in = new InstruccionDao();
        $cambiarStatus = $in->cambiarEstado($i);
        if ($cambiarStatus['status']) {
            $instr = $in->obtener($i);
            if ($instr['status']) {
                $datosInstruccion = $instr['instruccion'];
                $documento = $datosInstruccion->Documento;
                $rutaActual = $datosInstruccion->Ruta . $documento;
                $rutaDocumento = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                        DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $documento;
                //movemos el documento
                if (copy(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $rutaActual, $rutaDocumento)) {
                    chmod($rutaDocumento, 0777);
                    //unlink($rutaActual);
                    $de = $in->obtenerDetalleAutorizar($idInstruccion);
                    if ($de['status']) {
                        $detalle = $de['datosDetalle'];
                        $idDetalle = $detalle->Id_Detalle_Instruccion;
                        $usuarioAutoriza = $in->usuarioAutoriza(16, $idDetalle);
                        if ($usuarioAutoriza['status']) {
                            $response['status'] = true;
                            $response['mensaje'] = 'Documento autorizado correctamente.';
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $usuarioAutoriza['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $de['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = 'Ocurrió un error al guardar el documento';
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $instr['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }

    public function rechazarManualCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ManualCalidadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'PHPMailer.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'SMTP.php';

        $idProcedimiento = filter_input(INPUT_POST, 'idManual', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);
        $razones = filter_input(INPUT_POST, 'razones', FILTER_SANITIZE_STRING);

        $p = new ManualCalidad();
        $p->__set('_idManual', $idProcedimiento);
        $p->__set('_status', $status);
        $pr = new ManualCalidadDao();
        $cambiarStatus = $pr->cambiarStatus($p);
        if ($cambiarStatus['status']) {
            $obtener = $pr->obtenerManual($p);
            if ($obtener['status']) {
                $datosProcedimiento = $obtener['manual'];
                $u = new UsuarioDao();
                $idUsuario = $datosProcedimiento->Id_Usuario;
                $usu = $u->obtenerUsuario($idUsuario);
                if ($usu['status']) {
                    $datosUsuario = $usu['usuarios'];
                    $emailUsuario = $datosUsuario->Mail;
                    $asunto = 'Manual de Calidad Rechazado';
                    $cuerpo = 'El Manual de Calidad ' . $datosProcedimiento->Manual . ' ha sido rechazado por las siguentes razones: ' . $razones
                            . '<br>Por favor vuelve a solicitar su autorización.';
                    $mail = new PHPMailer();
                    $mail->isSMTP();
                    $mail->SMTPDebug = 0;
                    $mail->Host = "mail.merdizshell.com";
                    $mail->Port = 2626;
                    $mail->SMTPAuth = true;
                    $mail->Username = 'notificaciones@merdizshell.com';
                    $mail->Password = '@NotificacionesMerdiz';
                    $mail->CharSet = "UTF-8";
                    $mail->setFrom("notificaciones@merdizshell.com", "Notificaciones MerdizShell");
                    $mail->addAddress($emailUsuario);
                    $mail->Subject = $asunto;
                    $mail->Body = $cuerpo;
                    $mail->msgHTML($cuerpo);
                    if ($mail->send()) {
                        $response['status'] = true;
                        $response['mensaje'] = 'El Manual fue rechazado correctamente. Se ha enviado notificación al usuario';
                    } else {
                        $response['status'] = true;
                        $response['mensaje'] = 'El Manual fue rechazado correctamente. Pero no se envió notificación al usuario';
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $usu['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $obtener['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }

    public function rechazarPolitica() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'PoliticasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'PHPMailer.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'SMTP.php';

        $idPolitica = filter_input(INPUT_POST, 'idPolitica', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);
        $razones = filter_input(INPUT_POST, 'razones', FILTER_SANITIZE_STRING);
        $p = new Politicas();
        $p->__set('_idPolitica', $idPolitica);
        $p->__set('_status', $status);
        $pr = new PoliticasDao();
        $cambiarStatus = $pr->cambiarStatus($p);
        if ($cambiarStatus['status']) {
            $obtener = $pr->obtenerPolitica($idPolitica);
            if ($obtener['status']) {
                $datosProcedimiento = $obtener['politica'];
                $u = new UsuarioDao();
                $idUsuario = $datosProcedimiento->Id_Usuario;
                $usu = $u->obtenerUsuario($idUsuario);
                if ($usu['status']) {
                    $datosUsuario = $usu['usuarios'];
                    $emailUsuario = $datosUsuario->Mail;
                    $asunto = 'Política Calidad Rechazado';
                    $cuerpo = 'La Política de Calidad ' . $datosProcedimiento->Politica . ' ha sido rechazado por las siguentes razones: ' . $razones
                            . '<br>Por favor vuelve a solicitar su autorización.';
                    $mail = new PHPMailer();
                    $mail->isSMTP();
                    $mail->SMTPDebug = 0;
                    $mail->Host = "mail.merdizshell.com";
                    $mail->Port = 2626;
                    $mail->SMTPAuth = true;
                    $mail->Username = 'notificaciones@merdizshell.com';
                    $mail->Password = '@NotificacionesMerdiz';
                    $mail->CharSet = "UTF-8";
                    $mail->setFrom("notificaciones@merdizshell.com", "Notificaciones MerdizShell");
                    $mail->addAddress($emailUsuario);
                    $mail->Subject = $asunto;
                    $mail->Body = $cuerpo;
                    $mail->msgHTML($cuerpo);
                    if ($mail->send()) {
                        $response['status'] = true;
                        $response['mensaje'] = 'El documento fue rechazado correctamente. Se ha enviado notificación al usuario';
                    } else {
                        $response['status'] = true;
                        $response['mensaje'] = 'El documento fue rechazado correctamente. Pero no se envió notificación al usuario';
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $usu['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $obtener['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }

    public function rechazarInstruccion() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'InstruccionDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'PHPMailer.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'SMTP.php';

        $idInstruccion = filter_input(INPUT_POST, 'idInstruccion', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);
        $razones = filter_input(INPUT_POST, 'razones', FILTER_SANITIZE_STRING);

        $p = new Instruccion();
        $p->__set('_idInstruccion', $idInstruccion);
        $p->__set('_status', $status);
        $pr = new InstruccionDao();
        $cambiarStatus = $pr->cambiarEstado($p);
        if ($cambiarStatus['status']) {
            $obtener = $pr->obtener($p);
            if ($obtener['status']) {
                $datosProcedimiento = $obtener['instruccion'];
                $u = new UsuarioDao();
                $idUsuario = $datosProcedimiento->Id_Usuario;
                $usu = $u->obtenerUsuario($idUsuario);
                if ($usu['status']) {
                    $datosUsuario = $usu['usuarios'];
                    $emailUsuario = $datosUsuario->Mail;
                    $asunto = 'Manual de Instrucciones Rechazado';
                    $cuerpo = 'El Manual de Instrucciones ' . $datosProcedimiento->Instruccion . ' ha sido rechazado por las siguentes razones: ' . $razones
                            . '<br>Por favor vuelve a solicitar su autorización.';
                    $mail = new PHPMailer();
                    $mail->isSMTP();
                    $mail->SMTPDebug = 0;
                    $mail->Host = "mail.merdizshell.com";
                    $mail->Port = 2626;
                    $mail->SMTPAuth = true;
                    $mail->Username = 'notificaciones@merdizshell.com';
                    $mail->Password = '@NotificacionesMerdiz';
                    $mail->CharSet = "UTF-8";
                    $mail->setFrom("notificaciones@merdizshell.com", "Notificaciones MerdizShell");
                    $mail->addAddress($emailUsuario);
                    $mail->Subject = $asunto;
                    $mail->Body = $cuerpo;
                    $mail->msgHTML($cuerpo);
                    if ($mail->send()) {
                        $response['status'] = true;
                        $response['mensaje'] = 'El Manual fue rechazado correctamente. Se ha enviado notificación al usuario';
                    } else {
                        $response['status'] = true;
                        $response['mensaje'] = 'El Manual fue rechazado correctamente. Pero no se envió notificación al usuario';
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $usu['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $obtener['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }
    
    public function autorizarFormato() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FormatoDao.php';

        $idInstruccion = filter_input(INPUT_POST, 'idFormato', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'estado', FILTER_SANITIZE_NUMBER_INT);

        $in = new FormatoDao();
        $cambiarStatus = $in->cambiarEstado($idInstruccion, $status);
        if ($cambiarStatus['status']) {
            $instr = $in->obtener($idInstruccion);
            if ($instr['status']) {
                $datosInstruccion = $instr['formato'];
                $documento = $datosInstruccion->Documento;
                $rutaActual = $datosInstruccion->Ruta . $documento;
                $rutaDocumento = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                        DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $documento;
                //movemos el documento
                if (copy(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'documentos' . DIRECTORY_SEPARATOR . $rutaActual, $rutaDocumento)) {
                    chmod($rutaDocumento, 0777);
                    //unlink($rutaActual);
                    $de = $in->obtenerDetalleAutorizar($idInstruccion);
                    if ($de['status']) {
                        $detalle = $de['datosDetalle'];
                        $idDetalle = $detalle->Id_Formato_Detalle;
                        $usuarioAutoriza = $in->usuarioAutoriza(16, $idDetalle);
                        if ($usuarioAutoriza['status']) {
                            $response['status'] = true;
                            $response['mensaje'] = 'Documento autorizado correctamente.';
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $usuarioAutoriza['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $de['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = 'Ocurrió un error al guardar el documento';
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $instr['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }
    
    public function rechazarFormato() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FormatoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'PHPMailer.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'SMTP.php';

        $idFormato = filter_input(INPUT_POST, 'idFormato', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);
        $razones = filter_input(INPUT_POST, 'razones', FILTER_SANITIZE_STRING);

        $pr = new FormatoDao();
        $cambiarStatus = $pr->cambiarEstado($idFormato, $status);
        if ($cambiarStatus['status']) {
            $obtener = $pr->obtener($idFormato);
            if ($obtener['status']) {
                $datosProcedimiento = $obtener['formato'];
                $u = new UsuarioDao();
                $idUsuario = $datosProcedimiento->Id_Usuario;
                $usu = $u->obtenerUsuario($idUsuario);
                if ($usu['status']) {
                    $datosUsuario = $usu['usuarios'];
                    $emailUsuario = $datosUsuario->Mail;
                    $asunto = 'Formato de calidad Rechazado';
                    $cuerpo = 'El formato de calidad ' . $datosProcedimiento->Formato . ' ha sido rechazado por las siguentes razones: ' . $razones
                            . '<br>Por favor vuelve a solicitar su autorización.';
                    $mail = new PHPMailer();
                    $mail->isSMTP();
                    $mail->SMTPDebug = 0;
                    $mail->Host = "mail.merdizshell.com";
                    $mail->Port = 2626;
                    $mail->SMTPAuth = true;
                    $mail->Username = 'notificaciones@merdizshell.com';
                    $mail->Password = '@NotificacionesMerdiz';
                    $mail->CharSet = "UTF-8";
                    $mail->setFrom("notificaciones@merdizshell.com", "Notificaciones MerdizShell");
                    $mail->addAddress($emailUsuario);
                    $mail->Subject = $asunto;
                    $mail->Body = $cuerpo;
                    $mail->msgHTML($cuerpo);
                    if ($mail->send()) {
                        $response['status'] = true;
                        $response['mensaje'] = 'El formato fue rechazado correctamente. Se ha enviado notificación al usuario';
                    } else {
                        $response['status'] = true;
                        $response['mensaje'] = 'El formato fue rechazado correctamente. Pero no se envió notificación al usuario';
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $usu['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $obtener['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }

        echo json_encode($response);
    }

    public function subirManualCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ManualCalidadDao.php';

        $manualCalidad = filter_input(INPUT_POST, 'manualCalidad', FILTER_SANITIZE_STRING);
        $fecha = date("Y-m-d");
        $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
        $idUsuario = Sesion::obtener('idUsuario');

        if (!isset($_FILES['documento']['name'])) {
            $response['status'] = false;
            $response['mensaje'] = 'Debes adjuntar un documento en formato PDF';
        } else {
            $rutaTemporal = BASEPATH . 'application/balance/documentos/temporales/';
            if (!is_dir($rutaTemporal)) {
                mkdir($rutaTemporal, 0777);
            }
            $nombre = $_FILES['documento']['name'];
            if (move_uploaded_file($_FILES['documento']['tmp_name'], $rutaTemporal . $nombre)) {
                chmod($rutaTemporal . $nombre, 0777);
                //generamos el registro
                $m = new ManualCalidadDao();
                $fo = $m->obtenerFolio();
                if ($fo['status']) {
                    $fol = $fo['folio'];
                    $consecutivo = $fol->Folio + 1;

                    $folio = 'CA-' . $consecutivo;
                    $c = new ManualCalidad();
                    $c->__set('_folio', $folio);
                    $fecha = date("Y-m-d");
                    $c->__set('_fecha', $fecha);
                    $c->__set('_manual', $manualCalidad);
                    $c->__set('_idUsuario', Sesion::obtener('idUsuario'));
                    $c->__set('_status', 0);
                    $ruta2 = 'temporales/';
                    $guardar = $m->guardarManualCalidad($c);
                    if ($guardar['status']) {
                        $idCalidad = $guardar['idCalidad'];
                        $det = $m->guardarDetalleCalidad($fecha, $descripcion, $nombre, $ruta2, $idUsuario, $idCalidad);
                        if ($det['status']) {
                            $response['status'] = true;
                            $response['mensaje'] = 'Los datos de tu documento se guardaron correctamente. Se ha enviado a autorización';
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $det['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $guardar['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $fo['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'Ocurrió un error al subir el documento. Intenta más tarde. '
                        . TICKETS;
            }
        }

        echo json_encode($response);
    }

    public function nuevaPolitica() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'PoliticasDao.php';

        $politica = filter_input(INPUT_POST, 'politica', FILTER_SANITIZE_STRING);
        $fecha = date("Y-m-d");
        $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
        $idUsuario = Sesion::obtener('idUsuario');

        if (!isset($_FILES['documento']['name'])) {
            $response['status'] = false;
            $response['mensaje'] = 'Debes adjuntar un documento en formato PDF';
        } else {
            $rutaTemporal = BASEPATH . 'application/balance/documentos/temporales/';
            if (!is_dir($rutaTemporal)) {
                mkdir($rutaTemporal, 0777);
            }
            $nombre = $_FILES['documento']['name'];
            if (move_uploaded_file($_FILES['documento']['tmp_name'], $rutaTemporal . $nombre)) {
                chmod($rutaTemporal . $nombre, 0777);
                //generamos el registro
                $p = new PoliticasDao();
                $fo = $p->obtenerFolio();
                if ($fo['status']) {
                    if ($fo['total'] > 0) {
                        $fol = $fo['folio'];
                        $consecutivo = $fol->Folio + 1;
                    } else {
                        $consecutivo = 1;
                    }

                    $folio = 'PO-' . $consecutivo;
                    $c = new Politicas();
                    $c->__set('_folio', $folio);
                    $fecha = date("Y-m-d");
                    $c->__set('_fecha', $fecha);
                    $c->__set('_politica', $politica);
                    $c->__set('_idUsuario', Sesion::obtener('idUsuario'));
                    $c->__set('_status', 0);
                    $ruta2 = 'temporales/';
                    $guardar = $p->guardar($c);
                    if ($guardar['status']) {
                        $idPolitica = $guardar['idPolitica'];
                        $det = $p->guardarDetallePolitica($fecha, $descripcion, $nombre, $ruta2, $idUsuario, $idPolitica);
                        if ($det['status']) {
                            $response['status'] = true;
                            $response['mensaje'] = 'Los datos de tu documento se guardaron correctamente. Se ha enviado a autorización';
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $det['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $guardar['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $fo['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'Ocurrió un error al subir el documento. Intenta más tarde. '
                        . TICKETS;
            }
        }

        echo json_encode($response);
    }

    public function subirInstruccion() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'InstruccionDao.php';

        $idProcedimiento = filter_input(INPUT_POST, 'procedimiento', FILTER_SANITIZE_NUMBER_INT);
        $instruccion = filter_input(INPUT_POST, 'instruccion', FILTER_SANITIZE_STRING);
        $fecha = date("Y-m-d");
        $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
        $idUsuario = Sesion::obtener('idUsuario');

        if (!isset($_FILES['documento']['name'])) {
            $response['status'] = false;
            $response['mensaje'] = 'Debes adjuntar un documento en formato PDF';
        } else {
            $rutaTemporal = BASEPATH . 'application/balance/documentos/temporales/';
            if (!is_dir($rutaTemporal)) {
                mkdir($rutaTemporal, 0777);
            }
            $nombre = $_FILES['documento']['name'];
            if (move_uploaded_file($_FILES['documento']['tmp_name'], $rutaTemporal . $nombre)) {
                chmod($rutaTemporal . $nombre, 0777);
                //generamos el registro
                $m = new InstruccionDao();
                $fo = $m->obtenerFolio();
                if ($fo['status']) {
                    if ($fo['total'] > 0) {
                        $fol = $fo['folio'];
                        $consecutivo = $fol->Folio + 1;
                    } else {
                        $consecutivo = 1;
                    }

                    $folio = 'IN-' . $consecutivo;
                    $i = new Instruccion();
                    $i->__set('_folio', $folio);
                    $fecha = date("Y-m-d");
                    $i->__set('_fecha', $fecha);
                    $i->__set('_instruccion', $instruccion);
                    $i->__set('_descripcion', $descripcion);
                    $i->__set('_idProcedimiento', $idProcedimiento);
                    $i->__set('_idUsuario', Sesion::obtener('idUsuario'));
                    $i->__set('_status', 0);
                    $ruta2 = 'temporales/';
                    $guardar = $m->guardar($i);
                    if ($guardar['status']) {
                        $idInstruccion = $guardar['idInstruccion'];
                        $det = $m->guardarDetalleInstrcuccion($fecha, $descripcion, $nombre, $ruta2, $idUsuario, $idInstruccion);
                        if ($det['status']) {
                            $response['status'] = true;
                            $response['mensaje'] = 'Los datos de tu documento se guardaron correctamente. Se ha enviado a autorización';
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $det['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $guardar['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $fo['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'Ocurrió un error al subir el documento. Intenta más tarde. '
                        . TICKETS;
            }
        }

        echo json_encode($response);
    }

    public function cargarInstruccionesAutorizar() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'InstruccionDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $i = new InstruccionDao();
        $t = $i->totalInstruccionesAutorizar();
        if ($t['status']) {
            $total = $t['total'];
            $instrucciones = $i->obtenerInstruccionesAutorizar($inicio, $registros);
            if ($instrucciones['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['instrucciones'] = $instrucciones['instrucciones'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $instrucciones['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }
    
    public function cargarFormatosAutorizar() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FormatoDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $i = new FormatoDao();
        $t = $i->totalFormatosAutorizar();
        if ($t['status']) {
            $total = $t['total'];
            $formatos = $i->obtenerFormatosAutorizar($inicio, $registros);
            if ($formatos['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['formatos'] = $formatos['formatos'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $formatos['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarPoliticasAutorizar() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'PoliticasDao.php';
        
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new PoliticasDao();
        $t = $p->totalPoliticasAutorizar();
        if ($t['status']) {
            $total = $t['total'];
            $politicas = $p->obtenerPolitcasAutorizar($inicio, $registros);
            if ($politicas['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['politicas'] = $politicas['politicas'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $politicas['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarPoliticas() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'PoliticasDao.php';
        
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new PoliticasDao();
        $t = $p->totalPoliticasAutorizar();
        if ($t['status']) {
            $total = $t['total'];
            $politicas = $p->obtenerPolitcas($inicio, $registros);
            if ($politicas['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['politicas'] = $politicas['politicas'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $politicas['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarInstrucciones() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'InstruccionDao.php';
        
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new InstruccionDao();
        $t = $p->totalInstruccionesAutorizadas();
        if ($t['status']) {
            $total = $t['total'];
            $procedimientos = $p->obtenerInstrucciones($inicio, $registros);
            if ($procedimientos['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['instrucciones'] = $procedimientos['instrucciones'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $procedimientos['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cambiarEstadoInstruccion() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'InstruccionDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

        $idInstruccion = filter_input(INPUT_POST, 'idInstruccion', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'estado', FILTER_SANITIZE_NUMBER_INT);

        $i = new InstruccionDao();
        $cambiarEstado = $i->cambiarEstado($idInstruccion, $status);
        if ($cambiarEstado['status']) {
            $instrucciones = $i->obtenerInstruccionesAutorizar(0, 10);
            $response['status'] = true;
            $response['instrucciones'] = $instrucciones['instrucciones'];
            if ($status == 1) {
                $response['mensaje'] = 'Documento autorizado correctamente.';
            } else {
                $response['mensaje'] = 'Documento rechazado correctamente. Se ha notificado al usuario.';
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambiarEstado['error'];
        }

        echo json_encode($response);
    }

    public function nuevoFormato() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FormatoDao.php';
        $idInstruccion = filter_input(INPUT_POST, 'instruccion', FILTER_SANITIZE_NUMBER_INT);
        $formato = filter_input(INPUT_POST, 'formato', FILTER_SANITIZE_STRING);
        $fecha = date("Y-m-d");
        $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
        $idUsuario = Sesion::obtener('idUsuario');

        if (!isset($_FILES['documento']['name'])) {
            $response['status'] = false;
            $response['mensaje'] = 'Debes adjuntar un documento en formato PDF';
        } else {
            $rutaTemporal = BASEPATH . 'application/balance/documentos/temporales/';
            if (!is_dir($rutaTemporal)) {
                mkdir($rutaTemporal, 0777);
            }
            $nombre = $_FILES['documento']['name'];
            if (move_uploaded_file($_FILES['documento']['tmp_name'], $rutaTemporal . $nombre)) {
                chmod($rutaTemporal . $nombre, 0777);
                //generamos el registro
                $m = new FormatoDao();
                $fo = $m->obtenerFolio();
                if ($fo['status']) {
                    if ($fo['total'] > 0) {
                        $fol = $fo['folio'];
                        $consecutivo = $fol->Folio + 1;
                    } else {
                        $consecutivo = 1;
                    }

                    $folio = 'FO-' . $consecutivo;
                    $i = new Formato();
                    $i->__set('_folio', $folio);
                    $fecha = date("Y-m-d");
                    $i->__set('_fecha', $fecha);
                    $i->__set('_formato', $formato);
                    $i->__set('_descripcion', $descripcion);
                    $i->__set('_documento', $rutaTemporal . $nombre);
                    $i->__set('_idInstruccion', $idInstruccion);
                    $i->__set('_idUsuario', Sesion::obtener('idUsuario'));
                    $i->__set('_status', 0);
                    $i->__set('_idInstruccion', $idInstruccion);
                    $ruta2 = 'temporales/';
                    $guardar = $m->guardar($i);
                    if ($guardar['status']) {
                        $idInstruccion = $guardar['idFormato'];
                        $det = $m->guardarDetalleFormato($fecha, $descripcion, $nombre, $ruta2, $idUsuario, $idInstruccion);
                        if ($det['status']) {
                            $response['status'] = true;
                            $response['mensaje'] = 'Los datos de tu documento se guardaron correctamente. Se ha enviado a autorización';
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $det['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $guardar['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $fo['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'Ocurrió un error al subir el documento. Intenta más tarde. '
                        . TICKETS;
            }
        }

        echo json_encode($response);
    }
    
    public function guardarCheckMontacargas(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CheckMontacargasDao.php';
        
        $m = new CheckMontacargas();
        switch(Sesion::obtener('idSucursal')){
            case '1':
                $idMontacargas = 1;
                break;
            case '2':
                $idMontacargas = 2;
                break;
            case '5':
                $idMontacargas = 5;
                break;
            default: 
                $idMontacargas = 0;
                break;
        }

        $m->__set('_idMontacargas', $idMontacargas);
        $m->__set('_idSucursal', Sesion::obtener('idSucursal'));
        $m->__set('_fechaInicial', isset($_POST['fechaInicia']) ? $_POST['fechaInicial'] : date("Y-m-d"));
        $m->__set('_fechaFinal', isset($_POST['fechaFinal']) ? $_POST['fechaFinal'] : date("Y-m-d"));
        $m->__set('_idUsuario', Sesion::obtener('idUsuario'));
        $m->__set('_marca', isset($_POST['marca']) ? $_POST['marca'] : '');
        $m->__set('_kmsInicia', isset($_POST['kmsInicial']) ? $_POST['kmsInicial'] : '');
        $m->__set('_kmsFinal', isset($_POST['kmsFinal']) ? $_POST['kmsFinal'] : '');
        $m->__set('_supervisor', isset($_POST['supervisor']) ? $_POST['supervisor'] : '');
        $m->__set('_mes', isset($_POST['mes']) ? $_POST['mes'] : '');
        $m->__set('_dependencia', isset($_POST['dependencia']) ? $_POST['dependencia'] : '');
        $m->__set('_ubicacion', isset($_POST['ubicacion']) ? $_POST['ubicacion'] : '');
        $m->__set('_espejosLateralesAplica', isset($_PST['espejosLateralesAplica']) ? $_POST['espejosLateralesAplica'] : 0);
        $m->__set('_espejosLateralesLunes', isset($_POST['espejosLateralesLunes']) ? $_POST['espejosLateralesLunes'] : 0);
        $m->__set('_espejosLateralesMartes', isset($_POST['espejosLateralesMartes']) ? $_POST['espejosLateralesMartes'] : 0);
        $m->__set('_espejosLateralesMiercoles', isset($_POST['espejosLateralesMiercoles']) ? $_POST['espejosLateralesMiercoles'] : 0);
        $m->__set('_espejosLateralesJueves', isset($_POST['espejosLateralesJueves']) ? $_POST['espejosLateralesJueves'] : 0);
        $m->__set('_espejosLateralesViernes', isset($_POST['espejosLateralesViernes']) ? $_POST['espejosLateralesViernes'] : 0);
        $m->__set('_espejosLateralesSabado', isset($_POST['espejosLateralesSabado']) ? $_POST['espejosLateralesSabado'] : 0);
        $m->__set('_lucesTraserasAplica', isset($_POST['lucesTraserasAplica']) ? $_POST['lucesTraserasAplica'] : 0);
        $m->__set('_lucesTraserasLunes', isset($_POST['lucesTraserasLunes']) ? $_POST['lucesTraserasLunes'] : 0);
        $m->__set('_lucesTraserasMartes', isset($_POST['lucesTraserasMartes']) ? $_POST['lucesTraserasMartes'] : 0);
        $m->__set('_lucesTraserasMiercoles', isset($_POST['lucesTraserasMiercoles']) ? $_POST['lucesTraserasMiercoles'] : 0);

        if (isset($_FILES['documentoMontacargas']['name'])){
            $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'montacargas' . DIRECTORY_SEPARATOR;
            if (date("N") == 1){
                $fechaInicial = date("Y-m-d");
            }
            else{
                $fechaInicial = date("Y-m-d", strtotime('last Monday'));    
            }

            if (date("N") == 6){
                $fechaFinal = date("Y-m-d");
            }
            else{
                $fechaFinal = date("Y-m-d", strtotime('next Saturday'));
            }
                        
            $nombre = Sesion::obtener('idSucursal') . '-' .$fechaInicial . '-' . $fechaFinal;
            move_uploaded_file($_FILES['documentoMontacargas']['tmp_name'], $ruta . $nombre . '.pdf');
            $response['status'] = true;
            $response['mensaje'] = 'Datos guardados correctamente.';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = 'Adjunta el archivo en PDF. -_-';
        }

        
        echo json_encode($response);
    }
    
     public function cargarProcedimientosReporteCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProcedimientoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';


        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new ProcedimientoDao();
        $sistemasCalidadDao = new SistemasCalidadDao();
        $t = $sistemasCalidadDao->totalTipoDeCalidad("-P");
        if ($t['status']) {
            $total = $t['total'];
            $procedimientos = $sistemasCalidadDao->obtenerTipoDeCalidad("-P",$inicio, $registros);
            if ($procedimientos['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['procedimientos'] = $procedimientos['calidad'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $procedimientos['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }


    public function cargarFormatosReporteCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'FormatoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';



        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new FormatoDao();
        $sistemasCalidadDao = new SistemasCalidadDao();
        $t = $sistemasCalidadDao->totalTipoDeCalidad("-F");
        if ($t['status']) {
            $total = $t['total'];
            $procedimientos = $sistemasCalidadDao->obtenerTipoDeCalidad("-F",$inicio, $registros);
            if ($procedimientos['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['formatos'] = $procedimientos['calidad'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $procedimientos['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarManualesReporteCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ManualCalidadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';


        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }
        $sistemasCalidadDao = new SistemasCalidadDao();
        $c = new ManualCalidadDao();
        $t = $sistemasCalidadDao->totalTipoDeCalidad("-C");
        if ($t['status']) {
            $total = $t['total'];
            $manuales = $sistemasCalidadDao->obtenerTipoDeCalidad("-C",$inicio, $registros);
            if ($manuales['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['calidad'] = $manuales['calidad'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $manuales['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarPoliticasReporteCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'PoliticasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';



        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new PoliticasDao();
        $sistemasCalidadDao = new SistemasCalidadDao();
        $t = $sistemasCalidadDao->totalTipoDeCalidad("PO");
        if ($t['status']) {
            $total = $t['total'];
            $politicas = $sistemasCalidadDao->obtenerTipoDeCalidad("PO", $inicio, $registros);
            if ($politicas['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['politicas'] = $politicas['calidad'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $politicas['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function cargarInstruccionesReporteCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'InstruccionDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';



        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $p = new InstruccionDao();
        $sistemasCalidadDao = new SistemasCalidadDao();
        $t = $sistemasCalidadDao->totalTipoDeCalidad("-I");
        if ($t['status']) {
            $total = $t['total'];
            $procedimientos = $sistemasCalidadDao->obtenerTipoDeCalidad("-I",$inicio, $registros);
            if ($procedimientos['status']) {
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['instrucciones'] = $procedimientos['calidad'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $procedimientos['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        }
        else{
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxBalanceController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}