<?php
/**
 * AjaxRutinasController.php
 * Controlador para el manejo de ajax con rutinas
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';
//require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RutinaDao.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'BitacoraRecorridoDao.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

class AjaxRutinasController 
{

    public function getBitacoras(){
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }
        
        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $v = new BitacoraRecorridoDao();
        $bitacoras = $v->getBitacoras(Sesion::obtener('idSucursal'), $inicio, $registros);
        if ($bitacoras['status']){
            $response['status'] = true;
            $total = $bitacoras['total'];
            $paginas = ceil($total / $registros);

            $response['bitacoras'] = $bitacoras['bitacoras'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $bitacoras['error'];
        }

        echo json_encode($response);
    }
    
    public function findBitacora(){
        $termino = filter_input(INPUT_GET, 'cadena', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }
        
        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $v = new BitacoraRecorridoDao();
        $bitacoras = $v->findBitacora(Sesion::obtener('idSucursal'), $inicio, $registros, $termino);
        if ($bitacoras['status']){
            $response['status'] = true;
            $total = $bitacoras['total'];
            $paginas = ceil($total / $registros);

            $response['bitacoras'] = $bitacoras['bitacoras'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $bitacoras['error'];
        }
        
        echo json_encode($response);
    }

    public function getBitacora(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'VehiculoDao.php';
        $idBitacora = filter_input(INPUT_GET, 'idBitacora', FILTER_SANITIZE_NUMBER_INT);

        $v = new BitacoraRecorridoDao();
        
        $bitacora = $v->getBitacora($idBitacora);
        if ($bitacora['status']){
            $bitacora['bitacora']->fechaf = substr($bitacora['bitacora']->Fecha, 0, 10);
            $v = new VehiculoDao();
            $vehiculo = $v->getVehiculo($bitacora['bitacora']->Id_Vehiculo)['vehiculo'];

            $bitacora['bitacora']->Tanque = $vehiculo->Tanque;

            $response['status'] = true;
            $response['bitacora'] = $bitacora['bitacora'];
            $response['myvehiculo'] = $vehiculo;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $bitacora['error'];
        }
        
        echo json_encode($response);
    }

    public function getVehiculo(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'VehiculoDao.php';

        $idVehiculo = filter_input(INPUT_GET, 'idVehiculo', FILTER_SANITIZE_NUMBER_INT);

        $v = new VehiculoDao();
        $b = new BitacoraRecorridoDao();

        $vehiculo = $v->getVehiculo($idVehiculo);
        if ($vehiculo['status']){
            $vehi = $vehiculo['vehiculo'];
            $indi = $b->getLastIndicador($vehi->Id_Vehiculo)['indicador'];
            $kminicial = $indi ? $indi->Km_Final : 0;
            $kmRestante = $indi ? $indi->km_restantes : 0;

            $vehi->Km_Inicial = $kminicial;
            $vehi->km_restantes = $kmRestante;
            $response['status'] = true;
            $response['vehiculo'] = $vehi;
            //$response['kmRestante'] = $kmRestante;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $vehiculo['error'];
        }
        
        echo json_encode($response);
    }

    public function saveBitacora(){
        $tipo = intval(filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT));
        $idBitacora = intval(filter_input(INPUT_POST, 'idBitacora', FILTER_SANITIZE_NUMBER_INT));

        $vales = filter_input(INPUT_POST, 'vales', FILTER_SANITIZE_STRING);

        $br = new BitacoraRecorridoDao();

        Utils::logInfo("LLEGA HASTA EL SAVE", "", "");


        if($tipo == 1 && $idBitacora == 0){
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'BitacoraRecorrido.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RutinaDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Vehiculo.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'VehiculoDao.php';

            $vehiculo = filter_input(INPUT_POST, 'vehiculo', FILTER_SANITIZE_NUMBER_INT);
            $placas = filter_input(INPUT_POST, 'placas', FILTER_SANITIZE_STRING);
            $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $kmRango = filter_input(INPUT_POST, 'kmRango', FILTER_SANITIZE_NUMBER_INT);
            $kmini = filter_input(INPUT_POST, 'kmini', FILTER_SANITIZE_NUMBER_INT);
            $kmfin = filter_input(INPUT_POST, 'kmfin', FILTER_SANITIZE_NUMBER_INT);
            $recorridos = filter_input(INPUT_POST, 'recorridos', FILTER_SANITIZE_NUMBER_INT);
            $kmRestantes = filter_input(INPUT_POST, 'kmRestantes', FILTER_SANITIZE_STRING);
            //$fechaServ = filter_input(INPUT_POST, 'fechaServ', FILTER_SANITIZE_NUMBER_INT);

            $folio = $br->getFolio()['folio'];

            $b = new BitacoraRecorrido();
            $b->__set('_folio', $folio);
            $b->__set('_idVehiculo', $vehiculo);
            $b->__set('_idConductor', Sesion::obtener('idUsuario'));
            $b->__set('_placas', $placas);
            $b->__set('_fecha', $fecha.' '.date("H:i:s"));
            $b->__set('_kmRango', $kmRango);
            $b->__set('_kmInicial', $kmini);
            $b->__set('_kmFinal', $kmfin);
            $b->__set('_kmRecorridos', $recorridos);
            $b->__set('_kmRestantes', $kmRestantes);
            $b->__set('_idSucursal', Sesion::obtener('idSucursal'));

            $bitacora = $br->guardaBitacora($b);
        }else if($tipo == 2 && $idBitacora > 0){
            $bitacora = $br->guardaValesBitacora($idBitacora, $vales);
        }

        if ($bitacora['status']){
            $idBitacora = $bitacora['idBitacora'];

            if($tipo == 1){
                $r = new RutinaDao();
                $c = new ComentariosDao();
                $u = new UsuarioDao();
                $v = new VehiculoDao();

                $v->setKilometraje($vehiculo, $kmfin);
                $v->setKmRestantes($vehiculo, $kmRestantes);

                $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];
                $username = $user->Nombre.' '.$user->Apellido_Paterno.' '.$user->Apellido_Materno;
                $mail = $user->Mail;
                $vehi = $v->getVehiculo($vehiculo)['vehiculo'];


                if($kmRestantes <= 300){
                    $contenidoMail = "Al vehiculo ".$vehi->Marca." ".$vehi->Vehiculo. " con matricula ".$vehi->Placas." le restan ".$kmRestantes."km para su proximo servicio.";
                    Email::enviarEmail($mail, '', 'Proximo Servicio Vehicular', $contenidoMail);
                }

                $rutinas = $r->getRutinasVehiculoRecorrido($vehiculo, $kmfin)['rutinas'];
                foreach ($rutinas as $rutina) {
                    $mult = round($kmfin / $rutina->Frecuencia);
                    $etapa = $mult * $rutina->Frecuencia;
                    $comentario = 'Vehículo '.$vehi->Vehiculo.' con placas '.$vehi->Placas;
                    if($kmfin >= ($rutina->Frecuencia - 200) && $kmfin <= ($rutina->Frecuencia - 100)){
                        $comentario .= ' está próximo a realizar servicio '.$rutina->Rutina;
                    }else if($kmfin >= ($rutina->Frecuencia - 100) && $kmfin <= ($rutina->Frecuencia + 100)){
                        $comentario .= ' ya debe realizar servicio '.$rutina->Rutina;
                    }else if($kmfin >= ($rutina->Frecuencia + 100) && $kmfin <= ($rutina->Frecuencia + 200)){
                        $comentario .= ' no se realizó servicio '.$rutina->Rutina.'. Hacer lo antes posible';
                    }

                    $comm = new Comentarios();
                    $comm->__set('_que',            $rutina->Rutina);
                    $comm->__set('_quien',          $username);
                    $comm->__set('_cuando',         $fecha.' '.date("H:i:s"));
                    $comm->__set('_comentarios',    $comentario);
                    $comm->__set('_etapa',          $etapa);
                    $comm->__set('_idSospechoso',   $rutina->Id_Rutina);
                    $comm->__set('_tipo',           'rutina');
                    $comm->__set('_status',         0);
                    $comm->__set('_progreso',       '0');
                    $comm->__set('_avance',         '0');
                    $comm->__set('_idSucursalComentario', Sesion::obtener('idSucursal'));

                    $res = $c->saveBitacoraServicio($comm);
                }
            }

            $response['status'] = true;
            $response['idBitacora'] = $idBitacora;
            $response['mensaje'] = 'Los datos de la bitacora se guardaron correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $bitacora['error'];
        }
        
        echo json_encode($response);
    }
}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        }
        else{
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxRutinasController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}
