<?php
/**
 * AjaxBalanceController.php
 * Controlador para el manejo de ajax con el módulo de balance
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

ini_set('display_errors', 1);
error_reporting(E_ALL);

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';


class AjaxCuestionarioController {

    public function guardarcuestionario(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuestionarioUsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuestionarioRiesgoPsicologicoDao.php';

        $idCuestionarioRiesgos = (int) filter_input(INPUT_POST, 'idCuestionarioRiesgos', FILTER_SANITIZE_NUMBER_INT);
        $servicioCliente =  filter_input(INPUT_POST, 'servicioCliente', FILTER_SANITIZE_STRING);
        $jefeTrabajadores =  filter_input(INPUT_POST, 'jefeTrabajadores', FILTER_SANITIZE_STRING);

        $cuestionario = $_POST['cuestionario'];
        $cuestionario = json_decode($cuestionario);


        $cuestionarioUsuarioDao = new CuestionarioUsuarioDao();
        $cuestionarioRiesgoPsicologicoDao = new CuestionarioRiesgoPsicologicoDao();
        $seguridadDao = new SeguridadDao();

        $cuestionarioRiesgoPsicologicoDao->actualizarStatusCuestionarioRiesgos('finalizado', $idCuestionarioRiesgos, $servicioCliente, $jefeTrabajadores  );


        foreach ($cuestionario as $preguntas) {

           $idCuestionario = $cuestionarioUsuarioDao->guardarCuestionarioUsuario($preguntas->id, $idCuestionarioRiesgos, $preguntas->comentario, $preguntas->respuesta  )['idCuestionarioUsuario'];

            if($preguntas->comentario != ""){

                $s = new Seguridad();
                $s->__set('_nombre', $preguntas->pregunta);
                $s->__set('_clave', '01');
                $s->__set('_idResponsablepachuca', "");
                $s->__set('_idResponsablepuebla', "");
                $s->__set('_idResponsablequeretaro', "");
                $s->__set('_Dialimite', 0);
                $s->__set('_categoria', 11);
                $s->__set('_descripcion',  $preguntas->pregunta);
                $s->__set('_tipo', 'cuestionario');
                $s->__set('_responsableremplazararchivo', null);
                $s->__set('_idSucursal', null);
                $s->__set('_tipoDescripcion', '');
                $s->__set('_fechaInicio',  date("Y-m-d"));
                $s->__set('_idCuestionarioUsuario', $idCuestionario);

                $guardarTareaSeguridad =  $seguridadDao->altaActividadSeguridad($s);
                if($guardarTareaSeguridad['status']){
                    $idTareaSeguridad = $guardarTareaSeguridad['id'];

                    $a = new Seguridad();
                    $a->__set('_idResponsable', Sesion::obtener('idUsuario'));
                    $a->__set('_idSupervisor', 0 );
                    $a->__set('_status', 'finalizado');
                    $a->__set('_idSeguridad', $idTareaSeguridad );
                    $subirTareaAsignada = $seguridadDao->altaActividadAsignada($a);
                    if($subirTareaAsignada['status']){

                        $idAsignada = $subirTareaAsignada['id'];

                        $t = new Seguridad();
                        $t->__set('_descripcionNoConformidad',  $preguntas->comentario);
                        $t->__set('_idSeguridad', $idAsignada);
                        $t->__set('_status', 'pendiente');
                        $t->__set('_idEmpleado', Sesion::obtener('idUsuario'));
                        $t->__set('_idSucursal', Sesion::obtener('idSucursal'));
                        $t->__set('_tipoDescripcion', 'evento');
                        $t->__set('_fechaInicio', null);
                        $t->__set('_idSupervisor', 16);
                        $seguridadDao->SubirNoConformidad($t);

                        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                        $datos = array("contenido" => "Se ha generado una tarea de no conformidad del cuestionario de riesgos");
                        $opciones = array(
                            'http' => array(
                                'method' => 'POST',
                                'header' => 'Content-type: application/x-www-form-urlencoded',
                                'content' => http_build_query($datos)
                            )
                        );
                        $contexto = stream_context_create($opciones);
                        $contenidoEmail = file_get_contents($url, false, $contexto);
                        Email::enviarEmail('arturomercado.merdiz@gmail.com', '', 'actividad de cuestionario para asignar', $contenidoEmail );



                    }else{
                        $response['status'] = false;
                    }
                }else{
                    $response['status'] = false;
                }

            }

            $response['status'] = true;
            $response['mensaje'] = 'cuestionario guardado correctamente';

        }

        echo json_encode($response);

    }

    public function getCuestionariosPorUsuario(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuestionarioUsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuestionarioRiesgoPsicologicoDao.php';


        $cuestionarioRiesgoPsicologicoDao = new CuestionarioRiesgoPsicologicoDao();

        set_time_limit(120);

        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $pagina = filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);

        $cursos = $cuestionarioRiesgoPsicologicoDao->getAllCuestionariosPorUsuario($idUsuario,$pagina);
        $response['cuestionarios'] = $cursos['cuestionarios'];
        $response['total'] = $cursos['total'];

        echo json_encode($response);
    }


}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        }
        else{
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxCuestionarioController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}
