<?php
/**
 * AjaxCursosController.php
 * Controlador para el manejo de ajax con cursos de Lubecoach
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Prez
 * @version 1.0 Beta
 * @package balance
 */

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxCursosInternosController
{

    public function getCursos(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
            'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }
        
        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $cursosInternosDao = new CursosInternosDao();
        $cursos = $cursosInternosDao->obtenerCursos($inicio, $registros);
        if ($cursos['status']){
            $response['status'] = true;
            $total = $cursos['total'];
            $paginas = ceil($total / $registros);

            $response['cursos'] = $cursos['cursos'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $cursos['error'];
        }

        echo json_encode($response);
    }

    public function saveCurso(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
            DIRECTORY_SEPARATOR . 'PreguntaCursoInternoDao.php';

        $idCurso = filter_input(INPUT_POST, 'idCurso', FILTER_SANITIZE_NUMBER_INT);
        $titulo = filter_input(INPUT_POST, 'titulo', FILTER_SANITIZE_STRING);
        $responsable = filter_input(INPUT_POST, 'responsable', FILTER_SANITIZE_STRING);
        $duracion = filter_input(INPUT_POST, 'duracion', FILTER_SANITIZE_STRING);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_STRING);
        $fechaInicio = filter_input(INPUT_POST, 'fechaInicio', FILTER_SANITIZE_STRING);
        $frecuencia = filter_input(INPUT_POST, 'frecuencia', FILTER_SANITIZE_STRING);
        $tipoCurso = filter_input(INPUT_POST, 'tipoCurso', FILTER_SANITIZE_STRING);
        $normaSeguridad = filter_input(INPUT_POST, 'normaSeguridad', FILTER_SANITIZE_STRING);
        $hoy = date("Y-m-d");

        $induccion = isset($_POST['induccion']) ? 1 : 0;
        $capacitacion = isset($_POST['capacitacion']) ? 1 : 0;

        if($capacitacion == "") $capacitacion = 0;
        if($induccion == "") $induccion = 0;

        $cursosInternosDao = new CursosInternosDao();
        $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();
        $usuarioDao = new UsuarioDao();

        foreach ($_POST['tipoUsuario'] as $tipoUsuario){
            $validarCursoRepetido = $cursosInternosDao->obtenerCursosRepetidos($fechaInicio, $idCurso, $tipoUsuario)['existe'];
            if($validarCursoRepetido > 0){
                $response['status'] = false;
                $response['mensaje'] = 'Ya existe un curso con esta fecha para esos perfiles';
                echo json_encode($response);
                exit();
            }
        }

        if (!empty($_FILES['doc-prese']['name']) && ($_FILES['doc-prese']['type'] == "application/pdf")){
            if($idCurso > 0){
                $preguntaCursoInternoDao = new PreguntaCursoInternoDao();
                $totalPreguntas = $preguntaCursoInternoDao->obtenerPreguntasPorCurso($idCurso)['total'];
                if($totalPreguntas == 0){
                    $response['status'] = false;
                    $response['mensaje'] = 'Para subir la presentacion en necesario capturar las preguntas del examen';
                    echo json_encode($response);
                    exit();
                }
            }

        }else{
            $response['status'] = false;
            $response['mensaje'] = 'El documento debe tener extencin PDF.';
        }



        $clave = $this->generarClaveCurso($tipoCurso, $normaSeguridad, $idCurso );

        if($tipoCurso == "seguridad" ){
            $codigoCurso = null;
            $codigoListaAsistencia = null;

        }else{
            $normaSeguridad = null;
            $codigoCurso = 7;
            $codigoListaAsistencia = 14;
        }

        $servicio = $cursosInternosDao->guardarCurso($idCurso, $titulo, $responsable, "", $duracion, $status, $fechaInicio, $frecuencia, $capacitacion,
            $induccion, $codigoCurso, $codigoListaAsistencia, $normaSeguridad, $clave, $tipoCurso, Sesion::obtener('idUsuario') );
        if ($servicio['status']){
            if($idCurso == 0){
                $idCurso = $servicio['idCurso'];
            }

            if (!empty($_FILES['doc-prese']['name']) && ($_FILES['doc-prese']['type'] == "application/pdf")){
                $filename = 'presentacion_'.$idCurso;
                $ruta = '../lubecoachinterno/';
                $ext = '.pdf';
                copy($_FILES['doc-prese']['tmp_name'],$ruta.$filename.$ext);
            }else{
                $response['status'] = false;
                $response['mensaje'] = 'El documento debe tener extencin PDF.';
            }

            $cursosInternosDao->eliminarRolParticipantesCurso($idCurso);
            foreach ($_POST['tipoUsuario'] as $tipoUsuario){
                $cursosInternosDao->agregarRolParticipantesCurso($tipoUsuario, $idCurso);
            }

            if($fechaInicio == $hoy && $capacitacion == 1){
                $totalCursoCapacitacion = $cursoInternoParticipantesDao->obtenerCursoCapacitacionPorFecha($idCurso, $hoy)['total'];
                if($totalCursoCapacitacion > 0){
                    $idCursoCapacitacion = $cursoInternoParticipantesDao->actualizarCursoCapacitacion($idCurso, $hoy, "progreso", $hoy )['idCursoCapacitacion'];
                }else{
                    $idCursoCapacitacion = $cursoInternoParticipantesDao->agregarCursoCapacitacion($idCurso, $hoy, "progreso", $hoy )['idCursoCapacitacion'];
                }
                $rolesCurso = $cursosInternosDao->obtenerRolesCurso($idCurso)['roles'];

                foreach ($rolesCurso as $rol){

                    $usuarios = $usuarioDao->obtenerUsuariosPorRol($rol->tipo_usuario)['usuarios'];

                    foreach ($usuarios as $usuario){

                        $totalCursoParticipante =  $cursoInternoParticipantesDao->obtenerCursoParticipante($usuario->Id_Usuario,$idCursoCapacitacion , 'progreso')['total'];
                        if($totalCursoParticipante == 0){
                            $cursoInternoParticipantesDao->agregarCursoParticipante($usuario->Id_Usuario,$idCursoCapacitacion , 'progreso');
                         //   $this->enviarMail($usuario->Mail, 'Se te ha asignado un nuevo curso', 'Curso nuevo asignado' );

                        }
                    }
                }

                $this->actualizarFrecuencia($idCurso);
            }

            $response['status'] = true;
            $response['idCurso'] = $idCurso;
            $response['mensaje'] = 'Los datos del curso se guardaron correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $servicio['error'];
        }

        echo json_encode($response);
    }

    public function generarClaveCurso($tipoCurso, $normaSeguridad, $idCurso ){

        $cursosInternosDao =  new CursosInternosDao();

        if($idCurso > 0){
            $curso = $cursosInternosDao->obtenerCurso($idCurso)['curso'];

            if($tipoCurso == "seguridad" and $curso->tipo_curso == "seguridad" and $curso->id_normas_seguridad == $normaSeguridad ){
                $folio = $curso->clave;
            }else if($tipoCurso == "seguridad" and $curso->tipo_curso == "seguridad" and $curso->id_normas_seguridad != $normaSeguridad){
                $folio = $this->generarNuevaClaveCurso($tipoCurso, $normaSeguridad );
            }else if($tipoCurso == "seguridad" and $curso->tipo_curso == "calidad"){
                $folio = $this->generarNuevaClaveCurso($tipoCurso, $normaSeguridad );
            }else if($tipoCurso == "calidad" and $curso->tipo_curso == "seguridad"){
               $folio = $this->generarNuevaClaveCurso($tipoCurso, $normaSeguridad );
            }else if($tipoCurso == "calidad" and $curso->tipo_curso == "calidad"){
                $folio = $curso->clave;
            }else{
                $folio = $this->generarNuevaClaveCurso($tipoCurso, $normaSeguridad );
            }

        }else{
            $folio = $this->generarNuevaClaveCurso($tipoCurso, $normaSeguridad );
        }

        return $folio;
    }

    public function generarNuevaClaveCurso($tipoCurso, $normaSeguridad ){

        $cursosInternosDao = new CursosInternosDao();
        if($tipoCurso == "seguridad"){
            $ultimaClave = $cursosInternosDao->obtenerUltimaClaveCursoSeguridad($normaSeguridad);
            if($ultimaClave['total'] > 0){
                $folio = substr($ultimaClave['norma']->clave, -3);
                $folio = (int) $folio;
                $folio = $folio + 1;
                $folio = Utils::zerofill($folio, 3);
            }else{
                $folio = "001";
            }
        }else{
            $ultimaClave = $cursosInternosDao->obtenerUltimaClaveCursoCalidad();
            if($ultimaClave['total'] > 0){
                $folio = substr($ultimaClave['norma']->clave, -3);
                $folio = (int) $folio;
                $folio = $folio + 1;
                $folio = Utils::zerofill($folio, 3);
            }else{
                $folio = "001";
            }
        }

        return $folio;
    }

    public function findCurso(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

        $termino = filter_input(INPUT_GET, 'cadena', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $cursosInternosDao = new CursosInternosDao();
        $cursos = $cursosInternosDao->buscarCurso($inicio, $registros, $termino);
        if ($cursos['status']){
            $response['status'] = true;
            $total = $cursos['total'];
            $paginas = ceil($total / $registros);

            $response['cursos'] = $cursos['cursos'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $cursos['error'];
        }

        echo json_encode($response);
    }

    public function getCurso(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

        $idCurso = filter_input(INPUT_GET, 'idCurso', FILTER_SANITIZE_NUMBER_INT);

        $cursosInternosDao = new CursosInternosDao();

        $curso = $cursosInternosDao->obtenerCurso($idCurso);
        if ($curso['status']){

           $roles =  $cursosInternosDao->obtenerRolesCurso($idCurso);

           if($roles['status']){
               $response['status'] = true;
               $response['curso'] = $curso['curso'];
               $response['roles'] = $roles['roles'];
               $response['idUsuario'] = Sesion::obtener('idUsuario');
           }else{
               $response['status'] = false;
               $response['mensaje'] = $roles['error'];
           }

        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $curso['error'];
        }

        echo json_encode($response);
    }

    public function savePregunta(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PreguntaCursoInternoDao.php';

        $idPregunta = filter_input(INPUT_POST, 'idPregunta', FILTER_SANITIZE_NUMBER_INT);
        $idCurso = filter_input(INPUT_POST, 'idCurso', FILTER_SANITIZE_NUMBER_INT);
        $pregunta = filter_input(INPUT_POST, 'pregunta', FILTER_SANITIZE_STRING);
        $opcion1 = filter_input(INPUT_POST, 'opcion1', FILTER_SANITIZE_STRING);
        $opcion2 = filter_input(INPUT_POST, 'opcion2', FILTER_SANITIZE_STRING);
        $opcion3 = filter_input(INPUT_POST, 'opcion3', FILTER_SANITIZE_STRING);
        $respuesta = filter_input(INPUT_POST, 'respuesta', FILTER_SANITIZE_NUMBER_INT);
        $explica = filter_input(INPUT_POST, 'explica', FILTER_SANITIZE_STRING);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);

        $preguntaCursoInternoDao = new PreguntaCursoInternoDao();
        $pregunta = $preguntaCursoInternoDao->guardarPregunta($idPregunta, $idCurso, $pregunta, $opcion1, $opcion2, $opcion3, $respuesta, $explica, $status);
        if ($pregunta['status']){
            $idPregunta = $pregunta['idPregunta'];

            $response['status'] = true;
            $response['idPregunta'] = $idPregunta;
            $response['mensaje'] = 'Los datos de la pregunta se guardaron correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $pregunta['error'];
        }

        echo json_encode($response);
    }

    public function getPreguntas(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'PreguntaCursoInternoDao.php';

        $curso = (int) filter_input(INPUT_GET, 'curso', FILTER_SANITIZE_NUMBER_INT);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $preguntaCursoInternoDao = new PreguntaCursoInternoDao();
        $preguntas = $preguntaCursoInternoDao->obtenerPreguntas($curso, $inicio, $registros);
        if ($preguntas['status']){
            $response['status'] = true;
            $total = $preguntas['total'];
            $paginas = ceil($total / $registros);

            $response['preguntas'] = $preguntas['preguntas'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $preguntas['error'];
        }

        echo json_encode($response);
    }

    public function findPregunta(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PreguntaCursoInternoDao.php';

        $curso = (int) filter_input(INPUT_GET, 'curso', FILTER_SANITIZE_NUMBER_INT);
        $termino = filter_input(INPUT_GET, 'cadena', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $preguntaCursoInternoDao = new PreguntaCursoInternoDao();
        $preguntas = $preguntaCursoInternoDao->buscarPregunta($curso, $inicio, $registros, $termino);
        if ($preguntas['status']){
            $response['status'] = true;
            $total = $preguntas['total'];
            $paginas = ceil($total / $registros);

            $response['preguntas'] = $preguntas['preguntas'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $preguntas['error'];
        }

        echo json_encode($response);
    }

    public function getPregunta(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'PreguntaCursoInternoDao.php';

        $idPregunta = filter_input(INPUT_GET, 'idPregunta', FILTER_SANITIZE_NUMBER_INT);

        $preguntaCursoInternoDao = new PreguntaCursoInternoDao();

        $pregunta = $preguntaCursoInternoDao->obtenerPregunta($idPregunta);
        if ($pregunta['status']){
            $response['status'] = true;
            $response['pregunta'] = $pregunta['pregunta'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $pregunta['error'];
        }

        echo json_encode($response);
    }

    public function enviarMail($mail, $mensaje, $subject ){


        $contenido = $mensaje;
        $url = BASEURL .'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => $contenido);
        $opciones = array(
            'http' => array(
                'method' => 'POST',
                'header' => 'Content-type: application/x-www-form-urlencoded',
                'content' => http_build_query($datos)
            )
        );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        Email::enviarEmail($mail, '',  $subject, $contenidoEmail);

    }

    public function actualizarFrecuencia($idCurso ){

        $cursosInternosDao = new CursosInternosDao();

        $curso= $cursosInternosDao->obtenerCurso($idCurso)['curso'];

        if($curso->frecuencia == 'diario' ){
            $fechafinal = date("Y-m-d",strtotime( $curso->fecha."+ 1 days"));
        }else  if($curso->frecuencia == 'semanal' ) {

            $fechafinal = date("Y-m-d",strtotime($curso->fecha."+ 1 week"));

        } else  if($curso->frecuencia == 'mensual' ) {

            $fechafinal = date("Y-m-d",strtotime($curso->fecha."+ 1 month"));

        } else  if($curso->frecuencia == 'mes y medio' ) {

            $fechafinal = date("Y-m-d",strtotime($curso->fecha."+ 45 days"));

        } else  if($curso->frecuencia == '3 meses' ) {

            $fechafinal = date("Y-m-d",strtotime($curso->fecha."+ 3 month"));

        }  else  if($curso->frecuencia == '6 meses' ) {

            $fechafinal = date("Y-m-d",strtotime($curso->fecha."+ 6 month"));

        } else  if($curso->frecuencia == '1 a09o' ) {

            $fechafinal = date("Y-m-d",strtotime($curso->fecha."+ 1 year"));

        }else if ($curso->frecuencia == 'unaVez'){
            $fechafinal = date("Y-m-d",strtotime($curso->fecha));
        }

        $dia =  date("d",strtotime($fechafinal));
        if ($dia = 7 && $curso->frecuencia != 'unaVez' ) {
            $fechafinal = date("Y-m-d",strtotime($fechafinal."+ 1 days"));
        }

        $cursosInternosDao->actualizarFechaCursoCapacitacion($fechafinal, $curso->id_cursos_internos);

    }
    
    
    public function cargarHistorialCursoRechazado(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

        $idAsignada = (int) filter_input(INPUT_GET, 'idAsignada', FILTER_SANITIZE_NUMBER_INT);

        $cursosInternosDao = new CursosInternosDao();


        $razones =  $cursosInternosDao->obtenerRazonesDeRechazo($idAsignada)['razones'];

        $response['razones'] = $razones;
        $response['status'] = true;

        echo json_encode($response);

    }


    

}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        }
        else{
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxCursosInternosController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesin ha caducado. Por favor vuelve a iniciar sesin.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}