<?php
/**
 * AjaxBalanceController.php
 * Controlador para el manejo de ajax con el módulo de balance
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */


date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxForecastController {

    public function cargarClientesForecast() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $totalGlobalClientes = 0;
        $cl = new ClienteDao();
        $t = $cl->totalClientesVendedor(Sesion::obtener('idUsuario'), Sesion::obtener('idSucursal'));
        if ($t['status']) {
            $total = $t['total'];
            $cli = $cl->obtenerClientesPorVendedor(Sesion::obtener('idUsuario'))['clientes'];
            $arrayCli = new ArrayObject($cli);
            $iteradorCli = $arrayCli->getIterator();
            $acumuladoGlobal = 0;
            $f = new ForecastAnualDao();
            $fc = $f->hayForecast(date("Y"), Sesion::obtener('idSucursal'))['forecast'];
            $idForecast = $fc->Id_Forecast;
            while ($iteradorCli->valid()) {
                $de = new DetalleForecastAnualDao();
                $idCliente = $iteradorCli->current()->Id_Cliente;
                $pc = new ProductoClienteDao();
                $acumuladoGlobal = $de->obtenerAcumuladoCliente($idCliente, 'cliente', $idForecast)['totalAcumulado']->totalLitros;
                $totalGlobalClientes += $acumuladoGlobal;
                $iteradorCli->next();
            }


            $paginas = ceil($total / $registros);
            $clientes = $cl->obtenerClientesVendedor(Sesion::obtener('idSucursal'), $inicio, $registros, Sesion::obtener('idUsuario'));
            if ($clientes['status']) {
                $arrayClientes = new ArrayObject($clientes['clientes']);
                $iteradorClientes = $arrayClientes->getIterator();
                $clientesJson = array();
                while ($iteradorClientes->valid()) {
                    $de = new DetalleForecastAnualDao();
                    $idCliente = $iteradorClientes->current()->Id_Cliente;
                    $pc = new ProductoClienteDao();
                    $acumulado = $de->obtenerAcumuladoCliente($idCliente, 'cliente', $idForecast)['totalAcumulado']->totalLitros;
                    $clientesJson[] = array(
                        "Id_Cliente" => $iteradorClientes->current()->Id_Cliente,
                        "Cliente" => $iteradorClientes->current()->Cliente,
                        "RFC" => $iteradorClientes->current()->RFC,
                        "Acumulado" => $acumulado
                    );
                    $iteradorClientes->next();
                }

                $response['status'] = true;
                $response['clientes'] = $clientesJson;
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
                $response['acumuladoClientes'] = $totalGlobalClientes;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $clientes['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $total['error'];
        }

        echo json_encode($response);
    }

    public function buscarClienteForecast() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

        $termino = filter_input(INPUT_GET, 'cliente', FILTER_SANITIZE_STRING);

        $cl = new ClienteDao();
        $cliente = $cl->buscarClienteVendedor($termino, Sesion::obtener('idUsuario'));

        if ($cliente['status']) {
            if ($cliente['total'] > 0) {
                $datosCliente = $cliente['cliente'];
                $de = new DetalleForecastAnualDao();
                $acumulado = $de->obtenerAcumuladoCliente($datosCliente->Id_Cliente, 'cliente', 1)['totalAcumulado']->totalLitros;
                $clientesJson[] = array(
                    "Id_Cliente" => $datosCliente->Id_Cliente,
                    "Cliente" => $datosCliente->Cliente,
                    "RFC" => $datosCliente->RFC,
                    "Acumulado" => $acumulado
                );
                $response['status'] = true;
                $response['clientes'] = $clientesJson;
            } else {
                $response['status'] = true;
                $response['clientes'] = array();
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cliente['error'];
        }

        echo json_encode($response);
    }

    public function cargarProspectosForecast() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $cl = new SospechosoDao();
        $t = $cl->totalProspectosPorVendedor(Sesion::obtener('idUsuario'));
        if ($t['status']) {
            $total = $t['total'];
            $paginas = ceil($total / $registros);
            $totalGlobalProspectos = 0;
            $sos = $cl->obtenerListaSospechosoPorVendedor(Sesion::obtener('idUsuario'))['sospechosos'];
            $arraySospechosos = new ArrayObject($sos);
            $iteradorSospechosos = $arraySospechosos->getIterator();
            $f = new ForecastAnualDao();
            $fc = $f->hayForecast(date("Y"), Sesion::obtener('idSucursal'))['forecast'];
            $idForecast = $fc->Id_Forecast;
            while ($iteradorSospechosos->valid()) {
                $de = new DetalleForecastAnualDao();
                $idSospechoso = $iteradorSospechosos->current()->Id_Sospechoso;
                $ps = new ProductoProspectoDao();
                $acumulado = $de->obtenerAcumuladoCliente($idSospechoso, 'prospecto', $idForecast)['totalAcumulado']->totalLitros;
                $totalGlobalProspectos += $acumulado;
                $iteradorSospechosos->next();
            }

            $clientes = $cl->obtenerProspectosPorVendedor(Sesion::obtener('idUsuario'), $inicio, $registros, Sesion::obtener('idUsuario'));
            if ($clientes['status']) {
                $arrayProspectos = new ArrayObject($clientes['prospectos']);
                $iteradorClientes = $arrayProspectos->getIterator();
                $prospectosJson = array();
                while ($iteradorClientes->valid()) {
                    $de = new DetalleForecastAnualDao();
                    $idSospechoso = $iteradorClientes->current()->Id_Sospechoso;
                    $acumulado = $de->obtenerAcumuladoCliente($idSospechoso, 'prospecto', $idForecast)['totalAcumulado']->totalLitros;
                    $prospectosJson[] = array(
                        "Id_Sospechoso" => $iteradorClientes->current()->Id_Sospechoso,
                        "Cliente" => $iteradorClientes->current()->Cliente,
                        "Rfc" => $iteradorClientes->current()->Rfc,
                        "Acumulado" => $acumulado
                    );
                    $iteradorClientes->next();
                }

                $response['status'] = true;
                $response['clientes'] = $prospectosJson;
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
                $response['acumuladoClientes'] = $totalGlobalProspectos;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $clientes['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $total['error'];
        }

        echo json_encode($response);
    }

    public function buscarProspectoForecast() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

        $termino = filter_input(INPUT_GET, 'cliente', FILTER_SANITIZE_STRING);
        $s = new SospechosoDao();
        $sospechoso = $s->buscarProspectoVendedor($termino, Sesion::obtener('idUsuario'));
        if ($sospechoso['status']) {
            if ($sospechoso['total'] > 0) {
                $datosSospechoso = $sospechoso['cliente'];
                $de = new DetalleForecastAnualDao();
                $idSospechoso = $datosSospechoso->Id_Sospechoso;
                $acumulado = $de->obtenerAcumuladoCliente($idSospechoso, 'prospecto', 1)['totalAcumulado']->totalLitros;
                $prospectosJson[] = array(
                    "Id_Sospechoso" => $datosSospechoso->Id_Sospechoso,
                    "Cliente" => $datosSospechoso->Cliente,
                    "Rfc" => $datosSospechoso->Rfc,
                    "Acumulado" => $acumulado
                );
                $response['status'] = true;
                $response['clientes'] = $prospectosJson;
            } else {
                $response['status'] = true;
                $response['clientes'] = array();
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $sospechoso['error'];
        }

        echo json_encode($response);
    }

    public function guardaForecastAnual() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'AutorizacionesForecastAnualDao.php';

        $idCliente = filter_input(INPUT_POST, 'cliente', FILTER_SANITIZE_NUMBER_INT);
        $productos = $_POST['producto'];
        $clasificacion = filter_input(INPUT_POST, 'clasificacion', FILTER_SANITIZE_STRING);
        $totalProductos = count($productos);
        $contador = 0;
        
         $this->guardarServiciosCliente($idCliente);

        $datosForecast = $this->validarForecastAnual($clasificacion);
        $idForecast = $datosForecast->Id_Forecast;

        $fa = new ForecastAnualDao();
        $autorizacionesForecastAnualDao = new AutorizacionesForecastAnualDao();

        if($clasificacion == "actualizaForecast"){
            $clasificacion = 'forecast';
        }

        $existeAutorizacionForecast = $autorizacionesForecastAnualDao->hayAutorizacionForecastAnual($idForecast, Sesion::obtener('idUsuario'))['total'];
       /*if($existeAutorizacionForecast == 0){
            $autorizacionesForecastAnualDao->insertarAutorizacionForecastAnual('autorizacion',$idForecast, Sesion::obtener('idUsuario'));
        }else{
            $autorizacionesForecastAnualDao->actualizarAutorizacionForecastAnual('autorizacion',$idForecast, Sesion::obtener('idUsuario'));

        }*/



            //validamos si hay forecast lo eliminaos y guardamos el nuevo
            $de = new DetalleForecastAnualDao();
            $de->eliminarForecastCliente($idCliente, 'cliente', $idForecast);

            for ($i = 0; $i < $totalProductos; $i++) {
                $consumoEstimado1 = $_POST['enero_' . $productos[$i]];
                $consumoEstimado2 = $_POST['febrero_' . $productos[$i]];
                $consumoEstimado3 = $_POST['marzo_' . $productos[$i]];
                $consumoEstimado4 = $_POST['abril_' . $productos[$i]];
                $consumoEstimado5 = $_POST['mayo_' . $productos[$i]];
                $consumoEstimado6 = $_POST['junio_' . $productos[$i]];
                $consumoEstimado7 = $_POST['julio_' . $productos[$i]];
                $consumoEstimado8 = $_POST['agosto_' . $productos[$i]];
                $consumoEstimado9 = $_POST['septiembre_' . $productos[$i]];
                $consumoEstimado10 = $_POST['octubre_' . $productos[$i]];
                $consumoEstimado11 = $_POST['noviembre_' . $productos[$i]];
                $consumoEstimado12 = $_POST['diciembre_' . $productos[$i]];
                $total = $_POST['total_' . $productos[$i]];
                $totalLitros = $_POST['totalLitros_' . $productos[$i]];

                $d = new DetalleForecastAnual();
                $d->__set('_idProducto', $productos[$i]);
                $d->__set('_idCliente', $idCliente);
                $d->__set('_tipo', 'cliente');
                $d->__set('_clasificacion', $clasificacion);
                $d->__set('_enero', $consumoEstimado1);
                $d->__set('_febrero', $consumoEstimado2);
                $d->__set('_marzo', $consumoEstimado3);
                $d->__set('_abril', $consumoEstimado4);
                $d->__set('_mayo', $consumoEstimado5);
                $d->__set('_junio', $consumoEstimado6);
                $d->__set('_julio', $consumoEstimado7);
                $d->__set('_agosto', $consumoEstimado8);
                $d->__set('_septiembre', $consumoEstimado9);
                $d->__set('_octubre', $consumoEstimado10);
                $d->__set('_noviembre', $consumoEstimado11);
                $d->__set('_diciembre', $consumoEstimado12);
                $d->__set('_total', $total);
                $d->__set('_totalLitros', $totalLitros);
                $d->__set('_idForecast', $idForecast);


                $detalle = $de->guardar($d);

                if (!$detalle['status']) {
                    $contador++;
                    break;
                }
            }

            //actualizamos los litros
            $tla = $de->obtenerTotalLitros($idForecast)['totalLitros'];
            $totalLitrosAcumulados = $tla->totalLitros;
            $totalLitrosAcumulados += $totalLitros;
            $actualiza = $fa->actualizaLitrosForecast($totalLitrosAcumulados, $idForecast);

            if ($contador == 0) {
                $response['status'] = true;
                $response['mensaje'] = 'Forecast guardado correctamente. Por favor revisa tus datos';
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'Lo siento, ocurrió un error al guardar los datos. ' . TICKETS;
            }


        echo json_encode($response);
    }

    public function guardaForecastMensual() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR .
                'ForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';

        $idCliente = filter_input(INPUT_POST, 'cliente', FILTER_SANITIZE_NUMBER_INT);
        $tipo = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_STRING);
        $fechaInicial = filter_input(INPUT_POST, 'mes', FILTER_SANITIZE_STRING);
        //obtenemos el forecast del mes

        $fechaFinal = date("Y-m-d", strtotime($fechaInicial . '+ 1months'));
        $fechaFinal = date("Y-m-d", strtotime($fechaFinal .  '- 1day'));

        $f = new ForecastMensualDao();
        $hay = $f->obtenerForecastMensualPorUsuarioYSucursal($fechaInicial, $fechaFinal, Sesion::obtener('idUsuario') , Sesion::obtener('idSucursal'));
        if ($hay['total'] > 0){
            $datosForecast = $hay['datosForecast'];
            $idForecast = $datosForecast->Id_Forecast;
        }
        else{
            $fc = new ForecastMensual();
            $fc->__set('_fecha', $fechaInicial);
            $fc->__set('_idUsuario', Sesion::obtener('idUsuario'));
            $fc->__set('_idSucursal', Sesion::obtener('idSucursal'));
            $fc->__set('_status', 0);
            $fcG = new ForecastMensualDao();
            $guardar = $fcG->guardar($fc);
            if ($guardar['status']){
                $idForecast = $guardar['idForecast'];
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $guardar['error'];
                echo json_encode($response);
                exit;
            }
        }
        $det = new DetalleForecastMensualDao();
        $elimina = $det->eliminarDetalle($idCliente, $tipo, $idForecast);

        //guardamos el detalle del forecast
        $productos = $_POST['producto'];
        $contador = 0;
        
        foreach($productos as $key => $value){
            $d = new DetalleForecastMensual();
            $d->__set('_idCliente', $idCliente);
            $d->__set('_tipo', $tipo);
            $d->__set('_idProducto', $value);
            $d->__set('_semana1', $_POST['semana1_' . $value]);
            $d->__set('_semana2', $_POST['semana2_' . $value]);
            $d->__set('_semana3', $_POST['semana3_' . $value]);
            $d->__set('_semana4', $_POST['semana4_' . $value]);
            $d->__set('_mes1', isset($_POST['mes1_' . $value]) ? $_POST['mes1_' . $value] : 0);
            $d->__set('_mes2',  isset($_POST['mes2_' . $value]) ? $_POST['mes2_' . $value] : 0);
            $d->__set('_mes3',  isset($_POST['mes3_' . $value]) ? $_POST['mes3_' . $value] : 0);
            $d->__set('_status', 0);
            $d->__set('_idForecast', $idForecast);

            $det = new DetalleForecastMensualDao();
            $detalle = $det->guardar($d);
            if (!$detalle['status']){
                $contador++;
                break;
            }
        }

        if ($contador == 0){
            $response['status'] = true;
            $response['mensaje'] = 'Forecast guardado correctamente. Se ha enviado a autorización.';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al guardar el detalle del forecast. ' . TICKETS;
        }

        echo json_encode($response);

    }

    public function guardaForecastAnualProspecto() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'AutorizacionesForecastAnualDao.php';

        $idCliente = filter_input(INPUT_POST, 'cliente', FILTER_SANITIZE_NUMBER_INT);
        $productos = $_POST['producto'];
        $totalProductos = count($productos);
        $clasificacion = filter_input(INPUT_POST, 'clasificacion', FILTER_SANITIZE_STRING);
        $contador = 0;
        
        $this->guardarServiciosSospechoso($idCliente);

        $datosForecast = $this->validarForecastAnual($clasificacion);
        $idForecast = $datosForecast->Id_Forecast;

        $fa = new ForecastAnualDao();
        $autorizacionesForecastAnualDao = new AutorizacionesForecastAnualDao();

        if($clasificacion == "actualizaForecast"){

            $clasificacion = 'forecast';
        }

        $existeAutorizacionForecast = $autorizacionesForecastAnualDao->hayAutorizacionForecastAnual($idForecast, Sesion::obtener('idUsuario'))['total'];
      /*  if($existeAutorizacionForecast == 0){
            $autorizacionesForecastAnualDao->insertarAutorizacionForecastAnual('autorizacion',$idForecast, Sesion::obtener('idUsuario'));
        }else{
            $autorizacionesForecastAnualDao->actualizarAutorizacionForecastAnual('autorizacion',$idForecast, Sesion::obtener('idUsuario'));

        }*/

            //validamos si hay forecast lo eliminamos y guardamos el nuevo
            $de = new DetalleForecastAnualDao();
            $de->eliminarForecastCliente($idCliente, 'prospecto', $idForecast);

            for ($i = 0; $i < $totalProductos; $i++) {
                $consumoEstimado1 = $_POST['enero_' . $productos[$i]];
                $consumoEstimado2 = $_POST['febrero_' . $productos[$i]];
                $consumoEstimado3 = $_POST['marzo_' . $productos[$i]];
                $consumoEstimado4 = $_POST['abril_' . $productos[$i]];
                $consumoEstimado5 = $_POST['mayo_' . $productos[$i]];
                $consumoEstimado6 = $_POST['junio_' . $productos[$i]];
                $consumoEstimado7 = $_POST['julio_' . $productos[$i]];
                $consumoEstimado8 = $_POST['agosto_' . $productos[$i]];
                $consumoEstimado9 = $_POST['septiembre_' . $productos[$i]];
                $consumoEstimado10 = $_POST['octubre_' . $productos[$i]];
                $consumoEstimado11 = $_POST['noviembre_' . $productos[$i]];
                $consumoEstimado12 = $_POST['diciembre_' . $productos[$i]];
                $total = $_POST['total_' . $productos[$i]];
                $totalLitros = $_POST['totalLitros_' . $productos[$i]];

                $d = new DetalleForecastAnual();
                $d->__set('_idProducto', $productos[$i]);
                $d->__set('_idCliente', $idCliente);
                $d->__set('_tipo', 'prospecto');
                $d->__set('_clasificacion', $clasificacion);
                $d->__set('_enero', $consumoEstimado1);
                $d->__set('_febrero', $consumoEstimado2);
                $d->__set('_marzo', $consumoEstimado3);
                $d->__set('_abril', $consumoEstimado4);
                $d->__set('_mayo', $consumoEstimado5);
                $d->__set('_junio', $consumoEstimado6);
                $d->__set('_julio', $consumoEstimado7);
                $d->__set('_agosto', $consumoEstimado8);
                $d->__set('_septiembre', $consumoEstimado9);
                $d->__set('_octubre', $consumoEstimado10);
                $d->__set('_noviembre', $consumoEstimado11);
                $d->__set('_diciembre', $consumoEstimado12);
                $d->__set('_total', $total);
                $d->__set('_totalLitros', $totalLitros);
                $d->__set('_idForecast', $idForecast);


                $detalle = $de->guardar($d);

                if (!$detalle['status']) {
                    $contador++;
                    break;
                }
            }

            $tla = $de->obtenerTotalLitros($idForecast)['totalLitros'];
            $totalLitrosAcumulados = $tla->totalLitros;
            $totalLitrosAcumulados += $totalLitros;
            $actualiza = $fa->actualizaLitrosForecast($totalLitrosAcumulados, $idForecast);

            if ($contador == 0) {
                $response['status'] = true;
                $response['mensaje'] = 'Forecast guardado correctamente. Por favor revisa tus datos';
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'Lo siento, ocurrió un error al guardar los datos. ' . TICKETS;
            }


        echo json_encode($response);
    }

     public function autorizarForecastVendedor()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';

        $idVendedor = filter_input(INPUT_POST, 'idVendedor', FILTER_SANITIZE_NUMBER_INT);

        $date = date('Y-m-01');

        $dia = date('d');
        if($dia > 7){
            $fechaInicial = date('Y-m-01',strtotime($date. ' +1 months'));
            $fechaFinal = date('Y-m-t',strtotime($date. ' +1 months'));
        }else{
            $fechaInicial = date('Y-m-01');
            $fechaFinal = date('Y-m-31');
        }

        $f = new ForecastMensualDao();
        $forecast = $f->obtenerForecastMensualAutorizar($idVendedor, $fechaInicial, $fechaFinal, Sesion::obtener('idSucursal'));
        if ($forecast['status']){
            $datosForecast = $forecast['datosForecast'];
            $idForecast = $datosForecast->Id_Forecast;
            $d = new DetalleForecastMensualDao();
            $autoriza = $d->autorizaForecastMensualCompleto($idForecast);
            if ($autoriza['status']){
                $f->actualizaStatus($idForecast, 1);
                $response['status'] = true;
                $response['mensaje'] = 'Forecast autorizado correctamente';
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $autoriza['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $forecast['error'];
        }

        echo json_encode($response);
    }

    public function obtenerForecastVendedor(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';

        $mes = filter_input(INPUT_GET, 'fechaInicial', FILTER_SANITIZE_STRING);
        $idCliente = filter_input(INPUT_GET, 'idCliente', FILTER_SANITIZE_STRING);
        $tipo = filter_input(INPUT_GET, 'tipo', FILTER_SANITIZE_STRING);
        $thisYear = date('Y');
        $fechaInicial = $mes ;

        $fechaFinal = date("Y-m-t", strtotime($mes));

        if($tipo == "sospechoso"){
            $tipo2= "prospecto";
        }else{
            $tipo2= "cliente";
        }


        $f = new ForecastMensualDao();
        $i = 1;
        $totalUnidades = 0;
        $totalLitros = 0;
        $arrayForecast = array();
        $fore = $f->obtenerForecastMensual($fechaInicial, $fechaFinal, Sesion::obtener('idUsuario'));
        if ($fore['total'] > 0) {
            $datosForecast = $fore['datosForecast'];
            $idForecast = $datosForecast->Id_Forecast;
        } else {
            $idForecast = 0;
        }
        $totalLitrosGlobal = 0;
        $totalUnidadesGlobal = 0;
        $fechaInicialAnterior = date("Y-m-01", strtotime($fechaInicial . '-1 months'));
        $fechaFinalAnterior = date("Y-m-t", strtotime($fechaInicial . '-1 months'));


        //obtenemos el forecast anterior
        $ant = $f->obtenerForecastMensual($fechaInicialAnterior, $fechaFinalAnterior,  Sesion::obtener('idUsuario'));
        if ($ant['total'] > 0){
            $datosForecastAnerior = $ant['datosForecast'];
            $idForecastAnterior = $datosForecastAnerior->Id_Forecast;
        }
        else{
            $idForecastAnterior = 0;
        }

        $pc = new ProductoClienteDao();
        $p = new ProductoProspectoDao();
        if($tipo == "sospechoso"){
            $productos = $p->obtenerProductosProspecto($idCliente);
        }else{
            $productos = $pc->obtenerProductosCliente($idCliente);
        }



        $arrayProductos = new ArrayObject($productos['productos']);
        $iteradorProductos = $arrayProductos->getIterator();

        while ($iteradorProductos->valid()){
            /* $totalUnidades += $this->_datos['productos']->current()->Total;
              $totalLitros += $this->_datos['productos']->current()->Total_Litros; */
            $idProducto = $iteradorProductos->current()->Id_Producto;
            $p = new ProductoDao();
            $producto = $p->obtenerProducto($idProducto)['producto'];
            //obtenemos el forecast Anterior
            //obtenemos el detalle del forecast
            if ($idForecast > 0) {
                $d = new DetalleForecastMensualDao();
                $det = $d->obtenerForecastProductoCliente($idCliente, $tipo2, $idProducto, $idForecast);
                if ($det['total'] > 0):
                    $detalle = $det['detalle'];
                    $semana1 = $detalle->Semana1;
                    $semana2 = $detalle->Semana2;
                    $semana3 = $detalle->Semana3;
                    $semana4 = $detalle->Semana4;
                    $mes1 = $detalle->Mes1;
                    $mes2 = $detalle->Mes2;
                    $mes3 = $detalle->Mes3;
                    $totalUnidades = $semana1 + $semana2 + $semana3 + $semana4;
                    $totalLitros = $totalUnidades * $producto->Litraje;
                    $statusForecast = $detalle->Status;
                else:
                    $semana1 = 0;
                    $semana2 = 0;
                    $semana3 = 0;
                    $semana4 = 0;
                    $mes1 = 0;
                    $mes2 = 0;
                    $mes3 = 0;
                    $totalUnidades = 0;
                    $totalLitros = 0;
                    $statusForecast = 0;
                endif;
            }
            else {
                $semana1 = 0;
                $semana2 = 0;
                $semana3 = 0;
                $semana4 = 0;
                $mes1 = 0;
                $mes2 = 0;
                $mes3 = 0;
                $totalUnidades = 0;
                $totalLitros = 0;
                $statusForecast = 0;
            }




            $anterior = 0;
            //obtenemos el forecast anterior
            $d = new DetalleForecastMensualDao();
            $fa = $d->obtenerForecastProductoCliente($idCliente, $tipo2, $idProducto, $idForecastAnterior);
            if ($fa['total'] > 0){
                $datosAnterior = $fa['detalle'];
                $anterior = $datosAnterior->Mes1;
            }
            else{
                $anterior = 0;
            }



            $totalLitrosGlobal += $totalLitros;
            $totalUnidadesGlobal += $totalUnidades;

            //obtenemos el forecast anual
            $fa = new DetalleForecastAnualDao();
            $fan = $fa->obtenerForecastPorMesCliente($idCliente, $idProducto, $tipo);
            $forecastAnual = 0;
            if ($fan['existe'] > 0){
                $datosAnual = $fan['forecast'];
                $datosAnual->mayo;
                $enero = $datosAnual->enero;
            } else {
                $enero = 0;
            }


            if (!isset($statusForecast)){
                $statusForecast = 0;
            }


            $arrayForecast[] = array(
                'semana1' => $semana1,
                'semana2' => $semana2,
                'semana3' => $semana3,
                'semana4' => $semana4,
                'litraje' => $iteradorProductos->current()->Litraje,
                'idProducto' =>   $iteradorProductos->current()->Id_Producto,
                'nombre' =>   $iteradorProductos->current()->Nombre,
                'Unidad_Venta' =>   $iteradorProductos->current()->Unidad_Venta,
                'Consumo_Estimado' =>   $iteradorProductos->current()->Consumo_Estimado,
                'anterior' =>  $anterior,
                'totalUnidades' =>  $totalUnidades,
                'enero' => $enero,
                'totalLitros' => $totalLitros,
                'mes1' => $mes1,
                'mes2' => $mes2,
                'mes3' => $mes3,
                'statusForecast' => $statusForecast,


            );

            $iteradorProductos->next();
            $i++;
            }

        $response['status'] = true;
        $response['productos'] = $arrayForecast;

        echo json_encode($response);

        }

    public function iniciarForecastMensual() {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR .
            'ForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';

        $fechaInicial = date("Y-m-01");
        $fechaInicial = date("Y-m-01", strtotime($fechaInicial.'+ 1 month'));

        $f = new ForecastMensualDao();

        $hay = $f->obtenerForecastMensualPorUsuarioYSucursal($fechaInicial, $fechaInicial, Sesion::obtener('idUsuario'), Sesion::obtener('idSucursal'));
        if ($hay['total'] > 0){
            $datosForecast = $hay['datosForecast'];
            $idForecast = $datosForecast->Id_Forecast;
            $response['status'] = true;
        }
        else{
            $fc = new ForecastMensual();
            $fc->__set('_fecha', $fechaInicial);
            $fc->__set('_idUsuario', Sesion::obtener('idUsuario'));
            $fc->__set('_idSucursal', Sesion::obtener('idSucursal'));
            $fc->__set('_status', 0);
            $fcG = new ForecastMensualDao();
            $guardar = $fcG->guardar($fc);
            if ($guardar['status']){
                $idForecast = $guardar['idForecast'];
                $response['status'] = true;

            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $guardar['error'];
                echo json_encode($response);
                exit;
            }
        }

        $this->forecastAnualAMensual( Sesion::obtener('idUsuario'));
        $response['status'] = true;


        echo json_encode($response);

    }
    
    public function forecastAnualAMensual($idUsuario){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR .
            'ForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';


        $forecastMensualDao = new ForecastMensualDao();
        $detalleForecastMensualDao = new DetalleForecastMensualDao();

        $year = date("Y");
        $year = date("Y",strtotime($year."- 1 year"));

        $inicioFecha = date("Y-m-01");
        $proximoMes = date("m",strtotime($inicioFecha."+ 1 month"));

        $inicioFecha =   date("Y-m-01",strtotime($inicioFecha."+ 1 month"));

        switch ($proximoMes) {
            case '01':
                $mesForecast = "enero";
                $mes1 = "febrero";
                $mes2 = "marzo";
                $mes3 = "abril";
                break;
            case '02':
                $mesForecast = "febrero";
                $mes1 = "marzo";
                $mes2 = "abril";
                $mes3 = "mayo";
                break;
            case '03':
                $mesForecast = "marzo";
                $mes1 = "abril";
                $mes2 = "mayo";
                $mes3 = "junio";
                break;
            case '04':
                $mesForecast = "abril";
                $mes1 = "mayo";
                $mes2 = "junio";
                $mes3 = "julio";
                break;
            case '05':
                $mesForecast = "mayo";
                $mes1 = "junio";
                $mes2 = "julio";
                $mes3 = "agosto";
                break;
            case '06':
                $mesForecast = "junio";
                $mes1 = "julio";
                $mes2 = "agosto";
                $mes3 = "septiembre";
                break;
            case '07':
                $mesForecast = "julio";
                $mes1 = "agosto";
                $mes2 = "septiembre";
                $mes3 = "octubre";
                break;
            case '08':
                $mesForecast = "agosto";
                $mes1 = "septiembre";
                $mes2 = "octubre";
                $mes3 = "noviembre";
                break;
            case '09':
                $mesForecast = "septiembre";
                $mes1 = "octubre";
                $mes2 = "noviembre";
                $mes3 = "diciembre";
                break;
            case '10':
                $mesForecast = "octubre";
                $mes1 = "noviembre";
                $mes2 = "diciembre";
                $mes3 = "enero";
                break;
            case '11':
                $mesForecast = "noviembre";
                $mes1 = "diciembre";
                $mes2 = "enero";
                $mes3 = "febrero";
                break;
            case '12':
                $mesForecast = "diciembre";
                $mes1 = "enero";
                $mes2 = "febrero";
                $mes3 = "marzo";
                break;
        }

                $detallesForecast = $forecastMensualDao->obtenerdetalleForecast($inicioFecha, $idUsuario, $year, Sesion::obtener('idSucursal') )['datosForecast'];


                foreach ($detallesForecast as $detalleForecast){

                    $semana1 = 0;
                    $semana2 = 0;
                    $semana3 = 0;
                    $semana4 = 0;
                    $semanaAsignada = 1;

                    for($i =0; $i < $detalleForecast->{$mesForecast}; $i++){

                        switch ($semanaAsignada) {
                            case 1:
                                $semana1++;
                                $semanaAsignada = 2;
                                break;
                            case 2:
                                $semana2++;
                                $semanaAsignada = 3;
                                break;
                            case 3:
                                $semana3++;
                                $semanaAsignada = 4;
                                break;
                            case 4:
                                $semana4++;
                                $semanaAsignada = 1;
                                break;
                        }

                    }

                    if($detalleForecast->tipo == "cliente"){
                        $tipo = "cliente";
                    }else{
                        $tipo = "sospechoso";
                    }

                    $d = new DetalleForecastMensual();
                    $d->__set('_idCliente', $detalleForecast->idCliente );
                    $d->__set('_tipo', $tipo);
                    $d->__set('_idProducto',$detalleForecast->idProducto );
                    $d->__set('_semana1', $semana1);
                    $d->__set('_semana2',$semana2);
                    $d->__set('_semana3', $semana3);
                    $d->__set('_semana4', $semana4);
                    $d->__set('_mes1',$detalleForecast->{$mes1} );
                    $d->__set('_mes2', $detalleForecast->{$mes2}  );
                    $d->__set('_mes3', $detalleForecast->{$mes3}  );
                    $d->__set('_status',0 );
                    $d->__set('_idForecast',$detalleForecast->Id_Forecast );
                    $detalleForecastMensualDao->guardar($d);

                }


    }

    public function obtenerForecastAnual(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

        $clasificacion = filter_input(INPUT_GET, 'clasificacion', FILTER_SANITIZE_STRING);
        $idCliente = filter_input(INPUT_GET, 'idCliente', FILTER_SANITIZE_STRING);
        $tipo = filter_input(INPUT_GET, 'tipo', FILTER_SANITIZE_STRING);


        $pc = new ProductoClienteDao();
        $pp = new ProductoProspectoDao();
        $arrayForecast = array();

        $datosForecast = $this->validarForecastAnual($clasificacion);

        if($tipo == 'cliente'){
            $productos = $pc->obtenerProductosCliente($idCliente);
        }else{
            $productos = $pp->obtenerProductosProspecto($idCliente);
        }


        if ($productos['status']) {

                $arrayProductos = new ArrayObject($productos['productos']);
                $iteradorProductos = $arrayProductos->getIterator();

                $totalUnidades = 0;
                $totalLitrosGlobal = 0;
                $totalUnidadesGlobal = 0;
                $totalLitros = 0;

                while ($iteradorProductos->valid()) {
                    $totalUnidades += $iteradorProductos->current()->Total;
                    $totalLitros +=$iteradorProductos->current()->Total_Litros;
                    $idProducto = $iteradorProductos->current()->Id_Producto;
                    $f = new FamiliasDao();
                    $fam = $f->obtenerFamilia($iteradorProductos->current()->Id_Familia)['familia'];
                    $familia = $fam->Id_Familia;
                    $fo = new DetalleForecastAnualDao();
                    $fore = $fo->obtenerForecastAnual($idCliente, $idProducto, $tipo, $datosForecast->Id_Forecast);
                    if ($fore['total'] > 0) {
                        $forecast = $fore['datosForecast'];
                        $enero = $forecast->enero;
                        $febrero = $forecast->febrero;
                        $marzo = $forecast->marzo;
                        $abril = $forecast->abril;
                        $mayo = $forecast->mayo;
                        $junio = $forecast->junio;
                        $julio = $forecast->julio;
                        $agosto = $forecast->agosto;
                        $septiembre = $forecast->septiembre;
                        $octubre = $forecast->octubre;
                        $noviembre = $forecast->noviembre;
                        $diciembre = $forecast->diciembre;
                        $total = $forecast->total;
                        $totalLitros = $forecast->totalLitros;
                    } else {
                        $enero = 0;
                        $febrero = 0;
                        $marzo = 0;
                        $abril = 0;
                        $mayo = 0;
                        $junio = 0;
                        $julio = 0;
                        $agosto = 0;
                        $septiembre = 0;
                        $octubre = 0;
                        $noviembre = 0;
                        $diciembre = 0;
                        $total = 0;
                        $totalLitros = 0;
                    }
                    $totalLitrosGlobal += $totalLitros;
                    $totalUnidadesGlobal += $total;


                    if($tipo == 'cliente'){
                        $consumo = $iteradorProductos->current()->Consumo_Estimado;
                    }else{
                        $consumo = 0;
                    }

                    $arrayForecast[] = array(
                        'enero' => $enero,
                        'febrero' => $febrero,
                        'marzo' => $marzo,
                        'abril' => $abril,
                        'mayo' => $mayo,
                        'junio' => $junio,
                        'julio' => $julio,
                        'agosto' => $agosto,
                        'septiembre' => $septiembre,
                        'octubre' => $octubre,
                        'noviembre' => $noviembre,
                        'diciembre' => $diciembre,
                        'litraje' => $iteradorProductos->current()->Litraje,
                        'idProducto' =>   $iteradorProductos->current()->Id_Producto,
                        'nombre' =>   $iteradorProductos->current()->Nombre,
                        'Unidad_Venta' =>   $iteradorProductos->current()->Unidad_Venta,
                        'Consumo_Estimado' => $consumo ,
                        'total' =>  $total,
                        'totalLitros' => $totalLitros,
                        'familia' => $familia

                    );

                    $response['status'] = true;


                   // $b = new BalanceController();
                    //$consumoPromedioMensual = $b->consumoPromedioMensualCliente($this->_datos['cliente']->Id_Cliente, $idProducto, '2016-10-01 00:00:00', '2017-10-31 23:59:29');

                    $iteradorProductos->next();
                }

            }else{
                $response['status'] = false;
                $response['mensaje'] = $productos['error'];
            }


        $response['productos'] = $arrayForecast;
        $response['totalLitrosGlobal'] = $totalLitrosGlobal;
        $response['totalUnidadesGlobal'] = $totalUnidadesGlobal;

        echo json_encode($response);

    }


    public function validarForecastAnual($clasificacion){

        $f = new ForecastAnualDao();

        if($clasificacion == "actualizaForecast"){
            $fecha = (date("Y", strtotime('-1 year')));
        }else{
            $fecha = (date("Y"));
        }

        $fore = $f->hayForecast($fecha, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $datosForecast = $fore['forecast'];
                $totalLitrosSucursal = $datosForecast->Total_Litros;
            } else {
                $fn = new ForecastAnual();
                $fn->__set('_year',$fecha );
                $fn->__set('_idSucursal', Sesion::obtener('idSucursal'));
                $fn->__set('_totalLitros', 0);
                $for = $f->crear($fn);
                if ($for['status']) {
                    $forc = $f->hayForecast($fecha, Sesion::obtener('idSucursal'))['forecast'];
                    $datosForecast = $forc['forecast'];
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $for['error'];
                    echo json_encode($response);
                    exit;
            }

        }

        }

        return $datosForecast;

    }

    public function autorizarORechazarForecastAnual(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'AutorizacionesForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

        $idAutorizacionForecast = filter_input(INPUT_GET, 'idAutorizacionForecast', FILTER_SANITIZE_NUMBER_INT);
        $razon = filter_input(INPUT_GET, 'razon', FILTER_SANITIZE_STRING);
        $idUsuario = filter_input(INPUT_GET, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_GET, 'status', FILTER_SANITIZE_STRING);

        $autorizacionesForecastAnualDao = new AutorizacionesForecastAnualDao();

        $usuarioDao = new UsuarioDao();
        $usuario = $usuarioDao->obtenerUsuario($idUsuario)['usuarios'];


        $cambiarStatus = $autorizacionesForecastAnualDao->actualizarStatusYRazones($idAutorizacionForecast, $status, $razon );

        if($cambiarStatus['status']){

            $contenido = 'Tu forecast anual fue   : '. $status . ' ';

            if($status == 'rechazado'){
                $contenido = $contenido. '<br>'.'porque:   '. $razon . '<br>' . 'Favor de realizar las modificaciones';
            }
            $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            $datos = array('contenido' => $contenido);
            $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

            $contexto = stream_context_create($opciones);
            $contenidoEmail = file_get_contents($url, false, $contexto);

            Email::enviarEmail($usuario->Mail, '', 'Forecast anual ' . $status , $contenidoEmail);


            $response['status'] = true;

        }else{
            $response['status'] = false;
            $response['mensaje'] = $cambiarStatus['error'];
        }


        echo json_encode($response);

    }
    
      public function guardarServiciosSospechoso($idSospechoso){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ServiciosSospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProspectosDao.php';

        $consumo = filter_input(INPUT_POST, 'consumo', FILTER_SANITIZE_NUMBER_INT);
        $fechaCierre = filter_input(INPUT_POST, 'fechaCierre', FILTER_SANITIZE_STRING);

        $analyst = isset($_POST['analyst']) ? filter_input(INPUT_POST, 'analyst', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroAnalisis = isset($_POST['numeroAnalisis']) ? filter_input(INPUT_POST, 'numeroAnalisis', FILTER_SANITIZE_NUMBER_INT) : 0;
        $video = isset($_POST['video']) ? filter_input(INPUT_POST, 'video', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroVideoCheck = isset($_POST['numeroVideoCheck']) ? filter_input(INPUT_POST, 'numeroVideoCheck', FILTER_SANITIZE_NUMBER_INT) : 0;
        $coach = isset($_POST['coach']) ? filter_input(INPUT_POST, 'coach', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroCoach = isset($_POST['numeroCursos']) ? filter_input(INPUT_POST, 'numeroCursos', FILTER_SANITIZE_NUMBER_INT) : 0;
        $advisor = isset($_POST['advisor']) ? filter_input(INPUT_POST, 'advisor', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroAdvisor = ($advisor == 1) ? 1 : 0;
        $expert = isset($_POST['expert']) ? filter_input(INPUT_POST, 'expert', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroExpert = isset($_POST['numeroExpert']) ? filter_input(INPUT_POST, 'numeroExpert', FILTER_SANITIZE_NUMBER_INT) : 0;
        $match = isset($_POST['match']) ? filter_input(INPUT_POST, 'match', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroMatch = ($match == 1) ? 1 : 0;
        $control = isset($_POST['control']) ? filter_input(INPUT_POST, 'control', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroControl = ($control == 1) ? 1 : 0;
        $planner = isset($_POST['planner']) ? filter_input(INPUT_POST, 'planner', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroPlanner = ($planner == 1) ? 1 : 0;
        $equipment = isset($_POST['equipment']) ? filter_input(INPUT_POST, 'equipment', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroEquipment = ($equipment == 1) ? 1 : 0;
        $filter = isset($_POST['filter']) ? filter_input(INPUT_POST, 'filter', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroFilter = ($filter == 1) ? 1 : 0;
        $project = isset($_POST['project']) ? filter_input(INPUT_POST, 'project', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroProject = ($project == 1) ? 1 : 0;

        $LubeSupport = isset($_POST['LubeSupport']) ? filter_input(INPUT_POST, 'LubeSupport', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroSupport = isset($_POST['numeroSupport']) ? filter_input(INPUT_POST, 'numeroSupport', FILTER_SANITIZE_NUMBER_INT) : 0;
        $LubePerformance = isset($_POST['LubePerformance']) ? filter_input(INPUT_POST, 'LubePerformance', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroPerformance = isset($_POST['numeroPerformance']) ? filter_input(INPUT_POST, 'numeroPerformance', FILTER_SANITIZE_NUMBER_INT) : 0;
        $LubeCompetitive= isset($_POST['LubeCompetitive']) ? filter_input(INPUT_POST, 'LubeCompetitive', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroCompetitive = isset($_POST['numeroCompetitive']) ? filter_input(INPUT_POST, 'numeroCompetitive', FILTER_SANITIZE_NUMBER_INT) : 0;
        $LubeOptions= isset($_POST['LubeOptions']) ? filter_input(INPUT_POST, 'LubeOptions', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroOptions = isset($_POST['numeroOptions']) ? filter_input(INPUT_POST, 'numeroOptions', FILTER_SANITIZE_NUMBER_INT) : 0;


        $se = new ServiciosSospechoso();
        $se->__set('_analisis', $analyst);
        $se->__set('_cantidadAnalisis', $numeroAnalisis);
        $se->__set('_videoCheck', $video);
        $se->__set('_cantidadVideoCheck', $numeroVideoCheck);
        $se->__set('_lubeCoach', $coach);
        $se->__set('_cantidadLubeCoach', $numeroCoach);
        $se->__set('_lubeAdvisor', $advisor);
        $se->__set('_cantidadLubeAdvisor', $numeroAdvisor);
        $se->__set('_lubeExpert', $expert);
        $se->__set('_cantidadExpert', $numeroExpert);
        $se->__set('_lubMatch', $match);
        $se->__set('_cantidadLubMatch', $numeroMatch);
        $se->__set('_shellControl', $control);
        $se->__set('_cantidadShellControl', $numeroControl);
        $se->__set('_lubeEquipment', $equipment);
        $se->__set('_cantidadLubeEquipment', $numeroEquipment);
        $se->__set('_lubFilter', $filter);
        $se->__set('_cantidadLubFilter', $numeroFilter);
        $se->__set('_lubProject', $project);
        $se->__set('_cantidadLubProject', $numeroProject);
        $se->__set('_idSospechoso', $idSospechoso);
        $se->__set('_status', 0);
        $se->__set('_lubeSupport', $LubeSupport);
        $se->__set('_cantidadLubeSupport', $numeroSupport);
        $se->__set('_lubePerformance', $LubePerformance);
        $se->__set('_cantidadLubePerformance', $numeroPerformance);
        $se->__set('_lubeCompetitive', $LubeCompetitive);
        $se->__set('_cantidadLubeCompetitive', $numeroCompetitive);
        $se->__set('_lubeOptions', $LubeOptions);
        $se->__set('_cantidadLubeOptions', $numeroOptions);
        $se->__set('_lubePlanner', $planner);
        $se->__set('_cantidadLubePlanner', $numeroPlanner);
        $serv = new ServiciosSospechosoDao();
        $eliminaServicios = $serv->eliminarServicios($idSospechoso);
        $guardarServicios = $serv->guardar($se);

        $pr = new ProspectosDao();

        $pr->actualizarConsumoYFechaCierre($fechaCierre, $consumo, $idSospechoso);

        $this->generarPropositoProspecto($fechaCierre, $consumo, $idSospechoso);
    }

    public  function generarPropositoProspecto($fechaCierre, $consumo, $idSospechoso){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProspectosDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ServiciosSospechosoDao.php';

        $sospechosoDao = new SospechosoDao();

        $proposito = '';

        if($consumo >= 19 and $consumo <= 499 ){
            $consumoProposito = '19 - 499';
        }else  if($consumo >= 500 and $consumo <= 1000 ){
            $consumoProposito = '500 - 1000';
        }else  if($consumo >= 1001 and $consumo <= 2000 ){
            $consumoProposito = '1001 - 2000';
        }else  if($consumo >= 2001 and $consumo <= 5000 ){
            $consumoProposito = '2001 - 5000';
        }else  if($consumo >= 5000  ){
            $consumoProposito = 'Más de 5000';
        }else {
            $consumoProposito = $consumo;
        }

            $proposito .= 'Venta de ';
            $proposito .= $consumoProposito. ' litros mensuales a partir de ';
            $proposito .= date("Y-m-d", strtotime($fechaCierre)). ' ';


        $s = new ServiciosSospechosoDao();
        $servicios =  $s->obtenerServicios($idSospechoso);

        if($servicios['existe'] > 0){
            $proposito .= 'ofreciendo ';
            $infoServicio = $servicios['servicios'];

            if( $infoServicio->Analyst == 1)
                $proposito .= 'Analyst, ';
            if( $infoServicio->Videocheck == 1)
                $proposito .= 'Videocheck, ';
            if( $infoServicio->LubeCoach == 1)
                $proposito .= 'LubeCoach, ';
            if( $infoServicio->LubeAdvisor == 1)
                $proposito .=  'LubeAdvisor, ';
            if( $infoServicio->LubeExpert == 1)
                $proposito .=  'LubeExpert, ';
            if( $infoServicio->LubeMatch == 1)
                $proposito .=  'LubeMatch, ';
            if( $infoServicio->ShellControl == 1)
                $proposito .=  'ShellControl, ';
            if( $infoServicio->LubeEquipment == 1)
                $proposito .=  'LubeEquipment, ';
            if( $infoServicio->LubeFilter == 1)
                $proposito .=  'LubeFilter, ';
            if( $infoServicio->LubeProject == 1)
                $proposito .=  'LubeProject, ';
            if( $infoServicio->LubeSupport == 1)
                $proposito .=  'LubeSupport, ';
            if( $infoServicio->LubePerformance == 1)
                $proposito .=  'LubePerformance, ';
            if( $infoServicio->LubeCompetitive == 1)
                $proposito .=  'LubeCompetitive, ';
            if( $infoServicio->LubeOptions == 1)
                $proposito .=  'LubeOptions, ';
            if( $infoServicio->LubePlanner == 1)
                $proposito .= 'LubePlanner ';

        }

        $sospechosoDao->agregarProposito($proposito, $idSospechoso);

    }

    public function guardarServiciosCliente($idCliente){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ServiciosClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProspectosDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';

        $consumo = filter_input(INPUT_POST, 'consumo', FILTER_SANITIZE_NUMBER_INT);
        $fechaCierre = isset($_POST['fechaCierre']) ? filter_input(INPUT_POST, 'fechaCierre', FILTER_SANITIZE_STRING) : null;

        $analyst = isset($_POST['LubeAnalyst']) ? filter_input(INPUT_POST, 'LubeAnalyst', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroAnalisis = isset($_POST['numeroAnalisis']) ? filter_input(INPUT_POST, 'numeroAnalisis', FILTER_SANITIZE_NUMBER_INT) : 0;
        $video = isset($_POST['LubeVideocheck']) ? filter_input(INPUT_POST, 'LubeVideocheck', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroVideoCheck = isset($_POST['numeroVideoCheck']) ? filter_input(INPUT_POST, 'numeroVideoCheck', FILTER_SANITIZE_NUMBER_INT) : 0;
        $coach = isset($_POST['LubeCoach']) ? filter_input(INPUT_POST, 'LubeCoach', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroCoach = isset($_POST['numeroCapacitacion']) ? filter_input(INPUT_POST, 'numeroCapacitacion', FILTER_SANITIZE_NUMBER_INT) : 0;
        $advisor = isset($_POST['LubeAdvisor']) ? filter_input(INPUT_POST, 'LubeAdvisor', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroAdvisor = ($advisor == 1) ? 1 : 0;
        $expert = isset($_POST['LubeExpert']) ? filter_input(INPUT_POST, 'LubeExpert', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroExpert = isset($_POST['numeroExpert']) ? filter_input(INPUT_POST, 'numeroExpert', FILTER_SANITIZE_NUMBER_INT) : 0;
        $match = isset($_POST['match']) ? filter_input(INPUT_POST, 'match', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroMatch = ($match == 1) ? 1 : 0;
        $control = isset($_POST['LubeControl']) ? filter_input(INPUT_POST, 'LubeControl', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroControl = ($control == 1) ? 1 : 0;
        $planner = isset($_POST['planner']) ? filter_input(INPUT_POST, 'planner', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroPlanner = ($planner == 1) ? 1 : 0;
        $equipment = isset($_POST['LubeEquipment']) ? filter_input(INPUT_POST, 'LubeEquipment', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroEquipment = ($equipment == 1) ? 1 : 0;
        $filter = isset($_POST['LubeFilter']) ? filter_input(INPUT_POST, 'LubeFilter', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroFilter = ($filter == 1) ? 1 : 0;
        $project = isset($_POST['LubeProject']) ? filter_input(INPUT_POST, 'LubeProject', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroProject = ($project == 1) ? 1 : 0;

        $LubeSupport = isset($_POST['LubeSupport']) ? filter_input(INPUT_POST, 'LubeSupport', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroSupport = isset($_POST['numeroSupport']) ? filter_input(INPUT_POST, 'numeroSupport', FILTER_SANITIZE_NUMBER_INT) : 0;
        $LubePerformance = isset($_POST['LubePerformance']) ? filter_input(INPUT_POST, 'LubePerformance', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroPerformance = isset($_POST['numeroPerformance']) ? filter_input(INPUT_POST, 'numeroPerformance', FILTER_SANITIZE_NUMBER_INT) : 0;
        $LubeCompetitive= isset($_POST['LubeCompetitive']) ? filter_input(INPUT_POST, 'LubeCompetitive', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroCompetitive = isset($_POST['numeroCompetitive']) ? filter_input(INPUT_POST, 'numeroCompetitive', FILTER_SANITIZE_NUMBER_INT) : 0;
        $LubeOptions= isset($_POST['LubeOptions']) ? filter_input(INPUT_POST, 'LubeOptions', FILTER_SANITIZE_NUMBER_INT) : 0;
        $numeroOptions = isset($_POST['numeroOptions']) ? filter_input(INPUT_POST, 'numeroOptions', FILTER_SANITIZE_NUMBER_INT) : 0;

        $s = new ServiciosCliente();
        $s->__set('_analyst', $analyst);
        $s->__set('_cantidadAnalyst', $numeroAnalisis);
        $s->__set('_videocheck', $video);
        $s->__set('_cantidadVideocheck', $numeroVideoCheck);
        $s->__set('_lubcoach', $coach);
        $s->__set('_cantidadlubcoach', $numeroCoach);
        $s->__set('_advisor', $advisor);
        $s->__set('_cantidadAdvisor', $numeroAdvisor);
        $s->__set('_lubeExpert', $expert);
        $s->__set('_cantidadLubeExpert', $numeroExpert);
        $s->__set('_lubeMatch', $match);
        $s->__set('_cantidadLubeMatch', $numeroMatch);
        $s->__set('_shellControl', $control);
        $s->__set('_cantidadShellControl', $numeroControl);
        $s->__set('_lubeEquipment', $equipment);
        $s->__set('_cantidadLubEquipment', $numeroEquipment);
        $s->__set('_lubeFilter', $filter);
        $s->__set('_cantidadLubeFilter', $numeroFilter);
        $s->__set('_lubeProject', $project);
        $s->__set('_cantidadLubeProject', $numeroProject);
        $s->__set('_status', 0);
        $s->__set('_idCliente', $idCliente);
        $s->__set('_lubeSupport', $LubeSupport);
        $s->__set('_cantidadLubeSupport', $numeroSupport);
        $s->__set('_lubePerformance', $LubePerformance);
        $s->__set('_cantidadLubePerformance', $numeroPerformance);
        $s->__set('_lubeCompetitive', $LubeCompetitive);
        $s->__set('_cantidadLubeCompetitive', $numeroCompetitive);
        $s->__set('_lubeOptions', $LubeOptions);
        $s->__set('_cantidadLubeOptions', $numeroOptions);
        $s->__set('_lubePlanner', $planner);
        $s->__set('_cantidadLubePlanner', $numeroPlanner);
        $ser = new ServiciosClienteDao();
        $elimina = $ser->eliminaServiciosCliente($idCliente);
        $guardar = $ser->guardar($s);

        $clienteDao = new ClienteDao();
        $c = new Cliente();
        $c->__set('_idCliente', $idCliente);
        $cliente = $clienteDao->obtenerClientePorId($c)['cliente'];

        $clienteDao->actualizarConsumo( $consumo,$idCliente);

        if($cliente->Consumo != $consumo ){
            if($cliente->Consumo < $consumo){
                $clienteDao->actualizarIncrementoConsumo( "SI",$idCliente);
            }else {
                $clienteDao->actualizarIncrementoConsumo( "NO",$idCliente);
            }
        }

        $prospectosDao = new ProspectosDao();
        $prospectosDao->actualizarConsumoYFechaCierre($fechaCierre, $consumo, $cliente->Id_Sospechoso);


        $this->generarPropositoCliente($cliente);
    }

    public  function generarPropositoCliente($cliente){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ServiciosClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProspectosDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';

        $prospectosDao = new ProspectosDao();
        $clienteDao = new ClienteDao();

        $proposito = '';


        if($cliente->Consumo >= 19 and $cliente->Consumo <= 499 ){
            $consumo = '19 - 499';
        }else  if($cliente->Consumo >= 500 and $cliente->Consumo <= 1000 ){
            $consumo = '500 - 1000';
        }else  if($cliente->Consumo >= 1001 and $cliente->Consumo <= 2000 ){
            $consumo = '1001 - 2000';
        }else  if($cliente->Consumo >= 2001 and $cliente->Consumo <= 5000 ){
            $consumo = '2001 - 5000';
        }else  if($cliente->Consumo >= 5000  ){
            $consumo = 'Más de 5000';
        }else {
            $consumo = $cliente->Consumo;
        }

        if($cliente->Incremento_Consumo == 'SI'){
            $proposito .= 'Incremento de venta de ';
            $proposito .= $consumo. ' litros mensuales a partir de ';

            $prospecto = $prospectosDao->obtenerProspecto($cliente->Id_Sospechoso);
            if($prospecto['total'] > 0 ){
                $proposito .=  date("Y-m-d", strtotime($prospecto['prospecto']->F_Cie)) . ' ';
            }

        }else {
            $proposito .= 'Mantener la venta de ';
            $proposito .= $consumo. ' ';
        }


        $s = new ServiciosClienteDao();
        $servicios =  $s->obtenerServicios($cliente->Id_Cliente);

        if($servicios['existe'] > 0){
            $proposito .= 'ofreciendo ';
            $infoServicio = $servicios['servicios'];

            if( $infoServicio->Analyst == 1)
                $proposito .= 'Analyst, ';
            if( $infoServicio->Videocheck == 1)
                $proposito .= 'Videocheck, ';
            if( $infoServicio->LubeCoach == 1)
                $proposito .= 'LubeCoach, ';
            if( $infoServicio->LubeAdvisor == 1)
                $proposito .=  'LubeAdvisor, ';
            if( $infoServicio->LubeExpert == 1)
                $proposito .=  'LubeExpert, ';
            if( $infoServicio->LubeMatch == 1)
                $proposito .=  'LubeMatch, ';
            if( $infoServicio->ShellControl == 1)
                $proposito .=  'ShellControl, ';
            if( $infoServicio->LubeEquipment == 1)
                $proposito .=  'LubeEquipment, ';
            if( $infoServicio->LubeFilter == 1)
                $proposito .=  'LubeFilter, ';
            if( $infoServicio->LubeProject == 1)
                $proposito .=  'LubeProject, ';
            if( $infoServicio->LubeSupport == 1)
                $proposito .=  'LubeSupport, ';
            if( $infoServicio->LubePerformance == 1)
                $proposito .=  'LubePerformance, ';
            if( $infoServicio->LubeCompetitive == 1)
                $proposito .=  'LubeCompetitive, ';
            if( $infoServicio->LubeOptions == 1)
                $proposito .=  'LubeOptions, ';
            if( $infoServicio->LubePlanner == 1)
                $proposito .= 'LubePlanner ';

        }

        $clienteDao->agregarProposito($proposito, $cliente->Id_Cliente);

    }



}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        } else {
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxForecastController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}