<?php
/**
 * AjaxRutinasController.php
 * Controlador para el manejo de ajax con rutinas
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RutinaDao.php';

class AjaxRutinasController 
{

    public function getRutinas(){
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }
        
        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $v = new RutinaDao();
        $rutinas = $v->getRutinas(Sesion::obtener('idSucursal'), $inicio, $registros);
        if ($rutinas['status']){
            $response['status'] = true;
            $total = $rutinas['total'];
            $paginas = ceil($total / $registros);

            $response['rutinas'] = $rutinas['rutinas'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $rutinas['error'];
        }

        echo json_encode($response);
    }
    
    public function findRutina(){
        $termino = filter_input(INPUT_GET, 'cadena', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }
        
        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $v = new RutinaDao();
        $rutinas = $v->findRutina(Sesion::obtener('idSucursal'), $inicio, $registros, $termino);
        if ($rutinas['status']){
            $response['status'] = true;
            $total = $rutinas['total'];
            $paginas = ceil($total / $registros);

            $response['rutinas'] = $rutinas['rutinas'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $rutinas['error'];
        }
        
        echo json_encode($response);
    }

    public function getRutina(){
        $idRutina = filter_input(INPUT_GET, 'idRutina', FILTER_SANITIZE_NUMBER_INT);
        
        $v = new RutinaDao();
        
        $rutina = $v->getRutina($idRutina);
        if ($rutina['status']){
            $response['status'] = true;
            $response['rutina'] = $rutina['rutina'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $rutina['error'];
        }
        
        echo json_encode($response);
    }

    public function saveRutina(){
        $tipo = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
        $idRutina = filter_input(INPUT_POST, 'idRutina', FILTER_SANITIZE_NUMBER_INT);
        $vehiculo = filter_input(INPUT_POST, 'vehiculo', FILTER_SANITIZE_NUMBER_INT);
        $rutina = filter_input(INPUT_POST, 'rutina', FILTER_SANITIZE_STRING);
        $freq = filter_input(INPUT_POST, 'freq', FILTER_SANITIZE_STRING);
        $stat = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);

        $vd = new RutinaDao();
        $rutina = $vd->guardaRutina($vehiculo, $rutina, $freq, $stat, Sesion::obtener('idSucursal'), $idRutina, $tipo);
        if ($rutina['status']){
            $idRutina = $rutina['idRutina'];
            $response['status'] = true;
            $response['idRutina'] = $idRutina;
            $response['mensaje'] = 'Los datos de la rutina se guardaron correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $rutina['error'];
        }
        
        echo json_encode($response);
    }

    public function getOrdenesServicio(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $vehiculo = (int) filter_input(INPUT_GET, 'vehiculo', FILTER_SANITIZE_NUMBER_INT);

        $c = new ComentariosDao();
        $d = new DocumentoDao();
        $u = new UsuarioDao();
        $ordenes = $c->getOrdenesServicio($vehiculo);
        if ($ordenes['status']){
            $response['status'] = true;

            foreach ($ordenes['ordenes'] as $orden) {
                $orden->realizado = '';
                $orden->usuario = '';
                if($orden->Estatus == 2){
                    if($orden->documento > 0){
                        $doc = new Documento();
                        $doc->__set('_idDocumento', $orden->documento);
                        $docu = $d->obtenerDocumento($doc)['documento'];
                        $orden->realizado = date("d/m/Y", strtotime($docu->Fecha));

                        $user = $u->obtenerUsuario($docu->Id_Usuario)['usuarios'];
                        $orden->usuario = $user->Usuario;
                    }
                }
            }

            $response['ordenes'] = $ordenes['ordenes'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $ordenes['error'];
        }

        echo json_encode($response);
    }

    public function setOrdenProceso(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';

        $comm = (int) filter_input(INPUT_GET, 'comm', FILTER_SANITIZE_NUMBER_INT);

        $c = new ComentariosDao();
        $orden = $c->saveActProgress($comm, 50);
        if ($orden['status']){
            $orden = $c->saveActStatus($comm, 1);

            $response['status'] = true;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $orden['error'];
        }

        echo json_encode($response);
    }

    public function setOrdenRealizada(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';

        $comm = (int) filter_input(INPUT_GET, 'comm', FILTER_SANITIZE_NUMBER_INT);

        $c = new ComentariosDao();
        $d = new DocumentoDao();
        $orden = $c->saveActProgress($comm, 100);
        if ($orden['status']){
            $orden = $c->saveActStatus($comm, 2);

            $orden = $c->getOrdenServicio($comm)['orden'];

            $doc = $d->saveOrdenRealizada(Sesion::obtener('idSucursal'), $orden->Id_Vehiculo, $orden->Id_Rutina, $orden->Etapa, Sesion::obtener('idUsuario'));
            $response['documento'] = $doc['idDocumento'];

            $response['status'] = true;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $orden['error'];
        }

        echo json_encode($response);
    }

}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        }
        else{
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxRutinasController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}