<?php
/**
 * AjaxBalanceController.php
 * Controlador para el manejo de ajax con el módulo de balance
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

ini_set('display_errors', 1);
error_reporting(E_ALL);

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxSeguridadController
{

    public function testLog($data)
    {
        echo '<script>';
        echo 'console.log(' . json_encode($data) . ')';
        echo '</script>';

    }

    public function altaActividadSeguridad()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $s = new Seguridad();
        $usuarioDao = new UsuarioDao();
        $fecha = date("Y-m-d");

        $nombre = filter_input(INPUT_POST, 'nombre', FILTER_SANITIZE_STRING);
        $dias = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
        $clave = filter_input(INPUT_POST, 'clave', FILTER_SANITIZE_STRING);
        $categoria = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_STRING);
        $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
        $archivo = filter_input(INPUT_POST, 'adjunto', FILTER_SANITIZE_STRING);
        $razon = filter_input(INPUT_POST, 'razon', FILTER_SANITIZE_STRING);
        $frecuencia = filter_input(INPUT_POST, 'frecuencia', FILTER_SANITIZE_STRING);
        $evento = filter_input(INPUT_POST, 'evento', FILTER_SANITIZE_STRING);
        $inicioFecha = filter_input(INPUT_POST, 'iniciofecha', FILTER_SANITIZE_STRING);
        $remplazar = filter_input(INPUT_POST, 'remplazo', FILTER_SANITIZE_STRING);
        $id_sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);

        $reponsablePorsucursal = $_POST['responsable'];


      if (isset($_FILES['adjunto']['name'])) {
            $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'archivos' . DIRECTORY_SEPARATOR;
            if (!is_dir($ruta)){
                mkdir(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'archivos' . DIRECTORY_SEPARATOR);
                chmod($ruta, 0777);
            }
          list($base, $ext) = explode('.', $_FILES['adjunto']['name']);
          $array = explode('.', $_FILES['adjunto']['name']);

          foreach ($array as $iterador) {
              $extencion = $iterador;
          }
          $newname = $base . '_' . time() . '.' . $extencion;

          //list($base,$extension) = explode('.',$_FILES['adjunto']['name']);
          //$newname = implode('.', [$base, time(), $extension]);
            if (move_uploaded_file($_FILES['adjunto']['tmp_name'], $ruta . $newname)) {
                $s->__set('_archivo',$newname);
            } else {
                $s->__set('_archivo', '');
            }
        } else {
            $s->__set('_archivo', '');
        }

        $s->__set('_nombre', $nombre);
        $s->__set('_clave', $clave);
        $s->__set('_idResponsablepachuca', "");
        $s->__set('_idResponsablepuebla', "");
        $s->__set('_idResponsablequeretaro', "");
        $s->__set('_Dialimite', $dias);
        $s->__set('_categoria', $categoria);
        $s->__set('_descripcion', $descripcion);
        $s->__set('_tipo', $razon);

        foreach($reponsablePorsucursal as $responsable){
            $usuario =  $usuarioDao->obtenerUsuario($responsable)['usuarios'];
            if($remplazar == 'si') {
                if ($usuario->Id_Sucursal == $id_sucursal) {
                    $s->__set('_responsableremplazararchivo', $responsable);
                    $s->__set('_idSucursal', $id_sucursal);
                }
            }else {
                $s->__set('_responsableremplazararchivo', null);
                $s->__set('_idSucursal', null);
            }

        }

        if ($razon == 'calendario') {
            $s->__set('_tipoDescripcion', $frecuencia);
        } else {
            $s->__set('_tipoDescripcion', $evento);
        }
        $s->__set('_fechaInicio', $inicioFecha);

        $seg = new SeguridadDao();

        $seguridad = $seg->altaActividadSeguridad($s);

        foreach($reponsablePorsucursal as $responsable){
            $responsablesSeguridad = $seg->altaResponsableSeguridad($responsable,$seguridad['id'], $newname);
        }

        if ($seguridad['status']) {

            if ($razon=='calendario' and $fecha ==$inicioFecha){
                $this->subirActividadesAsignadas($seguridad['id'], $reponsablePorsucursal);
            }

            $response['status'] = true;
            $response['mensaje'] = 'Se guardo correctamente .';


        } else {
            $response['status'] = false;
            $response['mensaje'] = $seguridad['error'];

        }
        echo json_encode($response);

    }

    public function subirActividadesAsignadas($idTareaSeguridad, $responsables)
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $seg = new SeguridadDao();

        foreach($responsables as $responsable){
            $s = new Seguridad();
            $s->__set('_idResponsable', $responsable);
            $s->__set('_idSupervisor', 0 );
            $s->__set('_status', 'progreso');
            $s->__set('_idSeguridad', $idTareaSeguridad );

            $seg = new SeguridadDao();
            $tarea_asignada = $seg->altaActividadAsignada($s);

        }


    }

    public function activarPorEvento()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $idSeguridad = (int) filter_input(INPUT_GET, 'seguridad', FILTER_SANITIZE_NUMBER_INT);

        $seg = new SeguridadDao();

        $seguridad = $seg->buscarTareaSeguridadPorId($idSeguridad);
        $responsables = $seg->buscarResponsablesPorSeguridadId($idSeguridad)['usuarios'];
        $arrayResponsables = new ArrayObject($responsables);
        $iteradorResponsables = $arrayResponsables->getIterator();

        if ($seguridad['status']) {

            foreach($iteradorResponsables as $responsable){
                $s = new Seguridad();
                $s->__set('_idResponsable', $responsable->id_responsable);
                $s->__set('_idSupervisor', 0 );
                $s->__set('_status', 'progreso');
                $s->__set('_idSeguridad', $idSeguridad );

                $seg = new SeguridadDao();
                $tarea_asignada = $seg->altaActividadAsignada($s);
            }

            $response['status'] = true;
            $response['mensaje'] = 'la actividad por evento se ha activado';


        }else {
            $response['status'] = false;
            $response['mensaje'] = $seguridad['error'];

        }

        echo json_encode($response);

    }



     public function editarActividadSeguridad()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $fechahoy = date("Y-m-d");

        $nombre = filter_input(INPUT_POST, 'nombre', FILTER_SANITIZE_STRING);
        $clave = filter_input(INPUT_POST, 'clave', FILTER_SANITIZE_STRING);
        $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
        $categoria = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_NUMBER_INT);
        $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
        $archivo = filter_input(INPUT_POST, 'adjunto', FILTER_SANITIZE_STRING);
        $razon = filter_input(INPUT_POST, 'razon', FILTER_SANITIZE_STRING);
        $frecuencia = filter_input(INPUT_POST, 'frecuencia', FILTER_SANITIZE_STRING);
        $evento = filter_input(INPUT_POST, 'evento', FILTER_SANITIZE_STRING);
        $idSeguridad = filter_input(INPUT_POST, 'idSeguridad', FILTER_SANITIZE_STRING);
        $remplazar = filter_input(INPUT_POST, 'remplazo', FILTER_SANITIZE_STRING);
        $id_sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
        $inicioFecha = filter_input(INPUT_POST, 'iniciofecha', FILTER_SANITIZE_STRING);


        $reponsablePorsucursal = $_POST['responsable'];

        $seg = new SeguridadDao();
        $usuarioDao = new UsuarioDao();
        $s = new Seguridad();

        $seguridad = $seg->buscarSeguridadPorId($idSeguridad)['actividad'];

        if($razon=='calendario' and  $seguridad->fecha_inicio > $fechahoy  and $inicioFecha == $fechahoy ){
            $this->subirActividadesAsignadas($seguridad->id_tareas_seguridad, $reponsablePorsucursal);
        }

       // $borrarResponsables = $seg->borrarResponsableSeguridad($idSeguridad);


        
        //$s = new Seguridad();

        if (isset($_FILES['adjunto']['name']) and $_FILES['adjunto']['name'] != '') {
            $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'archivos' . DIRECTORY_SEPARATOR;
            if (!is_dir($ruta)){
                mkdir(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'archivos' . DIRECTORY_SEPARATOR);
                chmod($ruta, 0777);
            }
          //  list($base,$extension) = explode('.',$_FILES['adjunto']['name']);
          //  $newname = implode('.', [$base, time(), $extension]);
            list($base, $ext) = explode('.', $_FILES['adjunto']['name']);
            $array = explode('.', $_FILES['adjunto']['name']);

            foreach ($array as $iterador) {
                $extencion = $iterador;
            }
            $newname = $base . '_' . time() . '.' . $extencion;
            if (move_uploaded_file($_FILES['adjunto']['tmp_name'], $ruta . $newname)) {
                $s->__set('_archivo', $newname);
                $actualizar=1;
            } else {
                $s->__set('_archivo', '');
                $actualizar=0;
            }
        } else {
            $newname = null;
            $s->__set('_archivo', '');
            $actualizar=0;
        }

        foreach($reponsablePorsucursal as $responsable){
            $usuario =  $usuarioDao->obtenerUsuario($responsable)['usuarios'];
            if($remplazar == 'si') {
                if ($usuario->Id_Sucursal == $id_sucursal) {
                    $s->__set('_responsableremplazararchivo', $responsable);
                    $s->__set('_idSucursal', $id_sucursal);
                }
            }else {
                $s->__set('_responsableremplazararchivo', null);
                $s->__set('_idSucursal', null);
            }

            $buscarResponsable =  $seg->buscarSeguridadPorIdYSucursal($idSeguridad, $usuario->Id_Sucursal );
            if($buscarResponsable['total'] > 0  ){
                if($newname == null){
                    $newname =  $buscarResponsable['actividad']->archivo;
                }
                $seg->updateResponsableSeguridad($responsable, $newname,  $buscarResponsable['actividad']->id_responsable_tareas_seguridad);
            }else {
                if($newname == null){
                    $newname =  $seguridad->archivo;
                }
                $responsablesSeguridad = $seg->altaResponsableSeguridad($responsable,$idSeguridad, $newname);
            }

        }


        $s->__set('_nombre', $nombre);
        $s->__set('_clave', $clave);
        $s->__set('_idResponsablepachuca', '');
        $s->__set('_idResponsablepuebla', '');
        $s->__set('_idResponsablequeretaro', '');
        $s->__set('_Dialimite', $fecha);
        $s->__set('_categoria', $categoria);
        $s->__set('_descripcion', $descripcion);
        $s->__set('_tipo', $razon);
        $s->__set('_status', 'pendiente');
        if ($razon == 'calendario') {
            $s->__set('_tipoDescripcion', $frecuencia);
        } else {
            $s->__set('_tipoDescripcion', $evento);
        }
        $s->__set('_idSeguridad', $idSeguridad);
        $s->__set('_fechaInicio', $inicioFecha);

        $seg = new SeguridadDao();

        $seguridad = $seg->editarActividadSeguridad($s,$actualizar);

        if ($seguridad['status']) {

            foreach($reponsablePorsucursal as $responsable){
                $usuario =  $usuarioDao->obtenerUsuario($responsable)['usuarios'];
                $seguridad = $seg->actualizarResponsableTareaAsignada($responsable, $idSeguridad, $usuario->Id_Sucursal);

            }

            $response['status'] = true;
            $response['mensaje'] = 'Se actualizo correctamente .';

        } else {
            $response['status'] = false;
            $response['mensaje'] = $seguridad['error'];

        }
        echo json_encode($response);

    }



    public function obtenerActividadesSeguridad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);


        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $us = new UsuarioDao();
        $usuarios = $us->obtenerUsuariosActivosSucursal(Sesion::obtener('idSucursal'))['usuarios'];
        $seguridadDao = new SeguridadDao();
        $totalActividades = $seguridadDao->totalActividadesSeguridad(Sesion::obtener('idSucursal'));
        if ($totalActividades['status']){
            $total = $totalActividades['total'];
            $paginas = ceil($total / $registros);
            $actividadesSeguridad = $seguridadDao->obtenerActividadesSeguridad( $inicio, $registros, Sesion::obtener('idSucursal'));
            if ($actividadesSeguridad['status']){

                $response['status'] = true;

                $response['actividades'] = $actividadesSeguridad['actividades'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
                $response['usuarios'] = $usuarios;
            }else{
                $response['status'] = false;
                $response['mensaje'] = $actividadesSeguridad['error'];
            }

        }else{
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al calcular el total de las actividades. ' . TICKETS;
        }


        echo json_encode($response);

    }


    public function buscarActividadesPorCategoria(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);
        $seguridad = filter_input(INPUT_GET, 'seguridad', FILTER_SANITIZE_STRING);


        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $seguridadDao = new SeguridadDao();
        $totalActividades = $seguridadDao->totalActividadesSeguridadPorCategoria($seguridad);
        if ($totalActividades['status']){
            $total = $totalActividades['total'];
            $paginas = ceil($total / $registros);
            $actividadesSeguridad = $seguridadDao->obtenerActividadesSeguridadPorCategoria($seguridad,$inicio, $registros, Sesion::obtener('idSucursal'));
            if ($actividadesSeguridad['status']){
                $response['status'] = true;

                $response['actividades'] = $actividadesSeguridad['actividades'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            }else{
                $response['status'] = false;
                $response['mensaje'] = $actividadesSeguridad['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al calcular el total de las actividades. ' . TICKETS;
        }
        echo json_encode($response);

    }

    public function obtenerHistorialActividadesSeguridad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

        $sucursal = (int) filter_input(INPUT_GET, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
        $grupo = filter_input(INPUT_GET, 'grupo', FILTER_SANITIZE_STRING);
        $status = filter_input(INPUT_GET, 'status', FILTER_SANITIZE_STRING);
        $desdeFecha = filter_input(INPUT_GET, 'desde', FILTER_SANITIZE_STRING);
        $hastaFecha = filter_input(INPUT_GET, 'hasta', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);
        $clave = filter_input(INPUT_GET, 'clave', FILTER_SANITIZE_STRING);

        if($desdeFecha != ''){
            $desdeFecha = $desdeFecha.' 00:00:00';
        }
        if($hastaFecha != ''){
            $hastaFecha = $hastaFecha.' 23:59:59';
        }

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $seguridadDao = new SeguridadDao();
        $cursosInternosDao = new CursosInternosDao();
        $totalActividades = $seguridadDao->totalDeActividadesEnHistorial($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $clave);
        if ($totalActividades['status']){
            $total = $totalActividades['total'];

            $totalListaAsistencias = $cursosInternosDao->totalListasAsistenciaEnHistorial($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $clave, "seguridad");
            $totalcursos = $cursosInternosDao->totalCursosEnHistorial($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $clave, "seguridad");
            $paginas = ceil(($total + $totalListaAsistencias['total'] +  $totalcursos['total'] )/ $registros);

            $actividadesSeguridad = $seguridadDao->obtenerHistorialActividadesSeguridad($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $inicio, $registros, $clave);
            if ($actividadesSeguridad['status']){
                $asistenciaCursos = [];
                $cursos = [];

                if($actividadesSeguridad['total'] < $registros){

                    $diferenciaRegistros = $registros - $actividadesSeguridad['total'];
                    $inicio = (($pagina - 1) * $registros) - $total + $actividadesSeguridad['total'] ;

                    $vowels = array("L");
                    $claveLista = str_replace($vowels, "", $clave);

                    $actividadesCursos = $cursosInternosDao->obtenerHistorialListasAsistenciaSeguridad($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $inicio, $diferenciaRegistros, $claveLista);
                    $asistenciaCursos = $actividadesCursos['actividades'];

                    if( ($actividadesSeguridad['total'] + $actividadesCursos['total']) < $registros){

                        $diferenciaRegistros = $registros - $actividadesSeguridad['total'] - $actividadesCursos['total'];
                        $inicio = (($pagina - 1) * $registros) - ($total + $totalListaAsistencias['total']) + $actividadesCursos['total'] + $actividadesSeguridad['total']  ;
                        $vowels = array("C");
                        $claveCurso = str_replace($vowels, "", $clave);
                        $historialCursos = $cursosInternosDao->obtenerHistorialCursosSeguridad($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $inicio, $diferenciaRegistros, $claveCurso);
                        $cursos = $historialCursos['actividades'];

                    }
                }

                $response['status'] = true;
                $response['total_registros'] = $total;
                $response['actividades'] = $actividadesSeguridad['actividades'];
                $response['asistenciaCursos'] = $asistenciaCursos;
                $response['cursos'] = $cursos;
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            }else{
                $response['status'] = false;
                $response['mensaje'] = $actividadesSeguridad['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al calcular el total de las actividades. ' . TICKETS;
        }
        echo json_encode($response);

    }

    public function obtenerHistorialNoConformidad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $sucursal = (int) filter_input(INPUT_GET, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_GET, 'status', FILTER_SANITIZE_STRING);
        $desdeFecha = filter_input(INPUT_GET, 'desde', FILTER_SANITIZE_STRING);
        $hastaFecha = filter_input(INPUT_GET, 'hasta', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);
        $grupo = filter_input(INPUT_GET, 'grupo', FILTER_SANITIZE_STRING);
        $clave = filter_input(INPUT_GET, 'clave', FILTER_SANITIZE_STRING);

        if($desdeFecha != ''){
            $desdeFecha = $desdeFecha.' 00:00:00';
        }
        if($hastaFecha != ''){
            $hastaFecha = $hastaFecha.' 23:59:59';
        }

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $seguridadDao = new SeguridadDao();
        $totalActividades = $seguridadDao->totalDeNoConformidadEnHistorial($sucursal, $status, $desdeFecha, $hastaFecha, $grupo, $clave);
        if ($totalActividades['status']){
            $total = $totalActividades['total'];
            $paginas = ceil($total / $registros);
            $actividadesSeguridad = $seguridadDao->obtenerHistorialNoConformidad($sucursal, $status, $desdeFecha, $hastaFecha, $inicio, $registros, $grupo, $clave);
            if ($actividadesSeguridad['status']){
                $response['status'] = true;
                $response['total_registros'] = $total;
                $response['actividades'] = $actividadesSeguridad['actividades'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            }else{
                $response['status'] = false;
                $response['mensaje'] = $actividadesSeguridad['error'];
                $response['error'] = $actividadesSeguridad;
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al calcular el total de las actividades. ' . TICKETS;
        }
        echo json_encode($response);

    }

    public function obtenerNormasDeSeguridadActivas(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $seguridadDao = new SeguridadDao();
        $todasLasNormas = $seguridadDao->obtenerTodasLasNormasDeSeguridadActivas();
        if ($todasLasNormas['status']){
            $response['status'] = true;
            $response['normas'] = $todasLasNormas['normas'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al calcular el total de las actividades. ' . TICKETS;
        }
        echo json_encode($response);

    }

    public function obtenerNormasDeSeguridadActivasExceptoID(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $idNorma = (int) filter_input(INPUT_GET, 'idNorma', FILTER_SANITIZE_NUMBER_INT);

        $seguridadDao = new SeguridadDao();
        $todasLasNormas = $seguridadDao->obtenerTodasLasNormasDeSeguridadActivasExceptoId($idNorma);
        if ($todasLasNormas['status']){
            $response['status'] = true;
            $response['normas'] = $todasLasNormas['normas'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al calcular el total de las actividades. ' . TICKETS;
        }
        echo json_encode($response);

    }

    public function agragarNormaDeSeguridad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        //$normaSeguridad = $_POST['normaSeguridad'];

        $seguridadDao = new SeguridadDao();
        //$response['status'] = false;
       // $response['mensaje'] = 'Error desconocido';
      //  $norma = json_decode($normaSeguridad);

        //$nombreNorma = filter_var($norma->nombreNorma, FILTER_SANITIZE_STRING);
        //$descripcionNorma = filter_var($norma->descripcion, FILTER_SANITIZE_STRING);
        //$archivo = filter_var($norma->archivo, FILTER_SANITIZE_STRING);


        $nombreNorma = filter_input(INPUT_POST, 'nombreNormaNueva', FILTER_SANITIZE_STRING);
        $descripcionNorma = filter_input(INPUT_POST, 'descripcionNormaNueva', FILTER_SANITIZE_STRING);

        if (isset($_FILES['adjunto']['name'])) {
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'normas' . DIRECTORY_SEPARATOR;
        if (!is_dir($ruta)){
            mkdir(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'normas' . DIRECTORY_SEPARATOR);
            chmod($ruta, 0777);
        }
        list($base,$extension) = explode('.',$_FILES['adjunto']['name']);
        $newname = implode('.', [$base, time(), $extension]);
        if (move_uploaded_file($_FILES['adjunto']['tmp_name'], $ruta . $newname)) {
        } else {
            $newname = '';
        }
    } else {
            $newname = '';

        }

        $agregarNorma = $seguridadDao->insertarNuevaNormaSeguridad($nombreNorma, $descripcionNorma, $newname);
        if ($agregarNorma['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Se agrego la norma correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $agregarNorma['error'];
        }

        echo json_encode($response);

    }

    public function editarNormaDeSeguridad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $seguridadDao = new SeguridadDao();

        $nombreNorma = filter_input(INPUT_POST, 'nombre', FILTER_SANITIZE_STRING);
        $descripcionNorma = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
        $idNorma = filter_input(INPUT_POST, 'idNorma', FILTER_SANITIZE_NUMBER_INT);

        $newname = '';
        if (isset($_FILES['adjunto']['name']) and $_FILES['adjunto']['name'] != '') {
            $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'normas' . DIRECTORY_SEPARATOR;
            if (!is_dir($ruta)){
                mkdir(BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'normas' . DIRECTORY_SEPARATOR);
                chmod($ruta, 0777);
            }
            list($base,$extension) = explode('.',$_FILES['adjunto']['name']);
            $newname = implode('.', [$base, time(), $extension]);
            if (move_uploaded_file($_FILES['adjunto']['tmp_name'], $ruta . $newname)) {
                $actualizar=1;
            } else {;
                $actualizar=0;
            }
        } else {

            $actualizar=0;
        }

        $agregarNorma = $seguridadDao->actualizarNormaDeSeguridad($idNorma, $nombreNorma, $descripcionNorma, $newname, $actualizar);
        if ($agregarNorma['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Se editó la norma de seguridad correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $agregarNorma['error'];
        }

        echo json_encode($response);

    }

    public function eliminarNormaDeSeguridad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $normaSeguridad = $_POST['normaSeguridad'];

        $seguridadDao = new SeguridadDao();
        $response['status'] = false;
        $response['mensaje'] = 'Error desconocido';

        $norma = json_decode($normaSeguridad);

        $idNorma = (int) filter_var($norma->idNormaSeguridad, FILTER_SANITIZE_NUMBER_INT);

        $agregarNorma = $seguridadDao->actualizarStatusNormaDeSeguridad($idNorma, 0);
        if ($agregarNorma['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Se eliminó la norma de seguridad correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $agregarNorma['error'];
        }

        echo json_encode($response);

    }

    public function autorizacionNominasSeguridad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);


        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $us = new UsuarioDao();
        //$usuarios = $us->obtenerUsuariosActivosSucursal(Sesion::obtener('idSucursal'))['usuarios'];
        $seguridadDao = new SeguridadDao();
        $totalActividades = $seguridadDao->totalActividadesPorAutorizar();
        if ($totalActividades['status']){
            $total = $totalActividades['total'];

            $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();
            $obtenerCursos = $cursoInternoParticipantesDao->obtenerAsistenciasEnAutorizacion( "autorizacion", $inicio, $registros, "seguridad");
            $paginas = ceil(($total + $obtenerCursos['total']) / $registros);

            $actividadesSeguridad = $seguridadDao->obtenerActividadesPorAutorizar( $inicio, $registros);
            if ($actividadesSeguridad['status']){

                $response['status'] = true;
                $response['cursos'] = $obtenerCursos['cursos'];
                $response['actividades'] = $actividadesSeguridad['actividades'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
              //  $response['usuarios'] = $usuarios;
            }else{
                $response['status'] = false;
                $response['mensaje'] = $actividadesSeguridad['error'];
            }

        }else{
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al calcular el total de las actividades por autorizar. ' . TICKETS;
        }


        echo json_encode($response);

    }

    public function autorizarActividadSeguridad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';


        $idAsignada = (int) filter_input(INPUT_GET, 'actividadAsignada', FILTER_SANITIZE_NUMBER_INT);

        $us = new UsuarioDao();
        $seguridadDao = new SeguridadDao();

        $ActividadSeguridad = $seguridadDao->buscarActividadSeguridadPorId($idAsignada)['actividad'];

        $fechaInicio = date("Y-m-d");
        $tareasNoConformidad = $seguridadDao->obtenerTareasNoConformidadPorIdTareaAsingnada($idAsignada)['tareas'];
        foreach ($tareasNoConformidad as $tareaNoConformidad){

            if( $tareaNoConformidad->frecuencia == 'diario' ){

                $fechafinal = date("Y-m-d",strtotime($fechaInicio."+ 1 days"));

            } else  if( $tareaNoConformidad->frecuencia == 'semanal' ) {

                $fechafinal = date("Y-m-d",strtotime($fechaInicio."+ 1 week"));

            } else  if( $tareaNoConformidad->frecuencia == 'mensual' ) {

                $fechafinal = date("Y-m-d",strtotime($fechaInicio."+ 1 month"));

            } else  if($tareaNoConformidad->frecuencia == 'mes y medio' ) {

                $fechafinal = date("Y-m-d",strtotime($fechaInicio."+ 45 days"));

            } else  if( $tareaNoConformidad->frecuencia == '3 meses' ) {

                $fechafinal = date("Y-m-d",strtotime($fechaInicio."+ 3 month"));

            }  else  if($tareaNoConformidad->frecuencia == '6 meses' ) {

                $fechafinal = date("Y-m-d",strtotime($fechaInicio."+ 6 month"));

            } else  if( $tareaNoConformidad->frecuencia == '1 año' ) {

                $fechafinal = date("Y-m-d",strtotime($fechaInicio."+ 1 year"));

            } else {
                $fechafinal = $fechaInicio;
            }

            $seguridadDao->actualizarInicioTareaNoConformidad(date("Y-m-d H:i:s"), $fechafinal ,$tareaNoConformidad->id_tarea_no_conformidad);

        }


        if ($ActividadSeguridad->id_editorarchivo == null) {

          $actualizarStatus = $seguridadDao->actualizarStatusActividadAsignadaNoRemplazo('finalizado', $idAsignada );
          $seguridadDao->updateArchivoByIdSeguridadandResponsable( $ActividadSeguridad->id_tareas_seguridad, $ActividadSeguridad->archivo_nuevo,  $ActividadSeguridad->id_responsable );

            if($actualizarStatus['status']){
              $response['status'] = true;
              $response['mensaje'] = 'actividad autorizada correctamente. ';

          }else{
              $response['status'] = false;
              $response['mensaje'] = $actualizarStatus['error'];
          }

        }else {


            $actualizarStatus = $seguridadDao->actualizarStatusActividadAsignadaRemplazo('finalizado', $ActividadSeguridad->id_tareas_seguridad, 'autorizacion' );
            if($actualizarStatus['status']){

                $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR .
                    'archivos' . DIRECTORY_SEPARATOR;
                $rutaACopiar = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'archivos' . DIRECTORY_SEPARATOR;

              //  $archivo = $ruta . $ActividadSeguridad->archivo_nuevo;
               // $archivo_copiar = str_replace($ruta, $rutaACopiar, $archivo);
             //   if( copy($archivo, $archivo_copiar)){
                    $s = new Seguridad();
                    $s->__set('_archivo', $ActividadSeguridad->archivo_nuevo );
                    $s->__set('_idSeguridad', $ActividadSeguridad->id_tareas_seguridad);
                    $actualizarArchivoActividadPrincipal = $seguridadDao->editarArchivoActividadSeguridad($s);
                    $seguridadDao->updateArchivoByIdSeguridad($ActividadSeguridad->id_tareas_seguridad, $ActividadSeguridad->archivo_nuevo );

                    $response['status'] = true;
                    $response['mensaje'] = 'actividad autorizada correctamente. ';
             //   }else{

                //    $response['status'] = false;
               //     $response['mensaje'] = 'ocurrio un error al copiar la actividad. ';
               // }

            }else{
                $response['status'] = false;
                $response['mensaje'] = $actualizarStatus['error'];
            }

        }


        echo json_encode($response);

    }

    public function rechazarActividadSeguridad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';


        $idAsignada = (int) filter_input(INPUT_GET, 'idAsignada', FILTER_SANITIZE_NUMBER_INT);
        $razon = filter_input(INPUT_GET, 'razon', FILTER_SANITIZE_STRING);
        $fecha = filter_input(INPUT_GET, 'fecha', FILTER_SANITIZE_STRING);

        $usuarioDao = new UsuarioDao();

        $us = new UsuarioDao();
        $seguridadDao = new SeguridadDao();

        $ActividadSeguridad = $seguridadDao->buscarActividadSeguridadPorId($idAsignada)['actividad'];

        if ($ActividadSeguridad->id_editorarchivo == null) {

            $actualizarStatus = $seguridadDao->actualizarStatusActividadAsignadaNoRemplazo('progreso', $idAsignada );
            if($actualizarStatus['status']){

             $actualizarFechaYRazon =  $seguridadDao->actualizarFechaYRazonRechazoNoRemplazo($razon, $fecha, $idAsignada);
             $seguridadDao->razonRechazoTareaAsignada($razon, $idAsignada );

             if($actualizarFechaYRazon['status']){
                 $borrarTareasNoConformidad = $seguridadDao->borrarTareasNoConformidadPorIdTareaAsignada($idAsignada);


                 $usuario =  $usuarioDao->obtenerUsuario($ActividadSeguridad->id_responsable)['usuarios'];

                 $contenido = 'Fue rechazada la actividad de seguridad  : '.$ActividadSeguridad->nombre. ' ';
                 $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                 $datos = array('contenido' => $contenido);
                 $opciones = array(
                     'http' => array(
                         'method' => 'POST',
                         'header' => 'Content-type: application/x-www-form-urlencoded',
                         'content' => http_build_query($datos)
                     )
                 );

                 $contexto = stream_context_create($opciones);
                 $contenidoEmail = file_get_contents($url, false, $contexto);
                // Email::enviarEmail('sistemas@merdizshell.com', '', 'Se ha reasignado una tarea de seguridad', $contenidoEmail);
                 Email::enviarEmail($usuario->Mail, '', 'Se ha reasignado una tarea de seguridad', $contenidoEmail);



                 $response['status'] = true;
                 $response['mensaje'] = 'actividad autorizada correctamente. ';
             }else{
                 $response['status'] = false;
                 $response['mensaje'] = $actualizarFechaYRazon['error'];
             }

            }else{
                $response['status'] = false;
                $response['mensaje'] = $actualizarStatus['error'];
            }

        }else {

            $actualizarFechaYRazon =  $seguridadDao->actualizarFechaYRazonRechazoRemplazo($razon, $fecha, $ActividadSeguridad->id_tareas_seguridad, 'autorizacion' );
            if($actualizarFechaYRazon['status']){

                $actualizarStatus = $seguridadDao->actualizarStatusActividadAsignadaRemplazo('progreso', $ActividadSeguridad->id_tareas_seguridad, 'autorizacion' );
                $seguridadDao->razonRechazoTareaAsignada($razon, $idAsignada );
                if($actualizarStatus['status']){
                    $borrarTareasNoConformidad = $seguridadDao->borrarTareasNoConformidadPorIdTareaAsignada($idAsignada);
                    $responsables = $seguridadDao->buscarResponsablesPorSeguridadId( $ActividadSeguridad->id_tareas_seguridad)['usuarios'] ;


                    foreach ($responsables as $responsable){

                        $usuario =  $usuarioDao->obtenerUsuario($responsable->id_responsable)['usuarios'];

                        $contenido = 'Fue rechazada la actividad de seguridad  : '.$ActividadSeguridad->nombre. ' ';
                        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                        $datos = array('contenido' => $contenido);
                        $opciones = array(
                            'http' => array(
                                'method' => 'POST',
                                'header' => 'Content-type: application/x-www-form-urlencoded',
                                'content' => http_build_query($datos)
                            )
                        );

                        $contexto = stream_context_create($opciones);
                        $contenidoEmail = file_get_contents($url, false, $contexto);
                      //  Email::enviarEmail('sistemas@merdizshell.com', '', 'Se ha reasignado una tarea de seguridad', $contenidoEmail);
                        Email::enviarEmail($usuario->Mail, '', 'Se ha reasignado una tarea de seguridad', $contenidoEmail);

                    }

                    $response['status'] = true;
                    $response['mensaje'] = 'actividad autorizada correctamente. ';
                }else{
                    $response['status'] = false;
                    $response['mensaje'] = $actualizarFechaYRazon['error'];
                }


            }else{
                $response['status'] = false;
                $response['mensaje'] = $actualizarStatus['error'];
            }

        }


        echo json_encode($response);

    }

    public function cargarHistorialActividadRechazada(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $seguridadDao = new SeguridadDao();
        $idAsignada = (int) filter_input(INPUT_GET, 'idAsignada', FILTER_SANITIZE_NUMBER_INT);

        $razones =  $seguridadDao->obtenerRazonesDeRechazo($idAsignada)['razones'];

        $response['razones'] = $razones;
        $response['status'] = true;

        echo json_encode($response);

    }


    public function obtenerClaves(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

        $grupo =  filter_input(INPUT_GET, 'grupo', FILTER_SANITIZE_NUMBER_INT);

        $seguridadDao = new SeguridadDao();
        $cursosInternosDao = new CursosInternosDao();
        Utils::logInfo($grupo, " grupo", "");
        $claves =  $seguridadDao->buscarClaves($grupo)['claves'];
        $cursos = $cursosInternosDao->obtenerCursosPorTipoDeCurso("seguridad", $grupo)['cursos'];
        $response['claves'] = $claves;
        $response['clavesCursos'] = $cursos;
        $response['status'] = true;

        echo json_encode($response);

    }

}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        } else {
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxSeguridadController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}
