<?php
/**
 * AjaxVehiculosController.php
 * Controlador para el manejo de ajax con vehiculos
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'VehiculoDao.php';

class AjaxVehiculosController 
{

    public function getVehiculos(){
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }
        
        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $v = new VehiculoDao();
        $vehiculos = $v->getVehiculos(Sesion::obtener('idSucursal'), $inicio, $registros);
        if ($vehiculos['status']){
            $response['status'] = true;
            $total = $vehiculos['total'];
            $paginas = ceil($total / $registros);

            $response['vehiculos'] = $vehiculos['vehiculos'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $vehiculos['error'];
        }

        echo json_encode($response);
    }
    
    public function findVehiculo(){        
        $termino = filter_input(INPUT_GET, 'cadena', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        if (isset($registros) || $registros == 0){
            $registros = 10;
        }
        
        $inicio = ($pagina - 1) * $registros;       
        
        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        
        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $v = new VehiculoDao();
        $vehiculos = $v->findVehiculo(Sesion::obtener('idSucursal'), $inicio, $registros, $termino);
        if ($vehiculos['status']){
            $response['status'] = true;
            $total = $vehiculos['total'];
            $paginas = ceil($total / $registros);

            $response['vehiculos'] = $vehiculos['vehiculos'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $vehiculos['error'];
        }
        
        echo json_encode($response);
    }

    public function getVehiculo(){
        $idVehiculo = filter_input(INPUT_GET, 'idVehiculo', FILTER_SANITIZE_NUMBER_INT);
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'verificacion' . DIRECTORY_SEPARATOR;

        $v = new VehiculoDao();
        $fecha = date("Y-m-d");
        
        $vehiculo = $v->getVehiculo($idVehiculo);
        if ($vehiculo['status']){
            $response['status'] = true;
            $response['vehiculo'] = $vehiculo['vehiculo'];
            $response['fechaHoy'] = $fecha;

            $placas = $vehiculo['vehiculo']->Placas;
            $fVerificacion = $vehiculo['vehiculo']->fecha_verificacion;
            $fTarjetaC = $vehiculo['vehiculo']->fecha_tarjeta_circulacion;
            $fServicio = $vehiculo['vehiculo']->fecha_servicio;
            $fSeguro = $vehiculo['vehiculo']->fecha_seguro;

            if(file_exists($ruta."Verificacion-".$placas."-".$fVerificacion.".pdf"))
            {
                $response['archivoVerificacion'] = true;
            }else {
                $response['archivoVerificacion'] = false;
            }

            if(file_exists($ruta."Poliza-".$placas."-".$fSeguro.".pdf"))
            {
                $response['archivoPoliza'] = true;
            }else {
                $response['archivoPoliza'] = false;
            }

            if(file_exists($ruta."TarjetaC-".$placas."-".$fTarjetaC.".pdf"))
            {
                $response['archivoTarjeta'] = true;
            }else {
                $response['archivoTarjeta'] = false;
            }

            if(file_exists($ruta."Servicio-".$placas."-".$fServicio.".pdf"))
            {
                $response['archivoServicio'] = true;
            }else {
                $response['archivoServicio'] = false;
            }

        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $vehiculo['error'];
        }
        
        echo json_encode($response);
    }

    public function saveVehiculo(){
        
        $tipo = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
        $idVehiculo = filter_input(INPUT_POST, 'idVehiculo', FILTER_SANITIZE_NUMBER_INT);
        $marca = filter_input(INPUT_POST, 'marca', FILTER_SANITIZE_STRING);
        $vehiculo = filter_input(INPUT_POST, 'vehiculo', FILTER_SANITIZE_STRING);
        $color = filter_input(INPUT_POST, 'color', FILTER_SANITIZE_STRING);
        $tanque = filter_input(INPUT_POST, 'tanque', FILTER_SANITIZE_STRING);
        $confVehicular = filter_input(INPUT_POST, 'confVehicular', FILTER_SANITIZE_STRING);
        $verificacion = filter_input(INPUT_POST, 'verificacion', FILTER_SANITIZE_STRING);
        $tarjetaCirculacion = filter_input(INPUT_POST, 'ftarjeta', FILTER_SANITIZE_STRING);
        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_STRING);
        $placas = filter_input(INPUT_POST, 'placas', FILTER_SANITIZE_STRING);
        $serie = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_STRING);
        $kmini = filter_input(INPUT_POST, 'kmini', FILTER_SANITIZE_STRING);
        $kmServicio = filter_input(INPUT_POST, 'kmServicio', FILTER_SANITIZE_STRING);
        $fechaServicio = filter_input(INPUT_POST, 'fServicio', FILTER_SANITIZE_STRING);
        $asignado = filter_input(INPUT_POST, 'asignado', FILTER_SANITIZE_STRING);
        $aseguradora = filter_input(INPUT_POST, 'aseguradora', FILTER_SANITIZE_STRING);
        $poliza = filter_input(INPUT_POST, 'poliza', FILTER_SANITIZE_STRING);
        $fechaSeguro = filter_input(INPUT_POST, 'fSeguro', FILTER_SANITIZE_STRING);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);
        $sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
        $kmRestantes = filter_input(INPUT_POST, 'kilometrosRes', FILTER_SANITIZE_NUMBER_INT);
        $pesoBruto = filter_input(INPUT_POST, 'pesoBruto', FILTER_SANITIZE_NUMBER_INT);
        $fecha = date("Y-m-d");
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'verificacion' . DIRECTORY_SEPARATOR;
        $arcVerificacion = "Verificacion-" . $placas . "-" . $verificacion;
        $arcPoliza = "Poliza-" . $placas . "-" . $fechaSeguro;
        $arcTarjeta = "TarjetaC-" . $placas . "-" . $tarjetaCirculacion;
        $arcServicio = "Servicio-" . $placas . "-" . $fechaServicio;

        if (isset($_FILES['pdf']['name'])) {
            if (isset($_FILES['pdfPoliza']['name'])) {
                if (isset($_FILES['pdfTarjeta']['name'])) {
                    if (isset($_FILES['pdfServicio']['name'])) {
                        if (move_uploaded_file($_FILES['pdf']['tmp_name'], $ruta . "Verificacion-" . $placas . "-" . $verificacion .'.pdf') || file_exists($ruta . "Verificacion-" . $placas . "-" . $verificacion . ".pdf")) {
                            $vExpediente = new VehiculoDao();
                            $datosExpediente = $vExpediente->getExpedienteVehiculo($idVehiculo, $arcVerificacion);
                            if($datosExpediente['total'] == 0){
                                Utils::logInfo("total 0 VERI", "", "");
                                $expedienteVerificacion = new Vehiculo();
                                $expedienteVerificacion->__set('_nombreArc', trim($arcVerificacion));
                                $expedienteVerificacion->__set('_fechaSubida', trim($fecha));
                                $expedienteVerificacion->__set('_fechaDoc', trim($verificacion));
                                $expedienteVerificacion->__set('_id_vehiculo', trim($idVehiculo));
                                $vExpediente->guardaExpedienteVehiculo($expedienteVerificacion, $idVehiculo);
                            }
                            foreach ($datosExpediente['expediente'] as $nombreArchivo){
                                if($nombreArchivo->nombre_archivo != $arcVerificacion){
                                    Utils::logInfo("NO EXISTE VERI", "", "");
                                    $expedienteVerificacion = new Vehiculo();
                                    $expedienteVerificacion->__set('_nombreArc', trim($arcVerificacion));
                                    $expedienteVerificacion->__set('_fechaSubida', trim($fecha));
                                    $expedienteVerificacion->__set('_fechaDoc', trim($verificacion));
                                    $expedienteVerificacion->__set('_id_vehiculo', trim($idVehiculo));
                                    $vExpediente->guardaExpedienteVehiculo($expedienteVerificacion, $idVehiculo);
                                }else {
                                    Utils::logInfo("SI EXISTE VERI".$nombreArchivo->nombre_archivo, "", "");
                                }
                            }
                            if (move_uploaded_file($_FILES['pdfPoliza']['tmp_name'], $ruta . "Poliza-" . $placas . "-" . $fechaSeguro .'.pdf') || file_exists($ruta . "Poliza-" . $placas . "-" . $fechaSeguro . ".pdf")) {
                                $pExpediente = new VehiculoDao();
                                $datosExpediente = $pExpediente->getExpedienteVehiculo($idVehiculo, $arcPoliza);
                                if($datosExpediente['total'] == 0){
                                    Utils::logInfo("total 0 POLIZA", "", "");
                                    $expedientePoliza = new Vehiculo();
                                    $expedientePoliza->__set('_nombreArc', trim($arcPoliza));
                                    $expedientePoliza->__set('_fechaSubida', trim($fecha));
                                    $expedientePoliza->__set('_fechaDoc', trim($fechaSeguro));
                                    $expedientePoliza->__set('_id_vehiculo', trim($idVehiculo));
                                    $pExpediente->guardaExpedienteVehiculo($expedientePoliza, $idVehiculo);
                                }
                                foreach ($datosExpediente['expediente'] as $nombreArchivo){
                                    if($nombreArchivo->nombre_archivo != $arcPoliza){
                                        Utils::logInfo("NO EXISTE POLIZA", "", "");
                                        $expedientePoliza = new Vehiculo();
                                        $expedientePoliza->__set('_nombreArc', trim($arcPoliza));
                                        $expedientePoliza->__set('_fechaSubida', trim($fecha));
                                        $expedientePoliza->__set('_fechaDoc', trim($fechaSeguro));
                                        $expedientePoliza->__set('_id_vehiculo', trim($idVehiculo));
                                        $pExpediente->guardaExpedienteVehiculo($expedientePoliza, $idVehiculo);
                                    }else {
                                        Utils::logInfo("SI EXISTE POLIZA".$nombreArchivo->nombre_archivo, "", "");
                                    }
                                }
                                if (move_uploaded_file($_FILES['pdfTarjeta']['tmp_name'], $ruta . "TarjetaC-" . $placas . "-" . $tarjetaCirculacion .'.pdf') || file_exists($ruta . "TarjetaC-" . $placas . "-" . $tarjetaCirculacion . ".pdf")) {
                                    $tExpediente = new VehiculoDao();
                                    $datosExpediente = $tExpediente->getExpedienteVehiculo($idVehiculo, $arcTarjeta);
                                    if($datosExpediente['total'] == 0){
                                        Utils::logInfo("total 0 TARJETA", "", "");
                                        $expedienteTarjeta = new Vehiculo();
                                        $expedienteTarjeta->__set('_nombreArc', trim($arcTarjeta));
                                        $expedienteTarjeta->__set('_fechaSubida', trim($fecha));
                                        $expedienteTarjeta->__set('_fechaDoc', trim($tarjetaCirculacion));
                                        $expedienteTarjeta->__set('_id_vehiculo', trim($idVehiculo));
                                        $tExpediente->guardaExpedienteVehiculo($expedienteTarjeta, $idVehiculo);
                                    }
                                    foreach ($datosExpediente['expediente'] as $nombreArchivo){
                                        if($nombreArchivo->nombre_archivo != $arcTarjeta){
                                            Utils::logInfo("NO EXISTE TARJETA", "", "");
                                            $expedienteTarjeta = new Vehiculo();
                                            $expedienteTarjeta->__set('_nombreArc', trim($arcTarjeta));
                                            $expedienteTarjeta->__set('_fechaSubida', trim($fecha));
                                            $expedienteTarjeta->__set('_fechaDoc', trim($tarjetaCirculacion));
                                            $expedienteTarjeta->__set('_id_vehiculo', trim($idVehiculo));
                                            $tExpediente->guardaExpedienteVehiculo($expedienteTarjeta, $idVehiculo);
                                        }else {
                                            Utils::logInfo("SI EXISTE TARJETA".$nombreArchivo->nombre_archivo, "", "");
                                        }
                                    }
                                    if (move_uploaded_file($_FILES['pdfServicio']['tmp_name'], $ruta . "Servicio-" . $placas . "-" . $fechaServicio .'.pdf') || file_exists($ruta . "Servicio-" . $placas . "-" . $fechaServicio . ".pdf")) {
                                        $sExpediente = new VehiculoDao();
                                        $datosExpediente = $sExpediente->getExpedienteVehiculo($idVehiculo, $arcServicio);
                                        if($datosExpediente['total'] == 0){
                                            Utils::logInfo("total 0 SERVICIO", "", "");
                                            $expedienteServicio = new Vehiculo();
                                            $expedienteServicio->__set('_nombreArc', trim($arcServicio));
                                            $expedienteServicio->__set('_fechaSubida', trim($fecha));
                                            $expedienteServicio->__set('_fechaDoc', trim($fechaServicio));
                                            $expedienteServicio->__set('_id_vehiculo', trim($idVehiculo));
                                            $sExpediente->guardaExpedienteVehiculo($expedienteServicio, $idVehiculo);
                                        }
                                        foreach ($datosExpediente['expediente'] as $nombreArchivo){
                                            if($nombreArchivo->nombre_archivo != $arcServicio){
                                                Utils::logInfo("NO EXISTE SERVICIO", "", "");
                                                $expedienteServicio = new Vehiculo();
                                                $expedienteServicio->__set('_nombreArc', trim($arcServicio));
                                                $expedienteServicio->__set('_fechaSubida', trim($fecha));
                                                $expedienteServicio->__set('_fechaDoc', trim($fechaServicio));
                                                $expedienteServicio->__set('_id_vehiculo', trim($idVehiculo));
                                                $sExpediente->guardaExpedienteVehiculo($expedienteServicio, $idVehiculo);
                                            }else {
                                                Utils::logInfo("SI EXISTE SERVICIO".$nombreArchivo->nombre_archivo, "", "");
                                            }
                                        }
                                        $v = new Vehiculo();
                                        $v->__set('_marca', trim($marca));
                                        $v->__set('_vehiculo', trim($vehiculo));
                                        $v->__set('_color', trim($color));
                                        $v->__set('_tanque', trim($tanque));
                                        $v->__set('_year', trim($year));
                                        $v->__set('_placas', trim($placas));
                                        $v->__set('_serie', trim($serie));
                                        $v->__set('_status', trim("1"));
                                        $v->__set('_idSucursal', $sucursal);
                                        $v->__set('_kilometraje', trim($kmini));
                                        $v->__set('_confVehicular', trim($confVehicular));
                                        $v->__set('_aseguradora', trim($aseguradora));
                                        $v->__set('_poliza', trim($poliza));
                                        $v->__set('_asignado', trim($asignado));
                                        $v->__set('_kmServicio', trim($kmServicio));
                                        $v->__set('_verificacion', trim($verificacion));
                                        $v->__set('_tarjetaCirculacion', trim($tarjetaCirculacion));
                                        $v->__set('_fechaServicio', trim($fechaServicio));
                                        $v->__set('_fechaSeguro', trim($fechaSeguro));
                                        if($fechaServicio == $fecha && $kmRestantes <= 300 || !$kmRestantes )
                                        {
                                            $v->__set('_kmRestante', trim($kmServicio));
                                        }else{
                                            $v->__set('_kmRestante', trim($kmRestantes));
                                        }
                                        $v->__set('_idVehiculo', trim($idVehiculo));
                                        $v->__set('_pesoBruto', trim($pesoBruto));

                                        $vd = new VehiculoDao();
                                        $vehiculo = $vd->guardaVehiculo($v, $tipo);
                                        if ($vehiculo['status']) {
                                            $idVehiculo = $vehiculo['idVehiculo'];
                                            $response['status'] = true;
                                            $response['idVehiculo'] = $idVehiculo;
                                            $response['mensaje'] = 'Los datos del vehiculo se guardaron correctamente';
                                        } else {
                                            Utils::logInfo("Error", "", "");

                                            $response['status'] = false;
                                            $response['mensaje'] = $vehiculo['error'];
                                        }
                                    } else {
                                        $response['status'] = false;
                                        $response['mensaje'] = 'Debes adjuntar un archivo PDF del ultimo servicio del vehiculo. -_-';
                                    }
                                } else {
                                    $response['status'] = false;
                                    $response['mensaje'] = 'Debes adjuntar un archivo PDF de la tarjeta de circulación. -_-';
                                }
                            } else {
                                $response['status'] = false;
                                $response['mensaje'] = 'Debes adjuntar un archivo PDF de la poliza de seguro. -_-';
                            }
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = 'Debes adjuntar un archivo PDF de vereficación. -_-';
                        }
                    }
                }
            }
        }
        echo json_encode($response);
    }

    public function getVerificacion(){

        $placas = filter_input(INPUT_POST, 'placas', FILTER_SANITIZE_STRING);
        $fechaVeri = filter_input(INPUT_POST, 'fVerificacion', FILTER_SANITIZE_STRING);
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'verificacion' . DIRECTORY_SEPARATOR;

        if(file_exists($ruta."Verificacion-".$placas."-".$fechaVeri.".pdf"))
        {
            $response['status'] = true;
            $response['nombre'] = "Verificacion-".$placas."-".$fechaVeri.".pdf";
        }else {
            $response['status'] = false;
        }

        echo json_encode($response);
    }

    public function getTarjetaC(){

        $placas = filter_input(INPUT_POST, 'placas', FILTER_SANITIZE_STRING);
        $fechaTarje = filter_input(INPUT_POST, 'fTarjeta', FILTER_SANITIZE_STRING);
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'verificacion' . DIRECTORY_SEPARATOR;

        if(file_exists($ruta."TarjetaC-".$placas."-".$fechaTarje.".pdf"))
        {
            $response['status'] = true;
            $response['nombre'] = "TarjetaC-".$placas."-".$fechaTarje.".pdf";
        }else {
            $response['status'] = false;
        }

        echo json_encode($response);
    }

    public function getPoliza(){

        $placas = filter_input(INPUT_POST, 'placas', FILTER_SANITIZE_STRING);
        $fechaSeguro = filter_input(INPUT_POST, 'fSeguro', FILTER_SANITIZE_STRING);
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'verificacion' . DIRECTORY_SEPARATOR;

        if(file_exists($ruta."Poliza-".$placas."-".$fechaSeguro.".pdf"))
        {
            $response['status'] = true;
            $response['nombre'] = "Poliza-".$placas."-".$fechaSeguro.".pdf";
        }else {
            $response['status'] = false;
        }

        echo json_encode($response);
    }

    public function getPDFServicio(){

        $placas = filter_input(INPUT_POST, 'placas', FILTER_SANITIZE_STRING);
        $fechaServ = filter_input(INPUT_POST, 'fServicio', FILTER_SANITIZE_STRING);
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'verificacion' . DIRECTORY_SEPARATOR;

        if(file_exists($ruta."Servicio-".$placas."-".$fechaServ.".pdf"))
        {
            $response['status'] = true;
            $response['nombre'] = "Servicio-".$placas."-".$fechaServ.".pdf";
        }else {
            $response['status'] = false;
        }

        echo json_encode($response);
    }


    public function getHistorialVerificacion(){
        set_time_limit(120);

        $idVehiculo = filter_input(INPUT_POST, 'idVehiculo', FILTER_SANITIZE_NUMBER_INT);
        $pagina = filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $placas = filter_input(INPUT_POST, 'placasVeri', FILTER_SANITIZE_STRING);
        $nombreArchivo = "Verificacion-" . $placas;

        $v = new VehiculoDao();

        $arrRes = array('success' => true);
        $expedienteV = $v->getExpedienteVehicular($idVehiculo,$nombreArchivo,$pagina);
        $arrRes['expVerificacion'] = $expedienteV['expedienteVeri'];
        $arrRes['total'] = $expedienteV['total'];

        echo json_encode($arrRes);
    }

    public function getHistorialTarjetaC(){
        set_time_limit(120);

        $idVehiculo = filter_input(INPUT_POST, 'idVehiculo', FILTER_SANITIZE_NUMBER_INT);
        $pagina = filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $placas = filter_input(INPUT_POST, 'placasVeri', FILTER_SANITIZE_STRING);
        $nombreArchivo = "TarjetaC-" . $placas;

        $v = new VehiculoDao();

        $arrRes = array('success' => true);
        $expedienteV = $v->getExpedienteVehicular($idVehiculo,$nombreArchivo,$pagina);
        $arrRes['expTarjetaC'] = $expedienteV['expedienteVeri'];
        $arrRes['total'] = $expedienteV['total'];

        echo json_encode($arrRes);
    }

    public function getHistorialServicio(){
        set_time_limit(120);

        $idVehiculo = filter_input(INPUT_POST, 'idVehiculo', FILTER_SANITIZE_NUMBER_INT);
        $pagina = filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $placas = filter_input(INPUT_POST, 'placasVeri', FILTER_SANITIZE_STRING);
        $nombreArchivo = "Servicio-" . $placas;

        $v = new VehiculoDao();

        $arrRes = array('success' => true);
        $expedienteV = $v->getExpedienteVehicular($idVehiculo,$nombreArchivo,$pagina);
        $arrRes['expServicio'] = $expedienteV['expedienteVeri'];
        $arrRes['total'] = $expedienteV['total'];

        echo json_encode($arrRes);
    }

    public function getHistorialPoliza(){
        set_time_limit(120);

        $idVehiculo = filter_input(INPUT_POST, 'idVehiculo', FILTER_SANITIZE_NUMBER_INT);
        $pagina = filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $placas = filter_input(INPUT_POST, 'placasVeri', FILTER_SANITIZE_STRING);
        $nombreArchivo = "Poliza-" . $placas;

        $v = new VehiculoDao();

        $arrRes = array('success' => true);
        $expedienteV = $v->getExpedienteVehicular($idVehiculo,$nombreArchivo,$pagina);
        $arrRes['expPoliza'] = $expedienteV['expedienteVeri'];
        $arrRes['total'] = $expedienteV['total'];

        echo json_encode($arrRes);
    }
}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        }
        else{
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxVehiculosController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}
