<?php
/**
 * BalanceController.php
 * Controlador principal para el módulo de calidad
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package calidad
 */

class BalanceController extends Controller {

    private $_module = 6;
    private $_tarea;

    /**
     * Método constructor, inicializa el módulo
     * @access public
     */
    public function __construct() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'TareasDao.php';
        $this->_modulo = 'balance';

        $t = new TareasDao();
        $tareas = $t->obtenerTareasModuloUsuario($this->_module, Sesion::obtener('idUsuario'));
        if (!$tareas['status']) {
            ErrorController::mostrarError(1, $tareas['error']);
        }
        $tareasLista = $tareas['tareas'];
        $arrayTareas = new ArrayObject($tareasLista);
        $iteradorTareas = $arrayTareas->getIterator();
        $this->_datos['tareas'] = $iteradorTareas;
    }

    /**
     * Método para cargar la vista por defecto
     * @access public
     */
    public function index() {
        $this->_vista = 'index';
        $this->existeVista();
        $this->_datos['accion'] = '';
        $this->cargarVista();
    }

    public function calidad() {
        $this->_tarea = 17;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $sub = $t->obtenerSubtareasUsuario($this->_tarea, Sesion::obtener('idUsuario'));
            if ($sub['status']) {
                $subtareas = $sub['subtareas'];
                $arraySubtareas = new ArrayObject($subtareas);
                $iteradorSubtareas = $arraySubtareas->getIterator();
                $this->_vista = 'calidad';
                $this->existeVista();
                $this->_datos['accion'] = 'calidad';
                $this->_datos['subtareas'] = $iteradorSubtareas;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function sistemaCalidad() {
        $this->_tarea = 74;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $this->_vista = 'sistemaCalidad';
            $this->existeVista();
            $this->_datos['accion'] = 'sistema de calidad';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function subirManualProcedimientos() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'TareasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CategoriaDao.php';

        $this->_tarea = 74;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $c = new Categoria();
            $c->__set('_idUsuario', Sesion::obtener('idUsuario'));
            $ca = new CategoriaDao();
            $cat = $ca->obtenerListaCategorias($c);
            if ($cat['status']) {
                $cate = $cat['categorias'];
                $arrayCategorias = new ArrayObject($cate);
                if ($arrayCategorias->count() > 0) {
                    $iteradorCategorias = $arrayCategorias->getIterator();
                    $this->_datos['categorias'] = $iteradorCategorias;
                    $this->_vista = 'subirManualProcedimientos';
                    $this->existeVista();
                    $this->_datos['accion'] = 'sistema de calidad';
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, 'Lo siento, no tienes asignada una categoría');
                }
            } else {
                ErrorController::mostrarError(1, $cat['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function autorizaProcedimiento() {
        $this->_tarea = 74;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $this->_vista = 'autorizaProcedimiento';
            $this->existeVista();
            $this->_datos['accion'] = 'sistema de calidad';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function visorPdf() {
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'fpdf/fpdf.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'fpdi/fpdi.php';

        $documento = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_STRING);
        $documento = urldecode($documento);
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'documentos' . DIRECTORY_SEPARATOR . $documento;
        $pdf = new FPDI();
        $paginas = $pdf->setSourceFile($ruta);
        $pagina = 1;
        $templateId = $pdf->importPage($pagina);
        $size = $pdf->getTemplateSize($templateId);


        if ($size['w'] > $size['h']) {
            $pdf->AddPage('L', array($size['w'], $size['h']));
        } else {
            $pdf->AddPage('P', array($size['w'], $size['h']));
        }
        $pdf->useTemplate($templateId);

        $pdf->Output();
    }

    public function subirManualCalidad() {
        $this->_tarea = 74;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'subirManualCalidad';
            $this->existeVista();
            $this->_datos['accion'] = 'sistema de calidad';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function subirPoliticas() {
        $this->_tarea = 74;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'subirPoliticas';
            $this->existeVista();
            $this->_datos['accion'] = 'sistema de calidad';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function subirFormatos() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'InstruccionDao.php';
        $this->_tarea = 74;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $i = new InstruccionDao();
            $instrucciones = $i->listaInstrucciones();
            if ($instrucciones['status']) {
                $arrayInstrucciones = new ArrayObject($instrucciones['instrucciones']);
                $hay = $arrayInstrucciones->count();
                if ($hay > 0) {
                    $iteradorInstrucciones = $arrayInstrucciones->getIterator();
                    $this->_vista = 'subirFormatos';
                    $this->existeVista();
                    $this->_datos['accion'] = 'sistema de calidad';
                    $this->_datos['instrucciones'] = $iteradorInstrucciones;
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, 'No existen Instrucciones Autorizadas');
                }
            } else {
                ErrorController::mostrarError(1, $instrucciones['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function subirInstruccion() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProcedimientoDao.php';

        $this->_tarea = 74;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $p = new ProcedimientoDao();
            $procedimientos = $p->obtenerListaProcedimientosPorUsuario(Sesion::obtener('idUsuario'));
            if ($procedimientos['status']) {
                if ($procedimientos['total'] > 0) {
                    $arrayProcedimientos = new ArrayObject($procedimientos['procedimientos']);
                    $iteradorProcedimientos = $arrayProcedimientos->getIterator();
                    $this->_vista = 'subirInstruccion';
                    $this->existeVista();
                    $this->_datos['procedimientos'] = $iteradorProcedimientos;
                    $this->_datos['accion'] = 'sistema de calidad';
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, 'Lo siento, no existen Procedimientos Autorizados');
                }
            } else {
                ErrorController::mostrarError(1, $procedimientos['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function entregas() {
        $this->_tarea = 18;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $sub = $t->obtenerSubtareasUsuario($this->_tarea, Sesion::obtener('idUsuario'));
            if ($sub['status']) {
                $subtareas = $sub['subtareas'];
                $arraySubtareas = new ArrayObject($subtareas);
                $iteradorSubtareas = $arraySubtareas->getIterator();
                $this->_vista = 'entregas';
                $this->existeVista();
                $this->_datos['accion'] = 'entregas';
                $this->_datos['subtareas'] = $iteradorSubtareas;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }
    
    public function forecast() {
        $this->_tarea = 36;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }


            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                    DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR .
                'ForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'AutorizacionesForecastAnualDao.php';

            $us = new UsuarioDao();
            $forecastMensualDao = new ForecastMensualDao();
            $fechaInicial = date("Y-m-01");
            $fechaInicial = date("Y-m-01", strtotime($fechaInicial.'+ 1 month'));

            $usuario = $us->obtenerUsuario(Sesion::obtener('idUsuario'));
            if ($usuario['status']) {

                $f = new ForecastMensualDao();
                $hay = $f->obtenerForecastMensualPorUsuarioYSucursal($fechaInicial, $fechaInicial,  Sesion::obtener('idUsuario'), Sesion::obtener('idSucursal') );

                $autorizacionesForecastAnualDao = new AutorizacionesForecastAnualDao();
                $fecha = (date("Y", strtotime('-1 year')));
                $autorizacionesPendientes = $autorizacionesForecastAnualDao->obtenerAutorizacionForecastAnualUsuario( $fecha, Sesion::obtener('idUsuario') );

                $this->_datos['hayForecast'] = $hay['total'];
                $this->_datos['iniciarForecast'] = '';
                $datosUsuario = $usuario['usuarios'];

                Utils::logInfo('Sucursal Usuario: '.$datosUsuario->Id_Sucursal,'Sucursal sesion: '.Sesion::obtener('idSucursal'),'Hay forecast?: '.$hay['total'].' | '.__FILE__);

                if($datosUsuario->Id_Sucursal == Sesion::obtener('idSucursal') && $this->_datos['hayForecast'] == 0){
                    $this->_datos['iniciarForecast'] = '<button type="button" class="btn btn-primary" id="iniciarForecast">Iniciar Forecast mensual</button>';
                }

                $this->_vista = 'forecast';
                $this->existeVista();
                $this->_datos['accion'] = 'entregas';
                $this->_datos['vendedor'] = $datosUsuario;
                $this->_datos['autorizacionPendienteForecastAnual'] = $autorizacionesPendientes;
                $this->_datos['infoAutorizacion'] = $autorizacionesPendientes['autorizaciones'];

                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $usuario['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function forecastAnual() {
        $this->_tarea = 36;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProspectosDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ServiciosClienteDao.php';

            $idCliente = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            $c = new Cliente();
            $c->__set('_idCliente', $idCliente);
            $cl = new ClienteDao();
            $cliente = $cl->obtenerClientePorId($c);
            if ($cliente['status']) {
                $datosCliente = $cliente['cliente'];
                $pc = new ProductoClienteDao();
                $productos = $pc->obtenerProductosCliente($idCliente);
                if ($productos['status']) {
                    $arrayProductos = new ArrayObject($productos['productos']);
                    $iteradorProductos = $arrayProductos->getIterator();
                    if ($datosCliente->Consumo > 0) {
                        if ($datosCliente->Giro != NULL) {
                            //obtenemos el forecast




                            $f = new ForecastAnualDao();

                            $fore = $f->hayForecast(date("Y"), Sesion::obtener('idSucursal'));

                            if ($fore['status']) {
                                if ($fore['total'] > 0) {
                                    $datosForecast = $fore['forecast'];
                                    $totalLitrosSucursal = $datosForecast->Total_Litros;
                                } else {
                                    $fn = new ForecastAnual();
                                    $fn->__set('_year', date("Y") );
                                    $fn->__set('_idSucursal', Sesion::obtener('idSucursal'));
                                    $fn->__set('_totalLitros', 0);
                                    $for = $f->crear($fn);
                                    $forc = $f->hayForecast(date("Y"), Sesion::obtener('idSucursal'))['forecast'];
                                    $datosForecast = $forc['forecast'];
                                    $totalLitrosSucursal = $forc->Total_Litros;
                                }
                                switch (Sesion::obtener('idSucursal')) {
                                    case 1:
                                        $limiteSucursal = 1100000;
                                        break;
                                    case 2:
                                        $limiteSucursal = 295000;
                                        break;
                                    case 5:
                                        $limiteSucursal = 135000;
                                        break;
                                }

                                $count = 0;
                                $numero_dia = 4;
                                $hoy = date("Y-m-d");
                                $mes = date("m");
                                $anio = date("Y");
                                $dias_mes = cal_days_in_month(CAL_GREGORIAN, $mes, $anio);
                                for ($i = 1; $i <= $dias_mes; $i++) {
                                    if (date('N', strtotime($anio . '-' . $mes . '-' . $i)) == $numero_dia) {
                                        $count++;
                                        if ($count == 2) {
                                            $segundoJueves = date('Y-m-d', strtotime($anio . '-' . $mes . '-' . $i));
                                            break;
                                        }
                                    }
                                }

                                $fechaInicial = date("Y-m-01");
                                $fechaInicial = date("Y-m-01", strtotime($fechaInicial.'+ 1 month'));
                                $forecastMensualDao = new ForecastMensualDao();
                                $hay = $forecastMensualDao->obtenerForecastMensual($fechaInicial, $fechaInicial, Sesion::obtener('idUsuario'));

                                $serviciosClienteDao = new ServiciosClienteDao();

                                $this->_vista = 'forecastAnual';
                                $this->existeVista();
                                $this->_datos['accion'] = 'entregas';
                                $this->_datos['cliente'] = $datosCliente;
                                $this->_datos['productos'] = $iteradorProductos;
                                $this->_datos['litrosFacturados'] = $datosCliente->Total_Facturado;
                                $this->_datos['consumo'] = $datosCliente->Consumo;
                                $this->_datos['sector'] = $datosCliente->Giro;
                                $this->_datos['totalAcumulado'] = $totalLitrosSucursal;
                                $this->_datos['limiteSucursal'] = $limiteSucursal;
                                $this->_datos['segundoJueves'] = $segundoJueves;
                                $this->_datos['forecast'] = $datosForecast;
                                $this->_datos['hayForecastMensual'] = $hay['total'];
                                $this->_datos['prospecto'] = $this->obtenerDatosProspecto($datosCliente);
                                $this->_datos['servicios'] = $serviciosClienteDao->obtenerServicios($datosCliente->Id_Cliente)['servicios'];

                                $this->cargarVista();
                            } else {
                                ErrorController::mostrarError(1, $fore['error']);
                            }
                        } else {
                            ErrorController::mostrarError(1, 'Por favor actualiza el sector del cliente.');
                        }
                    } else {
                        ErrorController::mostrarError(1, 'El cliente no cuenta con su consumo actualizado. Por favor actualizalo antes de continuar.');
                    }
                } else {
                    ErrorController::mostrarError(1, $productos['error']);
                }
            } else {
                ErrorController::mostrarError(1, $cliente['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

   public function forecastMensual() {
        $this->_tarea = 36;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

            $idCliente = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            $c = new Cliente();
            $c->__set('_idCliente', $idCliente);
            $cl = new ClienteDao();
            $cliente = $cl->obtenerClientePorId($c);
            if ($cliente['status']) {
                $datosCliente = $cliente['cliente'];
                $pc = new ProductoClienteDao();
                $productos = $pc->obtenerProductosCliente($idCliente);
                if ($productos['status']) {
                    $arrayProductos = new ArrayObject($productos['productos']);
                    $iteradorProductos = $arrayProductos->getIterator();
                    $mesFirme = strtotime('+1 month', strtotime("m"));
                    $mesFirme = (int) date("m", $mesFirme);
                    $meses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
                    $nombreMesFirme = $meses[$mesFirme - 1];
                    $mes1 = $mesFirme + 1;
                    if ($mes1 > 12) {
                        $mes1 = 12;
                    }
                    $mes2 = $mes1 + 1;
                    if ($mes2 > 12) {
                        $mes2 = 1;
                    }

                    $fechaInicial = date("Y-m-01");
                    $fechaInicial = date("Y-m-01", strtotime($fechaInicial.'+ 1 month'));
                    $forecastMensualDao = new ForecastMensualDao();
                    $hay = $forecastMensualDao->obtenerForecastMensual($fechaInicial, $fechaInicial, Sesion::obtener('idUsuario'));

                    $nombreMes1 = $meses[$mes1 - 1];
                    $nombreMes2 = $meses[$mes2 - 1];
                    $mesActual = (int) date("m");
                    $nombreMesActual = $meses[$mesActual - 1];
                    $this->_vista = 'forecastMensual';
                    $this->existeVista();
                    $this->_datos['accion'] = 'entregas';
                    $this->_datos['cliente'] = $datosCliente;
                    $this->_datos['productos'] = $iteradorProductos;
                    $this->_datos['mesFirme'] = $nombreMesFirme;
                    $this->_datos['mes1'] = $nombreMes1;
                    $this->_datos['mes2'] = $nombreMes2;
                    $this->_datos['meses'] = $meses;
                    $this->_datos['mesActual'] = $nombreMesActual;
                    $this->_datos['hayForecastMensual'] = $hay['total'];
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $productos['error']);
                }
            } else {
                ErrorController::mostrarError(1, $cliente['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

     public function forecastAnualProspecto() {
        $this->_tarea = 36;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProspectosDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ServiciosSospechosoDao.php';

            $idCliente = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            $s = new SospechosoDao();
            $cliente = $s->obtenerSospechoso($idCliente);
            if ($cliente['status']) {
                $datosCliente = $cliente['sospechoso'];
                $pc = new ProductoProspectoDao();
                $productos = $pc->obtenerProductosProspecto($idCliente);
                if ($productos['status']) {
                    $arrayProductos = new ArrayObject($productos['productos']);
                    $iteradorProductos = $arrayProductos->getIterator();
                    $p = new ProspectosDao();
                    $prospecto = $p->obtenerProspecto($idCliente);
                    if ($prospecto['status']) {
                        if($prospecto['total'] == 0){
                            ErrorController::mostrarError(1, 'Por favor primero llena hasta la etapa de prospecto del SPANCOP.');
                        }
                        $datosProspecto = $prospecto['prospecto'];
                        if ($datosProspecto->Consumo > 0) {
                            if ($datosProspecto->Sector == 0 || $datosProspecto->Sector == '') {
                                ErrorController::mostrarError(1, 'Por favor actualiza el sector del prospecto.');
                            } else {
                                $fc = new ForecastAnualDao();
                                $fca = $fc->hayForecast(date("Y"), Sesion::obtener('idSucursal'));

                                switch (Sesion::obtener('idSucursal')) {
                                    case 1:
                                        $limiteSucursal = 1100000;
                                        break;
                                    case 2:
                                        $limiteSucursal = 295000;
                                        break;
                                    case 5:
                                        $limiteSucursal = 135000;
                                        break;
                                }

                                $f = new ForecastAnualDao();
                                $fore = $f->hayForecast(date("Y"), Sesion::obtener('idSucursal'));
                                if ($fore['status']) {
                                    if ($fore['total'] > 0) {
                                        $datosForecast = $fore['forecast'];
                                        $totalLitrosSucursal = $datosForecast->Total_Litros;
                                    } else {
                                        $fn = new ForecastAnual();
                                        $fn->__set('_year', date("Y"));
                                        $fn->__set('_idSucursal', Sesion::obtener('idSucursal'));
                                        $fn->__set('_totalLitros', 0);
                                        $for = $f->crear($fn);
                                        $forc = $f->hayForecast(date("Y"), Sesion::obtener('idSucursal'))['forecast'];
                                        $datosForecast = $forc['forecast'];
                                        $totalLitrosSucursal = $forc->Total_Litros;
                                    }

                                    switch (Sesion::obtener('idSucursal')) {
                                        case 1:
                                            $limiteSucursal = 1100000;
                                            break;
                                        case 2:
                                            $limiteSucursal = 295000;
                                            break;
                                        case 5:
                                            $limiteSucursal = 135000;
                                            break;
                                    }
                                }

                                $count = 0;
                                $numero_dia = 4;
                                $hoy = date("Y-m-d");
                                $mes = date("m");
                                $anio = date("Y");
                                $dias_mes = cal_days_in_month(CAL_GREGORIAN, $mes, $anio);
                                for ($i = 1; $i <= $dias_mes; $i++) {
                                    if (date('N', strtotime($anio . '-' . $mes . '-' . $i)) == $numero_dia) {
                                        $count++;
                                        if ($count == 2) {
                                            $segundoJueves = date('Y-m-d', strtotime($anio . '-' . $mes . '-' . $i));
                                            break;
                                        }
                                    }
                                }

                                $fechaInicial = date("Y-m-01");
                                $fechaInicial = date("Y-m-01", strtotime($fechaInicial.'+ 1 month'));
                                $forecastMensualDao = new ForecastMensualDao();
                                $hay = $forecastMensualDao->obtenerForecastMensual($fechaInicial, $fechaInicial, Sesion::obtener('idUsuario'));

                                $serviciosSospechosoDao = new ServiciosSospechosoDao();
                                $this->_datos['totalAcumulado'] = $totalLitrosSucursal;
                                $this->_datos['limiteSucursal'] = $limiteSucursal;
                                $this->_vista = 'forecastAnualProspectos';
                                $this->existeVista();
                                $this->_datos['accion'] = 'entregas';
                                $this->_datos['cliente'] = $datosCliente;
                                $this->_datos['productos'] = $iteradorProductos;
                                $this->_datos['consumo'] = $datosProspecto->Consumo;
                                $this->_datos['sector'] = $datosProspecto->Tipo;
                                $this->_datos['prospecto'] = $datosProspecto;
                                $this->_datos['forecast'] = $datosForecast;
                                $this->_datos['segundoJueves'] = $segundoJueves;
                                $this->_datos['hayForecastMensual'] = $hay['total'];
                                $this->_datos['servicios'] = $serviciosSospechosoDao->obtenerServicios($idCliente)['servicios'] ;
                                $this->cargarVista();
                            }
                        } else {
                            ErrorController::mostrarError(1, 'Por favor actualiza el consumo del prospecto.');
                        }
                    } else {
                        ErrorController::mostrarError(1, $prospecto['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $productos['error']);
                }
            } else {
                ErrorController::mostrarError(1, $cliente['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reportes() {
        $this->_tarea = 41;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }


            $sub = $t->obtenerSubtareasUsuario($this->_tarea, Sesion::obtener('idUsuario'));
            if ($sub['status']) {
                $subtareas = $sub['subtareas'];
                $arraySubtareas = new ArrayObject($subtareas);
                $iteradorSubtareas = $arraySubtareas->getIterator();
                $this->_vista = 'reportes';
                $this->existeVista();
                $this->_datos['accion'] = 'entregas';
                $this->_datos['subtareas'] = $iteradorSubtareas;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteForecastAnual() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';


        $this->_vista = 'reporteForecastAnual';
        $this->existeVista();
        $this->_datos['accion'] = 'reportes';

        $this->cargarVista();
    }

    public function generaReporteForecastAnual() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';

        $fecha = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);

        //obtenemos el forecast
        $f = new ForecastAnualDao();
        $for = $f->hayForecast($fecha, Sesion::obtener('idSucursal'));
        if ($for['status']) {
            if ($for['total'] > 0) {
                $datosForecast = $for['forecast'];
                $f = new FamiliasDao();
                $familias = $f->obtenerListaSubFamilias();
                if ($familias['status']) {
                    $arrayFamilias = new ArrayObject($familias['subfamilias']);
                    $iteradorFamilias = $arrayFamilias->getIterator();
                    $this->_vista = 'generaReporteForecastAnual';
                    $this->existeVista();
                    $this->_datos['accion'] = 'reportes';
                    $this->_datos['familias'] = $iteradorFamilias;
                    $this->_datos['forecast'] = $datosForecast;
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $familias['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos para el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $for['error']);
        }
    }

    public function reporteForecastAnualSucursal() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

        $s = new SucursalDao();
        $sucursales = $s->obtenerListaSucursales();
        if ($sucursales['status']) {
            $arraySucursales = new ArrayObject($sucursales['sucursales']);
            $iteradorSucursales = $arraySucursales->getIterator();
            $this->_vista = 'reporteForecastAnualSucursal';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->_datos['sucursales'] = $iteradorSucursales;
            $this->cargarVista();
        } else {
            ErrorController::error(1, $sucursales['error']);
        }
    }

    public function generaReporteForecastAnualSucursal() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';


        $idSucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);
        //obtenemos el forecast
        $fo = new ForecastAnualDao();
        $fore = $fo->hayForecast($year, $idSucursal);
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $f = new FamiliasDao();
                $familias = $f->obtenerListaSubFamilias();
                if ($familias['status']) {
                    $arrayFamilias = new ArrayObject($familias['subfamilias']);
                    $iteradorFamilias = $arrayFamilias->getIterator();
                    $this->_vista = 'generaReporteForecastAnualSucursal';
                    $this->existeVista();
                    $this->_datos['accion'] = 'reportes';
                    $this->_datos['familias'] = $iteradorFamilias;
                    $this->_datos['sucursal'] = $idSucursal;
                    $this->_datos['forecast'] = $fore['forecast'];
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $familias['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos en el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }

    public function reporteForecastAnualSectores() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorDao.php';

        $p = new ProveedorDao();
        $proveedores = $p->listaProveedoresMateriaPrima();
        if ($proveedores['status']) {
            $arrayProveedores = new ArrayObject($proveedores['proveedores']);
            $iteradorProveedor = $arrayProveedores->getIterator();
        }



        $this->_vista = 'reporteForecastAnualSectores';
        $this->existeVista();
        $this->_datos['accion'] = 'reportes';
        $this->_datos['proveedores'] = $iteradorProveedor;

        $this->cargarVista();
    }

    public function generaReporteForecastAnualSectores() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR .
                'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR .
                'DetalleForecastAnualDao.php';
        //obtenemos el forecast
        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);
        $idProveedor = filter_input(INPUT_POST, 'idProveedor', FILTER_SANITIZE_NUMBER_INT);

        $f = new ForecastAnualDao();
        $fore = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $s = new SectorDao();
                $sectores = $s->obtenerSectores();
                if ($sectores['status']) {
                    $arraySectores = new ArrayObject($sectores['sectores']);
                    $iteradorSectores = $arraySectores->getIterator();
                    $this->_vista = 'generaReporteForecastAnualSectores';
                    $this->existeVista();
                    $this->_datos['accion'] = 'reportes';
                    $this->_datos['sectores'] = $iteradorSectores;
                    $this->_datos['forecast'] = $fore['forecast'];
                    $this->_datos['idProveedor'] = $idProveedor;

                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $sectores['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos en el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }

    public function reporteFocastAnualSectoresFamilia() {

        $this->_vista = 'reporteFocastAnualSectoresFamilia';
        $this->existeVista();
        $this->_datos['accion'] = 'reportes';
        $this->cargarVista();
    }

    public function generaReporteFocastAnualSectoresFamilia() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);

        $f = new ForecastAnualDao();
        $fc = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fc['total'] > 0) {
            $datosForecast = $fc['forecast'];
            $s = new SectorDao();
            $sectores = $s->obtenerSectores();
            if ($sectores['status']) {
                $arraySectores = new ArrayObject($sectores['sectores']);
                $iteradorSectores = $arraySectores->getIterator();
                $this->_vista = 'generaReporteFocastAnualSectoresFamilia';
                $this->existeVista();
                $this->_datos['accion'] = 'reportes';
                $this->_datos['sectores'] = $iteradorSectores;
                $this->_datos['idForecast'] = $datosForecast->Id_Forecast;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sectores['error']);
            }
        } else {
            ErrorController::mostrarError(1, 'No existen datos para el periodo a consultar');
        }
    }

    public function reporteForecastAnualClientes() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorDao.php';

        $p = new ProveedorDao();
        $proveedores = $p->listaProveedoresMateriaPrima();
        if ($proveedores['status']) {
            $arrayProveedores = new ArrayObject($proveedores['proveedores']);
            $iteradorProveedor = $arrayProveedores->getIterator();
        }

        $u = new UsuarioDao();
        $us = $u->obtenerVendedoresActivos();
        if ($us['status']) {
            $arrayUsuarios = new ArrayObject($us['vendedores']);
            $iteradorVendedores = $arrayUsuarios->getIterator();
            $this->_vista = 'reporteForecastAnualClientes';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->_datos['proveedores'] = $iteradorProveedor;
            $this->_datos['vendedores'] = $iteradorVendedores;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $us['error']);
        }
    }

    public function reporteProyectosAnualClientes() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';

        $u = new UsuarioDao();
        $us = $u->obtenerVendedoresActivos();
        if ($us['status']) {
            $arrayUsuarios = new ArrayObject($us['vendedores']);
            $iteradorVendedores = $arrayUsuarios->getIterator();
            $this->_vista = 'reporteProyectosAnualClientes';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->_datos['vendedores'] = $iteradorVendedores;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $us['error']);
        }
    }

    public function reporteProyectosAnualClientesMenor() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';

        $u = new UsuarioDao();
        $us = $u->obtenerVendedoresActivos();
        if ($us['status']) {
            $arrayUsuarios = new ArrayObject($us['vendedores']);
            $iteradorVendedores = $arrayUsuarios->getIterator();
            $this->_vista = 'reporteProyectosAnualClientesMenor';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->_datos['vendedores'] = $iteradorVendedores;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $us['error']);
        }
    }

    public function generaReporteForecastAnualClientes() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';

        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);
        $idProveedor = filter_input(INPUT_POST, 'idProveedor', FILTER_SANITIZE_NUMBER_INT);


        $f = new ForecastAnualDao();
        $fore = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $u = new UsuarioDao();
                if (Sesion::obtener('idRol') == 1) {
                    $us = $f->obtenerVendedoresReporteAnual($year, Sesion::obtener('idSucursal'));
                } elseif (Sesion::obtener('idRol') == 2) {
                    $us = $f->obtenerVendedoresReporteAnual($year, Sesion::obtener('idSucursal'));
                } elseif (Sesion::obtener('idUsuario') == 143) {
                    $us = $f->obtenerVendedoresReporteAnual($year, Sesion::obtener('idSucursal'));
                } else {
                    ErrorController::mostrarError(1, 'Lo siento, no tienes los privilegios suficientes para consultar los datos. ');
                    exit;
                }
                if ($us['status']) {
                    $arrayUsuarios = new ArrayObject($us['vendedores']);
                    $iteradorVendedores = $arrayUsuarios->getIterator();
                    $this->_vista = 'generaReporteForecastAnualClientes';
                    $this->existeVista();
                    $this->_datos['accion'] = 'reportes';
                    $this->_datos['vendedores'] = $iteradorVendedores;
                    $this->_datos['forecast'] = $fore['forecast'];
                    $this->_datos['idProveedor'] = $idProveedor;



                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $us['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos para el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }

    public function generaReporteProyectosAnualClientes() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';

        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);

        $f = new ForecastAnualDao();
        $fore = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $u = new UsuarioDao();
                if (Sesion::obtener('idRol') == 1) {
                    $us = $u->obtenerVendedoresActivosPorSucursal(Sesion::obtener('idSucursal'));
                } elseif (Sesion::obtener('idRol') == 2) {
                    $us = $u->obtenerVendedoresActivosPorSucursal(Sesion::obtener('idSucursal'));
                }

                if ($us['status']) {
                    $arrayUsuarios = new ArrayObject($us['vendedores']);
                    $iteradorVendedores = $arrayUsuarios->getIterator();
                    $this->_vista = 'generaReporteProyectosAnualClientes';
                    $this->existeVista();
                    $this->_datos['accion'] = 'reportes';
                    $this->_datos['vendedores'] = $iteradorVendedores;
                    $this->_datos['forecast'] = $fore['forecast'];
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $us['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos para el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }

    public function generaReporteProyectosAnualClientesMenor() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';

        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);

        $f = new ForecastAnualDao();
        $fore = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $u = new UsuarioDao();
                if (Sesion::obtener('idRol') == 1) {
                    $us = $u->obtenerVendedoresActivosPorSucursal(Sesion::obtener('idSucursal'));
                } elseif (Sesion::obtener('idRol') == 2) {
                    $us = $u->obtenerVendedoresActivosPorSucursal(Sesion::obtener('idSucursal'));
                }

                if ($us['status']) {
                    $arrayUsuarios = new ArrayObject($us['vendedores']);
                    $iteradorVendedores = $arrayUsuarios->getIterator();
                    $this->_vista = 'generaReporteProyectosAnualClientesMenos';
                    $this->existeVista();
                    $this->_datos['accion'] = 'reportes';
                    $this->_datos['vendedores'] = $iteradorVendedores;
                    $this->_datos['forecast'] = $fore['forecast'];
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $us['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos para el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }

    public function generaReporteForecastAnualClientesDirector() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';

        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);

        $f = new ForecastAnualDao();
        $fore = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $u = new UsuarioDao();
                $us = $u->obtenerVendedoresActivos();
                if ($us['status']) {
                    $arrayUsuarios = new ArrayObject($us['vendedores']);
                    $iteradorVendedores = $arrayUsuarios->getIterator();
                    $this->_vista = 'generaReporteForecastAnualClientesDirector';
                    $this->existeVista();
                    $this->_datos['accion'] = 'reportes';
                    $this->_datos['vendedores'] = $iteradorVendedores;
                    $this->_datos['forecast'] = $fore['forecast'];
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $us['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos para el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }

    public function generaReporteForecastAnualClientesExcel() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'PHPExcel.php';

        $u = new UsuarioDao();
        $us = $u->obtenerVendedoresActivos();
        if ($us['status']) {
            $arrayUsuarios = new ArrayObject($us['vendedores']);
            $iteradorVendedores = $arrayUsuarios->getIterator();
            $this->_vista = 'generaReporteForecastAnualClientesExcel';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->_datos['vendedores'] = $iteradorVendedores;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $us['error']);
        }
    }

    public function seguridad() {
        $this->_tarea = 16;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }


            $sub = $t->obtenerSubtareasUsuario($this->_tarea, Sesion::obtener('idUsuario'));
            if ($sub['status']) {
                $subtareas = $sub['subtareas'];
                $arraySubtareas = new ArrayObject($subtareas);
                $iteradorSubtareas = $arraySubtareas->getIterator();
                $this->_vista = 'seguridad';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['subtareas'] = $iteradorSubtareas;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function generaReporteIncidentes() {
        $this->_tarea = 71;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'generaReporteIncidentes';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteIncidentes() {
        $this->_tarea = 71;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'AlertaSeguridadDao.php';

            $fechaInicial = filter_input(INPUT_POST, 'desde', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'hasta', FILTER_SANITIZE_STRING);

            $fechaInicial = $fechaInicial . ' 00:00:00';
            $fechaFinal = $fechaFinal . ' 23:59:59';

            $as = new AlertaSeguridadDao();

            $incidentes = $as->reporteIncidentes(Sesion::obtener('idSucursal'), $fechaInicial, $fechaFinal);
            if ($incidentes['status']) {
                $arrayIncidentes = new ArrayObject($incidentes['incidentes']);
                $iteradorIncidentes = $arrayIncidentes->getIterator();

                $this->_vista = 'reporteIncidentes';
                $this->existeVista();
                $this->_datos['accion'] = 'reportes';
                $this->_datos['incidentes'] = $iteradorIncidentes;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $incidentes['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function generaReporteRecorridosLPA() {
        $this->_tarea = 71;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'generaReporteRecorridosLPA';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteRecorridosLPA() {
        $this->_tarea = 71;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'LPADao.php';

            $fechaInicio = filter_input(INPUT_POST, 'desde', FILTER_SANITIZE_STRING);
            $fechaFin = filter_input(INPUT_POST, 'hasta', FILTER_SANITIZE_STRING);

            $u = new UsuarioDao();

            $usuarios = $u->obtenerUsuariosActivos(Sesion::obtener('idSucursal'));

            $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
            $iteradorUsuarios = $arrayUsuarios->getIterator();

            $this->_vista = 'reporteRecorridosLPA';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->_datos['usuarios'] = $iteradorUsuarios;
            $this->_datos['fechaInicio'] = $fechaInicio;
            $this->_datos['fechaFin'] = $fechaFin;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteCalidad() {
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'reporteCalidad';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteCalidadDao() {
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'AlertaCalidadDao.php';

            $fechaInicial = filter_input(INPUT_POST, 'desde', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'hasta', FILTER_SANITIZE_STRING);

            $fechaInicial = $fechaInicial . ' 00:00:00';
            $fechaFinal = $fechaFinal . ' 23:59:59';

            $ac = new AlertaCalidadDao();

            $alertas = $ac->reporteCalidadDao(Sesion::obtener('idSucursal'), $fechaInicial, $fechaFinal);
            if ($alertas['status']) {
                $arrayIncidentes = new ArrayObject($alertas['alertas']);
                $iteradorIncidentes = $arrayIncidentes->getIterator();
                echo json_encode(array('count' => $arrayIncidentes->count(), 'items' => $iteradorIncidentes));
            } else {
                ErrorController::mostrarError(1, $alertas['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function alertaSeguridad() {
        $this->_tarea = 30;
        $t = new TareasDao();
        //$perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AlertaSeguridadDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            $s = new SucursalDao();
            $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
            $meses = array("", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
            $fecha = date("d") . '-' . $meses[date("n")] . '-' . date("Y");
            $as = new AlertaSeguridadDao();
            $folio = $as->getSigFolioDao()['folio'];

            $u = new UsuarioDao();
            $usuarios = $u->obtenerUsuariosActivos(Sesion::obtener('idSucursal'));
            if ($usuarios['status']) {
                $arrUsers = new ArrayObject($usuarios['usuarios']);
                $itUsers = $arrUsers->getIterator();

                $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));

                $this->_vista = 'alertaSeguridad';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['sucursal'] = $suc->Nombre;
                $this->_datos['fecha'] = $fecha;
                $this->_datos['folio'] = $folio;
                $this->_datos['usuarios'] = $itUsers;
                $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

   public function guardaAlertaSeg() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AlertaSeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

        $folio = filter_input(INPUT_POST, 'folio', FILTER_SANITIZE_STRING);
        $razon = filter_input(INPUT_POST, 'razon', FILTER_SANITIZE_STRING);
        $que = filter_input(INPUT_POST, 'que', FILTER_SANITIZE_STRING);
        $equipo = filter_input(INPUT_POST, 'equipo', FILTER_SANITIZE_STRING);
        $capacitacion = filter_input(INPUT_POST, 'capacitacion', FILTER_SANITIZE_STRING);
        $humano = filter_input(INPUT_POST, 'humano', FILTER_SANITIZE_STRING);
        $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        $responsable = filter_input(INPUT_POST, 'responsable', FILTER_SANITIZE_NUMBER_INT);
        $faccion = filter_input(INPUT_POST, 'faccion', FILTER_SANITIZE_STRING);
        $fprep = filter_input(INPUT_POST, 'fprep', FILTER_SANITIZE_STRING);
        $frepor = filter_input(INPUT_POST, 'frepor', FILTER_SANITIZE_STRING);
        $riesgoPsicologico = filter_input(INPUT_POST, 'riesgoPsicologico', FILTER_SANITIZE_STRING);

        $a = new Alerta();
        $a->__set('_folio', trim($folio));
        $a->__set('_idSucursal', Sesion::obtener('idSucursal'));
        $a->__set('_razon', trim($razon));
        $a->__set('_que', trim($que));
        $a->__set('_fallaEquipo', trim($equipo));
        $a->__set('_fallaConocimiento', trim($capacitacion));
        $a->__set('_fallaHumana', trim($humano));
        $a->__set('_accion', trim($accion));
        $a->__set('_idResponsable', $responsable);
        $a->__set('_fechaAccion', trim($faccion));
        $a->__set('_fechaPreparo', trim($fprep));
        $a->__set('_fechaReporte', trim($frepor));
        $a->__set('_idUsuarioPreparado', Sesion::obtener('idUsuario'));

        if($riesgoPsicologico == 'Si'){
            $tareaNoConformidad = $this->guardarTareaNoConformidad($que, $accion, 'alertaSeguridad');
            $a->__set('_idTareaSeguridad',$tareaNoConformidad['idTareaSeguridad']);
        }

        $ale = new AlertaSeguridadDao();

        $u = new UsuarioDao();
        $user = $u->obtenerUsuario($responsable);
        $quien = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno;

        $foto = '';
        if (isset($_FILES['foto']['name'])) {
            $ruta = BASEPATH . 'application/balance/fotos/';
            $ext = substr($_FILES['foto']['type'], 6);
            if ($ext == 'jpeg')
                $ext = 'jpg';
            $foto = $folio . '.' . $ext;

            move_uploaded_file($_FILES['foto']['tmp_name'], $ruta . $foto);
        }

        $alerta = $ale->guardaAlertaSegDAO($a, $quien, $foto);

        if ($alerta['status']) {
            $response['status'] = true;
            $response['mensaje'] = 'Se guardo correctamente la alerta ' . $folio;

            $comm = new Comentarios();
            $comm->__set('_quien', $quien);
            $comm->__set('_cuando', $faccion);
            $comm->__set('_comentarios', $accion);
            $comm->__set('_idSospechoso', $alerta['idAlerta']);
            $comm->__set('_tipo', 'alertas');
            $comm->__set('_status', 0);
            $comm->__set('_progreso', '0');
            $comm->__set('_avance', '');
            $comm->__set('_idSucursalComentario', Sesion::obtener('idSucursal'));
            $c = new ComentariosDao();
            $c->guardarActividades($comm);

            if ($razon == 'Accidente' && $riesgoPsicologico != 'Si') {
                $s = new SucursalDao();
                $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
                $subject = 'Alerta de Seguridad';
                $body = '<strong>Fecha: </strong>' . date('d/m/Y H:i:s') . '<br>';
                $body .= '<strong>Sucursal: </strong>' . $suc->Nombre . '<br>';
                $body .= '<strong>Problema reportado: </strong>' . $que . '<br>';
                $body .= '<strong>Por qu&eacute; pas&oacute;: </strong> <em>Falla de Equipo: </em>' . $equipo . ' <em>Falla de Conocimiento: </em>' . $capacitacion . ' <em>Falla Humana: </em>' . $humano . '<br>';
                $body .= '<strong>Acciones a implementar: </strong>' . $accion . '<br><br><br>';
                $body .= '<small>No responda este correo, fue generado automaticamente.</small>';
                $attachmentRoot = $ruta . $foto;
                $attachment['file'][] = $attachmentRoot;
                $attachment['name'][] = $foto;
                $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                $datos = array("contenido" => $body);
                $opciones = array(
                    'http' => array(
                        'method' => 'POST',
                        'header' => 'Content-type: application/x-www-form-urlencoded',
                        'content' => http_build_query($datos)
                    )
                );
                $contexto = stream_context_create($opciones);
                $contenidoEmail = file_get_contents($url, false, $contexto);
                $usuarios = $u->obtenerTodosUsuariosActivos();
                foreach ($usuarios['usuarios'] as $usuario) {
                    Email::enviarEmail($usuario->Mail, '', $subject, $body, $attachment);
                }

                Email::enviarEmail('sistemas@merdizshell.com', '', $subject, $contenidoEmail, $attachment);
            }

            // Email responsable

            $subject2 = 'Nuevas Actividades';
            $body2 = 'Se te notifica que tienes esta actividad pendiente por realizar: ' . $accion;
            $body2 .= ' derivada de Alerta de Seguridad<br><br><br>';
            $body2 .= '<small>No responda este correo, fue generado automaticamente.</small>';
            $url2 = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            $datos2 = array("contenido" => $body2);
            $opciones2 = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos2)
                )
            );
            $contexto2 = stream_context_create($opciones2);
            $contenidoEmail2 = file_get_contents($url2, false, $contexto2);
            Email::enviarEmail($user['usuarios']->Mail, '', $subject, $contenidoEmail2, $attachment);
        }

        echo json_encode($response);
    }

    public function cumplimiento5s() {
        $this->_tarea = 31;
        $t = new TareasDao();
        //$perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LPADao.php';

            $s = new SucursalDao();
            $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
            $dia = date("N");
            $u = new UsuarioDao();
            $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
            if ($user['status']) {
                $lpa = new LPADao();
                $preg = $lpa->getPreguntas($dia);
                $dia = date("N");
                switch ($dia) {
                    case 1:
                        $vista = 'cumplimiento5sLunes';
                        break;
                    case 2:
                        $vista = 'cumplimiento5sMartes';
                        break;
                    case 3:
                        $vista = 'cumplimiento5sMiercoles';
                        break;
                    case 4:
                        $vista = 'cumplimiento5sJueves';
                        break;
                    case 5:
                        $vista = 'cumplimiento5sViernes';
                        break;
                    case 6:
                        $vista = 'cumplimiento5sSabado';
                        break;
                    default:
                        $vista = 'cumplimiento5s';
                        break;
                }
                $this->_vista = $vista;

                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['sucursal'] = $suc->Nombre;
                $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
                $this->_datos['preguntas'] = $preg['preguntas'];
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function guardaCincoS() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LPADao.php';

        $nivel = filter_input(INPUT_POST, 'nivel', FILTER_SANITIZE_STRING);
        $arrPreg = array();

        $lpa = new LPADao();
        $pregs = $lpa->getPreguntas();

        foreach ($pregs['preguntas'] as $preg) {
            $num = $preg->Id_Cinco_S_Preguntas;
            if(isset($_POST['preg-'.$num])){
                $arrPreg[] = array(
                    'calif' => filter_input(INPUT_POST, 'preg-' . $num, FILTER_SANITIZE_STRING),
                    'comm' => filter_input(INPUT_POST, 'comm-' . $num, FILTER_SANITIZE_STRING),
                    '5s' => isset($_POST['preg5s-'.$num]) ? filter_input(INPUT_POST, 'preg5s-' . $num, FILTER_SANITIZE_NUMBER_INT) : 0,
                    'preg' => $preg->Pregunta);
            }
        }

        $cincos = $lpa->guardaCincoSDAO(Sesion::obtener('idSucursal'), Sesion::obtener('idUsuario'), $arrPreg, $nivel);

        if ($cincos['status']) {
            $response['status'] = true;
            $response['mensaje'] = 'Se guardo correctamente la encuesta';
        }

        echo json_encode($response);
    }

    public function alertaCalidad() {
        $this->_tarea = 34;
        $t = new TareasDao();
        //$perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AlertaCalidadDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            $s = new SucursalDao();
            $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
            $meses = array("", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
            $fecha = date("d") . '-' . $meses[date("n")] . '-' . date("Y");
            $ac = new AlertaCalidadDao();
            $folio = $ac->getSigFolioDao()['folio'];

            $u = new UsuarioDao();
            $usuarios = $u->obtenerUsuariosActivos(Sesion::obtener('idSucursal'));
            if ($usuarios['status']) {
                $arrUsers = new ArrayObject($usuarios['usuarios']);
                $itUsers = $arrUsers->getIterator();

                $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));

                $this->_vista = 'alertaCalidad';
                $this->existeVista();
                $this->_datos['accion'] = 'calidad';
                $this->_datos['sucursal'] = $suc->Nombre;
                $this->_datos['fecha'] = $fecha;
                $this->_datos['folio'] = $folio;
                $this->_datos['usuarios'] = $itUsers;
                $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function guardaAlertaCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AlertaCalidadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';

        $folio = filter_input(INPUT_POST, 'folio', FILTER_SANITIZE_STRING);
        $razon = filter_input(INPUT_POST, 'razon', FILTER_SANITIZE_STRING);
        $que = filter_input(INPUT_POST, 'que', FILTER_SANITIZE_STRING);
        $equipo = filter_input(INPUT_POST, 'material', FILTER_SANITIZE_STRING);
        $capacitacion = filter_input(INPUT_POST, 'capacitacion', FILTER_SANITIZE_STRING);
        $humano = filter_input(INPUT_POST, 'humano', FILTER_SANITIZE_STRING);
        $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        $responsable = filter_input(INPUT_POST, 'responsable', FILTER_SANITIZE_NUMBER_INT);
        $faccion = filter_input(INPUT_POST, 'faccion', FILTER_SANITIZE_STRING);
        $fprep = filter_input(INPUT_POST, 'fprep', FILTER_SANITIZE_STRING);
        $frepor = filter_input(INPUT_POST, 'frepor', FILTER_SANITIZE_STRING);

        $a = new Alerta();
        $a->__set('_folio', trim($folio));
        $a->__set('_idSucursal', Sesion::obtener('idSucursal'));
        $a->__set('_razon', trim($razon));
        $a->__set('_que', trim($que));
        $a->__set('_fallaEquipo', trim($equipo));
        $a->__set('_fallaConocimiento', trim($capacitacion));
        $a->__set('_fallaHumana', trim($humano));
        $a->__set('_accion', trim($accion));
        $a->__set('_idResponsable', $responsable);
        $a->__set('_fechaAccion', trim($faccion));
        $a->__set('_fechaPreparo', trim($fprep));
        $a->__set('_fechaReporte', trim($frepor));
        $a->__set('_idUsuarioPreparado', Sesion::obtener('idUsuario'));

        $ale = new AlertaCalidadDao();

        $u = new UsuarioDao();
        $user = $u->obtenerUsuario($responsable);
        $quien = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno;

        $foto = '';
        if (isset($_FILES['foto']['name'])) {
            $ruta = BASEPATH . 'application/balance/fotos/';
            $ext = substr($_FILES['foto']['type'], 6);
            if ($ext == 'jpeg')
                $ext = 'jpg';
            $foto = $folio . '.' . $ext;

            move_uploaded_file($_FILES['foto']['tmp_name'], $ruta . $foto);
        }

        $alerta = $ale->guardaAlertaCalidadDAO($a, $quien, $foto);

        if ($alerta['status']) {
            $response['status'] = true;
            $response['mensaje'] = 'Se guardo correctamente la alerta ' . $folio;

            $comm = new Comentarios();
            $comm->__set('_quien', $quien);
            $comm->__set('_cuando', $faccion);
            $comm->__set('_comentarios', $accion);
            $comm->__set('_idSospechoso', $alerta['idAlerta']);
            $comm->__set('_tipo', 'alertas_calidad');
            $comm->__set('_status', 0);
            $comm->__set('_progreso', '0');
            $comm->__set('_avance', '');
            $comm->__set('_idSucursalComentario', Sesion::obtener('idSucursal'));
            $c = new ComentariosDao();
            $c->guardarActividades($comm);

            $s = new SucursalDao();
            $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
            $subject = 'Alerta de Calidad';
            $body = '<strong>Fecha: </strong>' . date('d/m/Y H:i:s') . '<br>';
            $body .= '<strong>Sucursal: </strong>' . $suc->Nombre . '<br>';
            $body .= '<strong>Problema reportado: </strong>' . $que . '<br>';
            $body .= '<strong>Por qu&eacute; pas&oacute;: </strong> <em>Falla de Material: </em>' . $equipo . ' <em>Falla de Conocimiento: </em>' . $capacitacion . ' <em>Falla Humana: </em>' . $humano . '<br>';
            $body .= '<strong>Acciones a implementar: </strong>' . $accion . '<br><br><br>';
            $body .= '<small>No responda este correo, fue generado automaticamente.</small>';
            $attachmentRoot = $ruta . $foto;
            $attachment['file'][] = $attachmentRoot;
            $attachment['name'][] = $foto;
            $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            $datos = array("contenido" => $body);
            $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );
            $contexto = stream_context_create($opciones);
            $contenidoEmail = file_get_contents($url, false, $contexto);

            $usuarios = $u->obtenerTodosUsuariosActivos();
            foreach ($usuarios['usuarios'] as $usuario) {
                //Email::enviarEmail($usuario->Mail, '', $subject, $contenidoEmail, $attachment, $foto);
            }

            Email::enviarEmail('sistemas@merdizshell.com', '', $subject, $body, $attachment);

            // Email responsable
            $subject = 'Nuevas Actividades';
            $body2 = 'Se te notifica que tienes esta actividad pendiente por realizar: ' . $accion;
            $body2 .= ' derivada de Alerta de Calidad<br><br><br>';
            $body2 .= '<small>No responda este correo, fue generado automaticamente.</small>';
            $url2 = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            $datos2 = array("contenido" => $body2);
            $opciones2 = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos2)
                )
            );
            $contexto2 = stream_context_create($opciones2);
            $contenidoEmail2 = file_get_contents($url2, false, $contexto2);
            Email::enviarEmail($user['usuarios']->Mail, '', $subject, $contenidoEmail2, $attachment);
        }

        echo json_encode($response);
    }

    public function sugerenciaMejora() {
        $this->_tarea = 41;
        $t = new TareasDao();
        //$perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SugerenciaDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            $s = new SucursalDao();
            $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
            $meses = array("", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
            $fecha = date("d") . '-' . $meses[date("n")] . '-' . date("Y");
            $s = new SugerenciaDao();
            $folio = $s->getSigFolioDao()['folio'];

            $u = new UsuarioDao();
            $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
            if ($user['status']) {
                $this->_vista = 'sugerenciaMejora';
                $this->existeVista();
                $this->_datos['accion'] = 'calidad';
                $this->_datos['sucursal'] = $suc->Nombre;
                $this->_datos['fecha'] = $fecha;
                $this->_datos['folio'] = $folio;
                $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

      public function guardaSugerencia() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SugerenciaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'NotificacionesDao.php';

        $folio = filter_input(INPUT_POST, 'folio', FILTER_SANITIZE_STRING);
        $avance = filter_input(INPUT_POST, 'avance', FILTER_SANITIZE_NUMBER_INT);
        if ($avance == '')
            $avance = '0';
        $desc = filter_input(INPUT_POST, 'desc', FILTER_SANITIZE_STRING);
        $nivel = filter_input(INPUT_POST, 'nivel', FILTER_SANITIZE_STRING);
        $causa1 = filter_input(INPUT_POST, 'causa1', FILTER_SANITIZE_STRING);
        $causa2 = filter_input(INPUT_POST, 'causa2', FILTER_SANITIZE_STRING);
        $causa3 = filter_input(INPUT_POST, 'causa3', FILTER_SANITIZE_STRING);
        $causa4 = filter_input(INPUT_POST, 'causa4', FILTER_SANITIZE_STRING);
        $causa5 = filter_input(INPUT_POST, 'causa5', FILTER_SANITIZE_STRING);
        $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        $fecha_comp = filter_input(INPUT_POST, 'fecha_comp', FILTER_SANITIZE_STRING);
        $esperado = filter_input(INPUT_POST, 'esperado', FILTER_SANITIZE_STRING);
        $real = filter_input(INPUT_POST, 'real', FILTER_SANITIZE_STRING);
        $riesgoPsicologico = filter_input(INPUT_POST, 'riesgoPsicologico', FILTER_SANITIZE_STRING);



        $s = new Sugerencia();
        $s->__set('_folio', trim($folio));
        $s->__set('_idSucursal', Sesion::obtener('idSucursal'));
        $s->__set('_idUsuario', Sesion::obtener('idUsuario'));
        $s->__set('_descripcion', trim($desc));
        $s->__set('_nivel', trim($nivel));
        $s->__set('_causa1', trim($causa1));
        $s->__set('_causa2', trim($causa2));
        $s->__set('_causa3', trim($causa3));
        $s->__set('_causa4', trim($causa4));
        $s->__set('_causa5', trim($causa5));
        $s->__set('_accion', trim($accion));
        $s->__set('_idResponsable', Sesion::obtener('idUsuario'));
        $s->__set('_fechaAccion', trim($fecha_comp));
        $s->__set('_resultadoEsperado', trim($esperado));
        $s->__set('_resultadoReal', trim($real));
        $s->__set('_avance', trim($avance));
        if($riesgoPsicologico == 'Si'){
            $tareaNoConformidad = $this->guardarTareaNoConformidad($desc, $accion, 'sugerencia');
            $s->__set('_idTareaSeguridad',$tareaNoConformidad['idTareaSeguridad']);
        }


        $sug = new SugerenciaDao();

        $u = new UsuarioDao();
        $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
        $usuario = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno;

        $sugerencia = $sug->guardaSugerenciaDAO($s, $usuario);

        if ($sugerencia['status']) {
            $response['status'] = true;
            $response['mensaje'] = 'Se guardo correctamente la sugerencia ' . $folio;

            $comm = new Comentarios();
            $comm->__set('_quien', $usuario);
            $comm->__set('_cuando', $fecha_comp);
            $comm->__set('_comentarios', $accion);
            $comm->__set('_idSospechoso', $sugerencia['idSugerencia']);
            $comm->__set('_tipo', 'sugerencias');
            $comm->__set('_status', 0);
            $comm->__set('_progreso', '0');
            $comm->__set('_avance', '');
            $comm->__set('_idSucursalComentario', Sesion::obtener('idSucursal'));
            $c = new ComentariosDao();
            $comentres = $c->guardarActividades($comm);

            $response['comm'] = $comentres;

            // Email responsable
            $subject = 'Nuevas Actividades';
            $body = 'Se te notifica que tienes esta actividad pendiente por realizar: ' . $accion;
            $body .= ' derivada de una Sugerencia<br><br><br>';
            $body .= '<small>No responda este correo, fue generado automaticamente.</small>';
            $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            $datos = array("contenido" => $body);
            $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );
            $contexto = stream_context_create($opciones);
            $contenidoEmail = file_get_contents($url, false, $contexto);
            Email::enviarEmail($user['usuarios']->Mail, '', $subject, $contenidoEmail);
            //generamos la notificación
            $n = new Notificaciones();
            $n->__set('_asunto', $subject);
            $n->__set('_descripcion', 'Se te notifica que tienes esta actividad pendiente por realizar ' . $accion . ' derivada de una sugerencia.');
            $n->__set('_fecha', date("Y-m-d"));
            $n->__set('_hora', date("H:i:s"));
            $n->__set('_url', 'inicio/avanceActividades/');
            $n->__set('_status', 1);
            $n->__set('_idUsuario', $user['usuarios']->Id_Usuario);
            $n->__set('_idSolicita', Sesion::obtener('idUsuario'));

            $not = new NotificacionesDao();
            $not->crearNotificacion($n);
        }

        echo json_encode($response);
    }

    public function reporteSugerencias() {
        $this->_tarea = 84;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'reporteSugerencias';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteSugerenciasDao() {
        $this->_tarea = 84;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'SugerenciaDao.php';

            $fechaInicial = filter_input(INPUT_POST, 'desde', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'hasta', FILTER_SANITIZE_STRING);

            $fechaInicial = $fechaInicial . ' 00:00:00';
            $fechaFinal = $fechaFinal . ' 23:59:59';

            $u = new UsuarioDao();
            $tot = 0;
            $usuarios = $u->obtenerUsuariosActivos(Sesion::obtener('idSucursal'));
            if ($usuarios['status']) {

                foreach ($usuarios['usuarios'] as $usuario) {
                    $idUsuario = $usuario->Id_Usuario;
                    $s = new SugerenciaDao();
                    $sug = $s->obtenerSugerenciasPorUsuario($idUsuario, $fechaInicial, $fechaFinal)['sugerencias'];
                    $arraySugerencia = new ArrayObject($sug);
                    $iteradorSugerencias = $arraySugerencia->getIterator();

                    $usuario->sug = $iteradorSugerencias;

                    $tot += $arraySugerencia->count();
                }

                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                echo json_encode(array('count' => $tot, 'items' => $iteradorUsuarios));
            } else {
                ErrorController::mostrarError(1, $alertas['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function consumoPromedioMensualCliente($idCliente, $idProducto, $fechaInicial, $fechaFinal) {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';

        $d = new DocumentoDao();
        $prom = $d->consumoPromedioCliente($idCliente, $idProducto, $fechaInicial, $fechaFinal);
        if ($prom['status']) {
            $arrayProm = new ArrayObject($prom['facturas']);
            $iteradorFacturas = $arrayProm->getIterator();
            $total = 0;
            while ($iteradorFacturas->valid()) {
                $total += $iteradorFacturas->current()->Cantidad;
                $iteradorFacturas->next();
            }

            $promedio = $total / 12;
        } else {
            $promedio = 0;
        }

        return round($promedio, 2);
    }

    public function consumoMensualCliente($idCliente, $idProducto, $fechaInicial, $fechaFinal) {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        $d = new DocumentoDao();
        $prom = $d->consumoPromedioCliente($idCliente, $idProducto, $fechaInicial, $fechaFinal);
        if ($prom['status']) {
            $arrayProm = new ArrayObject($prom['facturas']);
            $iteradorFacturas = $arrayProm->getIterator();
            $total = 0;
            while ($iteradorFacturas->valid()) {
                if ($iteradorFacturas->current()->Id_Cancelacion == 0) {
                    $total += $iteradorFacturas->current()->Cantidad;
                }
                $iteradorFacturas->next();
            }

            $promedio = $total;
        } else {
            $promedio = 0;
        }

        return round($promedio);
    }

    public function reporteForecastMensual() {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorDao.php';

        $p = new ProveedorDao();
        $proveedores = $p->listaProveedoresMateriaPrima();
        if ($proveedores['status']) {
            $arrayProveedores = new ArrayObject($proveedores['proveedores']);
            $iteradorProveedor = $arrayProveedores->getIterator();

            $anioActual = date('Y');
            for($i = 2017; $i <= $anioActual; $i++){
                $arrayAnios[] = $i;
            }
        }

        $this->_vista = 'reporteForecastMensual';
        $this->_datos['accion'] = 'reportes';
        $this->_datos['proveedores'] = $iteradorProveedor;
        $this->_datos['anios'] = $arrayAnios;
        $this->existeVista();
        $this->cargarVista();
    }

    public function generaReporteForecastMensual() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';

        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);
        $mes = filter_input(INPUT_POST, 'mes', FILTER_SANITIZE_NUMBER_INT);
        $idProveedor = filter_input(INPUT_POST, 'idProveedor', FILTER_SANITIZE_NUMBER_INT);


        $fechaInicial = $year . '-' . $mes . '-01 00:00:00';
        $fechaFinal = $year . '-' . $mes . '-31 23:59:59';
        $u = new UsuarioDao();

        $usuarios = $u->obtenerVendedoresForecastActivosPorSucursal(Sesion::obtener('idSucursal'),  $year . '-' . $mes . '-01');
        $arrayUsuarios = new ArrayObject($usuarios['vendedores']);
        $iteradorUsuarios = $arrayUsuarios->getIterator();

        $meses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
        $nombreMesFirme = $meses[intval($mes) - 1];

        $this->_vista = 'generaReporteForecastMensual';
        $this->existeVista();
        $this->_datos['accion'] = 'reportes';
        $this->_datos['vendedores'] = $iteradorUsuarios;
        $this->_datos['mesFirme'] = $nombreMesFirme;
        $this->_datos['mes'] = intval($mes);
        $this->_datos['year'] = intval($year);
        $this->_datos['fechaInicial'] = $fechaInicial;
        $this->_datos['fechaFinal'] = $fechaFinal;
        $this->_datos['idProveedor'] = $idProveedor;
        $this->cargarVista();
    }

   public function forecastMensualProspecto() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';

        $idProspecto = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
        $s = new SospechosoDao();
        $sospechoso = $s->obtenerSospechoso($idProspecto);
        if ($sospechoso['status']) {
            $datosSospechoso = $sospechoso['sospechoso'];
            $p = new ProductoProspectoDao();
            $productos = $p->obtenerProductosProspecto($idProspecto);
            if ($productos['status']) {
                $arrayProductos = new ArrayObject($productos['productos']);
                $iteradorProductos = $arrayProductos->getIterator();
                if ($iteradorProductos->count() > 0) {
                    $mesFirme = strtotime('+1 month', strtotime("m"));
                    $mesFirme = (int) date("m", $mesFirme);
                    $meses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
                    $nombreMesFirme = $meses[$mesFirme - 1];
                    $mes1 = $mesFirme + 1;
                    if ($mes1 > 12) {
                        $mes1 = 12;
                    }
                    $mes2 = $mes1 + 1;
                    if ($mes2 > 12) {
                        $mes2 = 1;
                    }

                    $nombreMes1 = $meses[$mes1 - 1];
                    $nombreMes2 = $meses[$mes2 - 1];

                    $mesActual = (int) date("m");
                    $nombreMesActual = $meses[$mesActual - 1];

                    $fechaInicial = date("Y-m-01");
                    $fechaInicial = date("Y-m-01", strtotime($fechaInicial.'+ 1 month'));
                    $forecastMensualDao = new ForecastMensualDao();
                    $hay = $forecastMensualDao->obtenerForecastMensual($fechaInicial, $fechaInicial, Sesion::obtener('idUsuario'));

                    $this->_vista = 'forecastMensualProspecto';
                    $this->existeVista();
                    $this->_datos['accion'] = 'entregas';
                    $this->_datos['sospechoso'] = $datosSospechoso;
                    $this->_datos['productos'] = $iteradorProductos;
                    $this->_datos['mesFirme'] = $nombreMesFirme;
                    $this->_datos['mes1'] = $nombreMes1;
                    $this->_datos['mes2'] = $nombreMes2;
                    $this->_datos['mesActual'] = $nombreMesActual;
                    $this->_datos['hayForecastMensual'] = $hay['total'];
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, 'El prospecto no cuenta con productos agregados. Por favor agrega al menos un producto.');
                }
            } else {
                ErrorController::mostrarError(1, $productos['error']);
            }
        } else {
            ErrorController::mostrarError(1, $sospechoso['error']);
        }
    }

    public function minutaDiaria() {
        $this->_tarea = 40;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'MinutaDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'PlaticasUsuarioDao.php';

            $fechaInicio = date("Y-m-d") . ' 00:00:00';
            $fechaFin = date("Y-m-d") . ' 23:59:59';

            $m = new MinutaDao();
            $valida = $m->validaMunutaDiaria($fechaInicio, $fechaFin, Sesion::obtener('idSucursal'));
            if ($valida['valida'] == 0) {
                $s = new SucursalDao();
                $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
                $meses = array("", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
                $fecha = date("d") . '-' . $meses[date("n")] . '-' . date("Y");

                $u = new UsuarioDao();
                $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));

                $a = new AsistenciaDao();
                $asistentes = $a->getAsistentes(date('Y-m-d'), Sesion::obtener('idSucursal'));
                $pla = new PlaticasUsuarioDao();
                $platica = $pla->obtenerPlaticaSeguridadSucursal(date("Y-m-d"), Sesion::obtener('idSucursal'));

                if ($platica['status']){
                    $datosPlatica = $platica['platica'];
                    if ($datosPlatica->Id_Usuario == Sesion::obtener('idUsuario')){
                        $this->_vista = 'minutaDiaria';
                        $this->existeVista();
                        $this->_datos['accion'] = 'calidad';
                        $this->_datos['sucursal'] = $suc->Nombre;
                        $this->_datos['fecha'] = $fecha;
                        $this->_datos['asistentes'] = $asistentes['asistentes'];
                        $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
                        $this->_datos['platica'] = $datosPlatica;
                        $this->cargarVista();
                    }
                    else{
                        ErrorController::mostrarError(1, 'Lo siento, la junta debe subirse por el usuario asignado');
                    }
                }
                else{
                    ErrorController::mostrarError(1, $platica['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'Ya ha sido capturada la junta del día de hoy.');
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function checarEntrada() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';
        $arr = json_decode($_POST['asistentes']);

        $a = new AsistenciaDao();
        $asistentes = $a->getAsistentes(date('Y-m-d'), Sesion::obtener('idSucursal'));

        $checked = json_decode($_POST['asistentes']);

        $fecha = date('Y-m-d') . ' 00:00:00';

        if ($asistentes['status']) {
            foreach ($asistentes['asistentes'] as $asist) {
                if (!in_array($asist->Id_Usuario, $checked)) {
                    $a->updateAsistencia($asist->Id_Usuario, 3, $fecha, Sesion::obtener('idSucursal'));
                }
            }
            $response['status'] = true;
            $response['mensaje'] = 'Se checo la entrada correctamente';
        } else {
            $response['status'] = false;
            $response['mensaje'] = 'No se pudo checar la entrada';
        }

        echo json_encode($response);
    }

    public function guardaMinuta() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'MinutaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AgendaDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'NotificacionesDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'PlaticasUsuarioDao.php';


        $tema = filter_input(INPUT_POST, 'radio-tema', FILTER_SANITIZE_STRING);

        $p = new PlaticasUsuarioDao();
        $platica = $p->obtenerPlaticaSeguridad($tema)['platica'];


        $comp = filter_input(INPUT_POST, 'comp', FILTER_SANITIZE_STRING);
        $sug = filter_input(INPUT_POST, 'sug', FILTER_SANITIZE_STRING);
        $fecha = date('Y-m-d H:i:s');

        $m = new Minuta();
        $m->__set('_idSucursal', Sesion::obtener('idSucursal'));
        $m->__set('_idUsuario', Sesion::obtener('idUsuario'));
        $m->__set('_tema', trim($tema));
        $m->__set('_compromiso', trim($comp));
        $m->__set('_sugerencia', trim($sug));
        $m->__set('_fecha', $fecha);

        $min = new MinutaDao();

        $u = new UsuarioDao();
        $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
        $usuario = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno;

        $minuta = $min->guardaMinuta($m);

        if ($minuta['status']) {
            if (isset($_FILES['documentoJunta']['name'])){
                $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'documentosJunta' . DIRECTORY_SEPARATOR;
                $nombre = date("Y-m-d") . '-' . Sesion::obtener('idSucursal');
                $array = explode('.', $_FILES['documentoJunta']['name']);
                foreach ($array as $iterador) {
                    $extencion = $iterador;
                }
                move_uploaded_file($_FILES['documentoJunta']['tmp_name'], $ruta . $nombre.".".$extencion);
            }
            $response['status'] = true;
            $response['mensaje'] = 'Se guardo correctamente la minuta.';

            $s = new SucursalDao();
            $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];

            $agenda = new AgendaDao();

            // Asistentes
            $a = new AsistenciaDao();
            $asistentes = $a->getAsistentes(date('Y-m-d'), Sesion::obtener('idSucursal'));
            $nomAsistentes = '';
            foreach ($asistentes['asistentes'] as $asist) {
                if ($asist->Hora_Entrada != '00:00:00') {
                    $agenda->actualizarActividad($fecha, $asist->Id_Usuario, 1);
                    if ($asist->Id_Usuario != 91):
                        $userinfo = $u->obtenerUsuario($asist->Id_Usuario);
                        $nomAsistentes .= ' ' . $userinfo['usuarios']->Nombre . ' ' . $userinfo['usuarios']->Apellido_Paterno . ' ' . $userinfo['usuarios']->Apellido_Materno;
                    endif;
                }
            }

            // Guarda comentario
            $comm = new Comentarios();
            $comm->__set('_quien', $usuario);
            $comm->__set('_cuando', $fecha);
            $comm->__set('_comentarios', 'Compromiso: ' . $comp . ' Sugerencia: ' . $sug);
            $comm->__set('_idSospechoso', $minuta['idMinuta']);
            $comm->__set('_tipo', 'minuta');
            $comm->__set('_status', 0);
            $comm->__set('_progreso', '0');
            $comm->__set('_avance', '');
            $comm->__set('_idSucursalComentario', Sesion::obtener('idSucursal'));
            $c = new ComentariosDao();
            $comentres = $c->guardarActividades($comm);
            $response['comm'] = $comentres;

            // Enviar Email
            $subject = 'Junta Diaria ' . $suc->Nombre;
            $body = 'Fecha: ' . $fecha;
            $body .= '<br>Sucursal: ' . $suc->Nombre;
            $body .= '<br>Usuario que elabora: ' . $usuario;
            $body .= '<br>Tema: ' . $platica->Tema;
            $body .= '<br>Compromisos: ' . $comp;
            $body .= '<br>Sugerencias: ' . $sug;
            $body .= '<br>Asistentes: ' . $nomAsistentes;
            $body .= '<br><br><br><small>No responda este correo, fue generado automaticamente.</small>';
            $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            $datos = array("contenido" => $body);
            $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );
            $contexto = stream_context_create($opciones);
            $contenidoEmail = file_get_contents($url, false, $contexto);
            /* Email::enviarEmail('arturo.mercado@merdizshell.com', '', $subject, $contenidoEmail);
              Email::enviarEmail('porfirio.mercado@merdizshell.com', '', $subject, $contenidoEmail); */
            Email::enviarEmail('sistemas@merdizshell.com', '', $subject, $contenidoEmail);
        }else {
            $response['status'] = false;
            $response['mensaje'] = $minuta['error'];
        }

        echo json_encode($response);
    }

    public function mantenimientoPreventivo() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'mantenimientoPreventivo';
            $this->existeVista();
            $this->_datos['accion'] = 'seguridad';
            $this->_datos['rol'] = Sesion::obtener('idRol');
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function altaVehiculo() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            $s = new SucursalDao();
            $usuarioDao = new UsuarioDao();

            $suc = $s->obtenerListaSucursales();
            if ($suc['status']) {

                $usuarios =  $usuarioDao->obtenerUsuariosActivosConLicencia(date("Y-m-d"))['usuarios'];

                $this->_vista = 'vehiculos';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['sucursal'] = Sesion::obtener('idSucursal');
                $this->_datos['sucursales'] = $suc['sucursales'];
                $this->_datos['usuarios'] =$usuarios;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $suc['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function altaServicio() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'VehiculoDao.php';
            $v = new VehiculoDao();

            $vehi = $v->getVehiculos(Sesion::obtener('idSucursal'), 0, 100);
            if ($vehi['status']) {

                $vehiculos = array();
                foreach ($vehi['vehiculos'] as $vehi) {
                    if ($vehi->Status == 1) {
                        $vehiculos[] = array('id' => $vehi->Id_Vehiculo,
                            'vehiculo' => $vehi->Marca . ' ' . $vehi->Vehiculo . ' - ' . $vehi->Placas);
                    }
                }

                $this->_vista = 'rutinas';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['vehiculos'] = $vehiculos;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $vehi['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function bitacoraRecorrido() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'VehiculoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'BitacoraRecorridoDao.php';
            $v = new VehiculoDao();
            $b = new BitacoraRecorridoDao();

            $vehi = $v->getVehiculos(Sesion::obtener('idSucursal'), 0, 100);
            if ($vehi['status']) {

                $vehiculos = array();
                foreach ($vehi['vehiculos'] as $vehi) {
                    if ($vehi->Status == 1) {
                        $indi = $b->getLastIndicador($vehi->Id_Vehiculo)['indicador'];
                        $indicador = $indi ? $indi->Indicador_Final : 0.00;
                        $vehiculos[] = array('id' => $vehi->Id_Vehiculo,
                            'vehiculo' => $vehi->Marca . ' ' . $vehi->Vehiculo . ' - ' . $vehi->Placas . ' Tanque: ' . $vehi->Tanque . ' Indicador: ' . $indicador);
                    }
                }

                $this->_vista = 'bitacoraRecorrido';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['rol'] = Sesion::obtener('idRol');
                $this->_datos['vehiculos'] = $vehiculos;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $vehi['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteConsumo() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status'] && Sesion::obtener('idRol') <= 3) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'reporteConsumo';
            $this->existeVista();
            $this->_datos['accion'] = 'seguridad';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function getReporteConsumo() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status'] && Sesion::obtener('idRol') <= 3) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'BitacoraRecorridoDao.php';
            $b = new BitacoraRecorridoDao();

            $fechaInicial = filter_input(INPUT_POST, 'desde', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'hasta', FILTER_SANITIZE_STRING);

            $fechaInicial = $fechaInicial . ' 00:00:00';
            $fechaFinal = $fechaFinal . ' 23:59:59';

            $bitacoras = $b->getBitacoraVales(Sesion::obtener('idSucursal'), $fechaInicial, $fechaFinal);
            if ($bitacoras['status']) {

                echo json_encode(array('count' => $bitacoras['total'], 'items' => $bitacoras['bitacoras']));
            } else {
                ErrorController::mostrarError(1, $bitacoras['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteConsumoExcel() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status'] && Sesion::obtener('idRol') <= 3) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'reporteConsumoExcel';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'BitacoraRecorridoDao.php';
            $b = new BitacoraRecorridoDao();

            $fechaInicial = filter_input(INPUT_POST, 'desde', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'hasta', FILTER_SANITIZE_STRING);
            $prov = filter_input(INPUT_POST, 'prov', FILTER_SANITIZE_STRING);
            $fact = filter_input(INPUT_POST, 'fact', FILTER_SANITIZE_STRING);
            $monto = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);

            $bitacoras = $b->getBitacoraVales(Sesion::obtener('idSucursal'), $fechaInicial . ' 00:00:00', $fechaFinal . ' 23:59:59');
            if ($bitacoras['status']) {
                $this->_datos['inicio'] = $fechaInicial;
                $this->_datos['fin'] = $fechaFinal;
                $this->_datos['prov'] = $prov;
                $this->_datos['fact'] = $fact;
                $this->_datos['monto'] = $monto;
                $this->_datos['bitacoras'] = $bitacoras['bitacoras'];
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $bitacoras['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function ordenServicio() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'VehiculoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'BitacoraRecorridoDao.php';
            $v = new VehiculoDao();
            $b = new BitacoraRecorridoDao();

            $vehi = $v->getVehiculos(Sesion::obtener('idSucursal'), 0, 100);
            if ($vehi['status']) {

                $vehiculos = array();
                foreach ($vehi['vehiculos'] as $vehi) {
                    if ($vehi->Status == 1) {
                        $indi = $b->getLastIndicador($vehi->Id_Vehiculo)['indicador'];
                        $kmf = $indi ? $indi->Km_Final : 0;
                        $vehiculos[] = array('id' => $vehi->Id_Vehiculo,
                            'vehiculo' => $vehi->Marca . ' ' . $vehi->Vehiculo . ' Placas: ' . $vehi->Placas . ' Kilometraje: ' . $kmf . ' Kms');
                    }
                }

                $this->_vista = 'ordenServicio';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['rol'] = Sesion::obtener('idRol');
                $this->_datos['vehiculos'] = $vehiculos;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $vehi['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function ordenServicioPdf() {
        $this->_tarea = 32;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            //require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'VehiculoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'BitacoraRecorridoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
            require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdf' . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';
            $c = new ComentariosDao();
            $b = new BitacoraRecorridoDao();
            //$v = new VehiculoDao();

            $comm = (int) filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            $orden = $c->getOrdenServicio($comm);

            if ($orden['status']) {
                $orden = $orden['orden'];
                $indi = $b->getLastIndicador($orden->Id_Vehiculo)['indicador'];
                $kmf = $indi ? $indi->Km_Final : 0;
                $orden->Kilometrajef = $kmf;
                //$vehiculos[] = array('id' => $vehi->Id_Vehiculo,
                //    'vehiculo' => $vehi->Marca.' '.$vehi->Vehiculo.' Placas: '.$vehi->Placas.' Kilometraje: '.$kmf.' Kms');

                $this->_vista = 'ordenServicioPdf';
                $this->existeVista();
                $this->_datos['orden'] = $orden;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $orden['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteSatisfaccion() {
        $this->_tarea = 80;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'reporteSatisfaccion';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function getReporteSatisfaccion() {
        $this->_tarea = 80;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'SatisfaccionClienteDao.php';

            $fechaInicial = filter_input(INPUT_POST, 'desde', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'hasta', FILTER_SANITIZE_STRING);

            $fechaInicial = $fechaInicial . ' 00:00:00';
            $fechaFinal = $fechaFinal . ' 23:59:59';

            $c = new ClienteDao();
            $s = new SatisfaccionClienteDao();

            $encuestas = $s->reporteSatisfaccion(Sesion::obtener('idSucursal'), $fechaInicial, $fechaFinal);
            if ($encuestas['status']) {
                $tot = $encuestas['total'];
                $ent = 0;
                $prod = 0;
                $serv = 0;
                $pre = 0;
                $fin = 0;
                foreach ($encuestas['encuestas'] as $enc) {
                    $cli = new Cliente();
                    $cli->__set('_idCliente', $enc->Id_Cliente);
                    $cliente = $c->obtenerClientePorId($cli)['cliente'];

                    $enc->fecha = date('d/m/Y', strtotime($enc->Fecha));
                    $enc->cliente = $cliente->Cliente;
                    $ent += $enc->Calificacion_Entregas;
                    $prod += $enc->Calificacion_Producto;
                    $serv += $enc->Calificacion_Servicio;
                    $pre += $enc->Calificacion_Precio;
                    $fin += $enc->Calificacion_Final;
                }

                $arrProm = array();
                if ($tot > 0) {
                    $arrProm = array('entregas' => number_format($ent / $tot, 2), 'producto' => number_format($prod / $tot, 2),
                        'servicio' => number_format($serv / $tot, 2), 'precio' => number_format($pre / $tot, 2), 'final' => number_format($fin / $tot, 2));
                }

                echo json_encode(array('encuestas' => $encuestas['encuestas'], 'prom' => $arrProm));
            } else {
                ErrorController::mostrarError(1, $encuestas['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function autorizaciones() {
        $this->_tarea = 82;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR  . 'models' . DIRECTORY_SEPARATOR .  'ProductoProspectoDao.php';

            $u = new UsuarioDao();
            $vendedores = $u->obtenerVendedoresActivosPorSucursal(Sesion::obtener('idSucursal'));
            if ($vendedores['status']) {
                $arrayVendedores = new ArrayObject($vendedores['vendedores']);
                $iteradorVendedores = $arrayVendedores->getIterator();
                $this->_vista = 'autorizaciones';
                $this->_datos['vendedores'] = $iteradorVendedores;
                $this->existeVista();
                $this->_datos['accion'] = 'autorizaciones';
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $vendedores['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function checkList() {
        $this->_tarea = 151;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'checkList';
            $this->existeVista();
            $this->_datos['accion'] = 'seguridad';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function checkDiarioVehiculo() {
        $this->_tarea = 151;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
                    DIRECTORY_SEPARATOR . 'VehiculoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR .
                    'CheckListDao.php';

            $idVehiculo = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            $ch = new CheckListDao();
            $hay = $ch->obtenerCheckList($idVehiculo, date("Y-m-d"));
            if ($hay['status']) {
                if ($hay['total'] > 0) {
                    $datosCheck = $hay['checkList'];
                    if ($datosCheck->Status == 1) {
                        $salida = true;
                    } else {
                        ErrorController::mostrarError(1, 'El checklist del vehículo ya ha sido finalizado. Espera a mañana -_-');
                    }
                } else {
                    $salida = false;
                }
            } else {
                $salida = false;
            }

            $v = new VehiculoDao();
            $vehiculo = $v->getVehiculo($idVehiculo);
            $u = new UsuarioDao();
            $usuario = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
            $s = new SucursalDao();
            $sucursal = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'));

            if ($vehiculo['status']) {

                $this->_vista = 'checkDiarioVehiculo';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['vehiculo'] = $vehiculo['vehiculo'];
                $this->_datos['usuario'] = $usuario['usuarios'];
                $this->_datos['sucursal'] = $sucursal['sucursal'];
                $this->_datos['salida'] = $salida;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $vehiculos['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function checkDiario() {
        $this->_tarea = 151;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
                    DIRECTORY_SEPARATOR . 'VehiculoDao.php';

            $v = new VehiculoDao();
            $vehiculos = $v->obtenerVehiculosSucursal(Sesion::obtener('idSucursal'));
            if ($vehiculos['status']) {

                $arrayVehiculos = new ArrayObject($vehiculos['vehiculos']);
                $iteradorVehiculos = $arrayVehiculos->getIterator();

                $this->_vista = 'checkDiario';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad';
                $this->_datos['vehiculos'] = $iteradorVehiculos;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $vehiculos['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function guardarCheckDiario() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CheckListDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleCheckListDao.php';

        $fecha = date("Y-m-d");
        $idVehiculo = filter_input(INPUT_POST, 'vehiculo', FILTER_SANITIZE_NUMBER_INT);


        $ck = new CheckListDao();
        $hay = $ck->obtenerCheckList($idVehiculo, $fecha);
        if ($hay['status']) {
            if ($hay['total'] == 0) {
                $c = new CheckList();
                $c->__set('_fecha', $fecha);
                $c->__set('_idVehiculo', $idVehiculo);
                $c->__set('_idUsuario', Sesion::obtener('idUsuario'));
                $c->__set('_idSucursal', Sesion::obtener('idSucursal'));
                $c->__set('_status', 1);
                $guarda = $ck->guardar($c);
                if ($guarda['status']) {
                    $idCheck = $guarda['idCheck'];

                    $llantasSalida = isset($_POST['llantasSalida']) ? $_POST['llantasSalida'] : 1;
                    $observacionesLlantasSalida = isset($_POST['observacionesLlantas']) ? $_POST['observacionesLlantas'] : '';
                    $lucesDelanterasSalida = isset($_POST['lucesDelanterasSalida']) ? $_POST['lucesDelanterasSalida'] : 1;
                    $observacionesLucesDelanteras = isset($_POST['observacionesLucesDelanteras']) ? $_POST['observacionesLucesDelanteras'] : '';
                    $intermitentesSalida = isset($_POS['intermitentesSalida']) ? $_POST['intermitentesSalida'] : 1;
                    $observacionesIntermitentes = isset($_POST['observacionesIntermitentes']) ? $_POST['observacionesIntermitentes'] : '';
                    $luzReversaSalida = isset($_POST['luzReversaSalida']) ? $_POST['luzReversaSalida'] : 1;
                    $observacionesLuzReversa = isset($_POST['observacionesLuzReversa']) ? $_POST['observacionesLuzReversa'] : '';
                    $observacionesAlarmaReversa = isset($_POST['observacionesAlarmaReversa']) ? $_POST['observacionesAlarmaReversa'] : '';
                    $alarmaReversaSalida = isset($_POST['alarmaReversaSalida']) ? $_POST['alarmaReversaSalida'] : 1;
                    $observacionesAlarmaReversa = isset($_POST['observacionesAlarmaReversa']) ? $_POST['observacionesAlarmaReversa'] : '';
                    $frenoManoSalida = isset($_POST['frenoManoSalida']) ? $_POST['frenoManoSalida'] : 1;
                    $observacionesFrenoMano = isset($_POST['observacionesFrenoMano']) ? $_POST['observacionesFrenoMano'] : '';
                    $claxonSalida = isset($_POST['claxonSalida']) ? $_POST['claxonSalida'] : 1;
                    $observacionesClaxon = isset($_POST['observacionesClaxon']) ? $_POST['observacionesClaxon'] : '';
                    $espejosSalida = isset($_POST['espejosSalida']) ? $_POST['espejosSalida'] : 1;
                    $observacionesEspejos = isset($_POST['observacionesEspejos']) ? $_POST['observacionesEspejos'] : '';
                    $indicadorTableroSalida = isset($_POST['indicadorTableroSalida']) ? $_POST['indicadorTableroSalida'] : 1;
                    $observacionesIndicadorTablero = isset($_POST['observacionesIndicadorTablero']) ? $_POST['observacionesIndicadorTablero'] : '';
                    $combustibleSalida = isset($_POST['combustibleSalida']) ? $_POST['combustibleSalida'] : 1;
                    $observacionesCombustible = isset($_POST['observacionesCombustible']) ? $_POST['observacionesCombustible'] : '';
                    $limpiezaSalida = isset($_POST['limpiezaSalida']) ? $_POST['limpiezaSalida'] : 1;
                    $observacionesLimpieza = isset($_POST['observacionesLimpieza']) ? $_POST['observacionesLimpieza'] : '';
                    $golpesSalida = isset($_POST['golpesSalida']) ? $_POST['golpesSalida'] : 1;
                    $observacionesGolpes = isset($_POST['observacionesGolpes']) ? $_POST['observacionesGolpes'] : '';

                    $det = new DetalleCkeckList();
                    $det->__set('_llantasSalida', $llantasSalida);
                    $det->__set('_llantasEntrada', 0);
                    $det->__set('_observacionesLlantasSalida', $observacionesLlantasSalida);
                    $det->__set('_observacionesLlantasEntrada', '');
                    $det->__set('_lucesDelanterasSalida', $lucesDelanterasSalida);
                    $det->__set('_lucesDelanterasEntrada', 0);
                    $det->__set('_observacionesLucesDelanterasSalida', $observacionesLucesDelanteras);
                    $det->__set('_observacionesLucesDelaterasEntrada', '');
                    $det->__set('_intermitentesSalida', $intermitentesSalida);
                    $det->__set('_intermitentesEntrada', 0);
                    $det->__set('_observacionesIntermitentesSalida', $observacionesIntermitentes);
                    $det->__set('_observacionesIntermitentesEntrada', '');
                    $det->__set('_luzReversaSalida', $luzReversaSalida);
                    $det->__set('_luzReversaEntrada', 0);
                    $det->__set('_observacionesLuzReversaSalida', $observacionesLuzReversa);
                    $det->__set('_observacionesLuzReversaEntrada', '');
                    $det->__set('_alarmaReversaEntrada', 0);
                    $det->__set('_alarmaReversaSalida', $alarmaReversaSalida);
                    $det->__set('_observacionesAlarmaReversaSalida', $observacionesAlarmaReversa);
                    $det->__set('_observacionesAlarmaReversaEntrada', '');
                    $det->__set('_frenoManoSalida', $frenoManoSalida);
                    $det->__set('_frenoManoEntrada', 0);
                    $det->__set('_observacionesFrenoManoSalida', $observacionesFrenoMano);
                    $det->__set('_observacionesFrenoManoEntrada', '');
                    $det->__set('_claxonSalida', $claxonSalida);
                    $det->__set('_claxonEntrada', 0);
                    $det->__set('_observacionesClaxonSalida', $observacionesClaxon);
                    $det->__set('_observacionesClaxonEntrada', '');
                    $det->__set('_espejosSalida', $espejosSalida);
                    $det->__set('_espejosEntrada', 0);
                    $det->__set('_observacionesEspejosSalida', $observacionesEspejos);
                    $det->__set('_observacionesEspejosEntrada', '');
                    $det->__set('_indicadorTableroSalida', $indicadorTableroSalida);
                    $det->__set('_indicadorTableroEntrada', 0);
                    $det->__set('_observacionesIndicadorTableroEntrada', '');
                    $det->__set('_observacionesIndicadorTableroSalida', $observacionesIndicadorTablero);
                    $det->__set('_combustibleSalida', $combustibleSalida);
                    $det->__set('_combustibleEntrada', 0);
                    $det->__set('_observacionesCombustibleSalida', $observacionesCombustible);
                    $det->__set('_observacionesCombustibleEntrada', '');
                    $det->__set('_limpiezaUnidadSalida', $limpiezaSalida);
                    $det->__set('_limpiezaUnidadEntrada', 0);
                    $det->__set('_observacionesLimpiezaSalida', $observacionesLimpieza);
                    $det->__set('_observacionesLimpiezaEntrada', '');
                    $det->__set('_golpesSalida', $golpesSalida);
                    $det->__set('_golpesEntrada', 0);
                    $det->__set('_observacionesGolpesSalida', $observacionesGolpes);
                    $det->__set('_observacionesGolpesEntrada', '');
                    $det->__set('_idCheckList', $idCheck);
                    $deta = new DetalleCheckListDao();
                    $detalle = $deta->guardarCheckList($det);
                    if ($detalle['status']) {
                        $response['status'] = true;
                        $response['mensaje'] = 'Datos guardados correctamente.';
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $detalle['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $guarda['error'];
                }
            } else {
                //si hay registro es check de entrada
                $datosCheck = $hay['checkList'];
                $llantasEntrada = isset($_POST['llantasEntrada']) ? $_POST['llantasEntrada'] : 1;
                $observacionesLlantas = isset($_POST['observacionesLlantas']) ? $_POST['observacionesLlantas'] : '';
                $lucesDelanterasEntrada = isset($_POST['lucesDelanterasEntrada']) ? $_POST['lucesDelanterasEntrada'] : 1;
                $observacionesLucesDelanteras = isset($_POST['observacionesLucesDelanteras']) ? $_POST['observacionesLucesDelanteras'] : '';
                $intermitentesEntrada = isset($_POST['intermitentesEntrada']) ? $_POST['intermitentesEntrada'] : 1;
                $observacionesIntermitentes = isset($_POST['observacionesIntermitentes']) ? $_POST['observacionesIntermitentes'] : '';
                $luzReversaEntrada = isset($_POST['luzReversaEntrada']) ? $_POST['luzReversaEntrada'] : 1;
                $observacionesLuzReversa = isset($_POST['observacionesLuzReversa']) ? $_POST['observacionesLuzReversa'] : '';
                $alarmaReversaEntrada = isset($_POST['alarmaReversaEntrada']) ? $_POST['alarmaReversaEntrada'] : 1;
                $observacionesAlarmaReversa = isset($_POST['observacionesAlarmaReversa']) ? $_POST['observacionesAlarmaReversa'] : '';
                $frenoManoEntrada = isset($_POST['frenoManoEntrada']) ? $_POST['frenoManoEntrada'] : 1;
                $observacionesFrenoMano = isset($_POST['observacionesFrenoMano']) ? $_POST['observacionesFrenoMano'] : '';
                $claxonEntrada = isset($_POST['claxonEntrada']) ? $_POST['claxonEntrada'] : 1;
                $observacionesClaxon = isset($_POST['observacionesClaxon']) ? $_POST['observacionesClaxon'] : '';
                $espejosEntrada = isset($_POST['espejosEntrada']) ? $_POST['espejosEntrada'] : 1;
                $observacionesEspejos = isset($_POST['observacionesEspejos']) ? $_POST['observacionesEspejos'] : '';
                $indicadorTableroEntrada = isset($_POST['indicadorTableroEntrada']) ? $_POST['indicadorTableroEntrada'] : 1;
                $observacionesIndicadorTablero = isset($_POST['observacionesIndicadorTablero']) ? $_POST['observacionesIndicadorTablero'] : '';
                $combustibleEntrada = isset($_POST['combustibleEntrada']) ? $_POST['combustibleEntrada'] : 1;
                $observacionesCombustible = isset($_POST['observacionesCombustible']) ? $_POST['observacionesCombustible'] : '';
                $limpiezaEntrada = isset($_POST['limpiezaEntrada']) ? $_POST['limpiezaEntrada'] : 1;
                $observacionesLimpieza = isset($_POST['observacionesLimpieza']) ? $_POST['observacionesLimpieza'] : '';
                $golpesEntrada = isset($_POST['golpesEntrada']) ? $_POST['golpesEntrada'] : 1;
                $observacionesGolpes = isset($_POST['observacionesGolpes']) ? $_POST['observacionesGolpes'] : '';
                $d = new DetalleCkeckList();
                $d->__set('_llantasEntrada', $llantasEntrada);
                $d->__set('_observacionesLlantasEntrada', $observacionesLlantas);
                $d->__set('_lucesDelanterasEntrada', $lucesDelanterasEntrada);
                $d->__set('_observacionesLucesDelaterasEntrada', $observacionesLucesDelanteras);
                $d->__set('_intermitentesEntrada', $intermitentesEntrada);
                $d->__set('_observacionesIntermitentesEntrada', $observacionesIntermitentes);
                $d->__set('_luzReversaEntrada', $luzReversaEntrada);
                $d->__set('_observacionesLuzReversaEntrada', $observacionesLuzReversa);
                $d->__set('_alarmaReversaEntrada', $alarmaReversaEntrada);
                $d->__set('_observacionesAlarmaReversaEntrada', $observacionesAlarmaReversa);
                $d->__set('_frenoManoEntrada', $frenoManoEntrada);
                $d->__set('_observacionesFrenoManoEntrada', $observacionesFrenoMano);
                $d->__set('_claxonEntrada', $claxonEntrada);
                $d->__set('_observacionesClaxonEntrada', $observacionesClaxon);
                $d->__set('_espejosEntrada', $espejosEntrada);
                $d->__set('_observacionesEspejosEntrada', $observacionesEspejos);
                $d->__set('_indicadorTableroEntrada', $indicadorTableroEntrada);
                $d->__set('_observacionesIndicadorTableroEntrada', $observacionesIndicadorTablero);
                $d->__set('_combustibleEntrada', $combustibleEntrada);
                $d->__set('_observacionesCombustibleEntrada', $observacionesCombustible);
                $d->__set('_limpiezaUnidadEntrada', $limpiezaEntrada);
                $d->__set('_observacionesLimpiezaUnidadEntrada', $observacionesLimpieza);
                $d->__set('_golpesEntrada', $golpesEntrada);
                $d->__set('_observacionesGolpesEntrada', $observacionesGolpes);
                $d->__set('_idCheckList', $datosCheck->Id_CheckList);
                $de = new DetalleCheckListDao();
                $detalle = $de->guardaEntrada($d);
                if ($detalle['status']) {
                    $response['status'] = true;
                    $response['mensaje'] = 'Datos guardados correctamente.';
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $detalle['error'];
                }
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $hay['error'];
        }

        echo json_encode($response);
    }

    public function checkSemanal() {
        $this->_tarea = 151;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'checkSemanal';
            $this->existeVista();
            $this->_datos['accion'] = 'seguridad';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function checkMontacargas(){
        $this->_tarea = 151;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

            $u = new UsuarioDao();
            $usuario = $u->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];

            $this->_vista = 'checkMontacargas';
            $this->existeVista();
            $this->_datos['accion'] = 'seguridad';
            $this->_datos['usuario'] = $usuario;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function seguridadHigiene(){
        $this->_tarea = 84;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']){
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .  DIRECTORY_SEPARATOR . 'CategoriaHigieneDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SubcategoriaHigieneDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoHigieneDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoSubcategoriaDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentosNivel3Dao.php';

            $c = new CategoriaHigieneDao();
            $categorias = $c->obtenerCategorias();

            if ($categorias['status']){
                $arrayCategorias = new ArrayObject($categorias['categorias']);
                $iteradorCategorias = $arrayCategorias->getIterator();

                $s = new DocumentoSubcategoriaDao();
                $sub = $s->obtenerSubcategorias();
                $arraySubcategorias = new ArrayObject($sub['subcategorias']);
                $iterardorSubcategorias = $arraySubcategorias->getIterator();
                $niv = new DocumentosNivel3Dao();
                $nivel = $niv->obtenerNivel3();
                $arrayNivel3 = new ArrayObject($nivel['nivel3']);
                $iteradorNivel3 = $arrayNivel3->getIterator();
                $this->_vista = 'seguridadHigiene';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad e higiene';
                $this->_datos['categorias'] = $iteradorCategorias;
                $this->_datos['subcategorias'] = $iterardorSubcategorias;
                $this->_datos['nivel3'] = $iteradorNivel3;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $categorias['error']);
            }

        }
        else{
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function guardarCategoriaHigiene(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CategoriaHigieneDao.php';

        $categoria = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_STRING);
        $folio = filter_input(INPUT_POST, 'folio', FILTER_SANITIZE_STRING);

        $c = new CategoriaHigiene();
        $c->__set('_categoria', $categoria);
        $c->__set('_folio', $folio);

        $cat = new CategoriaHigieneDao();
        $guardar = $cat->guardar($c);
        if ($guardar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Datos guardados correctamente.';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $guardar['error'];
        }

        echo json_encode($response);
    }

    public function documentosCategorias(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoCategoriaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SubcategoriaHigieneDao.php';

        $idCategoria = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

        $d = new DocumentoCategoriaDao();
        $documentos = $d->ontenerDocumentosCategoria($idCategoria);
        if ($documentos['status']){
            $arrayDocumentos = new ArrayObject($documentos['documentos']);
            $iteradorDocumentos = $arrayDocumentos->getIterator();
            //obtenemos las subcategorias
            $s = new SubcategoriaHigienDao();
            $subcategorias = $s->obtenerSubcategorias($idCategoria);
            if ($subcategorias['status']){
                $arraySubcategorias = new ArrayObject($subcategorias['subcategorias']);
                $iteradorSubcategorias = $arraySubcategorias->getIterator();
                $this->_vista = 'documentosCategorias';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad e higiene';
                $this->_datos['documentos'] = $iteradorDocumentos;
                $this->_datos['subcategorias'] = $iteradorSubcategorias;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $subcategorias['error']);
            }

        }
        else{
            ErrorController::mostrarError(1, $documentos['error']);
        }
    }

    public function documentosSubCategorias(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoCategoriaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SubcategoriaHigieneDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoSubcategoriaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
            DIRECTORY_SEPARATOR . 'DocumentosNivel3Dao.php';

        $idCategoria = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

        $d = new DocumentoSubcategoriaDao();
        $documentos = $d->obtenerDocumentosSubcategoria($idCategoria);
        if ($documentos['status']){
            $arrayDocumentos = new ArrayObject($documentos['documentos']);
            $iteradorDocumentos = $arrayDocumentos->getIterator();
            //obtenemos las subcategorias
            $s = new SubcategoriaHigienDao();
            $subcategorias = $s->obtenerSubcategorias($idCategoria);
            if ($subcategorias['status']){
                $arraySubcategorias = new ArrayObject($subcategorias['subcategorias']);
                $iteradorSubcategorias = $arraySubcategorias->getIterator();

                $this->_vista = 'documentosSubCategorias';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad e higiene';
                $this->_datos['documentos'] = $iteradorDocumentos;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $subcategorias['error']);
            }

        }
        else{
            ErrorController::mostrarError(1, $documentos['error']);
        }
    }

    public function documentosTercerNivel(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoCategoriaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SubcategoriaHigieneDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoSubcategoriaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' .
            DIRECTORY_SEPARATOR . 'DocumentosNivel3Dao.php';

        $idNiveo = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

        $d = new DocumentosNivel3Dao();
        $documentos = $d->obtenerDocumentos($idNiveo);
        if ($documentos['status']){
            $arrayDocumentos = new ArrayObject($documentos['documentos']);
            $iteradorDocumentos = $arrayDocumentos->getIterator();


                $this->_vista = 'documentosTercerNivel';
                $this->existeVista();
                $this->_datos['accion'] = 'seguridad e higiene';
                $this->_datos['documentos'] = $iteradorDocumentos;
                $this->cargarVista();

        }
        else{
            ErrorController::mostrarError(1, $documentos['error']);
        }
    }


    public function platicasSeguridad(){
        $this->_vista = 'platicasSeguridad';
        $this->existeVista();
        $this->_datos['accion'] = 'seguridad';
        $this->cargarVista();
    }

    public function obtenerListaJuntas(){
        require_once BASEPATH .  'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'MinutaDao.php';

        $pagina = (int) filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_POST, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_POST, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_POST, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $m = new MinutaDao();
        $t = $m->totalListaJunta(Sesion::obtener('idSucursal'));
        if ($t['status']){
            $total = $t['total'];
            $paginas = ceil($total / $registros);
            $juntas = $m->obtenerListaJunta(Sesion::obtener('idSucursal'), $inicio, $registros);
            if ($juntas['status']){
                $response['status'] = true;
                $response['juntas'] = $juntas['juntas'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $juntas['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function comisionMixta(){
        $this->_vista = 'comisionMixta';
        $this->existeVista();
        $this->_datos['accion'] = 'seguridad';
        $this->cargarVista();
    }

    public function extintores(){
        $this->_vista = 'extintores';
        $this->existeVista();
        $this->_datos['accion'] = 'seguridad';
        $this->cargarVista();
    }

    /** by isantosp */
    public function shellServices() {
        $this->_tarea = 85;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }


            $sub = $t->obtenerSubtareasUsuario($this->_tarea, Sesion::obtener('idUsuario'));
            if ($sub['status']) {
                $subtareas = $sub['subtareas'];
                $arraySubtareas = new ArrayObject($subtareas);
                $iteradorSubtareas = $arraySubtareas->getIterator();
                $this->_vista = 'shellServices';
                $this->existeVista();
                $this->_datos['accion'] = 'servicios shell';
                $this->_datos['subtareas'] = $iteradorSubtareas;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function lubePlanner() {
        $this->_tarea = 156;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }


            $this->_vista = 'lubePlanner';
            $this->existeVista();
            $this->_datos['accion'] = 'servicios shell';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function findCliente() {
        $this->_tarea = 156;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $q = filter_input(INPUT_POST, 'q', FILTER_SANITIZE_STRING);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ServiciosClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlannerEventoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'EquipoClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlannerCursoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'EquipoDao.php';

            $clid = new ClienteDao();
            $serv = new ServiciosClienteDao();
            $plan = new PlannerEventoDao();
            $cur = new PlannerCursoDao();
            $equi = new EquipoClienteDao();
            $equipoDao = new EquipoDao();
            $d = new DocumentoDao();
            $arrCli = array();
            $clientes = $clid->buscarClientesPlanner(0, 20, Sesion::obtener('idSucursal'), $q)['clientes'];
            foreach ($clientes as $cli) {
                $direccion = $cli->Calle . " " . $cli->Numero_Exterior . " " . $cli->Colonia . " " . $cli->CP . " " . $cli->Ciudad . " " . $cli->Estado . ".";

                $servicios = $serv->getServiciosCliente($cli->Id_Cliente)['servicios'];
                $arrPlanes = array();
                $planes = $plan->getPlanesAnio($cli->Id_Cliente);
                if($planes['existe']) $arrPlanes = $planes['planes'];

                $arrEquipos = array();
                $equipos = $equipoDao->obtenerEquipo($cli->Id_Sospechoso);
                if($equipos['equipos']) $arrEquipos = $equipos['equipos'];

                $arrCursos = array();
                $cursos = $cur->getCursoGiro($cli->Giro);
                if($cursos['cursos']) $arrCursos = $cursos['cursos'];

                $cotizaciones = $d->obtenerCotizacionesCliente($cli->Id_Cliente);
                $coti = array('id' => '', 'folio' => '');
                if($cotizaciones['total'] > 0){
                    $cotizacion = $cotizaciones['cotizaciones'][($cotizaciones['total']-1)];
                    $coti = array('id' => $cotizacion->Id_Documento, 'folio' => $cotizacion->Folio_Documento);
                }

                $arrCli[] = array('id' => $cli->Id_Cliente, 'label' => $cli->Cliente, 'mail' => $cli->email, 'dir' => $direccion, 'servicios' => $servicios, 'planes' => $arrPlanes, 'equipos' => $arrEquipos, 'cursos' => $arrCursos, 'cotizacion' => $coti);
            }

            echo json_encode($arrCli);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function addEventoPlanner(){
        $this->_tarea = 156;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $cliente = filter_input(INPUT_POST, 'cliente', FILTER_SANITIZE_NUMBER_INT);
            $destino = filter_input(INPUT_POST, 'destino', FILTER_SANITIZE_NUMBER_INT);
            $serv = filter_input(INPUT_POST, 'serv', FILTER_SANITIZE_NUMBER_INT);
            $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlannerEventoDao.php';

            $plan = new PlannerEventoDao();
            $evento = $plan->addEvento($cliente, $serv, $destino, $fecha);
            if($evento['status']){
                $response['status'] = false;
                $response['idEvento'] = $evento['idEvento'];
            }else{
                $response['status'] = false;
                $response['error'] = $evento['error'];
            }

            echo json_encode($evento);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function updateFechaPlanner(){
        $this->_tarea = 156;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $evento = filter_input(INPUT_POST, 'evento', FILTER_SANITIZE_NUMBER_INT);
            $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlannerEventoDao.php';

            $plan = new PlannerEventoDao();
            $evento = $plan->updateFecha($evento, $fecha);
            if($evento['status']){
                $response['status'] = false;
            }else{
                $response['status'] = false;
                $response['error'] = $evento['error'];
            }

            echo json_encode($evento);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function delEventoPlanner(){
        $this->_tarea = 156;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlannerEventoDao.php';

            $plan = new PlannerEventoDao();
            $evento = $plan->deleteEvento($id);
            if($evento['status']){
                $response['status'] = false;
            }else{
                $response['status'] = false;
                $response['error'] = $evento['error'];
            }

            echo json_encode($evento);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function uploadResult(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlannerEventoDao.php';
        $p = new PlannerEventoDao();

        $fecha = filter_input(INPUT_POST, 'res-fecha', FILTER_SANITIZE_STRING);
        $muestra = filter_input(INPUT_POST, 'res-muestra', FILTER_SANITIZE_STRING);
        $result = filter_input(INPUT_POST, 'res-option', FILTER_SANITIZE_NUMBER_INT);
        $evento = filter_input(INPUT_POST, 'evento', FILTER_SANITIZE_NUMBER_INT);


        if (!empty($_FILES['doc-result']['name']) && ($_FILES['doc-result']['type'] == "application/pdf")){
            $filename = $muestra.str_replace('-','',$fecha);
            $ruta = 'resultados_planner/';
            $ext = '_resultado.pdf';
            copy($_FILES['doc-result']['tmp_name'],$ruta.$filename.$ext);
        }else{
            $response['status'] = false;
            $response['mensaje'] = 'El documento debe tener extención PDF.';
        }

        if (!empty($_FILES['doc-reporte']['name']) && ($_FILES['doc-reporte']['type'] == "application/pdf")){
            $filename = $muestra.str_replace('-','',$fecha);
            $ruta = 'resultados_planner/';
            $ext = '_reporte.pdf';
            copy($_FILES['doc-reporte']['tmp_name'],$ruta.$filename.$ext);
        }else{
            $response['status'] = false;
            $response['mensaje'] = 'El reporte debe tener extención PDF.';
        }

        $exito = $p->guardaResultado($evento, $fecha, $muestra, $result);

        if($exito['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Se subieron los resultados correctamente.';
        }else{
            $response['status'] = false;
            $response['mensaje'] = $exito['error'];
        }


        echo json_encode($response);
    }

    public function getEventosPlan() {
        $this->_tarea = 156;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $cliente = filter_input(INPUT_POST, 'cliente', FILTER_SANITIZE_NUMBER_INT);
            $anio = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlannerEventoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ServiciosClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'MultiAlmacenDao.php';

            $plan = new PlannerEventoDao();
            $planes = $plan->getEventosPlan($cliente, $anio);

            $serv = new ServiciosClienteDao();
            $servicios = $serv->getServiciosCliente($cliente)['servicios'];

            $planes['servicios'] = $servicios;

            $m = new MultiAlmacenDao();
            $multi = $m->getMultiAlmacenCliente($cliente);
            $planes['multi'] = $multi;

            echo json_encode($planes);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function cursosCoach() {
        $this->_tarea = 157;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';

            $s = new SectorDao();
            $sectores = $s->obtenerSectores();
            if ($sectores['status']) {
                $arraySectores = new ArrayObject($sectores['sectores']);
                $iteradorSectores = $arraySectores->getIterator();
                $this->_vista = 'cursosCoach';
                $this->existeVista();
                $this->_datos['accion'] = 'servicios shell';
                $this->_datos['sectores'] = $iteradorSectores;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sectores['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function examenCoach() {
        $this->_tarea = 157;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            if (!isset($_GET['opcion'])) {
                ErrorController::mostrarError(404);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlannerCursoDao.php';

            $idCurso = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            $p = new PlannerCursoDao();
            $curso = $p->obtenerCurso($idCurso);
            if ($curso['status']) {
                if(!$curso['existe']){
                    ErrorController::mostrarError(404);
                }else{
                    $this->_vista = 'examenCoach';
                    $this->existeVista();
                    $this->_datos['accion'] = 'servicios shell';
                    $this->_datos['curso'] = $curso['curso'];
                    $this->cargarVista();
                }
            } else {
                ErrorController::mostrarError(1, $curso['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function lubeProject() {
        $this->_tarea = 158;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'lubeProject';
            $this->existeVista();
            $this->_datos['accion'] = 'servicios shell';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

  public function findClienteProject() {
        $this->_tarea = 158;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $q = filter_input(INPUT_POST, 'q', FILTER_SANITIZE_STRING);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'EquipoClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LubeProjectDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ServiciosClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'EquipoDao.php';


            $equipoDao = new EquipoDao();
            $clid = new ClienteDao();
            $proj = new LubeProjectDao();
            $equi = new EquipoClienteDao();
            $serv = new ServiciosClienteDao();
            $arrCli = array();
            $clientes = $clid->buscarClientesPlanner(0, 20, Sesion::obtener('idSucursal'), $q)['clientes'];
            foreach ($clientes as $cli) {
                $servicios = $serv->getServiciosCliente($cli->Id_Cliente)['servicios'];

                if($servicios['LubeProject'] > 0 && $servicios['CantidadLubeProject'] > 0){
                    $direccion = $cli->Calle . " " . $cli->Numero_Exterior . " " . $cli->Colonia . " " . $cli->CP . " " . $cli->Ciudad . " " . $cli->Estado . ".";

                    $arrProyectos = array();
                    $proyectos = $proj->getProyectosCliente($cli->Id_Cliente);
                    if($proyectos['existe']) $arrProyectos = $proyectos['proyectos'];

                    $arrEquipos = array();
                    $equipos = $equipoDao->obtenerEquipo($cli->Id_Sospechoso);
                    if($equipos['equipos']) $arrEquipos = $equipos['equipos'];

                    $arrCli[] = array('id' => $cli->Id_Cliente,
                        'label' => $cli->Cliente,
                        'mail' => $cli->email,
                        'dir' => $direccion,
                        'proyectos' => $arrProyectos,
                        'equipos' => $arrEquipos);
                }
            }

            echo json_encode($arrCli);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function addProyecto(){
        $this->_tarea = 158;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $cliente = filter_input(INPUT_POST, 'cliente', FILTER_SANITIZE_NUMBER_INT);
            $titulo = filter_input(INPUT_POST, 'titulo', FILTER_SANITIZE_STRING);
            $objetivo = filter_input(INPUT_POST, 'objetivo', FILTER_SANITIZE_STRING);
            $equipos = filter_input(INPUT_POST, 'equipos', FILTER_SANITIZE_STRING);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LubeProjectDao.php';

            $pro = new LubeProjectDao();
            $evento = $pro->addProyecto($cliente, $titulo, $objetivo, $equipos, 0);
            if($evento['status']){
                $response['status'] = false;
                $response['idProyecto'] = $evento['idProyecto'];
            }else{
                $response['status'] = false;
                $response['error'] = $evento['error'];
            }

            echo json_encode($evento);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function getProyecto(){
        $this->_tarea = 158;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $proyecto = filter_input(INPUT_POST, 'proyecto', FILTER_SANITIZE_NUMBER_INT);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LubeProjectDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'EquipoClienteDao.php';

            $pro = new LubeProjectDao();
            $e = new EquipoClienteDao();
            $info = $pro->getProyecto($proyecto);
            if($info['status']){
                $response['status'] = true;

                $equipos = $e->getEquiposIn($info['proyecto']['equipos']);
                $arrEqui = array();
                foreach ($equipos['equipos'] as $equi) {
                    $arrEqui[] = $equi->Maquina;
                }
                $info['proyecto']['equiposstr'] = implode(', ', $arrEqui);
                $info['proyecto']['equipos'] = explode(',',$info['proyecto']['equipos']);

                $cal = 'application/balance/resultados_project/calculadora_'.$proyecto.'.xls';
                if(file_exists($cal)) $info['proyecto']['calc'] = $cal;
                else if(file_exists($cal.'x')) $info['proyecto']['calc'] = $cal.'x';
                else $info['proyecto']['calc'] = '';

                $info['proyecto']['dvr'] = '';
                if($info['proyecto']['res_real'] > 0){
                    $info['proyecto']['dvr'] = 'application/balance/resultados_project/dvr_'.$proyecto.'.pdf';;
                }
                $response['proyecto'] = $info['proyecto'];
            }else{
                $response['status'] = false;
                $response['error'] = $info['error'];
            }

            echo json_encode($info);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function addActividad(){
        $this->_tarea = 158;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $proyecto = filter_input(INPUT_POST, 'proyecto', FILTER_SANITIZE_NUMBER_INT);
            $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
            $responsable = filter_input(INPUT_POST, 'responsable', FILTER_SANITIZE_STRING);
            $inicio = filter_input(INPUT_POST, 'inicio', FILTER_SANITIZE_STRING);
            $fin = filter_input(INPUT_POST, 'fin', FILTER_SANITIZE_STRING);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LubeProjectActividadDao.php';

            $act = new LubeProjectActividadDao();
            $res = $act->addActividad($proyecto, $descripcion, $responsable, $inicio, $fin);
            if($res['status']){
                $response['status'] = false;
                $response['idActividad'] = $res['idActividad'];
            }else{
                $response['status'] = false;
                $response['error'] = $res['error'];
            }

            echo json_encode($res);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function getActividades(){
        $this->_tarea = 158;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $proyecto = filter_input(INPUT_POST, 'proyecto', FILTER_SANITIZE_NUMBER_INT);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LubeProjectActividadDao.php';

            $pro = new LubeProjectActividadDao();
            $act = $pro->getActividades($proyecto);
            if($act['status']){
                $response['status'] = true;
                $response['actividades'] = $act['actividades'];
            }else{
                $response['status'] = false;
                $response['error'] = $act['error'];
            }

            echo json_encode($act);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function delActividad(){
        $this->_tarea = 158;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LubeProjectActividadDao.php';

            $act = new LubeProjectActividadDao();
            $res = $act->deleteActividad($id);
            if($res['status']){
                $response['status'] = false;
            }else{
                $response['status'] = false;
                $response['error'] = $res['error'];
            }

            echo json_encode($res);
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function satisfaccionCliente(){
        $this->_tarea = 156;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $this->_vista = 'satisfaccionCliente';
            $this->_datos['accion'] = 'calidad';
            $this->existeVista();
            $this->cargarVista();

        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function administrarLPA(){
        $this->_tarea = 158;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }


            $this->_vista = 'administrarLPA';
            $this->_datos['accion'] = 'calidad';
            $this->existeVista();
            $this->cargarVista();

        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function altaActividadSeguridad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';

        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $usuarioDao = new UsuarioDao();
            $u = $usuarioDao->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];
            $tipoUsuario = $u->Tipo;


            $u = new UsuarioDao();
            $todosUsuarios = $u->obtenerUsuariosNoInactivos();
            $arraytodosUsuarios = new ArrayObject($todosUsuarios['usuarios']);
            $iteradortodosUsuarios = $arraytodosUsuarios->getIterator();




            $seguridadDao = new SeguridadDao();
            $normas = $seguridadDao->obtenerNormasDeSeguridad()['normas'];
            $arrayNormas = new ArrayObject($normas);
            $iteradorNormas = $arrayNormas->getIterator();

            $sucursalDao = new SucursalDao();
            $sucursales = $sucursalDao->obtenerListaSucursales()['sucursales'];
            $arraySucursales = new ArrayObject($sucursales);
            $iteradorSucursales = $arraySucursales->getIterator();


                $this->_vista = 'altaActividadSeguridad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['normas'] = $iteradorNormas;
                $this->_datos['sucursales'] = $iteradorSucursales;
                $this->_datos['todosUsuarios'] = $iteradortodosUsuarios;

                $this->cargarVista();

        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }



    public function editarActividadSeguridad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';

        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $seguridadDao = new SeguridadDao();
            $normas = $seguridadDao->obtenerNormasDeSeguridad()['normas'];
            $arrayNormas = new ArrayObject($normas);
            $iteradorNormas = $arrayNormas->getIterator();

            $sucursalDao = new SucursalDao();
            $sucursales = $sucursalDao->obtenerListaSucursales()['sucursales'];
            $arraySucursales = new ArrayObject($sucursales);
            $iteradorSucursales = $arraySucursales->getIterator();

            $usuarioDao = new UsuarioDao();
            $u = $usuarioDao->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];
            $tipoUsuario = $u->Tipo;


            $todosUsuarios = $usuarioDao->obtenerUsuariosNoInactivos();
            $arraytodosUsuarios = new ArrayObject($todosUsuarios['usuarios']);
            $iteradortodosUsuarios = $arraytodosUsuarios->getIterator();


            $idActividad = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            $seguridad = new SeguridadDao();
            $actividad = $seguridad->buscarSeguridadPorIdYSucursal($idActividad, Sesion::obtener('idSucursal'));
            $responsables = $seguridad->buscarResponsablesPorSeguridadId($idActividad)['usuarios'];
            $arrayResponsables = new ArrayObject($responsables);
            $iteradorResponsables = $arrayResponsables->getIterator();

            if ($actividad['status']) {
//                $datosActividad = $actividad['actividad'];
                $datosActividad =  ($actividad['total'] > 0 ? $actividad['actividad'] : $seguridad->buscarSeguridadPorId($idActividad)['actividad']);
                $u = new UsuarioDao();

                    $this->_vista = 'editarActividadSeguridad';
                    $this->existeVista();
                    $this->_datos['actividad'] = $datosActividad ;
                    $this->_datos['accion'] = 'actividades';
                    $this->_datos['normas'] = $iteradorNormas;
                    $this->_datos['sucursales'] = $iteradorSucursales;
                    $this->_datos['todosUsuarios'] = $iteradortodosUsuarios;
                    $this->_datos['responsables'] = $iteradorResponsables;
                    $this->cargarVista();

            } else {
                ErrorController::mostrarError(1, $actividad['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function listadoActividadSeguridad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $seguridadDao = new SeguridadDao();
            $normas = $seguridadDao->obtenerNormasDeSeguridad()['normas'];
            $arrayNormas = new ArrayObject($normas);
            $iteradorNormas = $arrayNormas->getIterator();

            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivos();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'listadoActividadSeguridad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->_datos['normas'] = $iteradorNormas;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function historialActividadesSeguridad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';
        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $seguridadDao = new SeguridadDao();
            $normas = $seguridadDao->obtenerTodasLasNormasDeSeguridad()['normas'];
            $arrayNormas = new ArrayObject($normas);
            $iteradorNormas = $arrayNormas->getIterator();

            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivos();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'historialActividadesSeguridad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->_datos['normas'] = $iteradorNormas;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function normasSeguridad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivos();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'normasSeguridad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function editarNorma(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $idNorma = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            $seguridad = new SeguridadDao();

            $norma = $seguridad->obtenerNormaPorId($idNorma);
            if ($norma['status']) {
                    $this->_vista = 'editarNorma';
                    $this->existeVista();
                    $this->_datos['accion'] = 'actividades';
                    $this->_datos['norma'] = $norma['normas'];
                    $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $norma['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }
    
    public function autorizacionesSeguridad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivos();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'autorizacionesSeguridad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }
    
     public function verHistorialActividadesRechazadas() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $idTareaAsingnada = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            $u = new UsuarioDao();



                $this->_vista = 'verHistorialActividadesRechazadas';
                $this->existeVista();
                $this->_datos['accion'] = 'verHistorialActividadesRechazadas';
                $this->_datos['idAsignada'] = $idTareaAsingnada;

                $this->cargarVista();

        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }
    
    public function reporteProyectos() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProspectosDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SpancopDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'AnalisisDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'AnalisisFlotaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ventas' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SecuenciaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'ventas' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'DetalleSecuenciaDao.php';


        $u = new UsuarioDao();
        $us = $u->obtenerVendedoresActivosPorSucursal( Sesion::obtener('idSucursal'));
        if ($us['status']) {
            $arrayUsuarios = new ArrayObject($us['vendedores']);
            $iteradorUsuarios = $arrayUsuarios->getIterator();
            $this->_datos['vendedores'] = $iteradorUsuarios;
            $this->_vista = 'reporteProyectos';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $us['error']);
        }
    }
    
      public function listadoActividadSistemaCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';
        $this->_tarea = 96;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $seguridadDao = new SistemasCalidadDao();
            $normas = $seguridadDao->obtenerNormasDeSeguridad()['normas'];
            $arrayNormas = new ArrayObject($normas);
            $iteradorNormas = $arrayNormas->getIterator();

            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivos();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'listadoActividadSistemaCalidad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->_datos['normas'] = $iteradorNormas;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function altaActividadSistemaCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';

        $this->_tarea = 96;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $usuarioDao = new UsuarioDao();
            $u = $usuarioDao->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];
            $tipoUsuario = $u->Tipo;


            $u = new UsuarioDao();
            $todosUsuarios = $u->obtenerUsuariosNoInactivos();
            $arraytodosUsuarios = new ArrayObject($todosUsuarios['usuarios']);
            $iteradortodosUsuarios = $arraytodosUsuarios->getIterator();




            $seguridadDao = new SistemasCalidadDao();
            $normas = $seguridadDao->obtenerNormasDeSeguridad()['normas'];
            $arrayNormas = new ArrayObject($normas);
            $iteradorNormas = $arrayNormas->getIterator();

            $sucursalDao = new SucursalDao();
            $sucursales = $sucursalDao->obtenerListaSucursales()['sucursales'];
            $arraySucursales = new ArrayObject($sucursales);
            $iteradorSucursales = $arraySucursales->getIterator();


            $this->_vista = 'altaActividadSistemaCalidad';
            $this->existeVista();
            $this->_datos['accion'] = 'actividades';
            $this->_datos['normas'] = $iteradorNormas;
            $this->_datos['sucursales'] = $iteradorSucursales;
            $this->_datos['todosUsuarios'] = $iteradortodosUsuarios;

            $this->cargarVista();

        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function historialActividadesSistemaCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';
        $this->_tarea = 88;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $seguridadDao = new SistemasCalidadDao();
            $normas = $seguridadDao->obtenerTodasLasNormasDeSeguridad()['normas'];
            $arrayNormas = new ArrayObject($normas);
            $iteradorNormas = $arrayNormas->getIterator();

            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivos();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'historialActividadesSistemaCalidad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->_datos['normas'] = $iteradorNormas;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function normasSistemaCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $this->_tarea = 96;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivos();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'normasSistemaCalidad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function editarCodigoCalidad(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';

        $this->_tarea = 96;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $idNorma = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            $seguridad = new SistemasCalidadDao();

            $norma = $seguridad->obtenerNormaPorId($idNorma);
            if ($norma['status']) {
                $this->_vista = 'editarCodigoCalidad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['norma'] = $norma['normas'];
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $norma['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }


    public function editarActividadSistemaCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SistemasCalidadDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';

        $this->_tarea = 96;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $seguridadDao = new SistemasCalidadDao();
            $normas = $seguridadDao->obtenerNormasDeSeguridad()['normas'];
            $arrayNormas = new ArrayObject($normas);
            $iteradorNormas = $arrayNormas->getIterator();

            $sucursalDao = new SucursalDao();
            $sucursales = $sucursalDao->obtenerListaSucursales()['sucursales'];
            $arraySucursales = new ArrayObject($sucursales);
            $iteradorSucursales = $arraySucursales->getIterator();

            $usuarioDao = new UsuarioDao();
            $u = $usuarioDao->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];
            $tipoUsuario = $u->Tipo;


            $todosUsuarios = $usuarioDao->obtenerUsuariosNoInactivos();
            $arraytodosUsuarios = new ArrayObject($todosUsuarios['usuarios']);
            $iteradortodosUsuarios = $arraytodosUsuarios->getIterator();


            $idActividad = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            $seguridad = new SistemasCalidadDao();
            $actividad = $seguridad->buscarSeguridadPorIdYSucursal($idActividad, Sesion::obtener('idSucursal'));
            $responsables = $seguridad->buscarResponsablesPorSeguridadId($idActividad)['usuarios'];
            $arrayResponsables = new ArrayObject($responsables);
            $iteradorResponsables = $arrayResponsables->getIterator();

            if ($actividad['status']) {
                // $datosActividad = $actividad['actividad'];
                $datosActividad = ($actividad['total'] > 0 ? $actividad['actividad'] : $seguridad->buscarSeguridadPorId($idActividad)['actividad']);
                $u = new UsuarioDao();

                $this->_vista = 'editarActividadSistemaCalidad';
                $this->existeVista();
                $this->_datos['actividad'] = $datosActividad ;
                $this->_datos['accion'] = 'actividades';
                $this->_datos['normas'] = $iteradorNormas;
                $this->_datos['sucursales'] = $iteradorSucursales;
                $this->_datos['todosUsuarios'] = $iteradortodosUsuarios;
                $this->_datos['responsables'] = $iteradorResponsables;
                $this->cargarVista();

            } else {
                ErrorController::mostrarError(1, $actividad['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function autorizacionesSistemaCalidad() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $this->_tarea = 96;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }



            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivos();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'autorizacionesSistemaCalidad';
                $this->existeVista();
                $this->_datos['accion'] = 'actividades';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function verHistorialSistemaCalidadActividadesRechazadas() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $this->_tarea = 96;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $idTareaAsingnada = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            $u = new UsuarioDao();



            $this->_vista = 'verHistorialSistemaCalidadActividadesRechazadas';
            $this->existeVista();
            $this->_datos['accion'] = 'verHistorialSistemaCalidadActividadesRechazadas';
            $this->_datos['idAsignada'] = $idTareaAsingnada;

            $this->cargarVista();

        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }
    
      public function reporteSistemaCalidad() {

            $this->_vista = 'reporteSistemaCalidad';
            $this->existeVista();
            $this->_datos['accion'] = 'reporteSistemaCalidad';
            $this->cargarVista();

    }
    
    public function forecastPorProveedor() {
        $this->_tarea = 169;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorDao.php';

            $p = new ProveedorDao();
            $proveedores = $p->listaProveedoresForecast(Sesion::obtener('idSucursal'));
            if ($proveedores['status']) {
                $arrayProveedores = new ArrayObject($proveedores['proveedores']);
                $iteradorProveedor = $arrayProveedores->getIterator();
            }

            $this->_vista = 'forecastPorProveedor';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->_datos['proveedores'] = $iteradorProveedor;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteForecastPorProveedor() {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'EntradaAlmacenDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DireccionDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'EntregasForecastDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'DetalleEntregasForecastDao.php';

        $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
        $idProveedor = filter_input(INPUT_POST, 'idProveedor', FILTER_SANITIZE_STRING);
        $idSucursal = Sesion::obtener('idSucursal');

        $forecastMensualDao = new ForecastMensualDao();

        $mes= date("Y-m-01");


        $obtenerForcast = $forecastMensualDao->obtenerForecastPorSucursalNoAprovado($idSucursal,$fecha.'-01');
        if($obtenerForcast['status']){
            if($obtenerForcast['total'] == 0){

                if($mes <= $fecha.'-01'){
                  $this->calcularReporteEntregaForecast($fecha, $idSucursal, $idProveedor);
                }


                $this->_vista = 'reporteForecastPorProveedor';
                $this->existeVista();
                $this->_datos['accion'] = 'reportes';
                $this->_datos['fecha'] = $fecha;
                $this->_datos['idProveedor'] = $idProveedor;
                $this->cargarVista();
            }else{
                ErrorController::mostrarError(1, "existen forecast por autorizar");
            }
        }else {
            ErrorController::mostrarError(1, $obtenerForcast['error']);
        }

    }

  public function calcularReporteEntregaForecast($fecha, $idSucursal, $idProveedor){

        $forecastMensualDao = new ForecastMensualDao();
        $entradaAlmacenDao = new EntradaAlmacenDao();
        $clienteDao = new ClienteDao();
        $direccionDao = new DireccionDao();
        $entregasForecastDao = new EntregasForecastDao();
        $detalleEntregasForecastDao = new DetalleEntregasForecastDao();


        $entregasForecastDao->borrarEntregaForecast($fecha . '-01', $idSucursal, $idProveedor);
        $idEntregaForecast =  $entregasForecastDao->altaEntregaForecast($fecha . '-01', $idSucursal, $idProveedor)['idEntregasForecast'];


        $datosForecast = $forecastMensualDao->obtenerProductosReporteEntregas($idSucursal)['forecast'];
        foreach ($datosForecast as $datos){

            $totalForecast = $forecastMensualDao->obtenerForecastReporteEntregas($fecha . '-01', $idSucursal, $datos->Id_Producto );

            if ($totalForecast['total'] == 0){
               /* $detalleEntregasForecastDao->altaDetalleEntregasForecast(0, 0, 0,
                    0, $datos->Id_Producto, $idEntregaForecast );*/
                continue;
            }

            $datosForecast = $totalForecast['forecast'];
            $diferenciaMesActual = floatval($datosForecast->semana1) + floatval($datosForecast->semana2) + floatval($datosForecast->semana3) + floatval($datosForecast->semana4);

            if($diferenciaMesActual == 0){
                continue;
            }

            $transito = $entradaAlmacenDao->obtenerProductosEnTransito($datos->Id_Producto, $idProveedor);



            if ($transito['total'] > 0) {
                $transitoTotal = $transito['transito']->transito;
            } else {
                $transitoTotal = 0;
            }

            if ($datos->Stock == "" || $datos->Stock == null) {$datos->Stock = 0;}

            $diferenciaMesActual = $diferenciaMesActual - $transitoTotal - $datos->Stock;

            if($diferenciaMesActual< 0 ){
                $diferenciaMesActual =0;

            }
            $diferenciaMesActual = $diferenciaMesActual * $datos->Litraje;

            if($idSucursal == 1){

                    if($datosForecast->Tipo == "cliente"){
                        $c = new Cliente();
                        $c->__set('_idCliente', $datosForecast->Id_Cliente);
                        $cliente = $clienteDao->obtenerClientePorId($c)['cliente'];
                    }else{
                        $sospechosoDao = new SospechosoDao();
                        $cliente = $sospechosoDao->obtenerSospechoso($datosForecast->Id_Cliente)['sospechoso'];
                    }

                    $d = new Direccion();
                    $d->__set('_idDireccion', $cliente->Id_Direccion);
                    $direccion = $direccionDao->obtenerDireccion($d)['direccion'];

                    if(($idProveedor == 107 and (strlen(stristr($direccion->Estado, "MX"))>0) ||
                            (strlen(stristr($direccion->Estado, "mex"))>0) ||
                            (strlen(stristr($direccion->Estado, "df"))>0)||
                            (strlen(stristr($direccion->Estado, "dis"))>0)) ||
                        ($idProveedor == 110 and (strlen(stristr($direccion->Estado, "MX"))==0) ||
                            (strlen(stristr($direccion->Estado, "mex"))==0) ||
                            (strlen(stristr($direccion->Estado, "df"))==0)||
                            (strlen(stristr($direccion->Estado, "dis"))==0))){

                        $detalleEntregasForecastDao->altaDetalleEntregasForecast($diferenciaMesActual, $datosForecast->mes1* $datos->Litraje, $datosForecast->mes2* $datos->Litraje,
                            $datosForecast->mes3* $datos->Litraje, $datos->Id_Producto, $idEntregaForecast );

                    }else {
                        /*$detalleEntregasForecastDao->altaDetalleEntregasForecast(0, 0, 0,
                            0, $datos->Id_Producto, $idEntregaForecast );*/
                        continue;
                    }

            } else {

                $detalleEntregasForecastDao->altaDetalleEntregasForecast($diferenciaMesActual, $datosForecast->mes1* $datos->Litraje, $datosForecast->mes2* $datos->Litraje,
                    $datosForecast->mes3* $datos->Litraje, $datos->Id_Producto, $idEntregaForecast );

            }

        }

    }

    public function exportarReporteEntregasForecast() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'EntregasForecastDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'DetalleEntregasForecastDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
            require_once BASEPATH . 'libs/pdf/vendor/autoload.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorDao.php';

        $fecha = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_STRING);
        $idProveedor= filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

                $this->_vista = 'exportarReporteEntregasForecast';
                $this->existeVista();
                $this->_datos['accion'] = 'reportes';
                $this->_datos['fecha'] = $fecha;
                $this->_datos['idProveedor'] = $idProveedor;
                $this->cargarVista();

    }
    
   public function lubeCoachInterno() {
        $this->_tarea = 99;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        //if ($perm['status']) {
          //  if ($perm['acceso'] == 0) {
           //     ErrorController::mostrarError(403);
          //  }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';



            $usuarioDao = new UsuarioDao();
            $seguridadDao = new SeguridadDao();
            $usuariosActivos = $usuarioDao->obtenerUsuariosCursos()['usuarios'];

            $normasSeguridad = $seguridadDao->obtenerNormasDeSeguridad();
            if($normasSeguridad['status'] ){

                $arrayUsuarios = new ArrayObject($usuariosActivos);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'lubeCoachInterno';
                $this->existeVista();
                $this->_datos['accion'] = 'lubeCoachInterno';
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->_datos['normasSeguridad'] = $normasSeguridad['normas'];
                $this->cargarVista();

            }else{
                ErrorController::mostrarError(1, $normasSeguridad['error']);
            }

       // } else {
       //     ErrorController::mostrarError(1, $perm['error']);
        
    }


    public function examenCoachInteno() {

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

            $idCurso = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            $cursosInternosDao = new CursosInternosDao();
            $curso = $cursosInternosDao->obtenerCurso($idCurso);
            if ($curso['status']) {
                if(!$curso['existe']){
                    ErrorController::mostrarError(404);
                }else{

                    $this->_vista = 'examenCoachInteno';
                    $this->existeVista();
                    $this->_datos['accion'] = 'examenCoachInteno';
                    $this->_datos['curso'] = $curso['curso'];
                    $this->cargarVista();
                }
            } else {
                ErrorController::mostrarError(1, $curso['error']);
            }

    }
    
     public function verHistorialListaCursosRechazados() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

            $idTareaAsingnada = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            $u = new UsuarioDao();

            $this->_vista = 'verHistorialListaCursosRechazados';
            $this->existeVista();
            $this->_datos['accion'] = 'verHistorialListaCursosRechazados';
            $this->_datos['idAsignada'] = $idTareaAsingnada;
            $this->cargarVista();

    }
    
    
    public function generaAutorizacionesForecastAnual() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'AutorizacionesForecastAnualDao.php';

        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);

        $autorizacionesForecastAnualDao = new AutorizacionesForecastAnualDao();
        $year = 2023;
        
        $f = new ForecastAnualDao();
        $fore = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $u = new UsuarioDao();
                if (Sesion::obtener('idRol') == 1 || Sesion::obtener('idRol') == 2 ) {
                   $forecastAnualEnAutorizacion =  $autorizacionesForecastAnualDao->obtenerForecastAnualEnAutorizacionPorSucursal($year, Sesion::obtener('idSucursal'));
                } else {
                    ErrorController::mostrarError(1, 'Lo siento, no tienes los privilegios suficientes para consultar los datos. ');
                    exit;
                }
                if ($forecastAnualEnAutorizacion['status']) {
                    $arrayUsuarios = new ArrayObject($forecastAnualEnAutorizacion['autorizaciones']);
                    $iteradorVendedores = $arrayUsuarios->getIterator();
                    $this->_vista = 'generaAutorizacionesForecastAnual';
                    $this->existeVista();
                    $this->_datos['accion'] = 'autorizaciones';
                    $this->_datos['vendedores'] = $iteradorVendedores;
                    $this->_datos['forecast'] = $fore['forecast'];


                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $forecastAnualEnAutorizacion['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos para el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }

    public function autorizacionesForecastMensual() {
        $this->_tarea = 82;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensualDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR  . 'models' . DIRECTORY_SEPARATOR .  'ProductoProspectoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';

            $u = new UsuarioDao();
            $dia = date('d');
            if($dia > 7){
                $date = date('Y-m-01');
                $fechaInicial = date('Y-m-01',strtotime($date. ' +1 months'));
            }else{
                $fechaInicial = date('Y-m-01');
            }
            $vendedores = $u->obtenerVendedoresForecastActivosPorSucursal(Sesion::obtener('idSucursal'), $fechaInicial);
            if ($vendedores['status']) {
                $arrayVendedores = new ArrayObject($vendedores['vendedores']);
                $iteradorVendedores = $arrayVendedores->getIterator();
                $this->_vista = 'autorizacionesForecastMensual';
                $this->_datos['vendedores'] = $iteradorVendedores;
                $this->existeVista();
                $this->_datos['accion'] = 'autorizaciones';
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $vendedores['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function autorizacionesForecastAnual() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'AutorizacionesForecastAnualDao.php';

        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);

        $autorizacionesForecastAnualDao = new AutorizacionesForecastAnualDao();

        $year = 2022;

        $f = new ForecastAnualDao();
        $fore = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $u = new UsuarioDao();
                if (Sesion::obtener('idRol') == 1 || Sesion::obtener('idRol') == 2 ) {
                    $forecastAnualEnAutorizacion =  $autorizacionesForecastAnualDao->obtenerForecastAnualEnAutorizacionPorSucursal($year, Sesion::obtener('idSucursal'));
                } else {
                    ErrorController::mostrarError(1, 'Lo siento, no tienes los privilegios suficientes para consultar los datos. ');
                    exit;
                }
                if ($forecastAnualEnAutorizacion['status']) {
                    $arrayUsuarios = new ArrayObject($forecastAnualEnAutorizacion['autorizaciones']);
                    $iteradorVendedores = $arrayUsuarios->getIterator();
                    $this->_vista = 'autorizacionesForecastAnual';
                    $this->existeVista();
                    $this->_datos['accion'] = 'autorizaciones';
                    $this->_datos['vendedores'] = $iteradorVendedores;
                    $this->_datos['forecast'] = $fore['forecast'];

                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $forecastAnualEnAutorizacion['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos para el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }
    
    public function cuestionarioRiesgosPsicologicos() {

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RiesgosPsicologicosDao.php';
           require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuestionarioRiesgoPsicologicoDao.php';


        $s = new SucursalDao();
            $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
            $dia = date("N");
            $u = new UsuarioDao();
            $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
            if ($user['status']) {
                $lpa = new RiesgosPsicologicosDao();
                $preg = $lpa->getPreguntas();
                $pregAtencionClientes = $lpa->getPreguntasAtencionClientes();
                $pregOtrosTrabajadores = $lpa->getPreguntasJefeOtrosTrabajadores();

                $cuestionarioUsuarioDao = new CuestionarioRiesgoPsicologicoDao();

                $cuestionario =  $cuestionarioUsuarioDao->obtenerCuestionarioUsuarioActivo(Sesion::obtener('idUsuario'));
                if($cuestionario['existe'] > 0){
                    $this->_vista = 'cuestionarioRiesgosPsicologicos';
                    $this->existeVista();
                    $this->_datos['accion'] = 'seguridad';
                    $this->_datos['sucursal'] = $suc->Nombre;
                    $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
                    $this->_datos['preguntas'] = $preg['preguntas'];
                    $this->_datos['preguntasAtencionClientes'] = $pregAtencionClientes['preguntas'];
                    $this->_datos['preguntasOtrosTrabajadores'] = $pregOtrosTrabajadores['preguntas'];
                    $this->_datos['idCuestionario'] = $cuestionario['curso']->id_cuestionario_riesgos_psicologicos;
                    $this->cargarVista();

                }else{
                    ErrorController::mostrarError(1, 'no tiene cuestionario activo');
                }
            } else {
                ErrorController::mostrarError(1, $user['error']);
            }

    }

    public function riesgosPsicologicos() {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RiesgosPsicologicosDao.php';

        $this->_tarea = 102;
        $t = new TareasDao();
        $s = new SucursalDao();
        $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
        $dia = date("N");
        $u = new UsuarioDao();
        $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
        if ($user['status']) {
            $lpa = new RiesgosPsicologicosDao();
            $preg = $lpa->getPreguntas();
            $dia = date("N");

            $sub = $t->obtenerSubtareasUsuario($this->_tarea, Sesion::obtener('idUsuario'));
            if ($sub['status']) {
                $subtareas = $sub['subtareas'];
                $arraySubtareas = new ArrayObject($subtareas);
                $iteradorSubtareas = $arraySubtareas->getIterator();
                $this->_vista = 'riesgosPsicologicos';
                $this->existeVista();
                $this->_datos['accion'] = 'riesgospsicologicos';
                $this->_datos['sucursal'] = $suc->Nombre;
                $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
                $this->_datos['preguntas'] = $preg['preguntas'];
                $this->_datos['subtareas'] = $iteradorSubtareas;
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $sub['error']);
            }

        } else {
            ErrorController::mostrarError(1, $user['error']);
        }

    }

    public function preguntasRiesgosPsicologicos() {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RiesgosPsicologicosDao.php';

        $s = new SucursalDao();
        $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
        $dia = date("N");
        $u = new UsuarioDao();
        $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
        if ($user['status']) {
            $lpa = new RiesgosPsicologicosDao();
            $preg = $lpa->getPreguntas();
            $dia = date("N");

            $this->_vista = 'preguntasRiesgosPsicologicos';

            $this->existeVista();
            $this->_datos['accion'] = 'seguridad';
            $this->_datos['sucursal'] = $suc->Nombre;
            $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
            $this->_datos['preguntas'] = $preg['preguntas'];
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $user['error']);
        }

    }

    public function guardarTareaNoConformidad($desc, $accion, $tipo){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';

        $seguridadDao = new SeguridadDao();
        $s = new Seguridad();
        $s->__set('_nombre', $desc);
        $s->__set('_clave', '01');
        $s->__set('_idResponsablepachuca', "");
        $s->__set('_idResponsablepuebla', "");
        $s->__set('_idResponsablequeretaro', "");
        $s->__set('_Dialimite', 0);
        $s->__set('_categoria', 11);
        $s->__set('_descripcion',  $desc);
        $s->__set('_tipo', $tipo);
        $s->__set('_responsableremplazararchivo', null);
        $s->__set('_idSucursal', null);
        $s->__set('_tipoDescripcion', '');
        $s->__set('_fechaInicio',  date("Y-m-d"));

        $guardarTareaSeguridad =  $seguridadDao->altaActividadSeguridad($s);

        if($guardarTareaSeguridad['status']){
            $idTareaSeguridad = $guardarTareaSeguridad['id'];

            $a = new Seguridad();
            $a->__set('_idResponsable', Sesion::obtener('idUsuario'));
            $a->__set('_idSupervisor', 0 );
            $a->__set('_status', 'finalizado');
            $a->__set('_idSeguridad', $idTareaSeguridad );
            $subirTareaAsignada = $seguridadDao->altaActividadAsignada($a);
            if($subirTareaAsignada['status']){

                $idAsignada = $subirTareaAsignada['id'];

                $t = new Seguridad();
                $t->__set('_descripcionNoConformidad',  $accion);
                $t->__set('_idSeguridad', $idAsignada);
                $t->__set('_status', 'pendiente');
                $t->__set('_idEmpleado', Sesion::obtener('idUsuario'));
                $t->__set('_idSucursal', Sesion::obtener('idSucursal'));
                $t->__set('_tipoDescripcion', 'evento');
                $t->__set('_fechaInicio', null);
                $t->__set('_idSupervisor', 16);
                $seguridadDao->SubirNoConformidad($t);

                $response['idTareaSeguridad'] = $idTareaSeguridad;

            }else{
                $response['status'] = false;
            }
        }else{
            $response['status'] = false;
        }

        return $response;
    }

    public function seguimientoTareasNoConformidad() {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RiesgosPsicologicosDao.php';

        $s = new SucursalDao();
        $suc = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'))['sucursal'];
        $dia = date("N");
        $u = new UsuarioDao();
        $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
        if ($user['status']) {
            $lpa = new RiesgosPsicologicosDao();
            $preg = $lpa->getPreguntas();
            $dia = date("N");

            $this->_vista = 'seguimientoTareasNoConformidad';

            $this->existeVista();
            $this->_datos['accion'] = 'seguridad';
            $this->_datos['sucursal'] = $suc->Nombre;
            $this->_datos['user'] = $user['usuarios']->Nombre . ' ' . $user['usuarios']->Apellido_Paterno . ' ' . $user['usuarios']->Apellido_Materno;
            $this->_datos['preguntas'] = $preg['preguntas'];
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $user['error']);
        }

    }
    
     public function  obtenerDatosProspecto($datosCliente){
        if($datosCliente->Id_Sospechoso == 0 || $datosCliente->Id_Sospechoso == null || $datosCliente->Id_Sospechoso == '' ){
            //guardarmos el prospecto
            $so = new Sospechoso();
            $so->__set('_idVendedor', trim($datosCliente->Id_Usuario));
            $so->__set('_unidad', trim($datosCliente->Id_Sucursal));
            $so->__set('_fecha', trim( date("Y-m-d")));
            $so->__set('_cliente', trim($datosCliente->Cliente));
            $so->__set('_rfc', trim($datosCliente->RFC));
            $so->__set('_descuento', trim(0));
            $so->__set('_tipoPago', trim($datosCliente->Tipo_Pago));
            $so->__set('_emailFacturacion', trim($datosCliente->Correo_Factura));
            $so->__set('_idDireccion', trim($datosCliente->Id_Direccion));
            $so->__set('_tipo', trim($datosCliente->Giro));
            $so->__set('_idSucursal', $datosCliente->Id_Sucursal);
            $so->__set('_idZona', trim($datosCliente->Giro));
            $so->__set('_frecuenciaVisita', trim($datosCliente->Freq_Visita));
            $so->__set('_puntuacion', 0);
            $so->__set('_status', 0);
            $so->__set('_marketing', 0);
            $so->__set('_proposito', null);

            $sosp = new SospechosoDao();
            $guardar = $sosp->guardar($so, 1);
            if ($guardar['status']) {
                $idSospechoso = $guardar['idSospechoso'];
                $clienteDao = new ClienteDao();
                $clienteDao->actualizarSospechosoCliente($idSospechoso, $datosCliente->Id_Cliente);
            }
        }else {
            $idSospechoso = $datosCliente->Id_Sospechoso;
        }

        $p = new ProspectosDao();
        $pros = $p->obtenerProspecto($idSospechoso);
        $datosProspecto = $pros['prospecto'];

        return $datosProspecto;

    }
    
    public function reporteForecastAnualGlobal() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorDao.php';

        $p = new ProveedorDao();
        $proveedores = $p->listaProveedoresMateriaPrima();
        if ($proveedores['status']) {
            $arrayProveedores = new ArrayObject($proveedores['proveedores']);
            $iteradorProveedor = $arrayProveedores->getIterator();
        }

        $u = new UsuarioDao();
        $us = $u->obtenerVendedoresActivos();
        if ($us['status']) {
            $arrayUsuarios = new ArrayObject($us['vendedores']);
            $iteradorVendedores = $arrayUsuarios->getIterator();
            $this->_vista = 'reporteForecastAnualGlobal';
            $this->existeVista();
            $this->_datos['accion'] = 'reportes';
            $this->_datos['proveedores'] = $iteradorProveedor;
            $this->_datos['vendedores'] = $iteradorVendedores;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $us['error']);
        }
    }

    public function generaReporteForecastAnualGlobal() {
        set_time_limit(0);
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoProspectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'SectorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'FamiliasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnualDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProductoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ServiciosClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ServiciosSospechosoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PolizasDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';


        $year = filter_input(INPUT_POST, 'year', FILTER_SANITIZE_NUMBER_INT);
        $idProveedor = filter_input(INPUT_POST, 'idProveedor', FILTER_SANITIZE_NUMBER_INT);


        $f = new ForecastAnualDao();
        $fore = $f->hayForecast($year, Sesion::obtener('idSucursal'));
        if ($fore['status']) {
            if ($fore['total'] > 0) {
                $u = new UsuarioDao();
                if (Sesion::obtener('idRol') == 1) {
                    $us = $f->obtenerVendedoresReporteAnual($year, Sesion::obtener('idSucursal'));
                } elseif (Sesion::obtener('idRol') == 2) {
                    $us = $f->obtenerVendedoresReporteAnual($year, Sesion::obtener('idSucursal'));
                } else {
                    ErrorController::mostrarError(1, 'Lo siento, no tienes los privilegios suficientes para consultar los datos. ');
                    exit;
                }
                if ($us['status']) {
                    $arrayUsuarios = new ArrayObject($us['vendedores']);
                    $iteradorVendedores = $arrayUsuarios->getIterator();
                    $this->_vista = 'generaReporteForecastAnualGlobal';
                    $this->existeVista();
                    $this->_datos['accion'] = 'reportes';
                    $this->_datos['vendedores'] = $iteradorVendedores;
                    $this->_datos['forecast'] = $fore['forecast'];
                    $this->_datos['idProveedor'] = $idProveedor;
                    $this->_datos['year'] = $year;


                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $us['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'No se encontraron datos para el año a consultar');
            }
        } else {
            ErrorController::mostrarError(1, $fore['error']);
        }
    }

}
