<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Alerta.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

class AlertaCalidadDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

    public function obtenerAlertasPorUsuarioYDia($idUsuario, $fecha)
    {
    	$sql = "SELECT * FROM alertas_calidad WHERE Id_Usuario_Reponsable = ? AND `Fecha` >= ? AND `Fecha` <= ?";
    	$stmt = $this->_dbh->prepare($sql);
    	$stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
    	$stmt->bindValue(2, $fecha, PDO::PARAM_STR);
    	$stmt->bindValue(3, $fecha . ' 23:59:59', PDO::PARAM_STR);
    	try{
    		$stmt->execute();
    		$response['status'] = true;
    		$response['total'] = $stmt->rowCount();
    	}catch(PDOException $e){
    		Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
    		$response['status'] = false;
    		$response['error'] = 'Ocurrió un error al obtener las alertas de calidad. ' . TICKETS;
    	}

    	return $response;
    }       
    
    public function obtenerAlertasDiarias($idSucursal, $fechaInicio, $fechaFin)
    {
        $sql = "SELECT * FROM `alertas_calidad` WHERE `Id_Sucursal` = ? AND `Fecha` BETWEEN ? AND ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['alertas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener las alertas del mes. ' . TICKETS;
        }
        
        return $response;
    }
    
    
     public function reporteCalidadDao($idSucursal, $fechaInicial, $fechaFinal)
    {
        $sql = "SELECT *, DATE_FORMAT(Fecha,'%d/%m/%Y') AS FechaF FROM alertas_calidad WHERE Id_Sucursal = ? AND Fecha BETWEEN ? AND ? ORDER BY Fecha ASC";        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFinal, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['alertas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los datos solicitados. ' . TICKETS;
        }
        
        return $response;
    }

    public function getSigFolioDao(){
        $sql = "SELECT Folio FROM alertas_calidad ORDER BY Id_Alerta_Calidad DESC LIMIT 1 ";        
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();

            if($stmt->rowCount() == 0){
                $folio = "AC-".date("ym")."001";
            }else{
                $last = $stmt->fetch(PDO::FETCH_OBJ)->Folio;
                
                $num = intval(substr($last,7,strlen($last))) + 1;
                if ($num < 10) $numStr = '00'.$num;
                elseif ($num < 100) $numStr = '0'.$num;
                else $numStr = $num;
                
                $folio = "AC-".date("ym")."".$numStr;
            }

            $response['status'] = true;
            $response['folio'] = $folio;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los datos solicitados. ' . TICKETS;
        }
        
        return $response;
    }

    public function guardaAlertaCalidadDAO(Alerta $a, $quien, $foto){
        $SQL = "INSERT INTO alertas_calidad 
                        (Id_Alerta_Calidad, Id_Sucursal, Folio, Fecha, Fecha_Preparo, Fecha_Reporte, Razon, Que, Falla_Material, Falla_Aplicacion, Falla_Humana, 
                        Accion, Id_Usuario_Reponsable, Fecha_Accion, Informacion_Adicional, Id_Usuario_Preparado, Id_Usuario_Reportado)
                    VALUES 
                        (NULL, :suc, :folio, NOW(), :fechaPrep, :fechaRepor, :razon, :que, :equipo, :conocimiento, :humana, 
                        :accion, :userResp, :fechaAccion, :imagen, :user, :user)";

        $stmt = $this->_dbh->prepare($SQL);
        ini_set('display_errors',0);
        $stmt->bindParam(":suc", $a->__get('_idSucursal'), PDO::PARAM_INT);
        $stmt->bindParam(":folio", $a->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindParam(":fechaPrep", $a->__get('_fechaPreparo'), PDO::PARAM_STR);
        $stmt->bindParam(":fechaRepor", $a->__get('_fechaReporte'), PDO::PARAM_STR);
        $stmt->bindParam(":razon", $a->__get('_razon'), PDO::PARAM_STR);
        $stmt->bindParam(":que", $a->__get('_que'), PDO::PARAM_STR);
        $stmt->bindParam(":equipo", $a->__get('_fallaEquipo'), PDO::PARAM_STR);
        $stmt->bindParam(":conocimiento", $a->__get('_fallaConocimiento'), PDO::PARAM_STR);
        $stmt->bindParam(":humana", $a->__get('_fallaHumana'), PDO::PARAM_STR);
        $stmt->bindParam(":accion", $a->__get('_accion'), PDO::PARAM_STR);
        $stmt->bindParam(":userResp", $a->__get('_idResponsable'), PDO::PARAM_INT);
        $stmt->bindParam(":fechaAccion", $a->__get('_fechaAccion'), PDO::PARAM_STR);
        $stmt->bindParam(":imagen", $foto, PDO::PARAM_STR);
        $stmt->bindParam(":user", $a->__get('_idUsuarioPreparado'), PDO::PARAM_INT);

        try{
            $stmt->execute();

            $idAlerta = $this->_dbh->lastInsertId();
            $response['status'] = true;
            $response['idAlerta'] = $idAlerta;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar la sugerencia. '
                    . TICKETS;
        }
        
        return $response;
    }
}