<?php
/**
 * Description of AutorizacionesForecastAnualDao
 *
 * @author sistemas
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'ForecastAnual.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AutorizacionesForecastAnualDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function hayAutorizacionForecastAnual($idForecast, $idUsuario)
    {
        $sql = "SELECT * FROM `autorizaciones_forecast_anual` WHERE `id_forecast_anual` = ? AND `id_usuario` = ? and id_sucursal = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(3, Sesion::obtener('idSucursal'), PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al validar si hay autorizacion  forecast. ' . TICKETS;
        }
        
        return $response;
    }

    public function insertarAutorizacionForecastAnual($status, $idForecastAnual, $idUsuario)
    {
        $sql = "INSERT INTO `autorizaciones_forecast_anual` (`status`, `id_forecast_anual`, `id_usuario`, id_sucursal ) VALUES (?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idForecastAnual, PDO::PARAM_INT);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(4, Sesion::obtener('idSucursal'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idForecast'] = $this->_dbh->lastInsertId();;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al insertar la autorizacion del forecast anual. ' . TICKETS;
        }

        return $response;
    }

    public function hayAutorizacionForecastAnualCron( $status, $year)
    {
        $sql = "SELECT * FROM `autorizaciones_forecast_anual` as afa
                inner join forecast_anual as fa on fa.Id_Forecast = afa.id_forecast_anual
                inner join usuarios as u on u.Id_Usuario = afa.id_usuario
                WHERE afa.status = ? and fa.Year = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $year, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['autorizaciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al validar si hay autorizacion  forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerAutorizacionForecastAnualUsuario( $year, $idUsuario)
    {
        $sql = "SELECT * FROM `autorizaciones_forecast_anual` as afa
                inner join forecast_anual as fa on fa.Id_Forecast = afa.id_forecast_anual
                inner join usuarios as u on u.Id_Usuario = afa.id_usuario
                WHERE (afa.status = 'autorizacion' || afa.status = 'rechazado' ) and fa.Year = ? and afa.id_usuario = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['autorizaciones'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al validar si hay autorizacion  forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastAnualEnAutorizacionPorSucursal( $year, $idSucursal)
    {
        $sql = "SELECT * FROM `autorizaciones_forecast_anual` as afa
                inner join forecast_anual as fa on fa.Id_Forecast = afa.id_forecast_anual
                inner join usuarios as u on u.Id_Usuario = afa.id_usuario
                WHERE afa.status = 'autorizacion' and fa.Year = ? and afa.id_sucursal = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['autorizaciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al validar si hay autorizacion  forecast. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusYRazones( $idForecastAnual,$status, $razon)
    {

        $sql = "UPDATE `autorizaciones_forecast_anual` SET `status` = ?, `razon_rechazo` = ? where id_autorizaciones_forecast_anual = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $razon, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecastAnual, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al cambiara el status de la autorizacion del forecast anual ' . TICKETS;
        }

        return $response;
    }

    public function actualizarAutorizacionForecastAnual($status, $idForecastAnual, $idUsuario)
    {
        $sql = "UPDATE `autorizaciones_forecast_anual` SET `status` = ? where id_forecast_anual = ? and id_usuario = ? and id_sucursal = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idForecastAnual, PDO::PARAM_INT);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(4, Sesion::obtener('idSucursal'), PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al actualizar la autorizacion del forecast anual. ' . TICKETS;
        }

        return $response;
    }



}
