<?php
/**
 * BitacoraRecorridoDao.php
 * Modelo para el manejo de vehículos
 * @author Ivan Santos Pérez
 * @copyright (c) 2018, Merdiz
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class BitacoraRecorridoDao extends Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getBitacoras($idSucursal, $inicio, $registros){
        $sql = "SELECT SQL_CALC_FOUND_ROWS b.*, v.Vehiculo, v.Placas, DATE_FORMAT(b.Fecha, '%d/%m/%Y') AS fechaf, 
                        (SELECT Usuario FROM usuarios WHERE Id_Usuario = Id_Usuario_Conductor) AS conductor
                    FROM `bitacora_recorrido` b INNER JOIN vehiculos v ON b.Id_Vehiculo = v.Id_Vehiculo
                        WHERE b.Status = 0 AND b.`Id_Sucursal` = ? AND v.Status = 1  AND v.Id_Sucursal = b.Id_Sucursal
                    ORDER BY b.Fecha DESC, Folio_Bitacora LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['bitacoras'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las bitacoras';
        }

        return $response;
    }

    public function getLastIndicador($idVehiculo){
        $sql = "SELECT Km_Final, km_restantes FROM bitacora_recorrido WHERE `Id_Vehiculo` = ? ORDER BY Id_Bitacora_Recorrido DESC LIMIT 1 ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idVehiculo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['indicador'] = $stmt->fetch(PDO::FETCH_OBJ);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del indicador';
        }

        return $response;
    }

    public function getProximoServicio($fechaSemana){
        $sql = "SELECT * FROM bitacora_recorrido WHERE `fecha_servicio` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaSemana, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['servicio'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener fecha de servicio';
        }

        return $response;
    }

    public function findBitacora($idSucursal, $inicio, $registros, $termino){
        $sql = "SELECT SQL_CALC_FOUND_ROWS b.*, v.Vehiculo, v.Placas, DATE_FORMAT(Fecha, '%d/%m/%Y') AS fechaf,
                        (SELECT Usuario FROM usuarios WHERE Id_Usuario = Id_Usuario_Conductor) AS conductor
                    FROM `bitacora_recorrido` b INNER JOIN vehiculos v ON b.Id_Vehiculo = v.Id_Vehiculo
                        WHERE b.Status = 0 AND b.`Id_Sucursal` = ? AND v.Status = 1  AND v.Id_Sucursal = b.Id_Sucursal
                            AND (Folio_Bitacora LIKE ? OR Vehiculo LIKE ? OR v.Placas LIKE ?)
                    ORDER BY b.Fecha DESC, Folio_Bitacora LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(3, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(4, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(5, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(6, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['bitacoras'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las bitacoras';
        }

        return $response;
    }

    public function getBitacora($idBitacora){
        $sql = "SELECT * FROM `bitacora_recorrido` WHERE `Id_Bitacora_Recorrido` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idBitacora, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['bitacora'] = $stmt->fetch(PDO::FETCH_OBJ);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de la bitacora';
        }

        return $response;
    }

    public function getDatosBitacora($idBitacora){
        $sql = "SELECT * FROM `bitacora_recorrido` WHERE `Id_Bitacora_Recorrido` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idBitacora, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['bitacora'] = $stmt->fetch(PDO::FETCH_OBJ);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de la bitacora';
        }

        return $response;
    }


    public function getFolio(){
        $fecha = date('Y-m');
        $sql = "SELECT Folio_Bitacora FROM bitacora_recorrido WHERE DATE_FORMAT(Fecha,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m') ORDER BY Id_Bitacora_Recorrido DESC LIMIT 1 ";
        $stmt = $this->_dbh->prepare($sql);
        //$stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;

            if($stmt->rowCount() > 0){
                $rd = $stmt->fetch(PDO::FETCH_OBJ);
                $fol = substr($rd->Folio_Bitacora, 7);
                $sig = intval($fol) + 1;
            }else{
                $sig = 1;
            }
            $folio = 'BR-'.date('ym').str_pad($sig, 3, "0", STR_PAD_LEFT);

            $response['folio'] = $folio;
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del indicador';
        }

        return $response;
    }

    public function guardaBitacora(BitacoraRecorrido $b){

        Utils::logInfo("GUARDA BITACORA", "", "");

    	$SQL = "INSERT INTO bitacora_recorrido
    					(Id_Bitacora_Recorrido, Folio_Bitacora, Id_Vehiculo, Id_Usuario_Conductor, Placas, Fecha, km_rango, Km_Inicial, Km_Final, Km_Recorridos,
    					km_restantes, Id_Sucursal, Status)
    				VALUES
    					(NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0) ";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $b->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindValue(2, $b->__get('_idVehiculo'), PDO::PARAM_INT);
        $stmt->bindValue(3, $b->__get('_idConductor'), PDO::PARAM_INT);
        $stmt->bindValue(4, $b->__get('_placas'), PDO::PARAM_STR);
        $stmt->bindValue(5, $b->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(6, $b->__get('_kmRango'), PDO::PARAM_INT);
        $stmt->bindValue(7, $b->__get('_kmInicial'), PDO::PARAM_INT);
        $stmt->bindValue(8, $b->__get('_kmFinal'), PDO::PARAM_INT);
        $stmt->bindValue(9, $b->__get('_kmRecorridos'), PDO::PARAM_INT);
        $stmt->bindValue(10, $b->__get('_kmRestantes'), PDO::PARAM_INT);
        $stmt->bindValue(11, $b->__get('_idSucursal'), PDO::PARAM_INT);


        try{
            $stmt->execute();
            $idBitacora = $this->_dbh->lastInsertId();
            $response['status'] = true;
            $response['idBitacora'] = $idBitacora;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar la bitacora. '
                    . TICKETS;
        }

        return $response;
    }

    public function guardaValesBitacora($idBitacora, $vales){
        $SQL = "UPDATE bitacora_recorrido SET Status = 1 , Folio_Vale = ? WHERE Id_Bitacora_Recorrido = ? ";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $vales, PDO::PARAM_STR);
        $stmt->bindValue(2, $idBitacora, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idBitacora'] = $idBitacora;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los vales. '
                    . TICKETS;
        }

        return $response;
    }

    public function getBitacoraVales($suc, $ini, $fin){
        $sql = "SELECT SQL_CALC_FOUND_ROWS b.*, v.Vehiculo, v.Placas
                    FROM `bitacora_recorrido` b INNER JOIN vehiculos v ON b.Id_Vehiculo = v.Id_Vehiculo
                        WHERE b.Status = 1 AND b.`Id_Sucursal` = ? AND v.Status = 1  AND v.Id_Sucursal = b.Id_Sucursal
                            AND b.Fecha >= ? AND b.Fecha <= ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $suc, PDO::PARAM_INT);
        $stmt->bindValue(2, $ini, PDO::PARAM_STR);
        $stmt->bindValue(3, $fin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['bitacoras'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las bitacoras';
        }

        return $response;
    }


}
