<?php
/**
 * Description of CalendarioSatisfaccionDao
 *
 * @author sistemas
 */
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'CalendarioSatisfaccion.php';

class CalendarioSatisfaccionDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function obtenerClientesMarketing($idSucursal, $limite, $year, $mes, $dia)
    {
        $sql = "SELECT `clientes`.`Id_Cliente`, `clientes`.`Cliente` FROM `calendario_satisfaccion` "
                . "INNER JOIN `clientes` ON `calendario_satisfaccion`.`Id_Cliente` = `clientes`.`Id_Cliente` "
                . "WHERE `calendario_satisfaccion`.`Id_Sucursal` = ? AND `calendario_satisfaccion`.`Status` = 1 "
                . "AND `calendario_satisfaccion`.`Year` = ? AND `calendario_satisfaccion`.`Mes` = ? "
                . "AND MOD(`calendario_satisfaccion`.`Id_Cliente`," . date('t') . ") = " . $dia . " ORDER BY RAND() LIMIT ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $year, PDO::PARAM_INT);
        $stmt->bindValue(3, $mes, PDO::PARAM_INT);
        $stmt->bindValue(4, $limite, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['clientes'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los clientes para encuestas. ' . TICKETS;
        }
        
        return $response;
    }
}