<?php
/**
 * CategoriaDao.php
 * Modelo para la persistencia de datos de categorias de sistema de calidad
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Categoria.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class CategoriaDao extends Model
{
    
    public function __construct() {
        parent::__construct();
    }
    
    public function obtenerListaCategorias(Categoria $c)
    {
        $sql = "SELECT * FROM `categorias_procedimientos` WHERE `Id_Usuario` = ? ORDER BY `Id_Categoria`";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_idUsuario'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['categorias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $$e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude listar las categorias. '
                    . TICKETS;
        }        
        
        return $response;
    }
    
    public function obtenerCategoria(Categoria $c)
    {
        $sql = "SELECT * FROM `categorias_procedimientos` WHERE `Id_Categoria` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_idCategoria'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['categoria'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude obtener los datos de la categoría. '
                    . TICKETS;
        }
        
        return $response;
    }
}