<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CategoriaHigiene.php';

class CategoriaHigieneDao extends Model {

	public function __construct(){
		parent::__construct();
	}

	public function guardar(CategoriaHigiene $c){
		$sql = "INSERT INTO categoria_higiene (Categoria, Folio) VALUES (?, ?)";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $c->__get('_categoria'), PDO::PARAM_STR);
		$stmt->bindValue(2, $c->_-get('_folio'), PDO::PARAM_STR);
		try {
			$stmt->execute();
			$response['status'] = true;			
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al guardar la categoría. ' . TICKETS;
		}

		return $response;
	}

	public function obtenerCategorias(){
		$sql = "SELECT * FROM categoria_higiene ORDER BY Id_Categoria_Higiene ASC";
		$stmt = $this->_dbh->prepare($sql);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['categorias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener las categorías. ' . TICKETS;
		}

		return $response;
	}
}