<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CheckList.php';

class CheckListDao extends Model{

	public function __construct()
    {
        parent::__construct();
    }

    public function guardar(CheckList $c){
    	$sql = "INSERT INTO checklist (Fecha, Id_Vehiculo, Id_Usuario, Id_Sucursal, Status) VALUES (?, ?, ?, ?, ?)";
    	$stmt = $this->_dbh->prepare($sql);
    	$stmt->bindValue(1, $c->__get('_fecha'), PDO::PARAM_STR);
    	$stmt->bindValue(2, $c->__get('_idVehiculo'), PDO::PARAM_INT);
    	$stmt->bindValue(3, $c->__get('_idUsuario'), PDO::PARAM_INT);
    	$stmt->bindValue(4, $c->__get('_idSucursal'), PDO::PARAM_INT);
    	$stmt->bindValue(5, $c->__get('_status'), PDO::PARAM_INT);
    	try {
    		$stmt->execute();
    		$response['status'] = true;
    		$response['idCheck'] = $this->_dbh->lastInsertId();
    	} catch (PDOException $e) {
    		Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
    		$response['status'] = false;
    		$response['error'] = ':( Lo siento, ocurrió un error al guardar el check list. ' . TICKETS;
    	}

    	return $response;
    }

    public function obtenerCheckList($idVehiculo, $fecha){
    	$sql = "SELECT * FROM checklist WHERE Id_vehiculo = ? AND Fecha = ?";
    	$stmt = $this->_dbh->prepare($sql);
    	$stmt->bindValue(1, $idVehiculo, PDO::PARAM_INT);
    	$stmt->bindValue(2, $fecha, PDO::PARAM_STR);
    	try {
    		$stmt->execute();
    		$response['status'] = true;
    		$response['total'] = $stmt->rowCount();
    		$response['checkList'] = $stmt->fetch(PDO::FETCH_OBJ);
    	} catch (PDOException $e) {
    		Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
    		$response['status'] = false;
    		$response['error'] = ':( Lo siento, ocurrió un error al validar el checklist del vehículo. ' . TICKETS;
    	}

    	return $response;
    }


}