<?php
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CheckMontacargas.php';

class CheckMontacargasDao extends Model {

	public function __construct(){
		parent::__construct();
	}

	public function obtenerChecklist($fechaInicial, $fechaFinal, $idMontacargas){
		$sql = "SELECT * FROM checklist_montacargas WHERE Fecha_Inicial >= ? AND Fecha_Final <= ? AND Id_Montacargas = ?";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
		$stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);
		$stmt->bindValue(3, $idMontacargas, PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['datosCheckList'] = $stmt->fetch(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getFile(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener los datos del checklist. ' . TICKETS;
		}

		return $response;		
	}
}