<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

class CuestionarioRiesgoPsicologicoDao extends Model
{
	public function __construct() {
        parent::__construct();
    }


    public function guardarCuestionarioRiesgoPsicologico($idUsuario)
    {
        $sql = "INSERT INTO `cuestionario_riesgos_psicologicos` (`id_Usuario`, `status`) VALUES (?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, 'activo', PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCuestionarioUsuario'] = $this->_dbh->lastInsertId();;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al guardar el cuestionario del usuarios ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCuestionarioUsuarioActivo($idUsuario){
        $sql = "SELECT * FROM cuestionario_riesgos_psicologicos WHERE status = 'activo' and id_Usuario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['curso'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los '
                . 'datos del curso. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusCuestionarioRiesgos($status, $idUsuario, $servicioCliente, $jefeTrabajadores){
        $sql = "update cuestionario_riesgos_psicologicos set status = ?, servicio_cliente = ?, jefe_trabajadores = ? where id_cuestionario_riesgos_psicologicos = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $servicioCliente, PDO::PARAM_STR);
        $stmt->bindValue(3, $jefeTrabajadores, PDO::PARAM_STR);
        $stmt->bindValue(4, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el status ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCuestionariosActivos(){
        $sql = "SELECT * FROM cuestionario_riesgos_psicologicos WHERE status = 'activo' ";
        $stmt = $this->_dbh->prepare($sql);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los cursos ' . TICKETS;
        }

        return $response;
    }

    public function getAllCuestionariosPorUsuario($idUsuario, $page = -1){
        $limit = '';
        if($page > -1){
            $ini = $page * 20;
            $limit = " LIMIT $ini, 20 ";
        }
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM cuestionario_riesgos_psicologicos 
WHERE id_Usuario = ? order by created_at desc $limit ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cuestionarios'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los cuestionarios . ' . TICKETS;
        }

        return $response;
    }



}
