<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

class CuestionarioUsuarioDao extends Model
{
	public function __construct() {
        parent::__construct();
    }


    public function guardarCuestionarioUsuario($idPregunta, $idCuestionario, $observaciones, $respuesta)
    {
        $sql = "INSERT INTO `cuestionario_usuario` (`id_preguntas_riesgos_psicologicos`, `id_cuestionario`, `observaciones` , `respuesta`) VALUES (?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idPregunta, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCuestionario, PDO::PARAM_INT);
        $stmt->bindValue(3, $observaciones, PDO::PARAM_STR);
        $stmt->bindValue(4, $respuesta, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCuestionarioUsuario'] = $this->_dbh->lastInsertId();;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al guardar el cuestionario del usuarios ' . TICKETS;
        }

        return $response;
    }


}
