<?php
/**
 * PlannerCursoDao.php
 * Modelo para la persistencia de datos de planner_curso
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class CursosInternosDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

    public function guardarCurso($idCurso, $titulo, $responsable, $tipoUsuario, $duracion, $status, $fechaInicio, $frecuencia, $capacitacion, $induccion, $codigoCurso, $codigoListaAsistencia, $normaSeguridad, $clave, $tipoCurso, $idUsuarioCurso){
        if($idCurso > 0){
            $sql = "UPDATE cursos_internos SET rol_participantes = ?, titulo = ?, duracion = ?, id_usuario_responsable = ?, status = ?, fecha = ?, frecuencia = ?, capacitacion = ?, induccion = ?, codigo_curso = ?, codigo_lista_asistencia = ?, id_normas_seguridad = ?, clave = ?, tipo_curso = ?, id_usuario_curso = ? WHERE id_cursos_internos = ?; ";
        }else{
            $sql = "INSERT INTO cursos_internos  (rol_participantes, titulo, duracion, id_usuario_responsable, status, fecha, frecuencia, capacitacion, induccion, codigo_curso, codigo_lista_asistencia, id_normas_seguridad, clave, tipo_curso, id_usuario_curso )  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $tipoUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $titulo, PDO::PARAM_STR);
        $stmt->bindValue(3, $duracion, PDO::PARAM_STR);
        $stmt->bindValue(4, $responsable, PDO::PARAM_STR);
        $stmt->bindValue(5, $status, PDO::PARAM_INT);
        $stmt->bindValue(6, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(7, $frecuencia, PDO::PARAM_STR);
        $stmt->bindValue(8, $capacitacion, PDO::PARAM_STR);
        $stmt->bindValue(9, $induccion, PDO::PARAM_STR);
        $stmt->bindValue(10, $codigoCurso, PDO::PARAM_INT);
        $stmt->bindValue(11, $codigoListaAsistencia, PDO::PARAM_INT);
        $stmt->bindValue(12, $normaSeguridad, PDO::PARAM_INT);
        $stmt->bindValue(13, $clave, PDO::PARAM_STR);
        $stmt->bindValue(14, $tipoCurso, PDO::PARAM_STR);
        $stmt->bindValue(15, $idUsuarioCurso, PDO::PARAM_INT);

        if($idCurso > 0) $stmt->bindValue(16, $idCurso, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCurso'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el curso. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursos($inicio, $registros){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM cursos_internos as ci
inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
 ORDER BY ci.status DESC, titulo  LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function buscarCurso($inicio, $registros, $termino){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM cursos_internos WHERE `titulo` LIKE ? ORDER BY id_cursos_internos ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de los cursos';
        }

        return $response;
    }

    public function obtenerCurso($idCurso){
        $sql = "SELECT * FROM cursos_internos WHERE id_cursos_internos = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCurso, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['curso'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los '
                . 'datos del curso. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursosCapacitacionPorUsuario($inicio, $registros){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM cursos_internos as ci
inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
 ORDER BY ci.status DESC, titulo  LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function eliminarRolParticipantesCurso( $idCursoInterno){

        $sql = "delete from tipo_usuario_curso  where id_cursos_internos=  ? ";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCursoInterno, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCurso'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al asignar los usuarios al curso. ' . TICKETS;
        }

        return $response;
    }

    public function agregarRolParticipantesCurso($tipoUsuario, $idCursoInterno){

        $sql = "INSERT INTO tipo_usuario_curso  (tipo_usuario, id_cursos_internos)  VALUES (?, ?); ";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $tipoUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCursoInterno, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCurso'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al asignar los usuarios al curso. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerRolesCurso($idCurso){
        $sql = "SELECT * FROM tipo_usuario_curso WHERE id_cursos_internos = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCurso, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['roles'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los '
                . 'roles del curso. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursosCapacitacionPorAsignar($fecha){
        $sql = " select * from cursos_internos where  fecha = ?  and status = 1 and capacitacion = 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los '
                . 'los cursos por asignar ' . TICKETS;
        }

        return $response;
    }

    public function actualizarFechaCursoCapacitacion($fecha, $idCursoInterno){
        $sql = " update cursos_internos set fecha = ? where id_cursos_internos = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idCursoInterno, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar '
                . 'la proxia fecha del curso ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursosInduccionVencidos($fecha, $idUsuario){
        $sql = "select * from curso_interno_induccion as cii
inner join cursos_internos as ci on ci.id_cursos_internos = cii.id_cursos_internos
where cii.status_examen = 'progreso' and fecha_limite <= ? and cii.id_usuario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);


        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los cursos de induccion vencidos ' . TICKETS;
        }

        return $response;
    }

    public function totalListasAsistenciaEnHistorial($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $clave, $tipoCurso){
        $sql = " select * from curso_interno_capacitacion as cic 
 inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
 inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
 where u.Id_Sucursal = ? and ci.tipo_curso = ? ";
        if ($grupo != ""){
            $sql = $sql." and ci.codigo_lista_asistencia = ? ";
        }
        if ($status != ""){
            $sql = $sql." and cic.status_curso = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and cic.fecha_inicio >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and cic.fecha_inicio <= ? ";
        }
        if ($clave != ""){
            $sql = $sql." and cic.id_cursos_internos = ? ";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipoCurso, PDO::PARAM_STR);
        $posisionNuevoBind = 3;

        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR);  $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind,  $clave, PDO::PARAM_STR);
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de los cursos ' . TICKETS;
        }

        return $response;
    }

    public function obtenerHistorialListasAsistenciaCalidad($sucursal, $grupo, $status, $desdeFecha, $hastaFecha,  $inicio, $registros, $clave){
        $sql = " select *, concat(u.Nombre, ' ', u.Apellido_Paterno, ' ', u.Apellido_Materno) as 'nombre_responsable' from curso_interno_capacitacion as cic 
 inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
 inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
 inner join codigo_calidad as ns on ns.id_codigo_calidad = ci.codigo_lista_asistencia
 where u.Id_Sucursal = ? and ci.tipo_curso = 'calidad' ";
        if ($grupo != ""){
            $sql = $sql." and ci.codigo_lista_asistencia = ? ";
        }
        if ($status != ""){
            $sql = $sql." and cic.status_curso = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and cic.fecha_inicio >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and cic.fecha_inicio <= ? ";
        }
        if ($clave != ""){
            $sql = $sql." and cic.id_cursos_internos = ? ";
        }
        $sql = $sql." order by ns.nombre_norma, ci.id_cursos_internos, cic.fecha_inicio LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $posisionNuevoBind = 2;
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind, $clave, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        $stmt->bindValue($posisionNuevoBind, $inicio, PDO::PARAM_INT); $posisionNuevoBind ++;
        $stmt->bindValue($posisionNuevoBind, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function totalCursosEnHistorial($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $clave, $tipoCurso){
        $sql = " select * from curso_interno_participantes as cip 
inner join curso_interno_capacitacion as cic on cic.id_curso_interno_capacitacion = cip.id_curso_interno_capacitacion
 inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
 inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
 where u.Id_Sucursal = ?  and ci.tipo_curso = ?  ";
        if ($grupo != ""){
            $sql = $sql." and ci.codigo_curso = ? ";
        }
        if ($status != ""){
            $sql = $sql." and cip.status_examen = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and cic.fecha_inicio >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and cic.fecha_inicio <= ? ";
        }
        if ($clave != ""){
            $sql = $sql." and cic.id_cursos_internos = ? ";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipoCurso, PDO::PARAM_INT);
        $posisionNuevoBind = 3;

        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR);  $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind,  $clave, PDO::PARAM_STR);
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de los cursos ' . TICKETS;
        }

        return $response;
    }

    public function obtenerHistorialCursosCalidad($sucursal, $grupo, $status, $desdeFecha, $hastaFecha,  $inicio, $registros, $clave){
        $sql = "  select *, concat(u.Nombre, ' ', u.Apellido_Paterno, ' ', u.Apellido_Materno) as 'nombre_responsable' from curso_interno_participantes as cip 
inner join curso_interno_capacitacion as cic on cic.id_curso_interno_capacitacion = cip.id_curso_interno_capacitacion
 inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
 inner join usuarios as u on u.Id_Usuario = cip.id_usuario
 inner join codigo_calidad as ns on ns.id_codigo_calidad = ci.codigo_curso
 where u.Id_Sucursal = ? and ci.tipo_curso = 'calidad' ";
        if ($grupo != ""){
            $sql = $sql." and ci.codigo_curso = ? ";
        }
        if ($status != ""){
            $sql = $sql." and cip.status_examen = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and cic.fecha_inicio >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and cic.fecha_inicio <= ? ";
        }
        if ($clave != ""){
            $sql = $sql." and cic.id_cursos_internos = ? ";
        }
        $sql = $sql." order by ns.nombre_norma, ci.id_cursos_internos, cic.fecha_inicio LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $posisionNuevoBind = 2;
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind, $clave, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        $stmt->bindValue($posisionNuevoBind, $inicio, PDO::PARAM_INT); $posisionNuevoBind ++;
        $stmt->bindValue($posisionNuevoBind, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function getAllCursosCapacitacionPorUsuario($idUsuario, $page = -1){
        $limit = '';
        if($page > -1){
            $ini = $page * 20;
            $limit = " LIMIT $ini, 20 ";
        }
        $sql = "select SQL_CALC_FOUND_ROWS * from curso_interno_participantes as cip 
inner join  curso_interno_capacitacion as cic on cic.id_curso_interno_capacitacion = cip.id_curso_interno_capacitacion
inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
inner join usuarios as u on u.Id_Usuario = cip.id_usuario
where cip.id_usuario = ? order by cic.fecha_inicio desc $limit ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los cursos de capacitacion del usuarioo. ' . TICKETS;
        }

        return $response;
    }

    public function getAllCursosInduccionPorUsuario($idUsuario, $page = -1){
        $limit = '';
        if($page > -1){
            $ini = $page * 20;
            $limit = " LIMIT $ini, 20 ";
        }
        $sql = "select SQL_CALC_FOUND_ROWS * from curso_interno_induccion as cii
inner join cursos_internos as ci on ci.id_cursos_internos = cii.id_cursos_internos
inner join usuarios as u on u.Id_Usuario = cii.id_usuario
where cii.id_usuario = ? order by cii.fecha_limite desc $limit ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los cursos de capacitacion del usuarioo. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerUltimaClaveCursoSeguridad($idNorma){
        $sql = "select * from cursos_internos where id_normas_seguridad = ? order by id_cursos_internos desc";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idNorma, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['norma'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la '
                . 'ultima norma del curso de seguridad ' . TICKETS;
        }

        return $response;
    }

    public function obtenerUltimaClaveCursoCalidad(){
        $sql = "select * from cursos_internos where tipo_curso = 'calidad' order by id_cursos_internos desc";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['norma'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la '
                . 'ultima norma del curso de seguridad ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursosPorTipoDeCurso($tipoCurso, $grupo){
        $sql = " select * from cursos_internos where tipo_curso = ? and id_normas_seguridad = ? group by id_normas_seguridad;
";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $tipoCurso, PDO::PARAM_STR);
        $stmt->bindValue(2, $grupo, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los '
                . 'datos de los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerHistorialListasAsistenciaSeguridad($sucursal, $grupo, $status, $desdeFecha, $hastaFecha,  $inicio, $registros, $clave){
        $sql = " select *, concat(u.Nombre, ' ', u.Apellido_Paterno, ' ', u.Apellido_Materno) as 'nombre_responsable' from curso_interno_capacitacion as cic 
 inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
 inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
inner join normas_seguridad as ns on ns.id_normas_seguridad = ci.id_normas_seguridad
 where u.Id_Sucursal = ? and ci.tipo_curso = 'seguridad' ";
        if ($grupo != ""){
            $sql = $sql." and ci.id_normas_seguridad = ? ";
        }
        if ($status != ""){
            $sql = $sql." and cic.status_curso = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and cic.fecha_inicio >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and cic.fecha_inicio <= ? ";
        }
        if ($clave != ""){
            $sql = $sql." and ci.clave = ? ";
        }
        $sql = $sql." order by ns.nombre_norma, ci.id_cursos_internos, cic.fecha_inicio LIMIT ?, ?";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $posisionNuevoBind = 2;
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind, $clave, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        $stmt->bindValue($posisionNuevoBind, $inicio, PDO::PARAM_INT); $posisionNuevoBind ++;
        $stmt->bindValue($posisionNuevoBind, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerHistorialCursosSeguridad($sucursal, $grupo, $status, $desdeFecha, $hastaFecha,  $inicio, $registros, $clave){
        $sql = "  select *, concat(u.Nombre, ' ', u.Apellido_Paterno, ' ', u.Apellido_Materno) as 'nombre_responsable' from curso_interno_participantes as cip 
inner join curso_interno_capacitacion as cic on cic.id_curso_interno_capacitacion = cip.id_curso_interno_capacitacion
 inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
 inner join usuarios as u on u.Id_Usuario = cip.id_usuario
 inner join normas_seguridad as ns on ns.id_normas_seguridad = ci.id_normas_seguridad
 where u.Id_Sucursal = ? and ci.tipo_curso = 'seguridad' ";
        if ($grupo != ""){
            $sql = $sql." and ci.id_normas_seguridad = ? ";
        }
        if ($status != ""){
            $sql = $sql." and cip.status_examen = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and cic.fecha_inicio >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and cic.fecha_inicio <= ? ";
        }
        if ($clave != ""){
            $sql = $sql." and ci.clave = ? ";
        }
        $sql = $sql." order by ns.nombre_norma, ci.id_cursos_internos, cic.fecha_inicio LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $posisionNuevoBind = 2;
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind, $clave, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        $stmt->bindValue($posisionNuevoBind, $inicio, PDO::PARAM_INT); $posisionNuevoBind ++;
        $stmt->bindValue($posisionNuevoBind, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de los cursos. ' . TICKETS;
        }

        return $response;
    }
    
       public function obtenerCursoCapacitacion($idCursoCapacitacion){
        $sql = "select * from curso_interno_capacitacion as cic
inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
where cic.id_curso_interno_capacitacion = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCursoCapacitacion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetch(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los datos del curso. ' . TICKETS;
        }

        return $response;
    }
    
     public function obtenerRazonesDeRechazo($idAsignada ){

        $sql = "select * from historial_rechazos_cursos_interno  where id_curso_interno_capacitacion  = ? ";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idAsignada, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['razones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento ocurrio un error al agregar la razon de rechazo'
                . TICKETS;
        }
        return $response;
    }

    public function guardarRazonHistorialRechazo($idCursoCapacitacion,$razon){

            $sql = "INSERT INTO historial_rechazos_cursos_interno (id_curso_interno_capacitacion , razon )  VALUES (?, ?); ";


        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCursoCapacitacion, PDO::PARAM_INT);
        $stmt->bindValue(2, $razon, PDO::PARAM_STR);



        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCurso'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar la razon de rechazon en el historial. ' . TICKETS;
        }

        return $response;
    }
    
    public function obtenerCursosRepetidos($fecha, $idCurso, $tipo){
        $sql = "select tuc.* from cursos_internos as c 
inner join tipo_usuario_curso as tuc on tuc.id_cursos_internos = c.id_cursos_internos
where c.fecha = ? and c.id_cursos_internos != ? and tuc.tipo_usuario = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idCurso, PDO::PARAM_INT);
        $stmt->bindValue(3, $tipo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['curso'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, existe un curso con la misma fecha. ' . TICKETS;
        }

        return $response;
    }






}
