<?php
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DetalleCkeckList.php';

class DetalleCheckListDao  extends Model {

	public function __construct(){
		parent::__construct();
	}

	public function guardarCheckList(DetalleCkeckList $d){
		$sql = "INSERT INTO checklist_detalle (Llantas_Salida, 	Llantas_Entrada, Observaciones_Llantas_Salida, 
		Observaciones_Llantas_Entrada, Luces_Delanteras_Salida, Luces_Delanteras_Entrada, Observaciones_Luces_Delanteras_Salida, Observaciones_Luces_Delanteras_Entrada, Intermitentes_Salida, Intermitentes_Entrada, Observaciones_Intermitentes_Salida, Observaciones_Intermitentes_Entrada, Luz_Reversa_Salida, Luz_Reversa_Entrada, Observaciones_Luz_Reversa_Salida, Observaciones_Luz_Reversa_Entrada, Alarma_Reversa_Salida, Alarma_Reversa_Entrada, Observaciones_Alarma_Salida, Observaciones_Alarma_Entrada, Freno_Mano_Salida, Freno_Mano_Entrada, Observaciones_Freno_Mano_Salida, Observaciones_Freno_Mano_Entrada, Claxon_Entrada, Claxon_Salida, Observaciones_Claxon_Salida, Observaciones_Claxon_Entrada, Espejos_Entrada, Espejos_Salida, Observaciones_Espejos_Salida, Observaciones_Espejos_Entrada, Indicador_Tablero_Salida, Indicador_Tablero_Entrada, Observaciones_Indicador_Tablero_Salida, Observaciones_Indicador_Tablero_Entrada, Combustible_Salida, Combustible_Entrada, Observaciones_Combustible_Salida, Observaciones_Combustible_Entrada, Limpieza_Entrada, Limpieza_Salida, Observaciones_Limpieza_Entrada, Observaciones_Limpieza_Salida, Golpes_Entrada, Golpes_Salida, Observaciones_Golpes_Entrada, Observaciones_Golpes_Salida, Id_CheckList) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; 
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindvalue(1, $d->__get('_llantasSalida'), PDO::PARAM_INT);
		$stmt->bindValue(2, $d->__get('_llantasEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(3, $d->__get('_observacionesLlantasSalida'), PDO::PARAM_STR);
		$stmt->bindValue(4, $d->__get('_observacionesLlantasEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(5, $d->__get('_lucesDelanterasSalida'), PDO::PARAM_INT);
		$stmt->bindValue(6, $d->__get('_lucesDelanterasEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(7, $d->__get('_observacionesLucesDelanterasSalida'), PDO::PARAM_STR);
		$stmt->bindValue(8, $d->__get('_observacionesLucesDelaterasEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(9, $d->__get('_intermitentesSalida'), PDO::PARAM_INT);
		$stmt->bindValue(10, $d->__get('_intermitentesEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(11, $d->__get('_observacionesIntermitentesSalida'), PDO::PARAM_STR);
		$stmt->bindValue(12, $d->__get('_observacionesIntermitentesEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(13, $d->__get('_luzReversaSalida'), PDO::PARAM_INT);
		$stmt->bindValue(14, $d->__get('_luzReversaEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(15, $d->__get('_observacionesLuzReversaSalida'), PDO::PARAM_STR);
		$stmt->bindvalue(16, $d->__get('_observacionesLuzReversaEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(17, $d->__get('_alarmaReversaSalida'), PDO::PARAM_INT);
		$stmt->bindValue(18, $d->__get('_alarmaReversaEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(19, $d->__get('_observacionesAlarmaReversaSalida'), PDO::PARAM_STR);
		$stmt->bindValue(20, $d->__get('_observacionesAlarmaReversaEntrada'), PDO::PARAM_STR);
		$stmt->bindvalue(21, $d->__get('_frenoManoSalida'), PDO::PARAM_INT);
		$stmt->bindValue(22, $d->__get('_frenoManoEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(23, $d->__get('_observacionesFrenoManoSalida'), PDO::PARAM_STR);
		$stmt->bindvalue(24, $d->__get('_observacionesFrenoManoEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(25, $d->__get('_claxonEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(26, $d->__get('_claxonSalida'), PDO::PARAM_INT);
		$stmt->bindValue(27, $d->__get('_observacionesClaxonSalida'), PDO::PARAM_STR);
		$stmt->bindValue(28, $d->__get('_observacionesClaxonEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(29, $d->__get('_espejosEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(30, $d->__get('_espejosSalida'), PDO::PARAM_INT);
		$stmt->bindValue(31, $d->__get('_observacionesEspejosSalida'), PDO::PARAM_STR);
		$stmt->bindValue(32, $d->__get('_observacionesEspejosEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(33, $d->__get('_indicadorTableroSalida'), PDO::PARAM_INT);
		$stmt->bindValue(34, $d->__get('_indicadorTableroEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(35, $d->__get('_observacionesIndicadorTableroEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(36, $d->__get('_observacionesIndicadorTableroEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(37, $d->__get('_combustibleSalida'), PDO::PARAM_INT);
		$stmt->bindValue(38, $d->__get('_combustibleEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(39, $d->__get('_observacionesCombustibleSalida'), PDO::PARAM_STR);
		$stmt->bindValue(40, $d->__get('_observacionesCombustibleEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(41, $d->__get('_limpiezaUnidadEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(42, $d->__get('_limpiezaUnidadSalida'), PDO::PARAM_INT);
		$stmt->bindValue(43, $d->__get('_observacionesLimpiezaEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(44, $d->__get('_observacionesLimpiezaSalida'), PDO::PARAM_STR);
		$stmt->bindValue(45, $d->__get('_golpesEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(46, $d->__get('_golpesSalida'), PDO::PARAM_INT);
		$stmt->bindValue(47, $d->__get('_observacionesGolpesEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(48, $d->__get('_observacionesGolpesSalida'), PDO::PARAM_STR);
		$stmt->bindValue(49, $d->__get('_idCheckList'), PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;			
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al guardar el detalle del check list. ' . TICKETS;
		}

		return $response;
	}

	public function guardaEntrada(DetalleCkeckList $d){
		$sql = "UPDATE checklist_detalle SET Llantas_Entrada = ?, Observaciones_Llantas_Entrada = ?, Luces_Delanteras_Entrada = ?, Observaciones_Luces_Delanteras_Entrada = ?, Intermitentes_Entrada = ?, Observaciones_Intermitentes_Entrada = ?, Luz_Reversa_Entrada = ?, Observaciones_Luz_Reversa_Entrada = ?, Alarma_Reversa_Entrada = ?, Observaciones_Alarma_Entrada = ?, Freno_Mano_Entrada = ?, Observaciones_Freno_Mano_Entrada = ?, Claxon_Entrada = ?, Observaciones_Claxon_Entrada = ?, Espejos_Entrada = ?, Observaciones_Espejos_Entrada = ?, Indicador_Tablero_Entrada = ?, Observaciones_Indicador_Tablero_Entrada = ?, Combustible_Entrada = ?, Observaciones_Combustible_Entrada = ?, Limpieza_Entrada = ?, Observaciones_Limpieza_Entrada = ?, Golpes_Entrada = ?, Observaciones_Golpes_Entrada = ? WHERE Id_CheckList = ?";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $d->__get('_llantasEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(2, $d->__get('_observacionesLlantasEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(3, $d->__get('_lucesDelanterasEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(4, $d->__get('_observacionesLucesDelaterasEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(5, $d->__get('_intermitentesEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(6, $d->__get('_observacionesIntermitentesEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(7, $d->__get('_luzReversaEntrada'), PDO::PARAM_INT);
		$stmt->bindvalue(8, $d->__get('_observacionesLuzReversaEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(9, $d->__get('_alarmaReversaEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(10, $d->__get('_observacionesAlarmaReversaEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(11, $d->__get('_frenoManoEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(12, $d->__get('_observacionesFrenoManoEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(13, $d->__get('_claxonEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(14, $d->__get('_observacionesClaxonEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(15, $d->__get('_espejosEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(16, $d->__get('_observacionesEspejosEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(17, $d->__get('_indicadorTableroEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(18, $d->__get('_observacionesIndicadorTableroEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(19, $d->__get('_combustibleEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(20, $d->__get('_observacionesCombustibleEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(21, $d->__get('_limpiezaUnidadEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(22, $d->__get('_observacionesLimpiezaUnidadEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(23, $d->__get('_golpesEntrada'), PDO::PARAM_INT);
		$stmt->bindValue(24, $d->__get('_observacionesGolpesEntrada'), PDO::PARAM_STR);
		$stmt->bindValue(25, $d->__get('_idCheckList'), PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());	
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al guardar los datos. ' . TICKETS;
		}

		return $response;
	}
}