<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

class DetalleEntregasForecastDao extends Model
{
	public function __construct() {
        parent::__construct();
    }


    public function altaDetalleEntregasForecast($mesActual,  $mes1, $mes2, $mes3, $idProducto,  $Id_Entregas_Forecast)
    {
        $sql = "INSERT INTO `detalle_entregas_forecast` (`MesActual`, `Mes1`, `Mes2`, Mes3, Id_Producto, Id_Entregas_Forecast ) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $mesActual, PDO::PARAM_STR);
        $stmt->bindValue(2, $mes1, PDO::PARAM_STR);
        $stmt->bindValue(3, $mes2, PDO::PARAM_STR);
        $stmt->bindValue(4, $mes3, PDO::PARAM_STR);
        $stmt->bindValue(5, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(6, $Id_Entregas_Forecast, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idEntregasForecast'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el detalle del reporte de forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerReporteDetalleEntregaForecast($fecha, $idSucursal, $idProveedor)
    {
        $sql = "select * from detalle_entregas_forecast as def
inner join entregas_forecast as ef on ef.Id_Entregas_Forecast = def.Id_Entregas_Forecast
inner join productos as p on p.Id_Producto = def.Id_Producto
where ef.Fecha = ? and ef.Id_Sucursal = ? and ef.Id_Proveedor = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $idProveedor, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener el reporte de forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTotalDetalleEntregaForecast($fecha, $idSucursal, $idProveedor)
    {
        $sql = "select sum(def.MesActual) as totalMesActual, sum( def.Mes1) as totalMes1, sum( def.Mes2) as totalMes2, sum( def.Mes3) as totalMes3, pr.Nombre 
from detalle_entregas_forecast as def
inner join entregas_forecast as ef on ef.Id_Entregas_Forecast = def.Id_Entregas_Forecast
inner join productos as p on p.Id_Producto = def.Id_Producto
inner join proveedores as pr on pr.Id_Proveedor = ef.Id_Proveedor
where ef.Fecha = ? and ef.Id_Sucursal = ? and ef.Id_Proveedor = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $idProveedor, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener el reporte de forecast. ' . TICKETS;
        }

        return $response;
    }




}