<?php
/**
 * Description of DetalleForecastAnualDao
 *
 * @author sistemas
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'DetalleForecastAnual.php';

class DetalleForecastAnualDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(DetalleForecastAnual $d)
    {
        $sql = "INSERT INTO `detalle_forecast` (`idProducto`, `idCliente`, `tipo`, `clasificacion`,  `enero`, "
                . "`febrero`, `marzo`, `abril`, `mayo`, `junio`, `julio`, `agosto`, `septiembre`, "
                . "`octubre`, `noviembre`, `diciembre`, `total`, `totalLitros`, `idforecast`) VALUES (?, ?, ?, ?, ?, "
                . "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $d->__get('_idProducto'), PDO::PARAM_INT);
        $stmt->bindValue(2, $d->__get('_idCliente'), PDO::PARAM_INT);
        $stmt->bindValue(3, $d->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(4, $d->__get('_clasificacion'), PDO::PARAM_STR);
        $stmt->bindValue(5, $d->__get('_enero'), PDO::PARAM_INT);
        $stmt->bindValue(6, $d->__get('_febrero'), PDO::PARAM_INT);
        $stmt->bindValue(7, $d->__get('_marzo'), PDO::PARAM_INT);
        $stmt->bindValue(8, $d->__get('_abril'), PDO::PARAM_INT);
        $stmt->bindValue(9, $d->__get('_mayo'), PDO::PARAM_INT);
        $stmt->bindValue(10, $d->__get('_junio'), PDO::PARAM_INT);
        $stmt->bindValue(11, $d->__get('_julio'), PDO::PARAM_INT);
        $stmt->bindValue(12, $d->__get('_agosto'), PDO::PARAM_INT);
        $stmt->bindValue(13, $d->__get('_septiembre'), PDO::PARAM_INT);
        $stmt->bindValue(14, $d->__get('_octubre'), PDO::PARAM_INT);
        $stmt->bindValue(15, $d->__get('_noviembre'), PDO::PARAM_INT);
        $stmt->bindValue(16, $d->__get('_diciembre'), PDO::PARAM_INT);
        $stmt->bindValue(17, $d->__get('_total'), PDO::PARAM_INT);
        $stmt->bindValue(18, $d->__get('_totalLitros'), PDO::PARAM_INT);
        $stmt->bindValue(19, $d->__get('_idForecast'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al guardar el detalle del forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerForecastAnual($idCliente, $idProducto, $tipo, $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast` WHERE `idProducto` = ? AND `idCliente` = ? AND `tipo` = ? AND `idForecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(3, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(4, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['datosForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function existeDetalleForecast($idCliente, $idProducto, $tipo, $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast` WHERE `idProducto` = ? AND `idCliente` = ? AND `tipo` = ? AND `idForecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(3, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(4, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al validar el forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function eliminaForecast($idCliente, $idProducto, $tipo, $idForecast)
    {
        $sql = "DELETE FROM `detalle_forecast` WHERE `idCliente` = ? AND `idProducto` = ? AND `tipo` = ? AND `idForecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(3, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(4, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al eliminar el forecast. ' . TICKETS;
        }
        
        return $response;
            
    }
    
    public function obtenerTotalLitros($idForecast)
    {
        $sql = "SELECT SUM(`totalLitros`) AS `totalLitros` FROM `detalle_forecast` WHERE `idForecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['totalLitros'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al calcular el total de litros acumulados. ' . TICKETS;
        }
        
        return $response;
    }   
    
    public function obtenerAcumuladoCliente($idCliente, $tipo, $idForecast)
    {
        $sql = "SELECT SUM(`totalLitros`) AS `totalLitros` FROM `detalle_forecast` WHERE `idCliente` = ? AND `tipo` = ? AND `idForecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['totalAcumulado'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al calcular el total de litros acumulados del cliente. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerForecastProducto($idProducto, $categoria, $idForecast)
    {
        $sql = "SELECT SUM(`totalLitros`) AS `totalLitros` FROM `detalle_forecast` WHERE `idProducto` = ? AND `clasificacion` = ? AND  `idForecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(2, $categoria, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerForecastProductoCliente($idProducto, $tipo,  $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast` WHERE `idProducto` = ? AND `idForecast` = ? AND `tipo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(2, $idForecast, PDO::PARAM_INT);
        $stmt->bindValue(3, $tipo, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerProductosClientePorFamilia($idCliente, $idFamilia, $tipo)
    {
        $sql = "SELECT * FROM `detalle_forecast` INNER JOIN `productos` ON "
                . "`productos`.`Id_Producto` = `detalle_forecast`.`idProducto` "
                . "WHERE `detalle_forecast`.`idCliente` = ? AND `productos`.`Id_Subfamilia` = ? AND "
                . "`detalle_forecast`.`tipo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $idFamilia, PDO::PARAM_INT);
        $stmt->bindValue(3, $tipo, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['productos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los productos. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerTotalForecastCliente($idCliente, $tipo, $idForecast)
    {
        $sql = "SELECT SUM(`enero`) AS `Enero`, SUM(`febrero`) AS `Febrero`, SUM(`marzo`) AS `Marzo`, "
                . "SUM(`abril`) AS `Abril`, SUM(`mayo`) AS `Mayo`, SUM(`junio`) AS `Junio`, SUM(`julio`) AS `Julio`, SUM(`agosto`) AS `Agosto`, "
                . "SUM(`septiembre`) AS `Septiembre`, SUM(`octubre`) AS `Octubre`, SUM(`noviembre`) AS `Noviembre`, "
                . "SUM(`diciembre`) AS `Diciembre`, SUM(`totalLitros`) AS `Total_Acumulado` FROM `detalle_forecast` WHERE `idCliente` = ? AND `tipo` = ? AND `idForecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['totalAcumulado'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el foracast. ' . TICKETS;
        }
        
        return $response;
        
    }
    
    public function obtenerForecastClienteProducto($idProducto, $idCliente, $tipo, $categoria, $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast` WHERE `idProducto` = ? AND `idCliente` = ? AND `tipo` = ? AND `clasificacion` = ? AND `idforecast` = ?";                
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(3, $tipo, PDO::PARAM_STR);
        $stmt->bindvalue(4, $categoria, PDO::PARAM_STR);
        $stmt->bindValue(5, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $$e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los datos del forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerForecastCliente($idCliente, $tipo, $categoria, $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast` WHERE `idCliente` = ? AND `tipo` = ? AND `clasificacion` = ? AND `idforecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $categoria, PDO::PARAM_STR);
        $stmt->bindValue(4, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function eliminarForecastCliente($idCliente, $tipo, $idForecast)
    {
        $sql = "DELETE FROM `detalle_forecast` WHERE `idCliente` = ? AND `tipo` = ? AND `idforecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = true;
            $response['error'] = ':( Lo siento, ocurrió un error al eliminar el detalle del forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerTotalesPorVendedor($idCliente, $tipo, $idForecast)
    {
        $sql = "SELECT * from detalle_forecast inner join productos on productos.Id_Producto = detalle_forecast.idProducto "
                . "where detalle_forecast.idCliente = ? AND detalle_forecast.tipo = ? AND idForecast = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['totalForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el total del forecast. '  . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerForecastCompleto($idForecast)
    {
        $sql = "SELECT * FROM detalle_forecast WHERE clasificacion = 'forecast' AND idForecast = ? GROUP BY idProducto";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento ocurrió un error al obtener el forecast. ' . TICKETS;
        }
        
        return $response;
    }       
    
    public function obtenerForecastClienteCompleto($idCliente, $tipo, $idForeacast)
    {
        $sql = "SELECT * FROM detalle_forecast WHERE `idCliente` = ? AND `tipo` = ? AND idForecast = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForeacast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast del cliente. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerForecastPorMesCliente($idCliente, $idProducto, $tipo)
    {
        $sql = "SELECT * FROM `detalle_forecast` WHERE `clasificacion` = 'forecast' AND `idCliente` = ? AND `tipo` = ? "
                . "AND `idProducto` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idProducto, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast anual. ' . TICKETS;
        }
        
        return $response;
    }

    public function obtenerForecastGlobal($idForecast){
        $sql = "SELECT * FROM detalle_forecast WHERE idForecast = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['detalleForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el detalle del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastClienteProveedor($idCliente, $tipo, $categoria, $idForecast, $idProveedor)
    {
        $sql = "SELECT detalle_forecast.* FROM detalle_forecast "
        . " inner join productos on productos.Id_Producto = detalle_forecast.idProducto"
        . " WHERE detalle_forecast.idCliente = ? AND detalle_forecast.tipo = ? AND detalle_forecast.clasificacion = ? AND detalle_forecast.idforecast = ?";

        if($idProveedor != 0){
            $sql = $sql." and productos.Id_Proveedor = ?";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $categoria, PDO::PARAM_STR);
        $stmt->bindValue(4, $idForecast, PDO::PARAM_INT);
        if($idProveedor != 0){
            $stmt->bindValue(5, $idProveedor, PDO::PARAM_INT);
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastClienteProductoProveedor($idProducto, $idCliente, $tipo, $categoria, $idForecast, $idProveedor)
    {
        $sql = "SELECT detalle_forecast.* FROM `detalle_forecast` "
        . " inner join productos on productos.Id_Producto = detalle_forecast.idProducto"
        . " WHERE detalle_forecast.idProducto = ? AND detalle_forecast.idCliente = ? AND detalle_forecast.tipo = ? AND detalle_forecast.clasificacion = ? AND detalle_forecast.idforecast = ?";
        if($idProveedor != 0){
            $sql = $sql." and productos.Id_Proveedor = ?";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(3, $tipo, PDO::PARAM_STR);
        $stmt->bindvalue(4, $categoria, PDO::PARAM_STR);
        $stmt->bindValue(5, $idForecast, PDO::PARAM_INT);
        if($idProveedor != 0){
            $stmt->bindValue(6, $idProveedor, PDO::PARAM_INT);
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $$e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los datos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTotalForecastClienteProveedor($idCliente, $tipo, $idForecast, $idProveedor)
    {
        $sql = "SELECT SUM(df.enero) AS `Enero`, SUM(df.febrero) AS `Febrero`, SUM(df.marzo) AS `Marzo`, "
            . " SUM(df.abril) AS `Abril`, SUM(df.mayo) AS `Mayo`, SUM(df.junio) AS `Junio`, SUM(df.julio) AS `Julio`, SUM(df.agosto) AS `Agosto`, "
            . "SUM(df.septiembre) AS `Septiembre`, SUM(df.octubre) AS `Octubre`, SUM(df.noviembre) AS `Noviembre`, "
            . " SUM(df.diciembre) AS `Diciembre`, SUM(df.totalLitros) AS `Total_Acumulado`, df.idProducto FROM detalle_forecast as df "
            . " inner join productos as p on p.Id_Producto = df.idProducto "
            . " WHERE df.idCliente = ? AND df.tipo = ? AND df.idForecast = ?";

        if($idProveedor != 0){
            $sql = $sql." and p.Id_Proveedor = ?";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        if($idProveedor != 0){
            $stmt->bindValue(4, $idProveedor, PDO::PARAM_INT);
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['totalAcumulado'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el foracast. ' . TICKETS;
        }

        return $response;

    }
    
     public function obtenerClientesForecastAnual($year, $idUsuario)
    {
        $sql = " SELECT * FROM detalle_forecast as df
inner join forecast_anual as fa on fa.Id_Forecast = df.idforecast
inner join clientes as c on c.Id_Cliente = df.idCliente
WHERE fa.Year = ? and df.tipo = 'cliente' and c.Id_Usuario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['clientes'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = true;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los clientes del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerSospechosoForecastAnual($year, $idUsuario)
    {
        $sql = "SELECT * FROM detalle_forecast as df
inner join forecast_anual as fa on fa.Id_Forecast = df.idforecast
inner join sospechoso as c on c.Id_Sospechoso = df.idCliente
WHERE fa.Year = ? and df.tipo = 'prospecto' and c.Id_Vendedor = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['sospechoso'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = true;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los sospechoso del forecast. ' . TICKETS;
        }

        return $response;
    }
}
