<?php
/**
 * Description of DetalleForecastMensualDao
 *
 * @author sistemas
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'DetalleForecastMensual.php';

class DetalleForecastMensualDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(DetalleForecastMensual $f)
    {        
        $sql = "INSERT INTO `detalle_forecast_mensual` (`Id_Cliente`, `Tipo`, `Id_Producto`, `Semana1`, `Semana2`, `Semana3`, `Semana4`, `Mes1`, `Mes2`, `Mes3`, `Status`, `Id_Forecast`) "
                . "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";   
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $f->__get('_idCliente'), PDO::PARAM_INT);
        $stmt->bindValue(2, $f->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(3, $f->__get('_idProducto'), PDO::PARAM_INT);
        $stmt->bindValue(4, $f->__get('_semana1'), PDO::PARAM_INT);
        $stmt->bindValue(5, $f->__get('_semana2'), PDO::PARAM_INT);
        $stmt->bindValue(6, $f->__get('_semana3'), PDO::PARAM_INT);
        $stmt->bindValue(7, $f->__get('_semana4'), PDO::PARAM_INT);
        $stmt->bindValue(8, $f->__get('_mes1'), PDO::PARAM_INT);
        $stmt->bindValue(9, $f->__get('_mes2'), PDO::PARAM_INT);
        $stmt->bindValue(10, $f->__get('_mes3'), PDO::PARAM_INT);
        $stmt->bindValue(11, $f->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(12, $f->__get('_idForecast'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el detalle del forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function eliminarDetalle($idCliente, $tipo, $idForecast)
    {
        $sql = "DELETE FROM `detalle_forecast_mensual` WHERE `Id_Cliente` = ? AND `Tipo` = ? AND `Id_Forecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al eliminar el detalle del forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerForecastProductoCliente($idCliente, $tipo, $idProducto, $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast_mensual` WHERE `Id_Cliente` = ? AND `Tipo` = ? AND `Id_Producto` = ? AND `Id_Forecast` = ?";                
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindvalue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(4, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['detalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el detalle del forecast. ' . TICKETS;
        }
        
        return $response;
    }

    public function obtenerForecastProductoClienteAutorizado($idCliente, $tipo, $idProducto, $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast_mensual` WHERE `Id_Cliente` = ? AND `Tipo` = ? AND `Id_Producto` = ? AND `Id_Forecast` = ? AND Status = 1";                
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindvalue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(4, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['detalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el detalle del forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function hayForecast($idCliente, $tipo, $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast_mensual` WHERE `Id_Cliente` = ? AND `Tipo` = ? AND `Id_Forecast` = ?";        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al validar el forecast del cliente. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function validarForecastCliente($idCliente, $fecha)
    {
        $sql = "SELECT `forecast_mensual`.`Id_Forecast` FROM `forecast_mensual` INNER JOIN `detalle_forecast_mensual` ON "
                . "`detalle_forecast_mensual`.`Id_Forecast` = `forecast_mensual`.`Id_Forecast` WHERE "
                . "`detalle_forecast_mensual`.`Id_Cliente` = ? AND `forecast_mensual`.`Fecha` >= ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al validar el forecast del cliente. ' . TICKETS;
        }
        
        return $response;
    }

    public function obtenerDetalleForecastCliente($idCliente, $tipo, $idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast_mensual` WHERE `Id_Cliente` = ? AND `Tipo` = ? AND `Id_Forecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['detalleForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast del cliente. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerDetalleForecastMensual($idForecast)
    {
        $sql = "SELECT * FROM `detalle_forecast_mensual` WHERE `Id_Forecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['detalleForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el detalle del forecast. ' . TICKETS;
        }

        return $response;
    }

     public function obtenerDetalleForecastSucursalProducto($idProducto, $fechaInicial, $fechaFinal, $idSucursal)
    {
        $sql = "SELECT (SELECT  SUM(IFNULL(ea.`Cantidad`,0))  FROM `detalle_documentos` INNER JOIN `documentos` ON `documentos`.`Id_Documento` = `detalle_documentos`.`Id_Documento`
        left join entrada_almacen as ea on ea.fk_pedido = `documentos`.`Id_Documento` 
        AND ea.fk_producto =  `detalle_documentos`.`Id_Producto` WHERE `documentos`.`Tipo_Documento` = 100 AND `documentos`.`Status` = 2 AND `detalle_documentos`.`Id_Producto` = ? ) AS `Transito`,SUM(Semana1) AS semana1, SUM(Semana2) AS semana2, SUM(Semana3) AS Semana3, SUM(Semana4) AS semana4, SUM(Mes1) AS Mes1,  SUM(Mes2) AS Mes2 FROM detalle_forecast_mensual INNER JOIN forecast_mensual ON forecast_mensual.Id_Forecast = detalle_forecast_mensual.Id_Forecast WHERE forecast_mensual.Fecha BETWEEN ? AND ? AND detalle_forecast_mensual.Id_Producto = ? AND forecast_mensual.Id_Sucursal = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFinal, PDO::PARAM_STR);
        $stmt->bindValue(4, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(5, $idSucursal, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['datosForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast. ';
        }

        return $response;
    }
    
    public function autorizaForecastMensualCompleto($idForecast)  {
        $sql = "UPDATE detalle_forecast_mensual SET Status = 1 WHERE Id_Forecast = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = true;
            $response['error'] = ':( Lo siento, ocurrió un error al validar el forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerDetalleAutorizado($idForecast){
        $sql = "SELECT * FROM detalle_forecast_mensual WHERE Id_Forecast = ? AND (Semana1+Semana2+Semana3+Semana4+Mes1+Mes2+Mes3) > 0";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['detalleForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el detalle del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastProductoPedido($idProducto, $idSucursal, $fechaInicial){
        $sql = "SELECT * FROM `detalle_forecast_mensual` INNER JOIN `forecast_mensual` ON `forecast_mensual`.`Id_Forecast` = `detalle_forecast_mensual`.`Id_Forecast` WHERE `forecast_mensual`.`Fecha` = ? AND `detalle_forecast_mensual`.`Id_Producto` = ? AND `forecast_mensual`.`Id_Sucursal` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(2, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(3, $idSucursal, PDO::PARAM_STR);        
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast del producto. ' . TICKETS;
        }

        return $response;
    }

    public function getForecastCliente($idCliente, $tipo, $idForecast, $idProveedor)
    {
        $sql = "SELECT d.*, p.Nombre, p.Unidad_Venta, p.Litraje, p.Clave_Producto 
                    FROM detalle_forecast_mensual d, productos p 
                    WHERE d.Id_Producto = p.Id_Producto AND 
                        Id_Cliente = ? AND d.Tipo = ? AND Id_Forecast = ? 
                        AND (Semana1+Semana2+Semana3+Semana4+Mes1+Mes2+Mes3) > 0 ";
        if( $idProveedor != 0){
            $sql = $sql." and p.Id_Proveedor = ?";
        }
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idForecast, PDO::PARAM_INT);
        if ( $idProveedor != 0){
            $stmt->bindValue(4, $idProveedor, PDO::PARAM_INT);
        }
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['detalleForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el forecast del cliente. ' . TICKETS;
        }

        return $response;
    }

    public function getClientesForecast($idForecast)
    {
        $sql = "SELECT d.Id_Cliente, c.Cliente FROM detalle_forecast_mensual d, clientes c 
                    WHERE d.Id_Cliente = c.Id_Cliente AND d.Tipo = 'cliente' AND Id_Forecast = ? 
                        GROUP BY Id_Cliente ORDER BY Cliente ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['clientes'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los clientes del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function getProspectosForecast($idForecast)
    {
        $sql = "SELECT d.Id_Cliente, s.Cliente FROM detalle_forecast_mensual d, sospechoso s 
                    WHERE d.Id_Cliente = s.Id_Sospechoso AND d.Tipo = 'sospechoso' AND Id_Forecast = ? and s.Status = 1
                        GROUP BY Id_Cliente ORDER BY Cliente ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['prospectos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los prospectos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function getProspectosForecastSecuenciaSemanal($idForecast)
    {
        $sql = "SELECT d.Id_Cliente as Id_Sospechoso, s.Cliente FROM detalle_forecast_mensual d, sospechoso s 
                    WHERE d.Id_Cliente = s.Id_Sospechoso AND d.Tipo = 'sospechoso' AND Id_Forecast = ? 
                        GROUP BY Id_Cliente ORDER BY Cliente ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['prospectos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los prospectos del forecast. ' . TICKETS;
        }

        return $response;
    }
    
  public function obtenerClientesDetalleForecastMensual($idForecast, $semana)
    {
        $sql = "SELECT * FROM detalle_forecast_mensual as dfm 
    inner join clientes as c on c.Id_Cliente = dfm.Id_Cliente and dfm.Tipo = 'cliente' 
WHERE dfm.Id_Forecast = ? and c.Status = 1 and " .$semana." > 0 group by dfm.Id_Cliente";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['detalleClientes'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el detalle del forecast de los clientes. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerProspectoDetalleForecastMensual($idForecast, $semana)
    {
        $sql = "SELECT * FROM detalle_forecast_mensual as dfm
inner join sospechoso as s on s.Id_Sospechoso = dfm.Id_Cliente and dfm.Tipo = 'sospechoso'
WHERE dfm.Id_Forecast = ? and s.Status = 1 and " .$semana." > 0 group by dfm.Id_Cliente";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['detalleClientes'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el detalle del forecast de los clientes. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerDetalleForecastMensualCierreVentas($idForecast)
    {
        $sql = "(SELECT dfm.*, c.Id_Sucursal  FROM detalle_forecast_mensual as dfm 
inner join clientes as c on c.Id_Cliente = dfm.Id_Cliente
where dfm.Tipo = 'cliente'  and  `Id_Forecast` = ?
                   )
 UNION
 (SELECT dfm.*, s.Id_Sucursal  FROM detalle_forecast_mensual as dfm 
inner join sospechoso as s on s.Id_Sospechoso = dfm.Id_Cliente
where dfm.Tipo = 'sospechoso'  and  `Id_Forecast` = ? )
                     ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idForecast, PDO::PARAM_INT);
        $stmt->bindValue(2, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['detalleForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el detalle del forecast. ' . TICKETS;
        }

        return $response;
    }
}
