<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';


class DocumentoCategoriaDao extends Model {

	public function __construct(){
		parent::__construct();
	}

	public function ontenerDocumentosCategoria($idCategoria){
		$sql = "SELECT * FROM documentos_categoria_higiene INNER JOIN usuarios ON usuarios.Id_Usuario = documentos_categoria_higiene.Id_Usuario WHERE documentos_categoria_higiene.Id_Categoria = ?";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $idCategoria, PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['documentos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener los documentos. ' . TICKETS;
		}

		return $response;
	}
}