<?php
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoHigiene.php';

class DocumentoHigieneDao extends Model {

	public function __construct(){
		parent::__construct();
	}

	public function obtenerDocumentos($idSubcategoria){
		$sql = "SELECT documento_higiene.*, CONCAT(usuarios.Nombre, ' ', usuarios.Apellido_Paterno , ' ' , usuarios.Apellido_Materno) as Usuario FROM documento_higiene INNER JOIN usuarios ON usuarios.Id_Usuario = documento_higiene.Id_Usuario WHERE documento_higiene.Id_Subcategoria = ?";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $idSubcategoria, PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['documentos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener los documentos. ' . TICKETS;
		}

		return $response;
	}
}