<?php
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class DocumentoSubcategoriaDao extends Model{

	public function __construct(){
		parent::__construct();
	}

	public function obtenerSubcategorias(){
		$sql = "SELECT * FROM subcategoria_higiene ORDER BY Id_Subcategoria_Higiene ASC";
		$stmt = $this->_dbh->prepare($sql);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['subcategorias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener las subcategorias. ' . TICKETS;
		}

		return $response;
	}

	public function obtenerDocumentosSubcategoria($idSubcategoria){
		$sql = "SELECT * FROM documentos_subcategoria_higiene INNER JOIN usuarios ON usuarios.Id_Usuario = documentos_subcategoria_higiene.Id_Usuario WHERE documentos_subcategoria_higiene.Id_Subcategoria = ?";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $idSubcategoria, PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['documentos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener las subcategorias. ' . TICKETS;
		}

		return $response;
	}
}