<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class DocumentosNivel3Dao  extends Model  {

	public function __construct(){
		parent::__construct();
	}

	public function obtenerNivel3(){
		$sql = "SELECT * FROM Nivel_3_Higiene";
		$stmt = $this->_dbh->prepare($sql);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['nivel3'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener el nivel 3 ' . TICKETS;
		}

		return $response;
	}

	public function obtenerDocumentos($idNivel){
		$sql = "SELECT * FROM documentos_nivel_3 INNER JOIN usuarios ON usuarios.Id_Usuario = documentos_nivel_3.Id_Usuario WHERE Id_Nivel_3 = ?";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $idNivel, PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['documentos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener el nivel 3 ' . TICKETS;
		}

		return $response;
	}
}