<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

class EntregasForecastDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

    public function obtenerReporteEntregaForecast($fecha, $idSucursal, $idProveedor)
    {
    	$sql = "select * from entregas_forecast where Fecha = ? and Id_Sucursal = ? and Id_Proveedor = ? ";
    	$stmt = $this->_dbh->prepare($sql);
    	$stmt->bindValue(1, $fecha, PDO::PARAM_STR);
    	$stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $idProveedor, PDO::PARAM_INT);

        try{
    		$stmt->execute();
    		$response['status'] = true;
    		$response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        }catch(PDOException $e){
    		Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
    		$response['status'] = false;
    		$response['error'] = 'Ocurrió un error al obtener el reporte de forecast. ' . TICKETS;
    	}

    	return $response;
    }

    public function altaEntregaForecast($fecha,  $idSucursal, $idProveedor)
    {
        $sql = "INSERT INTO `entregas_forecast` (`Fecha`, `Id_Sucursal`, `Id_Proveedor` ) VALUES (?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $idProveedor, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idEntregasForecast'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el reporte de forecast. ' . TICKETS;
        }

        return $response;
    }

    public function borrarEntregaForecast($fecha,  $idSucursal, $idProveedor)
    {
        $sql = "DELETE FROM `entregas_forecast` WHERE Fecha = ? and Id_Sucursal = ? and Id_Proveedor = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $idProveedor, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al eliminar el reporte de forecast anterior. ' . TICKETS;
        }

        return $response;
    }


}