<?php
/**
 * Description of ForecastAnualDao
 *
 * @author sistemas
 */
 


require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'ForecastAnual.php';

class ForecastAnualDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function hayForecast($year, $idSucursal)
    {
        $sql = "SELECT * FROM `forecast_anual` WHERE `Year` = ? AND `Id_Sucursal` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al validar el forecast. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function crear(ForecastAnual $f)
    {
        $sql = "INSERT INTO `forecast_anual` (`Year`, `Id_Sucursal`, `Total_Litros`) VALUES (?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $f->__get('_year'), PDO::PARAM_INT);
        $stmt->bindValue(2, $f->__get('_idSucursal'), PDO::PARAM_INT);
        $stmt->bindValue(3, $f->__get('_totalLitros'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idForecast'] = $this->_dbh->lastInsertId();;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al abrir el forecast anual. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function actualizaLitrosForecast($litros, $idForecast)
    {
        $sql = "UPDATE `forecast_anual` SET `Total_Litros` = ? WHERE `Id_Forecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $litros, PDO::PARAM_STR);
        $stmt->bindValue(2, $idForecast, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al actualizar los litros totales. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerVendedoresReporteAnual($year, $idSucursal)
    {
        $sql = "SELECT usuario.*
from(
(SELECT u.* FROM detalle_forecast as df
                inner join forecast_anual as fa on fa.Id_Forecast = df.idforecast
               inner join  clientes as c on c.Id_Cliente = df.idCliente
               inner join usuarios as u on u.Id_Usuario = c.Id_Usuario
                where fa.Year = ? and df.tipo = 'cliente' and (u.Tipo = 2 OR u.Tipo = 4) and u.Status > 0 and c.Id_Sucursal = ?
                GROUP by u.Id_Usuario
                   )
 UNION
 (SELECT u.* FROM detalle_forecast as df
                inner join forecast_anual as fa on fa.Id_Forecast = df.idforecast
               inner join  sospechoso as s on s.Id_Sospechoso = df.idCliente
               inner join usuarios as u on u.Id_Usuario = s.Id_Vendedor
                where fa.Year = ? and df.tipo = 'prospecto' and (u.Tipo = 2 OR u.Tipo = 4) and u.Status > 0 and s.Id_Sucursal = ?
                GROUP by u.Id_Usuario )) as usuario
                GROUP by usuario.Id_Usuario";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $year, PDO::PARAM_INT);
        $stmt->bindValue(4, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['vendedores'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurri un error al ubtener los usuarios del reporte de forecast anual. ' . TICKETS;
        }

        return $response;
    }
    
     public function obtenerForecastAnual($year)
    {
        $sql = "SELECT s.*, fa.* FROM forecast_anual as fa
inner join sucursal as s on s.Id_Sucursal = fa.Id_Sucursal
WHERE fa.Year = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurri un error al validar el forecast. ' . TICKETS;
        }

        return $response;
    }
    
     public function obtenerPorductosConLitrosForecastAnual($year)
    {
        $sql = "SELECT *, sum((df.enero * p.Litraje) + (df.febrero * p.Litraje) + (df.marzo * p.Litraje) + (df.abril * p.Litraje) + (df.mayo * p.Litraje)
             + (df.junio * p.Litraje)  + (df.julio * p.Litraje)  + (df.agosto * p.Litraje) + (df.septiembre * p.Litraje) + (df.octubre * p.Litraje) + (df.noviembre * p.Litraje)
              + (df.diciembre * p.Litraje) ) as totalProducto
              FROM detalle_forecast as df  
inner join forecast_anual as fa on fa.Id_Forecast = df.idforecast
inner join productos as p on p.Id_Producto = df.idProducto
WHERE fa.Year = ? GROUP by p.Clave_Producto order by totalProducto desc";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['productos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurri un error al obtener los productos. ' . TICKETS;
        }

        return $response;
    }
    
     public function obtenerTotalMesesForecastAnual($mes, $mes1, $mes2, $mes3,$year, $idSucursal, $idUsuario )
    {
        $sql = "SELECT IFNULL(sum(df.".$mes." * p.Litraje),0) as mes,  IFNULL(sum(df.".$mes1." * p.Litraje),0) as mes1, IFNULL(sum(df.".$mes2." * p.Litraje),0) as mes2, IFNULL(sum(df.".$mes3." * p.Litraje),0) as mes3
              FROM detalle_forecast as df  
inner join forecast_anual as fa on fa.Id_Forecast = df.idforecast
inner join productos as p on p.Id_Producto = df.idProducto
inner join clientes as c on c.Id_Cliente = df.idCliente
WHERE fa.Year = ? and fa.Id_Sucursal = ? and c.Id_Usuario = ? and df.tipo = 'cliente'";

        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['anual'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurri un error al obtener el total de los meses. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTotalMesesForecastAnualProspecto($mes, $mes1, $mes2, $mes3,$year, $idSucursal, $idUsuario )
    {
        $sql = "SELECT IFNULL(sum(df.".$mes." * p.Litraje),0) as mes,  IFNULL(sum(df.".$mes1." * p.Litraje),0) as mes1, IFNULL(sum(df.".$mes2." * p.Litraje),0) as mes2, IFNULL(sum(df.".$mes3." * p.Litraje),0) as mes3
              FROM detalle_forecast as df  
inner join forecast_anual as fa on fa.Id_Forecast = df.idforecast
inner join productos as p on p.Id_Producto = df.idProducto
inner join sospechoso as s on s.Id_Sospechoso = df.idCliente
WHERE fa.Year = ? and fa.Id_Sucursal = ? and s.Id_Vendedor = ? and df.tipo = 'prospecto'";

        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $year, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['anual'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurri un error al obtener el total de los meses. ' . TICKETS;
        }

        return $response;
    }
}