<?php
/**
 * ForecastMensualDao.php
 * Modelo para la persisitencia de datos del forecast mensual
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . 
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ForecastMensual.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class ForecastMensualDao extends Model
{
    public function __construct() 
    {
        parent::__construct();
    }
    
    public function guardar(ForecastMensual $f)
    {
       $sql = "INSERT INTO `forecast_mensual` (`Fecha`, `Id_Usuario`, `Id_Sucursal`, `Status`, `Total`) VALUES (?, ?, ?, ?, 0)";
       $stmt = $this->_dbh->prepare($sql);
       $stmt->bindValue(1, $f->__get('_fecha'), PDO::PARAM_STR);
       $stmt->bindValue(2, $f->__get('_idUsuario'), PDO::PARAM_INT);
       $stmt->bindValue(3, $f->__get('_idSucursal'), PDO::PARAM_INT);
       $stmt->bindValue(4, $f->__get('_status'), PDO::PARAM_INT);
       try{
           $stmt->execute();
           $response['status'] = true;
           $response['idForecast'] = $this->_dbh->lastInsertId();
       } catch (PDOException $e) {
           Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
           $response['status'] = false;
           $response['error'] = 'Lo siento, ocurrió un error al guardar el forecast. ' . TICKETS;
       }              
        
        return $response;
    }
    
    public function obtenerUltimoForecast($idUsuario, $idCliente)
    {
        $sql = "SELECT * FROM `forecast_mensual` WHERE `Id_Usuario` = ? AND "
                . "`Id_Cliente` = ? ORDER BY `Fecha` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCliente, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                    . 'del forecast. ' . TICKETS;
        }
        
        return $response;
    }

    public function guardarForecastMensual1(ForecastMensual $f)
    {
        $sql = "INSERT INTO `forecast_mensual` (`Id_Usuario`, `Id_Cliente`, `Tipo`, `enero_1`, `enero_2`, `enero_3`, `enero_4`, `febrero_1`, `febrero_2`, `febrero_3`, `febrero_4`, `marzo_1`, `marzo_2`, `marzo_3`, `marzo_4`, `abril_1`, `abril_2`, `abril_3`, `abril_4`, `mayo_1`, `mayo_2`, `mayo_3`, `mayo_4`, `junio_1`, `junio_2`, `junio_3`, `junio_4`, `julio_1`, `julio_2`, `julio_3`, `julio_4`, `agosto_1`, `agosto_2`, `agosto_3`, `agosto_4`, `septiembre_1`, `septiembre_2`, `septiembre_3`, `septiembre_4`, `octubre_1`, `octubre_2`, `octubre_3`, `octubre_4`, `noviembre_1`, `noviembre_2`, `noviembre_3`, `noviembre_4`, `diciembre_1`, `diciembre_2`, `diciembre_3`, `diciembre_4`, `year`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $f->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(2, $f->__get('_idCliente'), PDO::PARAM_INT);
        $stmt->bindValue(3, $f->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(4, $f->__get('_enero1'), PDO::PARAM_INT);
        $stmt->bindValue(5, $f->__get('_enero2'), PDO::PARAM_INT);
        $stmt->bindValue(6, $f->__get('_enero3'), PDO::PARAM_INT);
        $stmt->bindValue(7, $f->__get('_enero4'), PDO::PARAM_INT);
        $stmt->bindValue(8, $f->__get('_febrero1'), PDO::PARAM_INT);
        $stmt->bindValue(9, $f->__get('_febrero2'), PDO::PARAM_INT);
        $stmt->bindValue(10, $f->__get('_febrero3'), PDO::PARAM_INT);
        $stmt->bindValue(11, $f->__get('_febrero4'), PDO::PARAM_INT);
        $stmt->bindValue(12, $f->__get('_marzo1'), PDO::PARAM_INT);
        $stmt->bindValue(13, $f->__get('_marzo2'), PDO::PARAM_INT);
        $stmt->bindValue(14, $f->__get('_marzo3'), PDO::PARAM_INT);
        $stmt->bindValue(15, $f->__get('_marzo4'), PDO::PARAM_INT);
        $stmt->bindValue(16, $f->__get('_abril1'), PDO::PARAM_INT);
        $stmt->bindValue(17, $f->__get('_abril2'), PDO::PARAM_INT);
        $stmt->bindValue(18, $f->__get('_abril3'), PDO::PARAM_INT);
        $stmt->bindValue(19, $f->__get('_abril4'), PDO::PARAM_INT);
        $stmt->bindValue(20, $f->__get('_mayo1'), PDO::PARAM_INT);
        $stmt->bindValue(21, $f->__get('_mayo2'), PDO::PARAM_INT);
        $stmt->bindValue(22, $f->__get('_mayo3'), PDO::PARAM_INT);
        $stmt->bindValue(23, $f->__get('_mayo4'), PDO::PARAM_INT);
        $stmt->bindValue(24, $f->__get('_junio1'), PDO::PARAM_INT);
        $stmt->bindValue(25, $f->__get('_junio2'), PDO::PARAM_INT);
        $stmt->bindValue(26, $f->__get('_junio3'), PDO::PARAM_INT);
        $stmt->bindValue(27, $f->__get('_junio4'), PDO::PARAM_INT);
        $stmt->bindValue(28, $f->__get('_julio1'), PDO::PARAM_INT);
        $stmt->bindValue(29, $f->__get('_julio2'), PDO::PARAM_INT);
        $stmt->bindValue(30, $f->__get('_julio3'), PDO::PARAM_INT);
        $stmt->bindValue(31, $f->__get('_julio4'), PDO::PARAM_INT);
        $stmt->bindValue(32, $f->__get('_agosto1'), PDO::PARAM_INT);        
        $stmt->bindValue(33, $f->__get('_agosto2'), PDO::PARAM_INT);  
        $stmt->bindValue(34, $f->__get('_agosto3'), PDO::PARAM_INT);  
        $stmt->bindValue(35, $f->__get('_agosto4'), PDO::PARAM_INT);  
        $stmt->bindValue(36, $f->__get('_septiembre1'), PDO::PARAM_INT);
        $stmt->bindValue(37, $f->__get('_septiembre2'), PDO::PARAM_INT);
        $stmt->bindValue(38, $f->__get('_septiembre3'), PDO::PARAM_INT);
        $stmt->bindValue(39, $f->__get('_septiembre4'), PDO::PARAM_INT);
        $stmt->bindValue(40, $f->__get('_octubre1'), PDO::PARAM_INT);
        $stmt->bindValue(41, $f->__get('_octubre2'), PDO::PARAM_INT);
        $stmt->bindValue(42, $f->__get('_octubre3'), PDO::PARAM_INT);
        $stmt->bindValue(43, $f->__get('_octubre4'), PDO::PARAM_INT);
        $stmt->bindValue(44, $f->__get('_noviembre1'), PDO::PARAM_INT);
        $stmt->bindValue(45, $f->__get('_noviembre2'), PDO::PARAM_INT);
        $stmt->bindValue(46, $f->__get('_noviembre3'), PDO::PARAM_INT);
        $stmt->bindValue(47, $f->__get('_noviembre4'), PDO::PARAM_INT);
        $stmt->bindValue(48, $f->__get('_diciembre1'), PDO::PARAM_INT);
        $stmt->bindValue(49, $f->__get('_diciembre2'), PDO::PARAM_INT);
        $stmt->bindValue(50, $f->__get('_diciembre3'), PDO::PARAM_INT);
        $stmt->bindValue(51, $f->__get('_diciembre4'), PDO::PARAM_INT);
        $stmt->bindValue(52, $f->__get('_year'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar los datos. ' . TICKETS;
        }

        return $response;
    }
    
    public function obtenerForecastMensual($fechaInicial, $fechaFinal, $idUsuario)
{
    $sql = "SELECT * FROM `forecast_mensual` WHERE `Fecha` BETWEEN ? AND ? AND `Id_Usuario` = ? ";
    if(Sesion::obtener('idSucursal')){
        $sql = $sql." AND `Id_Sucursal` = ?  ";
    }
    $stmt = $this->_dbh->prepare($sql);
    $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
    $stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);
    $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
    if(Sesion::obtener('idSucursal')){
        $stmt->bindValue(4, Sesion::obtener('idSucursal'), PDO::PARAM_INT);

    }
    try{
        $stmt->execute();
        $response['status'] = true;
        $response['total'] = $stmt->rowCount();
        $response['datosForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
    } catch (PDOException $e) {
        Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
        $response['status'] = false;
        $response['error'] = 'Lo siento, ocurrió un error al validar los datos del forecast. ' . TICKETS;
    }

    return $response;
}

    public function obtenerForecastMensualNoAutorizado($fechaInicial, $fechaFinal, $idUsuario)
    {
        $sql = "SELECT * FROM `forecast_mensual` WHERE `Fecha` BETWEEN ? AND ? AND  `Id_Usuario` = ? AND `status` = 0 ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['datosForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al validar los datos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastMensualAprovado($fechaInicial, $fechaFinal, $idUsuario)
    {
        $sql = "SELECT * FROM `forecast_mensual` WHERE `Fecha` BETWEEN ? AND ? AND `Id_Usuario` = ? AND `Status` = 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['datosForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al validar los datos del forecast. ' . TICKETS;
        }
        
        return $response;
    }

    public function obtenerForecastPorSucursal($idSucursal, $fechaInicial, $fechaFinal)
    {
        $sql = "SELECT * FROM `forecast_mensual` WHERE `Id_Sucursal` = ? AND `Fecha` BETWEEN ? AND ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaInicial, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['datosForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastPorSucursalAprovado($idSucursal, $fechaInicial, $fechaFinal)
    {
        $sql = "SELECT * FROM `forecast_mensual` as fm
inner join usuarios as u on u.Id_Usuario = fm.Id_Usuario
 WHERE fm.Id_Sucursal = ? AND fm.Fecha BETWEEN ? AND ? AND fm.Status = 1 and u.Status = 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaInicial, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['datosForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastMensualAutorizar($idVendedor, $fechaInicial, $fechaFinal, $idSucursal){
        $sql = "SELECT * FROM forecast_mensual WHERE Id_Usuario = ? AND Fecha BETWEEN ? AND ? AND Status = 0 and Id_Sucursal = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idVendedor, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFinal, PDO::PARAM_STR);
        $stmt->bindValue(4, $idSucursal, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['datosForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los datos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function actualizaStatus($idForecast, $status){
        $sql = "UPDATE forecast_mensual SET Status = ? WHERE Id_Forecast = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_INT);
        $stmt->bindValue(2, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al autorizar el forecast. ' . TICKETS;
        }

        return $response;   
    }

    public function actualizaTotal($idForecast, $total){
        $sql = "UPDATE `forecast_mensual` SET `Total` = ? WHERE `Id_Forecast` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $total, PDO::PARAM_INT);
        $stmt->bindValue(2, $idForecast, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al actualizar el total del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerProductosReporteEntregas( $idSucursal)
    {
        $sql = "select * from productos as p where Id_Sucursal = ? and Status > 0 and
(p.Nombre like '%tellus%' || p.Nombre like '%rim%' || p.Nombre like '%turbo%' 
|| p.Nombre like '%tonna%' || p.Nombre like '%spirax%' || p.Nombre like '%rot%' || p.Nombre like '%omala%'
|| p.Nombre like '%nautilus%' || p.Nombre like '%Naturelle%' || p.Nombre like '%Mysella%' || p.Nombre like '%Morlina%'
|| p.Nombre like '%irus%' || p.Nombre like '%hydrauli%' || p.Nombre like '%gadus%' || p.Nombre like '%helix%'
|| p.Nombre like '%caprinus%' || p.Nombre like '%gadinia%' || p.Nombre like '%corena%' || p.Nombre like '%Rhodina%'
|| p.Nombre like '%Refrig%' || p.Nombre like '%heat%' || p.Nombre like '%diala%' || p.Nombre like '%atf%') order by p.Nombre  ;      
";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos para el reporte '
                . 'del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastPorSucursalNoAprovado($idSucursal, $fechaInicial)
    {
        $sql = "SELECT * FROM `forecast_mensual` as fm
inner join usuarios as u on u.Id_Usuario = fm.Id_Usuario
 WHERE fm.Id_Sucursal = ? AND fm.Fecha BETWEEN ? AND ? AND fm.Status != 1 and u.Status = 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaInicial, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['datosForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastReporteEntregas($idFecha, $idSucursal, $idProducto )
    {
        $sql = "select *, sum(Semana1) as semana1, sum(Semana2) as semana2, sum(Semana3) as semana3, sum(Semana4) as semana4,
 sum(Mes1) as mes1,  sum(Mes2) as mes2,  sum(Mes3) as mes3, dfm.Tipo
from forecast_mensual as fm
inner join detalle_forecast_mensual as dfm on dfm.Id_Forecast = fm.Id_Forecast
inner join productos as p on p.Id_Producto = dfm.Id_Producto
where fm.Fecha = ? and p.Id_Sucursal = ?  and dfm.Id_Producto  = ? and fm.Id_Sucursal = ?  group by dfm.Id_Producto 
";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idFecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $idProducto, PDO::PARAM_INT);
        $stmt->bindValue(4, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['forecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos para el reporte '
                . 'del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerProductosReporteEntregasPorProv( $idSucursal, $idProveedor)
    {
        $sql = "select * from productos as p where Id_Sucursal = ? and Status > 0 and Id_Proveedor = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $idProveedor, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['forecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos para el reporte '
                . 'del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function agregarForcastMensuales($fecha)
    {
        $sql = "INSERT INTO `forecast_mensual` ( `Fecha`, `Status`, `Id_Usuario`, `Id_Sucursal`, `Total`)
select ?, 0, Id_Usuario, Id_Sucursal, 0 from usuarios where Status > 0 and (Tipo = 2 || Tipo = 4) and
 not EXISTS (select * from forecast_mensual as df where df.Fecha = ? and df.Id_Usuario = usuarios.Id_Usuario )";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idForecast'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerUsuariosForecastMensual($fechaInicial, $fechaFinal)
    {
        $sql = "SELECT * FROM `forecast_mensual` WHERE `Fecha` BETWEEN ? AND ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['datosForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al validar los datos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerdetalleForecast($fechaInicial, $idUsuario, $year, $idSucursal)
    {
        $sql = "SELECT df.*, fm.Id_Forecast
   FROM detalle_forecast as df
   left join sospechoso as s on s.Id_Sospechoso = df.idCliente
   left join clientes as c on c.Id_Cliente = df.idCliente 
   inner join forecast_anual as fa on fa.Id_Forecast = df.idforecast
   inner join forecast_mensual as fm on (case when df.Tipo = 'cliente' then  c.Id_Usuario else s.Id_Vendedor end) = fm.Id_Usuario
   where fm.Fecha = ? and fm.Id_Usuario = ? and fa.Year = ? and not EXISTS (select * from detalle_forecast_mensual as dfm where dfm.Id_Cliente = df.idCliente and dfm.Tipo = df.tipo and dfm.Id_Producto = df.idProducto and dfm.Id_Forecast = fm.Id_Forecast limit 1  )
     and (case WHEN df.Tipo = 'cliente' then c.Id_Sucursal = ? else s.Id_Sucursal = ? end) ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(3, $year, PDO::PARAM_INT);
        $stmt->bindValue(4, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(5, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['datosForecast'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al validar los datos del forecast. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerForecastMensualPorUsuarioYSucursal($fechaInicial, $fechaFinal, $idUsuario, $idSucursal)
    {
        $sql = "SELECT * FROM `forecast_mensual` WHERE `Fecha` BETWEEN ? AND ? AND `Id_Usuario` = ? and Id_Sucursal = ?  ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(4, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['datosForecast'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al validar los datos del forecast. ' . TICKETS;
        }

        return $response;
    }




}
