<?php
/**
 * FormatoDao.php
 * Modelo para la persistencia de datos de formatos
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . 
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Formato.php';

class FormatoDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(Formato $f)
    {
        $sql = "INSERT INTO `formatos_calidad` (`Folio`, `Formato`, `Descripcion`, `Fecha`, `Documento`, "
                . "`Id_Usuario`, `Status`, `Id_Instruccion`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $f->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindValue(2, $f->__get('_formato'), PDO::PARAM_STR);
        $stmt->bindValue(3, $f->__get('_descripcion'), PDO::PARAM_STR);
        $stmt->bindValue(4, $f->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(5, $f->__get('_documento'), PDO::PARAM_STR);
        $stmt->bindValue(6, $f->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(7, $f->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(8, $f->__get('_idInstruccion'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idFormato'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el formato. '
                    . TICKETS;            
        }
        
        return $response;
    }
    
    public function guardarDetalleFormato($fecha, $descripcion, $documento, $ruta, $idUsuario, $idFormato)
    {
        $sql = "INSERT INTO `formatos_calidad_detalle` (`Fecha`, `Descripcion`, `Documento`, `Ruta`, "
                . "`Id_Usuario`, `Id_Formato`) VALUES (?, ?, ?, ?, ?, ?) ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(3, $documento, PDO::PARAM_STR);
        $stmt->bindValue(4, $ruta, PDO::PARAM_STR);
        $stmt->bindValue(5, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(6, $idFormato, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos de tu documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerFolio()
    {
        $sql = "SELECT `Folio` FROM `formatos_calidad` ORDER BY `Id_Formato` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['folio'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el folio del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerFormatosAutorizar($inicio, $registros)
    {
        $sql = "SELECT `formatos_calidad`.`Id_Formato`, `formatos_calidad`.`Formato`, `formatos_calidad`.`Folio`, `formatos_calidad`.`Descripcion`, "
                . "`formatos_calidad`.`Fecha`, `formatos_calidad`.`Status`, `formatos_calidad_detalle`.`Documento`, "
                . "`formatos_calidad_detalle`.`Ruta`, `usuarios`.`Nombre`, `usuarios`.`Apellido_Paterno`, `usuarios`.`Apellido_Materno`, `formatos_calidad`.`Formato`, `instrucciones_manual`.`Instruccion` "
                . "FROM `formatos_calidad` INNER JOIN `formatos_calidad_detalle` ON `formatos_calidad_detalle`.`Id_Formato` = `formatos_calidad`.`Id_Formato` "
                . "INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `formatos_calidad`.`Id_Usuario` INNER JOIN `instrucciones_manual` ON `instrucciones_manual`.`Id_Instruccion` = `formatos_calidad`.`Id_Instruccion` WHERE `formatos_calidad`.`Status` = 0 ORDER BY "
                . "`formatos_calidad`.`Id_Formato` ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['formatos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la lista de Instrucciones. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerFormatos($inicio, $registros)
    {
        $sql = "SELECT `formatos_calidad`.`Id_Formato`, `formatos_calidad`.`Formato`, `formatos_calidad`.`Folio`, `formatos_calidad`.`Descripcion`, "
                . "`formatos_calidad`.`Fecha`, `formatos_calidad`.`Status`, `formatos_calidad_detalle`.`Documento`, "
                . "`formatos_calidad_detalle`.`Ruta`, `usuarios`.`Nombre`, `usuarios`.`Apellido_Paterno`, `usuarios`.`Apellido_Materno`, `formatos_calidad`.`Formato`, `instrucciones_manual`.`Instruccion` "
                . "FROM `formatos_calidad` INNER JOIN `formatos_calidad_detalle` ON `formatos_calidad_detalle`.`Id_Formato` = `formatos_calidad`.`Id_Formato` "
                . "INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `formatos_calidad`.`Id_Usuario` INNER JOIN `instrucciones_manual` ON `instrucciones_manual`.`Id_Instruccion` = `formatos_calidad`.`Id_Instruccion` WHERE `formatos_calidad`.`Status` = 1 ORDER BY "
                . "`formatos_calidad`.`Id_Formato` ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['formatos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la lista de Instrucciones. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalFormatosAutorizadas()
    {
        $sql = "SELECT `Id_Formato` FROM `formatos_calidad` WHERE `Status` = 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de instrucciones autorizadas. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalFormatosAutorizar()
    {
        $sql = "SELECT `Id_Formato` FROM `formatos_calidad` WHERE `Status` = 0";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de formatos autorizados. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function cambiarEstado($idFormato, $status)
    {
        $sql = "UPDATE `formatos_calidad` SET `Status` = ? WHERE `Id_Formato` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_INT);
        $stmt->bindValue(2, $idFormato, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al cambiar el estado del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtener($idFormato)
    {
        $sql = "SELECT * FROM `formatos_calidad` INNER JOIN `formatos_calidad_detalle` ON "
                . "`formatos_calidad_detalle`.`Id_Formato` = `formatos_calidad`.`Id_Formato` WHERE `formatos_calidad`.`Id_Formato` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idFormato, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['formato'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerDetalleAutorizar($idFormato)
    {
        $sql = "SELECT * FROM `formatos_calidad_detalle` WHERE `Id_Formato` = ? AND `Id_Autoriza` = 0 ORDER BY `Id_Formato_Detalle` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idFormato, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['datosDetalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el detalle del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function usuarioAutoriza($idUsuario, $idManual)
    {
        $sql = "UPDATE `formatos_calidad_detalle` SET `Id_Autoriza` = ? WHERE `Id_Formato_Detalle` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idManual, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $$e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un problema al autorizar el documento. ' . 
                    TICKETS;
        }
        
        return $response;
    }
    
    public function totalFormatosAutorizados()
    {
        $sql = "SELECT `Id_Formato` FROM `formatos_calidad` WHERE `Status` = 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de formatos autorizados. '
                    . TICKETS;
        }
        
        return $response;
    }
}