<?php
/**
 * InstruccionDao.php
 * Modelo para la persistencia de datos de instrucciones
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Instruccion.php';

class InstruccionDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(Instruccion $i)
    {
        $sql = "INSERT INTO `instrucciones_manual` (`Folio`, `Instruccion`, `Descripcion`, "
                . "`Fecha`, `Id_Procedimiento`, `Id_Usuario`, `Status`) VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $i->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindValue(2, $i->__get('_instruccion'), PDO::PARAM_STR);
        $stmt->bindValue(3, $i->__get('_descripcion'), PDO::PARAM_STR);
        $stmt->bindValue(4, $i->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(5, $i->__get('_idProcedimiento'), PDO::PARAM_INT);
        $stmt->bindValue(6, $i->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(7, $i->__get('_status'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idInstruccion'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos del documento.';
        }
        
        return $response;
    }    
    
    public function obtenerInstrucciones($inicio, $registros)
    {
        $sql = "SELECT `instrucciones_manual`.`Folio`, `instrucciones_manual`.`Instruccion`, `instrucciones_manual`.`Descripcion`, "
                . "`instrucciones_manual`.`Fecha`, `instrucciones_manual`.`Status`, `instrucciones_detalle`.`Documento`, "
                . "`instrucciones_detalle`.`Ruta`, `usuarios`.`Nombre`, `usuarios`.`Apellido_Paterno`, `usuarios`.`Apellido_Materno`, `manuales_procedimientos`.`Procedimiento` "
                . "FROM `instrucciones_manual` INNER JOIN `instrucciones_detalle` ON `instrucciones_detalle`.`Id_Instruccion` = `instrucciones_manual`.`Id_Instruccion` "
                . "INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `instrucciones_manual`.`Id_Usuario` INNER JOIN `manuales_procedimientos` ON "
                . "`manuales_procedimientos`.`Id_Manual` = `instrucciones_manual`.`Id_Procedimiento` WHERE `instrucciones_manual`.`Status` = 1 ORDER BY "
                . "`instrucciones_manual`.`Id_Procedimiento` ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['instrucciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la lista de Instrucciones. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerInstruccionesAutorizar($inicio, $registros)
    {
        $sql = "SELECT `instrucciones_manual`.`Id_Instruccion`, `instrucciones_manual`.`Instruccion`, `instrucciones_manual`.`Folio`, `instrucciones_manual`.`Descripcion`, "
                . "`instrucciones_manual`.`Fecha`, `instrucciones_manual`.`Status`, `instrucciones_detalle`.`Documento`, "
                . "`instrucciones_detalle`.`Ruta`, `usuarios`.`Nombre`, `usuarios`.`Apellido_Paterno`, `usuarios`.`Apellido_Materno`, `manuales_procedimientos`.`Procedimiento` "
                . "FROM `instrucciones_manual` INNER JOIN `instrucciones_detalle` ON `instrucciones_detalle`.`Id_Instruccion` = `instrucciones_manual`.`Id_Instruccion` "
                . "INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `instrucciones_manual`.`Id_Usuario` INNER JOIN `manuales_procedimientos` ON `manuales_procedimientos`.`Id_Manual` = `instrucciones_manual`.`Id_Procedimiento` WHERE `instrucciones_manual`.`Status` = 0 ORDER BY "
                . "`instrucciones_manual`.`Id_Procedimiento` ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['instrucciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la lista de Instrucciones. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalInstruccionesAutorizadas()
    {
        $sql = "SELECT `Id_Instruccion` FROM `instrucciones_manual` WHERE `Status` = 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de instrucciones autorizadas. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalInstruccionesAutorizar()
    {
        $sql = "SELECT `Id_Instruccion` FROM `instrucciones_manual` WHERE `Status` = 0";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de instrucciones autorizadas. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerFolio()
    {
        $sql = "SELECT `Folio` FROM `instrucciones_manual` ORDER BY `Id_Instruccion` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['folio'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el folio del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function guardarDetalleInstrcuccion($fecha, $descripcion, $documento, $ruta, $idUsuario, $idInstruccion)
    {
        $sql = "INSERT INTO `instrucciones_detalle` (`Fecha`, `Descripcion`, `Documento`, `Ruta`, "
                . "`Id_Usuario`, `Id_Instruccion`) VALUES (?, ?, ?, ?, ?, ?) ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(3, $documento, PDO::PARAM_STR);
        $stmt->bindValue(4, $ruta, PDO::PARAM_STR);
        $stmt->bindValue(5, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(6, $idInstruccion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos de tu documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function cambiarEstado(Instruccion $i)
    {
        $sql = "UPDATE `instrucciones_manual` SET `Status` = ? WHERE `Id_Instruccion` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $i->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(2, $i->__get('_idInstruccion'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al cambiar el estado del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtener(Instruccion $i)
    {
        $sql = "SELECT * FROM `instrucciones_manual` INNER JOIN `instrucciones_detalle` ON "
                . "`instrucciones_detalle`.`Id_Instruccion` = `instrucciones_manual`.`Id_Instruccion` WHERE `instrucciones_manual`.`Id_Instruccion` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $i->__get('_idInstruccion'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['instruccion'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de la Instrucción. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerDetalleAutorizar($idInstruccion)
    {
        $sql = "SELECT * FROM `instrucciones_detalle` WHERE `Id_Instruccion` = ? AND `Id_Autoriza` = 0 ORDER BY `Id_Detalle_Instruccion` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idInstruccion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['datosDetalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el detalle del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function usuarioAutoriza($idUsuario, $idManual)
    {
        $sql = "UPDATE `instrucciones_detalle` SET `Id_Autoriza` = ? WHERE `Id_Detalle_Instruccion` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idManual, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $$e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un problema al autorizar el documento. ' . 
                    TICKETS;
        }
        
        return $response;
    }
    
    public function listaInstrucciones()
    {
        $sql = "SELECT * FROM `instrucciones_manual` WHERE `Status` = 1 ORDER BY `Id_Instruccion` ASC";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['instrucciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la lista de instrucciones. '
                    . TICKETS;
        }
        
        return $response;
    }
}