<?php
/**
 * LPA2Dao.php
 * Modelo para la persistencia de datos de formatos LPA2
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . 
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'LPA2.php';

class LPA2Dao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function obtenerLPA2PorUsuario($idUsuario, $fechaInicio, $fechaFin)
    {
        $sql = "SELECT * FROM `documentos` WHERE `Tipo_Documento` = 21 AND `Id_Usuario` = ? "
                . "AND `Fecha` BETWEEN ? AND ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['lpa'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de auditorias LPA2. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function cumplimientoLPAP2orUsuario($idUsuario, $fechaInicio, $fechaFin)
    {
        $sql = "SELECT SUM(`Total`) AS `Cumplimiento` FROM `documentos` WHERE `Id_Usuario` = ? "
                . "AND `Fecha` BETWEEN ? AND ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cumplimiento'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el cumplimiento LPA2. '
                    . TICKETS;
        }
        
        return $response;
    }
}