<?php
/**
 * Description of LPADao
 *
 * @author sistemas
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class LPADao extends Model
{
    public function __construct()
    {
        parent::__construct();
    }
    
    public function reporteActividades($idSucursal, $idUsuario, $fechaInicio, $fechaFin)
    {
        $sql = "SELECT comentarios.Comentarios, comentarios.Avance, comentarios.Progreso, comentarios.Cuando FROM cinco_s 
                INNER JOIN comentarios ON comentarios.Id_Sospechoso = cinco_s.Id_Pregunta INNER JOIN documentos ON documentos.Id_Documento = cinco_s.Id_Documento
                WHERE cinco_s.Id_Sucursal= ? AND comentarios.Cuando >= ? AND comentarios.Cuando <= ? AND cinco_s.Calificacion = 'NO' AND documentos.Id_Usuario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFin, PDO::PARAM_STR);
        $stmt->bindValue(4, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener las actividades. ' . TICKETS;
        }
        
        return $response;
    }
    
    /** by isantosp **/
    public function getPreguntas(){
        $SQL = "SELECT * FROM cinco_s_preguntas WHERE status = 1; ";
        $stmt = $this->_dbh->prepare($SQL);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener las preguntas. ' . TICKETS;
        }
        
        return $response;
    }

    public function guardaCincoSDAO($sucursal, $usuario, $preguntas, $nivel){
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        $d = new Documento();
        $d->__set('_idCliente', 0);
        $d->__set('_idConfiguracion', 0);
        $d->__set('_status', 1);
        $d->__set('_fecha', date("Y-m-d H:i:s"));
        $d->__set('_idSucursal', $sucursal);
        $d->__set('_subtotal', 0);
        $d->__set('_total', $nivel);
        $d->__set('_idUsuario', $usuario);
        $d->__set('_folioDocumento', '');
        $d->__set('_condicionesPago', '');
        $d->__set('_formaPago', '');
        $d->__set('_metodoPago', '');
        $d->__set('_tipoComprobante', '');
        $d->__set('_noCuenta', '');
        $d->__set('_tipoDocumento', 20);
        $d->__set('_idProveedor', 0);
        $d->__set('_observaciones', '');
        $d->__set('_tipoCambio', 0);
        $d->__set('_moneda', 'MXN');
        $d->__set('_idPedido', 0);
        $d->__set('_idAlmacen', 0);
        $doc = new DocumentoDao();
        $documento = $doc->generarDocumento($d);

        try{
            $idDoc = $documento['idDocumento'];

            $response['status'] = true;
            $response['Id_Documento'] = $idDoc;

            $SQLa = "UPDATE agenda SET Fecha_Ultima_Aplicacion = 'NOW()' WHERE Id_Usuario = ? and Id_Actividad = 2 ";
            $stmta = $this->_dbh->prepare($SQLa);
            $stmta->bindValue(1, $usuario, PDO::PARAM_INT);
            $stmta->execute();


            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
            
            foreach ($preguntas as $preg) {
                $calif = $preg['calif'];
                $comm = $preg['comm'];
                $cincos = $preg['5s'];
                $pregs = $preg['preg'];

                if($calif == 'NO'){
                    $SQL5s = "INSERT INTO cinco_s (Id_Pregunta, Id_Documento, Id_Comentario_Cinco_S, Calificacion_Cinco_S, Calificacion, Id_Sucursal)
                                    VALUES (NULL, ?, 0, ?, ?, ?) ";
                    $stmt5s = $this->_dbh->prepare($SQL5s);
                    $stmt5s->bindValue(1, $idDoc, PDO::PARAM_INT);
                    $stmt5s->bindValue(2, $cincos, PDO::PARAM_INT);
                    $stmt5s->bindValue(3, $calif, PDO::PARAM_STR);
                    $stmt5s->bindValue(4, $sucursal, PDO::PARAM_INT);
                    $stmt5s->execute();
                    $idCinco = $this->_dbh->lastInsertId();


                    $comentario = 'P: '.$pregs.'. C: '.$comm;
                    $comm = new Comentarios();
                    $comm->__set('_quien', '');
                    $comm->__set('_cuando', date('Y-m-d H:i:s'));
                    $comm->__set('_comentarios', $comentario);
                    $comm->__set('_idSospechoso', $idCinco);
                    $comm->__set('_tipo', 'cinco_s');
                    $comm->__set('_status', 0);
                    $comm->__set('_progreso', '0');
                    $comm->__set('_avance', '');
                    $comm->__set('_idSucursalComentario', $sucursal);
                    $c = new ComentariosDao();
                    $commres = $c->guardarActividades($comm);
                    $idComentario = $this->_dbh->lastInsertId();


                    $SQLuc = "UPDATE cinco_s SET Id_Comentario_Cinco_S = ? WHERE Id_Pregunta = ? ";
                    $stmtuc = $this->_dbh->prepare($SQLuc);
                    $stmtuc->bindValue(1, $idComentario, PDO::PARAM_INT);
                    $stmtuc->bindValue(2, $idCinco, PDO::PARAM_INT);
                    $stmtuc->execute();
                }else{
                    $SQL5s = "INSERT INTO cinco_s (Id_Pregunta, Id_Documento, Id_Comentario_Cinco_S, Calificacion_Cinco_S, Calificacion, Id_Sucursal)
                                VALUES (NULL, ?, 0, ?, ?, ?) ";
                    $stmt5s = $this->_dbh->prepare($SQL5s);
                    $stmt5s->bindValue(1, $idDoc, PDO::PARAM_INT);
                    $stmt5s->bindValue(2, $cincos, PDO::PARAM_INT);
                    $stmt5s->bindValue(3, $calif, PDO::PARAM_STR);
                    $stmt5s->bindValue(4, $sucursal, PDO::PARAM_INT);
                    $stmt5s->execute();
                    $idCinco = $this->_dbh->lastInsertId();
                }
            }

            $response['idCinco'] = $idCinco;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar la sugerencia. '
                    . TICKETS;
        }
        
        return $response;
    }

    public function get5sDoc($doc){
        $SQL = "SELECT * FROM cinco_s WHERE Id_Documento = ?  ";
        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $doc, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener las preguntas cinco_s. ' . TICKETS;
        }
        
        return $response;
    }
}
