<?php
/**
 * LubeProjectActividadDao.php
 * Modelo para la persistencia de datos de lubeproject
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class LubeProjectActividadDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

   public function addActividad($proyecto, $descripcion, $responsable, $inicio, $fin){
        $sql = "INSERT INTO lubeproject_actividad 
                    ( fk_project, descripcion, responsable, inicio, fin) 
                    VALUES (?, ?, ?, ?, ?);";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $proyecto, PDO::PARAM_INT);
        $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(3, $responsable, PDO::PARAM_STR);
        $stmt->bindValue(4, $inicio, PDO::PARAM_STR);
        $stmt->bindValue(5, $fin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['idActividad'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function getActividad($idActividad){
        $sql = "SELECT * FROM lubeproject_actividad WHERE id_actividad = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();

            $response['actividad'] = $stmt->fetch();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function updateCumplimiento($actividad, $cumplimiento){
        $sql = "UPDATE lubeproject_actividad SET cumplimiento = ? WHERE id_actividad = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $cumplimiento, PDO::PARAM_INT);
        $stmt->bindValue(2, $actividad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el cumplimiento. ' . TICKETS;
        }

        return $response;
    }

    public function deleteActividad($actividad){
        $sql = "UPDATE lubeproject_actividad SET status = 0 WHERE id_actividad = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $actividad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
            //$response['planes'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar la actividad. ' . TICKETS;
        }

        return $response;
    }


    public function closeProject($proyecto){
        $sql = "UPDATE lubeproject SET status = 2 WHERE id_project = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $proyecto, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al cerrar el proyecto. ' . TICKETS;
        }

        return $response;
    }

    public function getActividades($idProyecto){
        $sql = "SELECT *
                    FROM lubeproject_actividad WHERE status > 0 AND fk_project = ? 
                    ORDER BY inicio ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProyecto, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer las actividades del proyecto. ' . TICKETS;
        }

        return $response;
    }

    

}
