<?php
/**
 * LubeProjectDao.php
 * Modelo para la persistencia de datos de lubeproject
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class LubeProjectDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

   public function addProyecto($idCliente, $titulo, $objetivo, $equipos, $esperado){
        $sql = "INSERT INTO lubeproject 
                    ( fk_cliente, fecha, titulo, objetivo, equipos, res_esperado) 
                    VALUES (?, NOW(), ?, ?, ?, ?);";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $titulo, PDO::PARAM_STR);
        $stmt->bindValue(3, $objetivo, PDO::PARAM_STR);
        $stmt->bindValue(4, $equipos, PDO::PARAM_STR);
        $stmt->bindValue(5, $esperado, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['idProyecto'] = $this->_dbh->lastInsertId();
            //$response['existe'] = $stmt->rowCount();
            //$response['planes'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el proyecto. ' . TICKETS;
        }

        return $response;
    }

    public function getProyecto($idProyecto){
        $sql = "SELECT * FROM lubeproject WHERE id_project = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProyecto, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();

            $response['proyecto'] = $stmt->fetch();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer el proyecto. ' . TICKETS;
        }

        return $response;
    }

    public function updateEquipos($proyecto, $equipos){
        $sql = "UPDATE lubeproject SET equipos = ? WHERE id_project = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $equipos, PDO::PARAM_STR);
        $stmt->bindValue(2, $proyecto, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar los equipos. ' . TICKETS;
        }

        return $response;
    }

    public function updateEsperado($proyecto, $esperado){
        $sql = "UPDATE lubeproject SET res_esperado = ? WHERE id_project = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $esperado, PDO::PARAM_STR);
        $stmt->bindValue(2, $proyecto, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el resultado. ' . TICKETS;
        }

        return $response;
    }

    public function updateReal($proyecto, $real){
        $sql = "UPDATE lubeproject SET res_real = ? WHERE id_project = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $real, PDO::PARAM_STR);
        $stmt->bindValue(2, $proyecto, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el resultado. ' . TICKETS;
        }

        return $response;
    }

    public function closeProject($proyecto){
        $sql = "UPDATE lubeproject SET status = 2 WHERE id_project = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $proyecto, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al cerrar el proyecto. ' . TICKETS;
        }

        return $response;
    }

    public function deleteProyecto($proyecto){
        $sql = "UPDATE lubeproject SET status = 0 WHERE id_project = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $proyecto, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
            //$response['planes'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el proyecto. ' . TICKETS;
        }

        return $response;
    }

    public function getProyectosCliente($idCliente){
        $sql = "SELECT id_project, titulo/*, 
                        IFNULL((SELECT MIN(fecha) FROM lubeproject_actividad WHERE status = 1 AND fk_project = id_project),'') AS inicio, 
                        IFNULL((SELECT MAX(fecha) FROM lubeproject_actividad WHERE status = 1 AND fk_project = id_project),'') AS fin*/
                    FROM lubeproject WHERE status > 0 AND fk_cliente = ? 
                    ORDER BY id_project DESC ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['proyectos'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los proyectos del cliente. ' . TICKETS;
        }

        return $response;
    }

    


    public function getActividadesCron(){
        $sql = "SELECT a.*, p.fk_cliente, p.titulo, 
                        DATEDIFF(inicio,NOW()) AS diasini, IFNULL(DATEDIFF(fin,NOW()),DATEDIFF(inicio,NOW()) AS diasfin, 
                        c.Cliente, c.email, v.Id_Usuario AS vendedor, v.Mail, v.Id_Sucursal
                    FROM lubeproject_actividad a, lubeproject p, clientes c, usuarios v 
                        WHERE p.id_project = a.fk_project AND c.Id_Cliente = p.fk_cliente AND v.Id_Usuario = c.Id_Usuario 
                            AND p.status > 0 a.status > 0 AND cumplimiento != 100 
                            AND DATEDIFF(inicio,NOW()) <= 15 AND IFNULL(DATEDIFF(fin,NOW()),DATEDIFF(inicio,NOW()) > -2 ";
        $stmt = $this->_dbh->prepare($sql);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();

            $actividades = $stmt->fetchAll();
            $response['actividades'] = $actividades;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los servicios del cliente. ' . TICKETS;
        }

        return $response;
    }

}
