<?php
/**
 * ManualCalidadDao.php
 * Modelo para la persistencia de datos de manuales de calidad
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package calidad
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'ManualCalidad.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class ManualCalidadDao extends Model
{
    
    public function __construct() {
        parent::__construct();
    }
    
    public function guardarManualCalidad(ManualCalidad $c)
    {
        $sql = "INSERT INTO `manuales_calidad` (`Folio`, `Manual`, `Fecha`, `Id_Usuario`, `Status`) "
                . "VALUES (?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindValue(2, $c->__get('_manual'), PDO::PARAM_STR);
        $stmt->bindValue(3, $c->__get('_fecha'), PDO::PARAM_INT);
        $stmt->bindValue(4, $c->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(5, $c->__get('_status'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCalidad'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar los datos de tu documento 1. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerFolio()
    {
        $sql = "SELECT `Folio` FROM `manuales_calidad` ORDER BY `Id_Manual` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['folio'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude obtener el folio de tu documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function guardarDetalleCalidad($fecha, $descripcion, $documento, $ruta, $idUsuario, $idCalidad)
    {
        $sql = "INSERT INTO `manuales_calidad_detalle` (`Fecha`, `Descripcion`, `documento`, `ruta`, "
                . "`Id_Usuario`, `Id_Calidad`) VALUES (?, ?, ?, ?, ?, ?) ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(3, $documento, PDO::PARAM_STR);
        $stmt->bindValue(4, $ruta, PDO::PARAM_STR);
        $stmt->bindValue(5, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(6, $idCalidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos de tu documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerManualesCalidad($inicio, $registros)
    {
        $sql = "SELECT `manuales_calidad`.`Id_Manual`, `manuales_calidad`.`Folio`, "
                . "`manuales_calidad`.`Manual`, `manuales_calidad`.`Fecha`, `usuarios`.`Id_Usuario`, "
                . "`usuarios`.`Nombre`, `usuarios`.`Apellido_Paterno`, `usuarios`.`Apellido_Materno`, `manuales_calidad_detalle`.`documento`, "
                . "`manuales_calidad_detalle`.`Descripcion` FROM `manuales_calidad` INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `manuales_calidad`.`Id_Usuario` "
                . "INNER JOIN `manuales_calidad_detalle` ON `manuales_calidad_detalle`.`Id_Calidad` = `manuales_calidad`.`Id_Manual` "
                . "WHERE `manuales_calidad`.`Status` = 1 ORDER BY `manuales_calidad`.`Id_Manual` ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['manuales'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de los manuales de calidad. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerManualesCalidadAutorizar($inicio, $registros)
    {
        $sql = "SELECT `manuales_calidad`.`Id_Manual`, `manuales_calidad`.`Folio`, "
                . "`manuales_calidad`.`Manual`, `manuales_calidad`.`Fecha`, `usuarios`.`Id_Usuario`, "
                . "`usuarios`.`Nombre`, `usuarios`.`Apellido_Paterno`, `usuarios`.`Apellido_Materno`, `manuales_calidad_detalle`.`documento`, "
                . "`manuales_calidad_detalle`.`Descripcion`, `manuales_calidad_detalle`.`ruta` FROM `manuales_calidad` INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `manuales_calidad`.`Id_Usuario` "
                . "INNER JOIN `manuales_calidad_detalle` ON `manuales_calidad_detalle`.`Id_Calidad` = `manuales_calidad`.`Id_Manual` "
                . "WHERE `manuales_calidad`.`Status` = 0 ORDER BY `manuales_calidad`.`Id_Manual` ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['manuales'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de los manuales de calidad. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalManualesCalidad()
    {
        $sql = "SELECT `Id_Manual` FROM `manuales_calidad` WHERE `Status` = 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de Manuales. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalManualesCalidadAutorizar()
    {
        $sql = "SELECT `Id_Manual` FROM `manuales_calidad` WHERE `Status` = 0";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de Manuales. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function cambiarStatus(ManualCalidad $c)
    {   
        $sql = "UPDATE `manuales_calidad` SET `Status` = ? WHERE `Id_Manual` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(2, $c->__get('_idManual'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude actualizar el procedimiento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerManual(ManualCalidad $c)
    {
        $sql = "SELECT * FROM `manuales_calidad` INNER JOIN `manuales_calidad_detalle` ON "
                . "`manuales_calidad_detalle`.`Id_Calidad` = `manuales_calidad`.`Id_Manual` "
                . "WHERE `manuales_calidad`.`Id_Manual` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_idManual'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['manual'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ńo pude obtener los datos del manual. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerDetalleAutorizar($idManual)
    {
        $sql = "SELECT * FROM `manuales_calidad_detalle` WHERE `Id_Calidad` = ? AND `Id_Autoriza` = 0 ORDER BY `Id_Manual` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idManual, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['datosDetalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener el detalle del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function usuarioAutoriza($idUsuario, $idManual)
    {
        $sql = "UPDATE `manuales_calidad_detalle` SET `Id_Autoriza` = ? WHERE `Id_Manual` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idManual, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $$e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un problema al autorizar el documento. ' . 
                    TICKETS;
        }
        
        return $response;
    }
}