<?php
/**
 * MinutaDao.php
 * Modelo para la persistencia de datos de minutas
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
        'models' . DIRECTORY_SEPARATOR . 'Minuta.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class MinutaDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

    public function validaMunutaDiaria($fecha, $fechaFin, $idSucursal)
    {
    	$sql = "SELECT * FROM `minuta` WHERE `Fecha` >= ? AND `Fecha` <= ? AND `Id_Sucursal` = ?";
    	$stmt = $this->_dbh->prepare($sql);
    	$stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFin, PDO::PARAM_STR);
    	$stmt->bindValue(3, $idSucursal, PDO::PARAM_INT);
    	try{
    		$stmt->execute();
    		$response['status'] = true;
    		$response['valida'] = $stmt->rowCount();
    	}catch(PDOException $e){
    		Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
    		$response['status'] = false;
    		$response['error'] = 'Ocurrió un error al validar la junta diaria. ' . TICKETS;
    	}

    	return $response;
    }

    public function guardaMinuta(Minuta $m){
        $sql = "INSERT INTO `minuta` (`Id_Usuario`, `Fecha`, `Tema`,"
                . " `Compromiso`, `Id_Sucursal`, `Sugerencia`) "
                . "VALUES(?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $m->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(2, $m->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(3, $m->__get('_tema'), PDO::PARAM_STR);
        $stmt->bindValue(4, $m->__get('_compromiso'), PDO::PARAM_STR);
        $stmt->bindValue(5, $m->__get('_idSucursal'), PDO::PARAM_INT);
        $stmt->bindValue(6, $m->__get('_sugerencia'), PDO::PARAM_STR);
        try{
            $stmt->execute();
            $idMinuta = $this->_dbh->lastInsertId();
            $response['idMinuta'] = $idMinuta;
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar la minuta. ' . TICKETS;
        }

        return $response;
    }

    public function totalListaJunta($idSucursal){
        $sql = "SELECT * FROM minuta WHERE Id_Sucursal = ? AND Fecha >= '2018-09-01 00:00:00'";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al calcular el total de juntas. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerListaJunta($idSucursal, $inicio, $registros){
        $sql = "SELECT * FROM minuta INNER JOIN usuarios ON usuarios.Id_Usuario = minuta.Id_Usuario INNER JOIN platicas_seguridad ON platicas_seguridad.Id_Platica = minuta.Tema WHERE minuta.Id_Sucursal = ? AND minuta.Fecha >= '2018-09-01 00:00:00' ORDER BY minuta.Id_Minuta DESC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['juntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener el listado de juntas. ' . TICKETS;
        }

        return $response;
    }
    
public function usuarioPlatica($fecha, $idSucursal)
    {
        $sql = "SELECT `platicas_usuario`.*, `usuarios`.Mail FROM `platicas_usuario` INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `platicas_usuario`.`Id_Usuario` WHERE `Fecha` = ? AND `platicas_usuario`.`Id_Sucursal` = ? LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['usu'] = $stmt->fetch(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al validar la junta diaria. ' . TICKETS;
        }

        return $response;
    }    

}
