<?php
/**
 * VehiculoDao.php
 * Modelo para el manejo de vehículos 
 * @author José Francisco Montaño Andriano
 * @copyright (c) 2017, Merdiz
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class PedidoVehiculoNoIdentificadoDao extends Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getVehiculoNoIdentificado($idDocumento){
        $sql = "SELECT * FROM pedido_vehiculo_no_identificado where Id_Documento = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idDocumento, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['vehiculo'] = $stmt->fetch(PDO::FETCH_OBJ);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del vehiculo';
        }

        return $response;
    }

    public function agregarVehiculoNoIdentificado($confVehicular, $placas, $year, $aseguradora, $poliza, $rfc, $licencia, $tipo, $idDocumento){
        $sql = "INSERT INTO `pedido_vehiculo_no_identificado` (`Conf_Vehicular`, `Placas`, `Ano`, `Aseguradora`, `Poliza`, 
                                  `RFC`, `Licencia`, `Tipo`, `Id_Documento`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $confVehicular, PDO::PARAM_STR);
        $stmt->bindValue(2, $placas, PDO::PARAM_STR);
        $stmt->bindValue(3, $year, PDO::PARAM_STR);
        $stmt->bindValue(4, $aseguradora, PDO::PARAM_STR);
        $stmt->bindValue(5, $poliza, PDO::PARAM_STR);
        $stmt->bindValue(6, $rfc, PDO::PARAM_STR);
        $stmt->bindValue(7, $licencia, PDO::PARAM_STR);
        $stmt->bindValue(8, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(9, $idDocumento, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al agregar los datos del vehiculo';
        }

        return $response;
    }



}
