<?php
/**
 * PlannerCursoDao.php
 * Modelo para la persistencia de datos de planner_curso
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class PlannerCursoDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

    public function guardarCurso($idCurso, $titulo, $responsable, $sector, $duracion, $status){
        if($idCurso > 0){
            $sql = "UPDATE planner_curso SET fk_sector = ?, titulo = ?, tiempo = ?, responsable = ?, status = ? WHERE id_curso = ?; ";
        }else{
            $sql = "INSERT INTO planner_curso  (fk_sector, fecha, titulo, tiempo, responsable, status)  VALUES (?, NOW(), ?, ?, ?, ?); ";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sector, PDO::PARAM_INT);
        $stmt->bindValue(2, $titulo, PDO::PARAM_STR);
        $stmt->bindValue(3, $duracion, PDO::PARAM_STR);
        $stmt->bindValue(4, $responsable, PDO::PARAM_STR);
        $stmt->bindValue(5, $status, PDO::PARAM_INT);
        if($idCurso > 0) $stmt->bindValue(6, $idCurso, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCurso'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el curso. ' . TICKETS;
        }

        return $response;
    }
    
    public function obtenerCursos($inicio, $registros){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM planner_curso ORDER BY status DESC, titulo  LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function buscarCurso($inicio, $registros, $termino){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM planner_curso WHERE `Titulo` LIKE ? ORDER BY id_curso ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de los cursos';
        }

        return $response;
    }

    public function obtenerCurso($idCurso){
        $sql = "SELECT * FROM planner_curso WHERE id_curso = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCurso, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['curso'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los '
                    . 'datos del curso. ' . TICKETS;
        }
        
        return $response;
    }

    public function getCursoGiro($giro){
        $sql = "SELECT * FROM planner_curso WHERE status = 1 AND fk_sector IN (0, ?) ORDER BY titulo ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $giro, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['cursos'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los cursos. ' . TICKETS;
        }

        return $response;
    }




}
