<?php
/**
 * PlannerEventoDao.php
 * Modelo para la persistencia de datos de planner_evento
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class PlannerEventoDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

    public function addEvento($idCliente, $serv, $destino, $visita){
        $sql = "INSERT INTO planner_evento ( fk_cliente, fk_servicio, fk_destino, visita) VALUES (?, ?, ?, ?);";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $serv, PDO::PARAM_INT);
        $stmt->bindValue(3, $destino, PDO::PARAM_INT);
        $stmt->bindValue(4, $visita, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['idEvento'] = $this->_dbh->lastInsertId();
            //$response['existe'] = $stmt->rowCount();
            //$response['planes'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el evento. ' . TICKETS;
        }

        return $response;
    }

    public function getEvento($idEvento){
        $sql = "SELECT * FROM planner_evento WHERE id_evento = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idEvento, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();

            $response['evento'] = $stmt->fetch();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer el evento. ' . TICKETS;
        }

        return $response;
    }

    public function updateFecha($evento, $visita){
        $sql = "UPDATE planner_evento SET visita = ? WHERE id_evento = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $visita, PDO::PARAM_STR);
        $stmt->bindValue(2, $evento, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
            //$response['planes'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el evento. ' . TICKETS;
        }

        return $response;
    }

    public function guardaResultado($evento, $fecha, $muestra, $res){
        $sql = "UPDATE planner_evento SET analisis = ?, muestra = ?, resultado = ?, status = 4 WHERE id_evento = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $muestra, PDO::PARAM_STR);
        $stmt->bindValue(3, $res, PDO::PARAM_INT);
        $stmt->bindValue(4, $evento, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
            //$response['planes'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el resultado. ' . TICKETS;
        }

        return $response;
    }

    public function deleteEvento($evento){
        $sql = "UPDATE planner_evento SET status = 2 WHERE id_evento = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $evento, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
            $response['exito'] = $stmt->rowCount();
            //$response['planes'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar el evento. ' . TICKETS;
        }

        return $response;
    }

    public function getPlanesAnio($idCliente){
        $sql = "SELECT DATE_FORMAT(visita,'%Y') AS anio FROM planner_evento WHERE status != 2 AND fk_cliente = ? GROUP BY DATE_FORMAT(visita,'%Y')  ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['planes'] = $stmt->fetchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los servicios del cliente. ' . TICKETS;
        }

        return $response;
    }

    public function getEventosPlan($idCliente, $anio){
        $sql = "SELECT *, DATEDIFF(visita, NOW()) AS dias, 
                    (CASE  
                    WHEN (fk_servicio = 1 OR fk_servicio = 2 OR fk_servicio = 8) 
                        THEN (SELECT Maquina FROM equipos_clientes WHERE Id_Equipo = fk_destino) 
                    WHEN (fk_servicio = 4 AND fk_destino = 0) 
                        THEN 'Asesoría' 
                    WHEN (fk_servicio = 4 AND fk_destino != 0) 
                        THEN (SELECT CONCAT(titulo,' (Examen)') FROM planner_curso WHERE id_curso = fk_destino) 
                    WHEN (fk_servicio = 5) 
                        THEN (SELECT CONCAT(titulo,' (Examen)') FROM planner_curso WHERE id_curso = fk_destino)  
                    ELSE 'Visita' END) AS actividad, 

                    (CASE 
                    WHEN (visita < NOW() AND visita = analisis) THEN 'green' 
                    WHEN (visita < NOW() AND visita != analisis AND analisis != '0000-00-00') THEN 'orange' 
                    WHEN (visita < NOW() AND (analisis = '0000-00-00' OR analisis IS NULL)) THEN 'red' 
                    ELSE '#3a87ad' END) AS color 
                     
                    FROM planner_evento e, planner_servicio s WHERE s.id_servicio = e.fk_servicio AND e.status != 2 AND fk_cliente = ? AND DATE_FORMAT(visita,'%Y') = ? ORDER BY fk_servicio, visita ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $anio, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();

            $eventos = $stmt->fetchAll();
            $arr = array();
            foreach ($eventos as $evento) {
                if($evento['analisis'] == '0000-00-00'|| $evento['analisis'] == null) $evento['analisis'] = '--';
                $evento['url'] = '';
                $evento['file'] = str_replace('-', '', $evento['analisis']).$evento['id_evento'];
                if($evento['fk_servicio'] == 5 || ($evento['fk_servicio'] == 4 && $evento['fk_destino'] > 0))
                    $evento['url'] = 'https://merdizshell.com/docs/lubecoach/diploma_'.$evento['fk_cliente'].'_'.$evento['fk_destino'].'.pdf';
                $arr[] = $evento;
            }

            $response['eventos'] = $arr;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los servicios del cliente. ' . TICKETS;
        }

        return $response;
    }


    public function getEventosCron(){
        $sql = "SELECT e.fk_cliente, e.fk_servicio, e.fk_destino, e.visita, s.descripcion, DATEDIFF(visita, NOW()) AS dias, 
                    (CASE  
                    WHEN (fk_servicio = 1 OR fk_servicio = 2 OR fk_servicio = 8) 
                        THEN (SELECT Maquina FROM equipos_clientes WHERE Id_Equipo = fk_destino) 
                    WHEN (fk_servicio = 4 AND fk_destino = 0) 
                        THEN 'Asesoría' 
                    WHEN (fk_servicio = 4 AND fk_destino != 0) 
                        THEN (SELECT CONCAT(titulo,' (Examen)') FROM planner_curso WHERE id_curso = fk_destino) 
                    WHEN (fk_servicio = 5) 
                        THEN (SELECT CONCAT(titulo,' (Examen)') FROM planner_curso WHERE id_curso = fk_destino)  
                    ELSE 'Visita' END) AS actividad, 

                    (CASE 
                    WHEN (visita < NOW() AND visita = analisis) THEN 3
                    WHEN (visita < NOW() AND visita != analisis AND analisis != '0000-00-00') THEN 2 
                    WHEN (visita < NOW() AND (analisis = '0000-00-00' OR analisis IS NULL)) THEN 1 
                    ELSE 0 END) AS estado, 

                    c.Cliente, c.email, v.Id_Usuario AS vendedor, v.Mail, v.Id_Sucursal
                     
                    FROM planner_evento e, planner_servicio s, clientes c, usuarios v
                    WHERE s.id_servicio = e.fk_servicio AND c.Id_Cliente = e.fk_cliente  AND v.Id_Usuario = c.Id_Usuario
                    AND e.status != 2 AND e.status != 4 AND DATEDIFF(visita, NOW()) BWTWEEN -2 AND 15 
                    ORDER BY dias DESC";
        $stmt = $this->_dbh->prepare($sql);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();

            $eventos = $stmt->fetchAll();
            $response['eventos'] = $eventos;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los servicios del cliente. ' . TICKETS;
        }

        return $response;
    }

    public function getPlannerCron(){
        $anio = date('Y');
        $sig = $anio + 1;
        $sql = "SELECT e.fk_cliente, e.visita, c.Cliente, v.Id_Usuario AS vendedor, v.Mail, 
                    DATEDIFF(e.visita, NOW()) AS dias, 
                    (SELECT COUNT(*) FROM planner_evento WHERE fk_cliente = e.fk_cliente AND DATE_FORMAT(visita, '%Y') = ?) AS proximo 
                    FROM 
                    (SELECT * FROM planner_evento WHERE status = 1 AND DATE_FORMAT(visita, '%Y') = ? AND visita > NOW() ORDER BY fk_cliente, visita DESC) e, 
                    clientes c, usuarios v 
                    WHERE c.Id_Cliente = e.fk_cliente AND v.Id_Usuario = c.Id_Usuario 
                    GROUP BY fk_cliente

                    ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sig, PDO::PARAM_STR);
        $stmt->bindValue(2, $anio, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['year'] = $anio;
            $response['nextyear'] = $sig;

            $planners = $stmt->fetchAll();
            $response['planners'] = $planners;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los evento del planner del año. ' . TICKETS;
        }

        return $response;
    }

}
