<?php
/**
 * PlannerPreguntaDao.php
 * Modelo para la persistencia de datos de planner_pregunta
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class PlannerPreguntaDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

  public function guardarPregunta($idPregunta, $idCurso, $pregunta, $opcion1, $opcion2, $opcion3, $respuesta, $explicacion, $status){
        if($idPregunta > 0){
            $sql = "UPDATE planner_pregunta SET fk_curso = ?, pregunta = ?, opcion1 = ?, opcion2 = ?, opcion3 = ?, respuesta = ?, explicacion = ?, status = ? WHERE id_pregunta = ?; ";
        }else{
            $sql = "INSERT INTO planner_pregunta (fk_curso,pregunta,opcion1,opcion2,opcion3,respuesta,explicacion, `status`) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?); ";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCurso, PDO::PARAM_INT);
        $stmt->bindValue(2, $pregunta, PDO::PARAM_STR);
        $stmt->bindValue(3, $opcion1, PDO::PARAM_STR);
        $stmt->bindValue(4, $opcion2, PDO::PARAM_STR);
        $stmt->bindValue(5, $opcion3, PDO::PARAM_STR);
        $stmt->bindValue(6, $respuesta, PDO::PARAM_INT);
        $stmt->bindValue(7, $explicacion, PDO::PARAM_STR);
        $stmt->bindValue(8, $status, PDO::PARAM_INT);
        if($idPregunta > 0) $stmt->bindValue(9, $idPregunta, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idPregunta'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al guardar la pregunta. ' . TICKETS;
        }

        return $response;
    }
    
    public function obtenerPreguntas($idCurso, $inicio, $registros){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM planner_pregunta WHERE fk_curso = ? ORDER BY status DESC, id_pregunta  LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCurso, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer las preguntas. ' . TICKETS;
        }

        return $response;
    }

    public function buscarPregunta($idCurso, $inicio, $registros, $termino){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM planner_curso WHERE fk_curso = ? AND pregunta LIKE ? ORDER BY id_pregunta ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCurso, PDO::PARAM_INT);
        $stmt->bindValue(2, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las preguntas';
        }

        return $response;
    }

    public function obtenerPregunta($idPregunta){
        $sql = "SELECT * FROM planner_pregunta WHERE id_pregunta = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idPregunta, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['pregunta'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los '
                    . 'datos de la pregunta. ' . TICKETS;
        }
        
        return $response;
    }

}
