<?php
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . 
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PlaticaUsuario.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class PlaticaUsuarioDao extends Model {

	public function __construct(){
		parent::__construct();
	}

	public function obtenerUltimasPlaticas($idSucursal){
		$sql = "SELECT * FROM platicas_usuario WHERE Id_Sucursal = ? ORDER BY Id_Platica_Usuario DESC LIMIT 2";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['platicas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			$response['status'] = false;
			$response['error'] = 'Ocurrió un error al obtener las platicas.';
		}

		return $response;
	}

	public function obtenerUltimaPlatica($idSucursal){
		$sql = "SELECT * FROM platicas_usuario WHERE Id_Sucursal = ? ORDER BY Id_Platica_Usuario DESC LIMIT 1";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['platica'] = $stmt->fetch(PDO::FETCH_OBJ);
		} catch (Exception $e) {
			$response['status'] = false;
			$response['error'] = 'Ocurrió un error al obtener la última platica.';
		}

		return $response;
	}

	public function guardarPlatica(PlaticaUsuario $p){
		$sql = "INSERT INTO platicas_usuario (Id_Usuario, Platica_Id, Fecha, Id_Sucursal) VALUES (?, ?, ?, ?)";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $p->__get('_idUsuario'), PDO::PARAM_INT);
		$stmt->bindValue(2, $p->__get('_platicaId'), PDO::PARAM_INT);
		$stmt->bindValue(3, $p->__get('_fecha'), PDO::PARAM_INT);
		$stmt->bindValue(4, $p->__get('_idSucursal'), PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
		} catch (PDOException $e) {
			$response['status'] = false;
			$response['error'] = 'Ocurrió un error al guardar la platica';
		}

		return $response;
	}
	
	public function obtenerPlaticasUsuarioPorUsuario($idUsuario, $fecha){
        $sql = "select * from platicas_usuario as pu
                left join platicas_seguridad as ps on ps.Id_Platica = pu.Platica_Id
                where pu.Id_Usuario = ? and pu.Fecha > ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['platicas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            $response['status'] = false;
            $response['error'] = 'Ocurri un error al obtener las platicas.';
        }

        return $response;
    }
}