<?php
/**
 * PoliticasDao.php
 * Modelo para la persistencia de datos de politicas de calidad
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . 
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Politicas.php';

class PoliticasDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(Politicas $p)
    {
        $sql = "INSERT INTO `politicas_calidad` (`Folio`, `Politica`, `Fecha`, "
                . "`Id_Usuario`, `Status`) VALUES (?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $p->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindValue(2, $p->__get('_politica'), PDO::PARAM_STR);
        $stmt->bindValue(3, $p->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(4, $p->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(5, $p->__get('_status'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idPolitica'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos de tu '
                    . 'documento. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerFolio()
    {
        $sql = "SELECT `Folio` FROM `politicas_calidad` ORDER BY `Id_Politica` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['folio'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el folio del documento. ' . 
                    TICKETS;
        }
        
        return $response;
    }
    
    public function guardarDetallePolitica($fecha, $descripcion, $documento, $ruta, $idUsuario, $idPolitica)
    {
        $sql = "INSERT INTO `politicas_detalle` (`Fecha`, `Descripcion`, `Documento`, "
                . "`Ruta`, `Id_Usuario`, `Id_Politica`) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(3, $documento, PDO::PARAM_STR);
        $stmt->bindValue(4, $ruta, PDO::PARAM_STR);
        $stmt->bindValue(5, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(6, $idPolitica, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el detalle del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalPoliticas()
    {
        $sql = "SELECT `Id_Politica` FROM `politicas_calidad` WHERE `Status` = 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de politicas. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerPolitcas($inicio, $registros)
    {
        $sql = "SELECT * FROM `politicas_calidad` INNER JOIN `politicas_detalle` ON "
                . "`politicas_detalle`.`Id_Politica` = `politicas_calidad`.`Id_Politica` "
                . "INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `politicas_calidad`.`Id_Usuario` "
                . "WHERE `politicas_calidad`.`Status` = 1 ORDER BY `politicas_calidad`.`Id_Politica` ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['politicas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió al obtener los datos de politicas de calidad. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalPoliticasAutorizar()
    {
        $sql = "SELECT `Id_Politica` FROM `politicas_calidad` WHERE `Status` = 0";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al calcular el total de politicas. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerPolitcasAutorizar($inicio, $registros)
    {
        $sql = "SELECT * FROM `politicas_calidad` INNER JOIN `politicas_detalle` ON "
                . "`politicas_detalle`.`Id_Politica` = `politicas_calidad`.`Id_Politica` "
                . "INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `politicas_calidad`.`Id_Usuario` "
                . "WHERE `politicas_calidad`.`Status` = 0 ORDER BY `politicas_calidad`.`Id_Politica` ASC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['politicas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió al obtener los datos de politicas de calidad. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function usuarioAutoriza($idUsuario, $idManual)
    {
        $sql = "UPDATE `politicas_detalle` SET `Id_Autoriza` = ? WHERE `Id_Politica` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idManual, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $$e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un problema al autorizar el documento. ' . 
                    TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerDetalleAutorizar($idPolitica)
    {
        $sql = "SELECT * FROM `politicas_detalle` WHERE `Id_Politica` = ? AND `Id_Autoriza` = 0 ORDER BY `Id_Politica` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idPolitica, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['datosDetalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener el detalle del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerPolitica($idPolitica)
    {
        $sql = "SELECT * FROM `politicas_calidad` INNER JOIN `politicas_detalle` "
                . "ON `politicas_detalle`.`Id_Politica` = `politicas_calidad`.`Id_Politica` "
                . "INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `politicas_calidad`.`Id_Usuario` "
                . "WHERE `politicas_calidad`.`Id_Politica` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idPolitica, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['politica'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function cambiarStatus(Politicas $c)
    {   
        $sql = "UPDATE `politicas_calidad` SET `Status` = ? WHERE `Id_Politica` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(2, $c->__get('_idPolitica'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude actualizar el documento. '
                    . TICKETS;
        }
        
        return $response;
    }
}